<?php
// $Id: subscribe_course2class.php 10811 2007-01-22 08:26:40Z elixir_julian $
/*
==============================================================================
	IILearn - elearning and course management software

	Copyright (c) 2007 IILearn China

	For a full list of contributors, see "credits.txt".
	The full license can be read in "license.txt".

	This program is free software; you can redistribute it and/or
	modify it under the terms of the GNU General Public License
	as published by the Free Software Foundation; either version 2
	of the License, or (at your option) any later version.

	See the GNU General Public License for more details.

	Contact: Zhong 	poopsoft@163.com
==============================================================================
*/
/**
============================================================================== 
*	@package iilearn.admin
============================================================================== 
*/
// name of the language file that needs to be included
$language_file = 'admin';

$cidReset = true;

require ('../inc/global.inc.php');
require_once (api_get_path(LIBRARY_PATH).'classmanager.lib.php');

api_protect_admin_script();

//$course = $_GET['course'];
$class_id = intval($_GET['idclass']);
$form_sent = 0;
$error_message = '';
$first_letter_left = '';
$first_letter_right = '';
$left_course_list = array();
$right_course_list = array ();

// Database table definitions
$tbl_class 		= Database :: get_main_table(TABLE_MAIN_CLASS);
$tbl_course_class = Database :: get_main_table(TABLE_MAIN_COURSE_CLASS);
$tbl_course 		= Database :: get_main_table(TABLE_MAIN_COURSE);

$sql = "SELECT name FROM $tbl_class WHERE id='$class_id'";
$result = api_sql_query($sql, __FILE__, __LINE__);

if (!list ($class_name) = mysql_fetch_row($result))
{
	//header('Location: class_list.php?filtreCours='.urlencode($course));
	header('Location: class_list.php');
	exit ();
}

$this_section=SECTION_PLATFORM_ADMIN;
$interbreadcrumb[] = array ("url" => 'index.php', "name" => get_lang('PlatformAdmin'));
//$interbreadcrumb[] = array ("url" => "class_list.php?filtreCours=".urlencode($course), "name" => get_lang('AdminClasses'));
$interbreadcrumb[] = array ("url" => "class_list.php", "name" => get_lang('ClassList'));
$tool_name = get_lang('AddCoursesToClass').' ('.$class_name.')';
$htmlHeadXtra[] =
"<script type='text/javascript'>
function sendForm(formSent)
{
	document.formulaire.formSent.value='2';
	if (formSent)
	{
		 document.formulaire.submit();
	} 
}
</script>";

Display :: display_header($tool_name);

if ($_POST['formSent'])
{
	$form_sent = $_POST['formSent'];
	$first_letter_left = $_POST['firstLetterLeft'];
	$first_letter_right = $_POST['firstLetterRight'];
	$left_course_list = is_array($_POST['LeftCourseList']) ? $_POST['LeftCourseList'] : array();
	$right_course_list = is_array($_POST['RightCourseList']) ? $_POST['RightCourseList'] : array();
	$add_to_class = empty ($_POST['addToClass']) ? 0 : 1;
	$remove_from_class = empty ($_POST['removeFromClass']) ? 0 : 1;
	if ($form_sent == 1)
	{
		if ($add_to_class)
		{
			if (count($left_course_list) == 0)
			{
				$error_message = get_lang('AtLeastOneCourse');
			}
			else
			{
				foreach ($left_course_list as $key=>$course_code)
				{
					ClassManager :: subscribe_to_course($class_id, $course_code);
				}
				Display :: display_normal_message(get_lang('CoursesAreSubscibedToClass'));
			}
		}
		elseif ($remove_from_class)
		{
			if (count($right_course_list) == 0)
				$error_message = get_lang('AtLeastOneCourse');
			else
			{
				foreach ($right_course_list as $key=>$course_code)
				{
					ClassManager :: unsubscribe_from_course($class_id, $course_code);
				}
				Display :: display_normal_message(get_lang('CoursesAreUnSubscibedToClass'));
			}
		}
		
		$first_letter_left = '';
		$first_letter_right = '';
	}
}

$sql = "SELECT c.code,title FROM $tbl_course c LEFT JOIN $tbl_course_class cc ON c.code=cc.course_code AND class_id='$class_id' WHERE title LIKE '%".$first_letter_left."%' AND class_id IS NULL ORDER BY ". (count($right_course_list) > 0 ? "(c.code IN(".implode(',', $right_course_list).")) DESC," : "")." title";
$result = api_sql_query($sql, __FILE__, __LINE__);
$left_courses = api_store_result($result);

$sql = "SELECT c.code,title FROM $tbl_course c,$tbl_course_class cc WHERE cc.course_code=c.code AND class_id='$class_id' AND title LIKE '%".$first_letter_right."%' ORDER BY ". (count($left_course_list) > 0 ? "(c.code IN(".implode(',', $left_course_list).")) DESC," : "")." title";
$result = api_sql_query($sql, __FILE__, __LINE__);
$right_courses = api_store_result($result);

if (!empty ($error_message))
{
	Display :: display_error_message($error_message); 
}

?>
<form name="formulaire" method="post" action="<?php echo $_SERVER['PHP_SELF']."?idclass={$class_id}";?> style="margin:0px;">
 <input type="hidden" name="formSent" value="1"/>
 <table border="0" cellpadding="5" cellspacing="0" align="center">
  <tr>
   <td>
    <b><?php echo get_lang('CoursesOutsideClass'); ?> </b>&nbsp;&nbsp;
	<input type="text" name="firstLetterLeft" size="15" value="<?php echo $first_letter_left; ?>" onkeydown="sendForm(false);"/>
	<input  type="button" class="inputSubmit" name="searchLeft" value="<?php echo get_lang('Search'); ?>" onclick="sendForm(true);"/>
   </td>
   <td width="20">&nbsp;</td>
   <td>
    <b><?php echo get_lang('CoursesInsideClass'); ?> </b>&nbsp;&nbsp;
	<input type="text" name="firstLetterRight" size="15" value="<?php echo $first_letter_right; ?>" onkeydown="sendForm(false);"/>
	<input  type="button" class="inputSubmit" name="searchRight" value="<?php echo get_lang('Search'); ?>" onclick="sendForm(true);"/>
   </td>
  </tr>
  <tr>
   <td align="center">
    <select name="LeftCourseList[]" multiple="multiple" size="20" style="width:300px;">
<?php
foreach ($left_courses as $course)
{
?>
     <option value="<?php echo $course['code']; ?>" <?php if(in_array($course['code'],$right_course_list)) echo 'selected="selected"'; ?>><?php echo '('.$course['code'].')' . $course['title']; ?></option>
<?php
}
?>
    </select>
   </td>
   <td valign="middle" align="center">
	<input type="submit" name="addToClass" class="inputSubmitShort" value="&gt;&gt;"/>
	<br/><br/>
	<input type="submit" name="removeFromClass" class="inputSubmitShort" value="&lt;&lt;"/>
   </td>
   <td align="center">
    <select name="RightCourseList[]" multiple="multiple" size="20" style="width:300px;">
<?php
foreach ($right_courses as $course)
{
?>
     <option value="<?php echo $course['code']; ?>" <?php if(in_array($course['code'],$left_course_list)) echo 'selected="selected"'; ?>><?php echo ' ('.$course['code'].')' . $course['title']; ?></option>
<?php
}
?>
    </select>
   </td>
  </tr>
 </table>
 <br>
</form>
<?php
/*
==============================================================================
		FOOTER 
==============================================================================
*/
Display :: display_footer();
?>