<?php

// $Id: user_import.php 12014 2007-04-13 09:57:59Z pcool $
/*
==============================================================================
	Dokeos - elearning and course management software

	Copyright (c) 2004 Dokeos S.A.
	Copyright (c) 2003 Ghent University (UGent)
	Copyright (c) 2001 Universite catholique de Louvain (UCL)
	Copyright (c) Olivier Brouckaert
	Copyright (c) 2005 Bart Mollet <bart.mollet@hogent.be>

	For a full list of contributors, see "credits.txt".
	The full license can be read in "license.txt".

	This program is free software; you can redistribute it and/or
	modify it under the terms of the GNU General Public License
	as published by the Free Software Foundation; either version 2
	of the License, or (at your option) any later version.

	See the GNU General Public License for more details.

	Contact: Zhong 	poopsoft@163.com
==============================================================================
*/
/**
==============================================================================
*   This tool allows platform admins to add users by uploading a CSV or XML file
* @todo Add some langvars to DLTT
*	@package iilearn.admin
==============================================================================
*/

// name of the language file that needs to be included
$language_file = array ('admin', 'registration');

include ('../inc/global.inc.php');
require_once (api_get_path(LIBRARY_PATH).'fileManage.lib.php');
require_once (api_get_path(LIBRARY_PATH).'usermanager.lib.php');
require_once (api_get_path(LIBRARY_PATH).'classmanager.lib.php');
require_once (api_get_path(LIBRARY_PATH).'import.lib.php');
require_once (api_get_path(LIBRARY_PATH).'formvalidator/FormValidator.class.php');
require_once(api_get_path(LIBRARY_PATH).'mail.lib.inc.php');

api_protect_admin_script();
$defined_auth_sources[] = PLATFORM_AUTH_SOURCE;
if (is_array($extAuthSource))
{
	$defined_auth_sources = array_merge($defined_auth_sources, array_keys($extAuthSource));
}

/**
 * validate the imported data
 */
function validate_data($users)
{
	global $defined_auth_sources;
	$errors = array ();
	$usernames = array ();
	$emails = array();
	foreach ($users as $index => $user)
	{
		//1. check if mandatory fields are set	
		//$mandatory_fields = array ('LastName', 'FirstName');
		$mandatory_fields = array ('FirstName', 'UserName');
		if (api_get_setting('registration', 'email') == 'true')
		{
			$mandatory_fields[] = 'Email';	
		}
		foreach ($mandatory_fields as $key => $field)
		{
			if (empty($user[$field]) || strlen($user[$field]) == 0)
			{
				$user['error'] = get_lang($field.'Mandatory');
				$errors[] = $user;
			}
		}
		//2. check username
		if (!empty($user['UserName']) && strlen($user['UserName']) != 0)
		{
			//2.1. check if no username was used twice in import file
			if (isset($usernames[$user['UserName']]))
			{
				$user['error'] = get_lang('UserNameUsedTwice');
				$errors[] = $user;
			}
			$usernames[$user['UserName']] = 1;
			//2.2. check if username isn't allready in use in database
			if (!UserManager :: is_username_available($user['UserName']))
			{
				$user['error'] = get_lang('UserNameNotAvailable');
				$errors[] = $user;
			}
			//2.3. check if username isn't longer than the 20 allowed characters
			if (strlen($user['UserName']) > 20)
			{
				$user['error'] = get_lang('UserNameTooLong');
				$errors[] = $user;
			}
		}
		//3. check status
		if (!empty($user['Status']) && ($user['Status'] != COURSEMANAGER && $user['Status'] != STUDENT))
		{
			$user['error'] = get_lang('WrongStatus');
			$errors[] = $user;
		}
		//4. Check classname
		if (!empty($user['ClassName']) && strlen($user['ClassName']) != 0)
		{
			if (!ClassManager :: class_name_exists($user['ClassName']))
			{
				$user['error'] = get_lang('ClassNameNotAvailable');
				$errors[] = $user;
			}
		}
		//5. Check authentication source
		if (!empty($user['AuthSource']) && strlen($user['AuthSource']) != 0)
		{
			if (!in_array($user['AuthSource'], $defined_auth_sources))
			{
				$user['error'] = get_lang('AuthSourceNotAvailable');
				$errors[] = $user;
			}
		}
		
		//6. check email
		if (!empty($user['Email']) && strlen($user['Email']) != 0)
		{
			//6.1. check if no username was used twice in import file
			if (isset($emails[$user['Email']]))
			{
				$user['error'] = get_lang('EmailUsedTwice');
				$errors[] = $user;
			}
			$emails[$user['Email']] = 1;
			//2.2. check if username isn't allready in use in database
			if (!UserManager :: is_email_available($user['Email']))
			{
				$user['error'] = get_lang('EmailNotAvailable');
				$errors[] = $user;
			}
		}
	}
	return $errors;
}
/**
 * Add missing user-information (which isn't required, like password, username
 * etc)
 */
function complete_missing_data($users)
{
	foreach ($users as $index => $user)
	{
		//1. Create a username if necessary
		if (!isset ($user['UserName']) || strlen($user['UserName']) == 0)
		{
			$username = strtolower(ereg_replace('[^a-zA-Z]', '', substr($user['FirstName'], 0, 3).' '.substr($user['LastName'], 0, 4)));
			if (!UserManager :: is_username_available($username))
			{
				$i = 0;
				$temp_username = $username.$i;
				while (!UserManager :: is_username_available($temp_username))
				{
					$temp_username = $username.++$i;
				}
				$username = $temp_username;
			}
			$users[$index]['UserName'] = $username;
		}
		//2. generate a password if necessary
		if (!isset ($user['Password']) || strlen($user['Password']) == 0)
		{
			$users[$index]['Password'] = api_generate_password();
		}
		//3. set status if not allready set
		if (!isset ($user['Status']) || strlen($user['Status']) == 0)
		{
			//$users[$index]['Status'] = 'user';
			$users[$index]['Status'] = STUDENT;
		}
		//4. set authsource if not allready set
		if (!isset ($user['AuthSource']) || strlen($user['AuthSource']) == 0)
		{
			$users[$index]['AuthSource'] = PLATFORM_AUTH_SOURCE;
		}
	}
	return $users;
}
/**
 * Save the imported data
 */
function save_data($users)
{
	$user_table = Database :: get_main_table(TABLE_MAIN_USER);
	$platformLanguage = api_get_setting('platformLanguage');
	$sendMail = $_POST['sendMail'] ? 1 : 0;
	foreach ($users as $index => $user)
	{
		$user_id = UserManager :: create_user($user['FirstName'], $user['LastName'], $user['Status'], $user['Email'], $user['UserName'], $user['Password'], $user['OfficialCode'], $platformLanguage, $user['PhoneNumber'], '', $user['AuthSource']);
		foreach ($user['Courses'] as $index => $course)
		{
			CourseManager :: subscribe_user($user_id, $course);
		}
		if (strlen($user['ClassName']) > 0)
		{
			$class_id = ClassManager :: get_class_id($user['ClassName']);
			ClassManager :: add_user($user_id, $class_id);
		}
		if ($sendMail)
		{
			$emailTo = '"' . $user['FirstName'] . '" <' . $user['Email'] . '>';
			$emailSubject = '[' . get_setting('siteName') . '] ' . get_lang('YourReg') . ' ' . get_setting('siteName');
			$emailBody = get_lang('Dear') . ' ' . $user['FirstName'] . ",\n\n" . 
						 get_lang('YouAreReg') . ' ' . get_setting('siteName') . ' ' . get_lang('Settings') . "\n\n" .
						 get_lang('TheU') . ' : ' . $user[UserName] . "\n" . 
						 get_lang('Pass') . ' : ' . $user[Password] . "\n" . 
						 get_lang('siteName') . ' : ' . api_get_path('WEB_PATH') . " \n\n" .
						 get_lang('Problem') . "\n\n" .
						 get_lang('Manager') . ' : ' . get_setting('administratorName') . ' : ' . get_setting('administratorSurname') . "\n" .
						 get_lang('Phone') . ' : ' . get_setting('administratorTelephone') . "\n" .
						 get_lang('Email') . ' : ' . get_setting('emailAdministrator');
			$emailFromName = addslashes(get_setting('administratorName') . ' ' . get_setting('administratorSurname'));
			$emailFrom = get_setting('emailAdministrator');
			$emailHeader = "Content-Type: text/plain;\n\tcharset=\"".SYSTEM_CHARSET."\"\n";
			$emailHeader .= "Mime-Version: 1.0";
	
			api_mail($emailToName,$emailTo,$emailSubject,$emailBody,$emailFromName,$emailFrom,$emailHeader);
		}

	}
}
/**
 * Read the CSV-file 
 * @param string $file Path to the CSV-file
 * @return array All userinformation read from the file
 */
function parse_csv_data($file)
{
	$users = Import :: csv_to_array($file);
	foreach ($users as $index => $user)
	{
		if (isset ($user['Courses']))
		{
			$user['Courses'] = explode('|', trim($user['Courses']));
		}
		if (strtolower($user['Status'] == 'student'))
		{
			$user['Status'] = STUDENT;
		}
		if (strtolower($user['Status'] == 'teacher'))
		{
			$user['Status'] = COURSEMANAGER;
		}

		$user['FirstName'] = mb_convert_encoding($user['FirstName'], SYSTEM_CHARSET, $_POST['import_encoding']);
		$user['ClassName'] = mb_convert_encoding($user['ClassName'], SYSTEM_CHARSET, $_POST['import_encoding']);

		$users[$index] = $user;
	}
	return $users;
}
/**
 * XML-parser: handle start of element
 */
function element_start($parser, $data)
{
	global $user;
	global $current_tag;
	switch ($data)
	{
		case 'Contact' :
			$user = array ();
			break;
		default :
			$current_tag = $data;
	}
}
/**
 * XML-parser: handle end of element
 */
function element_end($parser, $data)
{
	global $user;
	global $users;
	global $current_value;
	switch ($data)
	{
		case 'Contact' :
			if (strtolower($user['Status'] == 'student'))
			{
				$user['Status'] = STUDENT;
			}
			if (strtolower($user['Status'] == 'teacher'))
			{
				$user['Status'] = COURSEMANAGER;
			}
			$users[] = $user;
			break;
		default :
			$user[$data] = $current_value;
			break;
	}
}
/**
 * XML-parser: handle character data
 */
function character_data($parser, $data)
{
	global $current_value;
	$current_value = $data;
}
/**
 * Read the XML-file
 * @param string $file Path to the XML-file
 * @return array All userinformation read from the file
 */
function parse_xml_data($file)
{
	global $current_tag;
	global $current_value;
	global $user;
	global $users;
	$users = array ();
	$parser = xml_parser_create();
	xml_set_element_handler($parser, 'element_start', 'element_end');
	xml_set_character_data_handler($parser, "character_data");
	xml_parser_set_option($parser, XML_OPTION_CASE_FOLDING, false);
	xml_parse($parser, file_get_contents($file));
	xml_parser_free($parser);
	return $users;
}

function doAction()
{
	if ($_FILES['import_file']['size'] !== 0)
	{
		set_time_limit(0);
	
		$file_type = $_POST['file_type'];
		if ($file_type == 'csv')
		{
			$users = parse_csv_data($_FILES['import_file']['tmp_name']);
		}
		else
		{
			$users = parse_xml_data($_FILES['import_file']['tmp_name']);
		}
		
		my_delete($_FILES['import_file']['tmp_name']);
		
		$errors = validate_data($users);
		if (count($errors) == 0)
		{
			$users = complete_missing_data($users);
			save_data($users);
			header('Location: user_list.php?action=show_message&message='.urlencode(get_lang('FileImported')));
			exit ();
		}
		
		return $errors;
	}
}

$form = new FormValidator('user_import');

$form->addElement('header', 'header', get_lang('ImportUserListXMLCSV'));

$form->addElement('file', 'import_file', get_lang('ImportFileLocation'), array('size'=>'45'));
$form->addRule('import_file', get_lang('ThisFieldIsRequired'), 'required');
$allowed_file_types = array ('xml', 'csv');
$form->addRule('import_file', get_lang('InvalidExtension').' ('.implode(',', $allowed_file_types).')', 'filetype', $allowed_file_types);

$group = array();
$group[] = $form->createElement('radio', 'file_type', null, 'CSV','csv');
$group[] = $form->createElement('radio', 'file_type', null, 'XML','xml');
$form->addGroup($group,'file_type',get_lang('FileType'),null,false);

$encodings = get_encodings();
$form->addElement('select', 'import_encoding', get_lang('ImportEncoding'), $encodings);

$group = array();
$group[] = $form->createElement('radio', 'sendMail', null, get_lang('Yes'), 1);
$group[] = $form->createElement('radio', 'sendMail', null, get_lang('No'), 0);
$form->addGroup($group,'sendMail',get_lang('SendMailToUsers'),null,false);

$group = array ();
$group[] = $form->createElement('submit', 'submit', get_lang('Ok'), 'class="inputSubmit"');
$form->addGroup($group, 'submit', '&nbsp;', null, false);

$defaults['file_type'] = 'csv';
$defaults['sendMail'] = '0';
$defaults['import_encoding'] = get_default_encoding();
$form->setDefaults($defaults);

if ($form->validate())
{
	$errors = doAction();
}

$this_section = SECTION_PLATFORM_ADMIN;
$tool_name = get_lang('ImportUserListXMLCSV');
$interbreadcrumb[] = array ("url" => 'index.php', "name" => get_lang('PlatformAdmin'));
$htmlHeadXtra[] =
"<script type='text/javascript'>
function display_example(id)
{
	if (id == 'cvs')
	{
		document.getElementById('cvs').style.display = 'block';
		document.getElementById('xml').style.display = 'none';
	}
	else
	{
		document.getElementById('xml').style.display = 'block';
		document.getElementById('cvs').style.display = 'none';
	}
}
</script>";

Display :: display_header($tool_name);

if (count($errors) != 0)
{
	$error_message = '<ul>';
	$error_message .= '<li>' . get_lang('ErrorsWhenImportingFile') . ' :</li>';
	foreach ($errors as $index => $error_user)
	{
		$error_message .= '<li>'.$error_user['FirstName'].' '.$error_user['LastName'].': ';
		$error_message .= $error_user['error'];
		$error_message .= '</li>';
	}
	$error_message .= '</ul>';
	Display :: display_error_message($error_message, false);
}

Display::setTemplateBorder($form, '70%');
$form->display();

echo "<br>";

$temp = 'storage/examples/import_files/example_user_' . strtolower(get_default_encoding()) . '.csv';
if (is_file(api_get_path(SYS_PATH).$temp))
{
	$url_csv = api_get_path(WEB_PATH) . $temp;
}
else 
{
	$url_csv = api_get_path(WEB_PATH) . 'storage/examples/import_files/example_user.csv';
}

$temp = 'storage/examples/import_files/example_user_' . strtolower(get_default_encoding()) . '.xml';
if (is_file(api_get_path(SYS_PATH).$temp))
{
	$url_xml = api_get_path(WEB_PATH) . $temp;
}
else 
{
	$url_xml = api_get_path(WEB_PATH) . 'storage/examples/import_files/example_user.xml';
}

$html = "<a href='#' onclick=\"display_example('cvs');\">" . get_lang('ExampleCSVFile') . "</a>&nbsp;(<a href='" . $url_csv . "' target='_blank'>" . get_lang('Download') . "</a>)&nbsp;&nbsp;&nbsp;&nbsp;";
$html .= "<a href='#' onclick=\"display_example('xml');\">" . get_lang('ExampleXMLFile') . "</a>&nbsp;(<a href='" . $url_xml . "' target='_blank'>" . get_lang('Download') . "</a>)";

?>

<table align="center" width="70%">
<tr><td><?php echo $html; ?><br><br></td></tr>
<tr><td>
<div id="cvs" style="display:none">
<p><?php echo get_lang('CSVMustLookLike').' ('.get_lang('MandatoryFields').')'; ?> :</p>
<pre>
<!--<b>LastName</b>;--><b>FirstName</b>;<b>UserName</b>;Password;AuthSource;<b>Email</b>;OfficialCode;PhoneNumber;Status;Courses;ClassName
<!--<b>xxx</b>;--><b>xxx</b>;<b>xxx</b>;xxx;<?php echo implode('/',$defined_auth_sources); ?>;<b>xxx</b>;xxx;xxx;student/teacher;xxx1|xxx2|xxx3;xxx
</pre>
</div>
</td></tr>
<tr><td>
<div id="xml" style="display:none">
<p><?php echo get_lang('XMLMustLookLike').' ('.get_lang('MandatoryFields').')'; ?> :</p>
<pre>
&lt;?xml version=&quot;1.0&quot; encoding=&quot;Your encoding&quot;?&gt;
&lt;Contacts&gt;
    &lt;Contact&gt;
        <b>&lt;FirstName&gt;xxx&lt;/FirstName&gt;</b>
        <b>&lt;UserName&gt;xxx&lt;/UserName&gt;</b>
        &lt;Password&gt;xxx&lt;/Password&gt;
        &lt;AuthSource&gt;<?php echo implode('/',$defined_auth_sources); ?>&lt;/AuthSource&gt;
        <b>&lt;Email&gt;xxx&lt;/Email&gt;</b>
        &lt;OfficialCode&gt;xxx&lt;/OfficialCode&gt;
        &lt;PhoneNumber&gt;xxx&lt;/PhoneNumber&gt;
        &lt;Status&gt;student/teacher&lt;/Status&gt;
        &lt;Courses&gt;xxx1|xxx2|xxx3&lt;/Courses&gt;
        &lt;ClassName&gt;class 1&lt;/ClassName&gt;
    &lt;/Contact&gt;
&lt;/Contacts&gt;
</pre>
</div>
</td></tr>
</table>

<?php


/*
==============================================================================
		FOOTER
==============================================================================
*/
Display :: display_footer();
?>