<?php
// name of the language file that needs to be included
$language_file = array('registration','tracking');

$cidReset = true;

require ('../inc/global.inc.php');
require_once (api_get_path(LIBRARY_PATH).'tracking.lib.php');

$nameTools=get_lang('MyProgress');

if(isset($_GET['id_session']))
{
	$id_session = intval($_GET['id_session']);

	$_SESSION['id_session']=$id_session;
}
elseif(isset($_SESSION['id_session']))
{
	$id_session=$_SESSION['id_session'];
}
else
{
	$id_session=0;
}

api_block_anonymous_users();

$this_section = SECTION_PROGRESS;

$htmlHeadXtra[] = get_table_style_ie6();

Display :: display_header($nameTools);

// Database table definitions
$tbl_course 				= Database :: get_main_table(TABLE_MAIN_COURSE);
$tbl_user 					= Database :: get_main_table(TABLE_MAIN_USER);
$tbl_session 				= Database :: get_main_table(TABLE_MAIN_SESSION);
$tbl_course_user 			= Database :: get_main_table(TABLE_MAIN_COURSE_USER);
$tbl_session_course 		= Database :: get_main_table(TABLE_MAIN_SESSION_COURSE);
$tbl_session_course_user 	= Database :: get_main_table(TABLE_MAIN_SESSION_COURSE_USER);
$tbl_stats_lastaccess 		= Database :: get_statistic_table(TABLE_STATISTIC_TRACK_E_LASTACCESS);
$tbl_stats_exercices 		= Database :: get_statistic_table(TABLE_STATISTIC_TRACK_E_EXERCICES);
$tbl_course_lp_view 		= Database :: get_course_table(TABLE_LP_VIEW);
$tbl_course_lp_view_item 	= Database :: get_course_table(TABLE_LP_ITEM_VIEW);
$tbl_course_lp 				= Database :: get_course_table(TABLE_LP_MAIN);
$tbl_course_lp_item 		= Database :: get_course_table(TABLE_LP_ITEM);
$tbl_course_quiz 			= Database :: get_course_table(TABLE_QUIZ_TEST);

$sql = "SELECT DISTINCT id, name, date_start, date_end FROM $tbl_session_course_user,$tbl_session WHERE id_session=id AND id_user=" . $_user['user_id'] . " ORDER BY date_start, date_end, name";
$result=api_sql_query($sql,__FILE__,__LINE__);

$Sessions=api_store_result($result);

$Courses=array();

if($id_session)
{
	$sql = "SELECT DISTINCT code,title, CONCAT(lastname, ' ',firstname) coach, username, date_start, date_end, db_name
			FROM $tbl_course , $tbl_session_course
			LEFT JOIN $tbl_user
				ON $tbl_session_course.id_coach = $tbl_user.user_id
			INNER JOIN $tbl_session_course_user
				ON $tbl_session_course_user.id_session = $tbl_session_course.id_session
				AND $tbl_session_course_user.id_user = '".$_user['user_id']."'
			INNER JOIN $tbl_session ON $tbl_session.id = $tbl_session_course.id_session
			WHERE $tbl_session_course.course_code=code
			AND $tbl_session_course.id_session='$id_session'
			ORDER BY title";

	$result=api_sql_query($sql,__FILE__,__LINE__);

	$Courses=api_store_result($result);
}
else 
{
	$sql = "SELECT DISTINCT code,title, db_name
			FROM $tbl_course 
			LEFT JOIN $tbl_course_user
				ON $tbl_course_user.course_code = $tbl_course.code
			WHERE $tbl_course_user.user_id = '" . $_user['user_id'] . "'
			ORDER BY title";
	$result=api_sql_query($sql,__FILE__,__LINE__);

	$Courses=api_store_result($result);
}

//api_display_tool_title($nameTools);

$now=date('Y-m-d');

if($id_session)
{
?>

<form method="get" action="<?php echo $_SERVER['PHP_SELF']; ?>" style="margin: 0px;">
<center>
<?php echo get_lang('SessionCourses'); ?> :
<select name="id_session">
<option value="0">----- <?php echo get_lang('Select'); ?> -----</option>

<?php
$date_start=$date_end=$now;

foreach($Sessions as $enreg)
{
	if($enreg['id'] == $id_session)
	{
		$date_start=$enreg['date_start'];
		$date_end=$enreg['date_end'];
	}
	$enreg['date_start']=explode('-',$enreg['date_start']);
	$enreg['date_start']=$enreg['date_start'][2].'/'.$enreg['date_start'][1].'/'.$enreg['date_start'][0];

	$enreg['date_end']=explode('-',$enreg['date_end']);
	$enreg['date_end']=$enreg['date_end'][2].'/'.$enreg['date_end'][1].'/'.$enreg['date_end'][0];

?>

<option value="<?php echo $enreg['id']; ?>" <?php if($enreg['id'] == $id_session) echo 'selected="selected"'; ?> ><?php echo htmlentities($enreg['name'], ENT_NOQUOTES, SYSTEM_CHARSET); if($date_start!='0000-00-00') { ?> (<?php echo get_lang('From'); ?> <?php echo $enreg['date_start']; ?> <?php echo get_lang('To'); ?> <?php echo $enreg['date_end']; ?>)<?php } ?></option>

<?php
}

unset($Sessions);
?>

</select>
<input type="submit" class="inputSubmit" value="<?php echo get_lang('Ok'); ?>" />
</center>
</form>
<?php
}
echo '<br />';
?>

<table class="data_table" width="100%">
<tr>
  <th width="30%"><?php echo get_lang('Course'); ?></th>
  <th width="15%"><?php echo get_lang('Time'); ?></th>
  <th width="10%"><?php echo get_lang('Progress'); ?></th>
  <th width="10%"><?php echo get_lang('Score'); ?></th>
  <th width="25%"><?php echo get_lang('LastConnexion'); ?></th>
  <th width="10%"><?php echo get_lang('Details'); ?></th>
</tr>

<?php
$i = 0;
$totalWeighting = 0;
$totalScore = 0;
$totalItem = 0;
$totalProgress = 0;

foreach($Courses as $enreg)
{
	$weighting = 0;

	$lastConnexion = Tracking :: get_last_connection_date_on_the_course($_user['user_id'],$enreg['code']);

	$progress = Tracking :: get_avg_student_progress($_user['user_id'], $enreg['code']);

	$time = api_time_to_hms(Tracking :: get_time_spent_on_the_course($_user['user_id'], $enreg['code']));

	$pourcentageScore = Tracking :: get_avg_student_score($_user['user_id'], $enreg['code']);

?>

<tr class='<?php echo $i?'row_odd':'row_even'; ?>'>
  	<td>
		<?php echo htmlentities($enreg['title'], ENT_NOQUOTES, SYSTEM_CHARSET); ?>
  	</td>

  	<td align='center'>
		<?php echo $time; ?>
  	</td>

  	<td align='center'>
  		<?php echo $progress.'%'; ?>
  	</td>

  	<td align='center'>
		<?php echo $pourcentageScore.'%'; ?>
  	</td>

  	<td align='center'>
		<?php echo $lastConnexion; ?>
  	</td>

  	<td align='center'>
  	  <?php
  	  if($id_session) {
  	  ?>
		<a href="<?php echo $SERVER['PHP_SELF']; ?>?id_session=<?php echo $id_session ?>&course=<?php echo $enreg['code']; ?>"> <?php echo Display::return_icon('2rightarrow.gif'); ?> </a>
	  <?php
	  } else {
	  ?>
	    <a href="../mySpace/myStudents.php?student=<?php echo $_user['user_id'] ?>&details=true&course=<?php echo $enreg['code']; ?>&origin=tracking_course"> <?php echo Display::return_icon('2rightarrow.gif');;?> </a>
	  <?php
	  }
	  ?>
  	</td>
</tr>

<?php
	$i=$i ? 0 : 1;
}
?>
</table>

<br/><br/>

<?php
/*
 * **********************************************************************************************
 *
 * 	Details for one course
 *
 * **********************************************************************************************
 */
    if(isset($_GET['course']))
	{
		$sqlInfosCourse = "	SELECT course.code,course.title,course.db_name,CONCAT(user.firstname,' ',user.lastname,' / ',user.email) as tutor_infos
							FROM $tbl_user as user,$tbl_course as course
							INNER JOIN $tbl_session_course as sessionCourse
								ON sessionCourse.course_code = course.code
							WHERE sessionCourse.id_coach = user.user_id
							AND course.code= '".$_GET['course']."'
						 ";
         
		$resultInfosCourse = api_sql_query($sqlInfosCourse,__FILE__,__LINE__);

		$a_infosCours = mysql_fetch_array($resultInfosCourse);
		$tableTitle = $a_infosCours['title'].' - '.get_lang('Tutor').' : '.$a_infosCours['tutor_infos'];

		?>
		<table class="data_table" width="100%">
			<tr class="tableName">
				<td colspan="4">
					<strong><?php echo $tableTitle; ?></strong>
				</td>
			</tr>
			<tr>
			  <th class="head"><?php echo get_lang('Learnpath'); ?></th>
			  <th class="head"><?php echo get_lang('Time'); ?></th>
			  <th class="head"><?php echo get_lang('Progress'); ?></th>
			  <th class="head"><?php echo get_lang('LastConnexion'); ?></th>
			</tr>
			<?php
				$sqlLearnpath = "	SELECT lp.name,lp.id
									FROM ".$a_infosCours['db_name'].".".$tbl_course_lp." AS lp
								";

				$resultLearnpath = api_sql_query($sqlLearnpath,__FILE__,__LINE__);

				if(mysql_num_rows($resultLearnpath)>0)
				{
					while($a_learnpath = mysql_fetch_array($resultLearnpath))
					{
						$sqlProgress = "SELECT COUNT(DISTINCT lp_item_id) AS nbItem
										FROM ".$a_infosCours['db_name'].".".$tbl_course_lp_view_item." AS item_view
										INNER JOIN ".$a_infosCours['db_name'].".".$tbl_course_lp_view." AS view
											ON item_view.lp_view_id = view.id
											AND view.lp_id = ".$a_learnpath['id']."
											AND view.user_id = ".$_user['user_id']."
										WHERE item_view.status = 'completed' OR item_view.status = 'passed'
										";
						$resultProgress = api_sql_query($sqlProgress,__FILE__,__LINE__);
						$a_nbItem = mysql_fetch_array($resultProgress);

						$sqlTotalItem = "	SELECT	COUNT(item_type) AS totalItem
											FROM ".$a_infosCours['db_name'].".".$tbl_course_lp_item."
											WHERE lp_id = ".$a_learnpath['id']."
											AND item_type != 'chapter'
											AND item_type != 'dokeos_chapter'
											AND item_type != 'dir'"
										;
						$resultItem = api_sql_query($sqlTotalItem,__FILE__,__LINE__);
						$a_totalItem = mysql_fetch_array($resultItem);

						$progress = round(($a_nbItem['nbItem'] * 100)/$a_totalItem['totalItem']);


						// calculates last connection time
						$sql = 'SELECT MAX(start_time)
									FROM '.$a_infosCours['db_name'].'.'.$tbl_course_lp_view_item.' AS item_view
									INNER JOIN '.$a_infosCours['db_name'].'.'.$tbl_course_lp_view.' AS view
										ON item_view.lp_view_id = view.id
										AND view.lp_id = '.$a_learnpath['id'].'
										AND view.user_id = '.$_user['user_id'];
						$rs = api_sql_query($sql, __FILE__, __LINE__);
						$start_time = mysql_result($rs, 0, 0);

						// calculates time
						$sql = 'SELECT SUM(total_time)
									FROM '.$a_infosCours['db_name'].'.'.$tbl_course_lp_view_item.' AS item_view
									INNER JOIN '.$a_infosCours['db_name'].'.'.$tbl_course_lp_view.' AS view
										ON item_view.lp_view_id = view.id
										AND view.lp_id = '.$a_learnpath['id'].'
										AND view.user_id = '.$_user['user_id'];
						$rs = api_sql_query($sql, __FILE__, __LINE__);
						$total_time = mysql_result($rs, 0, 0);


						echo "<tr>
								<td>
							 ";
						echo 		stripslashes($a_learnpath['name']);
						echo "	</td>
								<td>
							 ";
						echo api_time_to_hms($total_time);
						echo "	</td>
								<td align='center'>
							 ";
						echo		$progress.'%';
						echo "	</td>
								<td align='center'>
							 ";
						if($start_time!=''){
							echo format_locale_date(get_lang('DateFormatLong'),$start_time);
						}
						else{
							echo '-';
						}
						echo "	</td>
							  </tr>
							 ";
					}

				}
				else
				{
					echo "	<tr>
								<td colspan='4'>
									".get_lang('NoLearnpath')."
								</td>
							</tr>
						 ";
				}



			?>
			<tr>
			  <th class="head"><?php echo get_lang('Exercices'); ?></th>
			  <th class="head"><?php echo get_lang('Score'); ?></th>
			  <th class="head"><?php echo get_lang('Attempts'); ?></th>
			  <th class="head"><?php echo get_lang('Details'); ?></th>
			</tr>

			<?php

				$sqlExercices = "	SELECT quiz.title,id
								FROM ".$a_infosCours['db_name'].".".$tbl_course_quiz." AS quiz
							";

				$resuktExercices = api_sql_query($sqlExercices,__FILE__,__LINE__);
				while($a_exercices = mysql_fetch_array($resuktExercices))
				{
					$sqlEssais = "	SELECT COUNT(ex.exe_id) as essais
									FROM $tbl_stats_exercices AS ex
									WHERE ex.exe_user_id='".$_user['user_id']."' AND ex.exe_cours_id = '".$a_infosCours['code']."'
									AND ex.exe_exo_id = ".$a_exercices['id']
								 ;
					$resultEssais = api_sql_query($sqlEssais,__FILE__,__LINE__);
					$a_essais = mysql_fetch_array($resultEssais);

					$sqlScore = "SELECT exe_id , exe_result,exe_weighting
								 FROM $tbl_stats_exercices
								 WHERE exe_user_id = ".$_user['user_id']."
								 AND exe_cours_id = '".$a_infosCours['code']."'
								 AND exe_exo_id = ".$a_exercices['id']."
								ORDER BY exe_date DESC LIMIT 1"
									;

					$resultScore = api_sql_query($sqlScore,__FILE__,__LINE__);
					$score = 0;
					while($a_score = mysql_fetch_array($resultScore))
					{
						$score = $score + $a_score['exe_result'];
						$weighting = $weighting + $a_score['exe_weighting'];
						$exe_id = $a_score['exe_id'];
					}
					$pourcentageScore = round(($score*100)/$weighting);

					$weighting = 0;

					echo "<tr>
							<td>
						 ";
					echo 		$a_exercices['title'];
					echo "	</td>
						 ";
					echo "	<td align='center'>
						  ";
					echo $pourcentageScore.'%';
					echo "	</td>

							<td align='center'>
						 ";
					echo 		$a_essais['essais'];
					echo '	</td>
							<td align="center" width="25">
						 ';
					if($a_essais['essais']>0)
						echo '<a href="../exercice/exercise_show.php?origin=student_progress&id=' . $exe_id . '&cidReq=' . $a_infosCours['code'] . '&id_session=' . $_GET['id_session'] . '">' . Display::return_icon('quiz.gif') . '</a>';
						
					echo "	</td>
						  </tr>
						 ";
				}


			?>
		</table>
		<?php
	}

Display :: display_footer();
?>