<?php
/*
==============================================================================
	Dokeos - elearning and course management software

	Copyright (c) 2004 Dokeos S.A.
	Copyright (c) 2003 University of Ghent (UGent)
	Copyright (c) 2001 Universite catholique de Louvain (UCL)
	Copyright (c) various contributors

	For a full list of contributors, see "credits.txt".
	The full license can be read in "license.txt".

	This program is free software; you can redistribute it and/or
	modify it under the terms of the GNU General Public License
	as published by the Free Software Foundation; either version 2
	of the License, or (at your option) any later version.

	See the GNU General Public License for more details.

	Contact: Zhong 	poopsoft@163.com

==============================================================================

    BLOG HOMEPAGE

	This file takes care of all blog navigation and displaying.

	@package iilearn.blogs
==============================================================================
*/

// name of the language file that needs to be included
$language_file = "blog";

require_once('../inc/global.inc.php');
require_once(api_get_path(LIBRARY_PATH) . "blog.lib.php");

// showing the header if we are not in the learning path, if we are in
// the learning path, we do not include the banner so we have to explicitly
// include the stylesheet, which is normally done in the header
if ($_GET['origin'] != 'learnpath')
{
	$this_section = SECTION_COURSES;
	$htmlHeadXtra[] = get_table_style_ie6();
	$nameTools = get_lang("blog_management");
	Display::display_header($nameTools,'Blogs');
}
else
{
	echo "<link rel=\"stylesheet\" type=\"text/css\" href=\"" . api_get_path(WEB_CSS_PATH).'default.css' . "\"/>";
}
/*
==============================================================================
	PROCESSING..
==============================================================================
*/
if ($_POST['new_blog_submit'])
{
	Blog::create_blog($_POST['blog_name'],$_POST['blog_subtitle']);
}
if ($_POST['edit_blog_submit'])
{
	Blog::edit_blog($_POST['blog_id'],$_POST['blog_name'],$_POST['blog_subtitle']);
}
if ($_GET['action'] == 'visibility')
{
	Blog::change_blog_visibility(Database::escape_string((int)$_GET['blog_id']));
}
if ($_GET['action'] == 'delete')
{
	Blog::delete_blog(Database::escape_string((int)$_GET['blog_id']));
}


/*
==============================================================================
	DISPLAY
==============================================================================
*/

	if ($_GET['action'] == 'add')
	{
		Blog::display_new_blog_form();
	}
	if ($_GET['action'] == 'edit')
	{
		Blog::display_edit_blog_form(Database::escape_string((int)$_GET['blog_id']));
	}

	echo "<a href='".$_SERVER['PHP_SELF']."?action=add'>",
		Display::return_icon('blog_new.gif', get_lang('NewBlog'), array('align'=>'absmiddle')) . "&nbsp;&nbsp;" . get_lang('AddBlog') . "</a>";
	echo "<table width=\"100%\" border=\"0\" cellspacing=\"0\" class='data_table'>";
	echo	"<tr>",
				 "<th>",get_lang('Title'),"</th>\n",
				 "<th>",get_lang('Subtitle'),"</th>\n",
				 "<th>&nbsp;</th>\n",
			"</tr>\n";
	Blog::display_blog_list();
	echo "</table>";


// Display the footer
Display::display_footer();
?>