<?php // $Id: index.php 11249 2007-02-27 10:53:09Z elixir_julian $
/*
==============================================================================
	Dokeos - elearning and course management software

	Copyright (c) 2004 Dokeos S.A.
	Copyright (c) 2003 Ghent University (UGent)
	Copyright (c) 2001 Universite catholique de Louvain (UCL)
	Copyright (c) Bart Mollet, Hogeschool Gent

	For a full list of contributors, see "credits.txt".
	The full license can be read in "license.txt".

	This program is free software; you can redistribute it and/or
	modify it under the terms of the GNU General Public License
	as published by the Free Software Foundation; either version 2
	of the License, or (at your option) any later version.

	See the GNU General Public License for more details.

	Contact: Zhong
	Mail: poopsoft@163.com
==============================================================================
*/
/**
==============================================================================
*	This script edits the course description.
*	This script is reserved for users with write access on the course.
*
*	@author Thomas Depraetere
*	@author Hugues Peeters
*	@author Christophe Gesch?
*	@author Olivier brouckaert
*	@package iilearn.course_description
==============================================================================
*/

/*
==============================================================================
		INIT SECTION
==============================================================================
*/
// name of the language file that needs to be included
$language_file = array ('course_description', 'pedaSuggest', 'accessibility');

include_once('../inc/global.inc.php');
include_once(api_get_path(LIBRARY_PATH).'formvalidator/FormValidator.class.php');
include_once(api_get_path(LIBRARY_PATH).'WCAG/WCAG_rendering.php');
include_once(api_get_path(LIBRARY_PATH).'events.lib.inc.php');

/*
-----------------------------------------------------------
	Header
-----------------------------------------------------------
*/

$this_section = SECTION_COURSES;

$interbreadcrumb[] = array ("url" => "index.php", "name" => get_lang('CourseProgram'));

if(isset($_GET['description_id']) && $_GET['description_id']==1) $interbreadcrumb[] = array ("url" => "#", "name" => get_lang('GeneralDescription'));
if(isset($_GET['description_id']) && $_GET['description_id']==2) $interbreadcrumb[] = array ("url" => "#", "name" => get_lang('Objectives'));
if(isset($_GET['description_id']) && $_GET['description_id']==3) $interbreadcrumb[] = array ("url" => "#", "name" => get_lang('Topics'));
if(isset($_GET['description_id']) && $_GET['description_id']==4) $interbreadcrumb[] = array ("url" => "#", "name" => get_lang('Methodology'));
if(isset($_GET['description_id']) && $_GET['description_id']==5) $interbreadcrumb[] = array ("url" => "#", "name" => get_lang('CourseMaterial'));
if(isset($_GET['description_id']) && $_GET['description_id']==6) $interbreadcrumb[] = array ("url" => "#", "name" => get_lang('HumanAndTechnicalResources'));
if(isset($_GET['description_id']) && $_GET['description_id']==7) $interbreadcrumb[] = array ("url" => "#", "name" => get_lang('Assessment'));
if(isset($_GET['description_id']) && $_GET['description_id']==8) $interbreadcrumb[] = array ("url" => "#", "name" => get_lang('NewBloc'));

event_access_tool(TOOL_COURSE_DESCRIPTION);

Display :: display_header(null, "Description");

api_protect_course_script();

/*
-----------------------------------------------------------
	Constants and variables
-----------------------------------------------------------
*/
//$nameTools = get_lang(TOOL_COURSE_DESCRIPTION);

$tbl_course_description = Database::get_course_table(TABLE_COURSE_DESCRIPTION);

$show_description_list = true;
$show_peda_suggest = true;
define('ADD_BLOCK', 8);
// Default descriptions
$default_description_titles = array();
$default_description_titles[1]= get_lang('GeneralDescription');
$default_description_titles[2]= get_lang('Objectives');
$default_description_titles[3]= get_lang('Topics');
$default_description_titles[4]= get_lang('Methodology');
$default_description_titles[5]= get_lang('CourseMaterial');
$default_description_titles[6]= get_lang('HumanAndTechnicalResources');
$default_description_titles[7]= get_lang('Assessment');
$default_description_titles[8]= get_lang('NewBloc');
$default_description_icon = array();
$default_description_icon[1]= 'edu_miscellaneous.gif';
$default_description_icon[2]= 'spire.gif';
$default_description_icon[3]= 'kcmdf_big.gif';
$default_description_icon[4]= 'misc.gif';
$default_description_icon[5]= 'laptop.gif';
$default_description_icon[6]= 'personal.gif';
$default_description_icon[7]= 'korganizer.gif';
$default_description_icon[8]= 'ktip.gif';

$default_description_small_icon = array();
$default_description_small_icon[1]= 'edu_miscellaneous_small.gif';
$default_description_small_icon[2]= 'spire_small.gif';
$default_description_small_icon[3]= 'kcmdf_big_small.gif';
$default_description_small_icon[4]= 'misc_small.gif';
$default_description_small_icon[5]= 'laptop_small.gif';
$default_description_small_icon[6]= 'personal_small.gif';
$default_description_small_icon[7]= 'korganizer_small.gif';
$default_description_small_icon[8]= 'ktip_small.gif';

$question = array();
$question[1]= get_lang('GeneralDescriptionQuestions');
$question[2]= get_lang('ObjectivesQuestions');
$question[3]= get_lang('TopicsQuestions');
$question[4]= get_lang('MethodologyQuestions');
$question[5]= get_lang('CourseMaterialQuestions');
$question[6]= get_lang('HumanAndTechnicalResourcesQuestions');
$question[7]= get_lang('AssessmentQuestions');
$information = array();
$information[1]= get_lang('GeneralDescriptionInformation');
$information[2]= get_lang('ObjectivesInformation');
$information[3]= get_lang('TopicsInformation');
$information[4]= get_lang('MethodologyInformation');
$information[5]= get_lang('CourseMaterialInformation');
$information[6]= get_lang('HumanAndTechnicalResourcesInformation');
$information[7]= get_lang('AssessmentInformation');
$default_description_title_editable = array();
$default_description_title_editable[1] = true;
$default_description_title_editable[2] = true;
$default_description_title_editable[3] = true;
$default_description_title_editable[4] = true;
$default_description_title_editable[5] = true;
$default_description_title_editable[6] = true;
$default_description_title_editable[7] = true;


/*
==============================================================================
		MAIN CODE
==============================================================================
*/
$description_id = isset ($_REQUEST['description_id']) ? intval($_REQUEST['description_id']) : null;
if (api_is_allowed_to_edit() && !is_null($description_id))
{
	// Delete a description block
	if (isset ($_GET['action']) && $_GET['action'] == 'delete')
	{
		$sql = "DELETE FROM $tbl_course_description WHERE id='$description_id'";
		api_sql_query($sql, __FILE__, __LINE__);
		Display :: display_confirmation_message(get_lang('CourseDescriptionDeleted'));
	}
	// Add or edit a description block
	else
	{
		$sql = "SELECT * FROM $tbl_course_description WHERE id='$description_id'";
		$result = api_sql_query($sql, __FILE__, __LINE__);
		if ($description = mysql_fetch_array($result))
		{
			$default_description_titles[$description_id] = $description['title'];
			$description_content = $description['content'];
		}
		
		$fck_attribute['Width'] = '100%';
		$fck_attribute['Height'] = '225';
		$fck_attribute['ToolbarSet'] = 'Middle';
		
		echo '
		<style>
		.row{
			width:100%;
		}
		div.row div.label {
			width: 60px;
		}
		
		div.row div.formw {
			width: 100%;
		}
		</style>';
		
		$form = new FormValidator('course_description1','POST','index.php','');
		$form->addElement('header', 'header', $default_description_titles[$description_id]);
		
		$form->addElement('hidden', 'description_id');
		if (($description_id == ADD_BLOCK) || $default_description_title_editable[$description_id])
		{
			$form->add_textfield('title', get_lang('Title'), true, array('size'=>50));
		}
		
		if (api_get_setting('wcag_anysurfer_public_pages')=='true') {
			WCAG_rendering::prepare_admin_form($description_content, $form);
		} else {
			$form->add_html_editor('contentDescription', get_lang('Content'));
		}
		
		$group = array ();
		$group[] = $form->createElement('submit', null, get_lang('Ok'), 'class="inputSubmit"');
		$form->addGroup($group, 'submit', '&nbsp;', null, false);

		// Set some default values
		$default['title'] = $default_description_titles[$description_id];
		$default['contentDescription'] = $description_content;
		$default['description_id'] = $description_id;
		if($description_id == ADD_BLOCK) $default['description_id'] = ADD_BLOCK;
		$form->setDefaults($default);
		
		Display::setTemplateBorder($form, '75%');
		
		// If form validates: save the description block
		if ($form->validate())
		{
			$description = $form->exportValues();
			if (api_get_setting('wcag_anysurfer_public_pages')=='true') {
				$content = WCAG_Rendering::prepareXHTML();
			} else {
				$content = $description['contentDescription'];
			}
			$title = $description['title'];
			if ($description['description_id'] == ADD_BLOCK)
			{
				$sql = "SELECT MAX(id) FROM $tbl_course_description";
				$result = api_sql_query($sql, __FILE__, __LINE__);
				$sql = "INSERT IGNORE INTO $tbl_course_description SET id = '".$description_id."', title = '".Database::escape_string($title)."', content = '".Database::escape_string($content)."'";
				api_sql_query($sql, __FILE__, __LINE__);
			}
			else
			{
				if (!$default_description_title_editable[$description_id])
				{
					$title = $default_description_titles[$description_id];
				}
				$sql = "DELETE FROM $tbl_course_description WHERE id = '".$description_id."'";
				api_sql_query($sql, __FILE__, __LINE__);
				$sql = "INSERT IGNORE INTO $tbl_course_description SET id = '".$description_id."', title = '".Database::escape_string($title)."', content = '".Database::escape_string($content)."'";
				api_sql_query($sql, __FILE__, __LINE__);
			}
			api_item_property_update($_course, TOOL_COURSE_DESCRIPTION, mysql_insert_id(), "CourseDescriptionUpdated", $_user['user_id']);
			Display :: display_confirmation_message(get_lang('CourseDescriptionUpdated'));
		}
		// Show the form
		else
		{
			if (api_get_setting('wcag_anysurfer_public_pages')=='true') {
				echo (WCAG_Rendering::editor_header());
			}

			$form->display();
			if ($show_peda_suggest)
			{
				echo "<table align=center width='75%'><tr><td>";
				if (isset ($question[$description_id]))
				{
					echo '<b>' . get_lang('QuestionPlan') . '</b>: ' . $question[$description_id];
				}
				echo '</td></tr></table>';
			}
			
			if (api_get_setting('wcag_anysurfer_public_pages')=='true') {
				echo (WCAG_Rendering::editor_footer());
			}
			$show_description_list = false;
		}
	}
}

// Show the list of all description blocks
if ($show_description_list)
{
	$sql = "SELECT * FROM $tbl_course_description ORDER BY id";
	$result = api_sql_query($sql, __FILE__, __LINE__);
	$descriptions;
	while ($description = mysql_fetch_object($result))
	{
		$descriptions[$description->id] = $description;
	}
	if (api_is_allowed_to_edit())
	{
		$categories = array ();
		
		foreach ($default_description_titles as $id => $title)
		{
			$categories[$id] = $title;
		}
		$categories[ADD_BLOCK] = get_lang('NewBloc');
		
		$i=1;
		foreach ($categories as $id => $title){
			if($i==1 || $i==5){
				echo '<div class="courseDescription">';
			}
			echo '<div class="courseDescriptionIcon">
	            	<a href="' . $_SERVER["PHP_SELF"] . '?description_id=' . $id . '">' . Display::return_icon($default_description_icon[$id]) . '<br>' . $title . '</a>
	        	</div>';
        	if($i==4 || $i==8){
				echo '<div class="clear"></div></div>';
			}
			$i++;
		}
		
		echo '<br>';
	}
	if (count($descriptions) > 0)
	{
		foreach ($descriptions as $id => $description)
		{
			$html = "<div class='courseDescriptionContent'>";
			$html .= "<table class='contentData' cellspacing='0'>";
			$html .= "<tr>";
			$html .= "<th align='left'>" . Display::return_icon($default_description_small_icon[$description->id]) . $description->title . "</th>";
			if (api_is_allowed_to_edit())
			{
				$html .= "<th align='right'><a href='" . $_SERVER['PHP_SELF'] . "?action=delete&amp;description_id=" . $description->id . "' onclick=\"javascript:if(!confirm('" . addslashes(htmlentities(get_lang('ConfirmYourChoice'), ENT_NOQUOTES, SYSTEM_CHARSET)) . "')) return false;\">";
				$html .= Display::return_icon('delete.gif', get_lang('Delete')) . "</a></th>";
			}
			else 
			{
				$html .= "<th>&nbsp;</th>";
			}
			$html .= "</tr>";
			$html .= "<tr><td colspan='2'>";
			echo $html;
			
			echo text_filter($description->content);
			
			$html = "</td></tr></table>";
			$html .= "</div>";
			echo $html;
		}
	}
	else
	{
		echo '<br>';
		Display :: display_normal_message(get_lang('ThisCourseDescriptionIsEmpty'));
	}
}
/*
==============================================================================
		FOOTER
==============================================================================
*/
Display :: display_footer();
?>