<?php
// $Id: create_document.php 11663 2007-03-22 14:48:23Z elixir_inter $
/*
==============================================================================
	Dokeos - elearning and course management software

	Copyright (c) 2004 Dokeos S.A.
	Copyright (c) 2003 Ghent University (UGent)
	Copyright (c) 2001 Universite catholique de Louvain (UCL)
	Copyright (c) Olivier Brouckaert
	Copyright (c) Bart Mollet, Hogeschool Gent

	For a full list of contributors, see "credits.txt".
	The full license can be read in "license.txt".

	This program is free software; you can redistribute it and/or
	modify it under the terms of the GNU General Public License
	as published by the Free Software Foundation; either version 2
	of the License, or (at your option) any later version.

	See the GNU General Public License for more details.

	Contact: Zhong 	poopsoft@163.com
==============================================================================
*/
/**
==============================================================================
*	This file allows creating new html documents with an online WYSIWYG html
*	editor.
*
*	@package iilearn.document
==============================================================================
*/

/*
==============================================================================
		INIT SECTION
==============================================================================
*/

// name of the language file that needs to be included 
$language_file = 'document';

include ('../inc/global.inc.php');
$this_section = SECTION_COURSES;

$htmlHeadXtra[]='<script>
	
	var temp=false;
	var temp2=false;
	var use_document_title='.api_get_setting('use_document_title').';

	function FCKeditor_OnComplete( editorInstance )
	{
	  editorInstance.Events.AttachEvent( \'OnSelectionChange\', check_for_title ) ;
	}

	function check_for_title()
	{
		if(temp==true){
			// This functions shows that you can interact directly with the editor area
			// DOM. In this way you have the freedom to do anything you want with it.
	
			// Get the editor instance that we want to interact with.
			var oEditor = FCKeditorAPI.GetInstance(\'content\') ;
	
			// Get the Editor Area DOM (Document object).
			var oDOM = oEditor.EditorDocument ;
	
			var iLength ;
			var contentText ;
			var contentTextArray;
			var bestandsnaamNieuw = "";
			var bestandsnaamOud = "";
	
			// The are two diffent ways to get the text (without HTML markups).
			// It is browser specific.
	
			if( document.all )		// If Internet Explorer.
			{
				contentText = oDOM.body.innerText ;
			}
			else					// If Gecko.
			{
				var r = oDOM.createRange() ;
				r.selectNodeContents( oDOM.body ) ;
				contentText = r.toString() ;
			}

			var index=contentText.indexOf("/*<![CDATA");
			contentText=contentText.substr(0,index);			

			// Compose title if there is none
			contentTextArray = contentText.split(\' \') ;
			var x=0;
			for(x=0; (x<5 && x<contentTextArray.length); x++)
			{
				if(x < 4)
				{
					bestandsnaamNieuw += contentTextArray[x] + \' \';
				}
				else
				{
					bestandsnaamNieuw += contentTextArray[x];
				}
			}
	
			if(document.getElementById(\'title_edited\').value == "false")
			{
				document.getElementById(\'filename\').value = bestandsnaamNieuw;
				if(use_document_title){
					document.getElementById(\'title\').value = bestandsnaamNieuw;
				}
			}
		}
		temp=true;
	}

	function trim(s) {
	 while(s.substring(0,1) == \' \') {
	  s = s.substring(1,s.length);
	 }
	 while(s.substring(s.length-1,s.length) == \' \') {
	  s = s.substring(0,s.length-1);
	 }
	 return s;
	}

	function check_if_still_empty()
	{
		if(trim(document.getElementById(\'filename\').value) != "")
		{
			document.getElementById(\'title_edited\').value = "true";
		}
	}

</script>';

include (api_get_path(LIBRARY_PATH).'fileUpload.lib.php');
include (api_get_path(LIBRARY_PATH).'document.lib.php');
include (api_get_path(LIBRARY_PATH).'groupmanager.lib.php');
include (api_get_path(LIBRARY_PATH).'events.lib.inc.php');
include (api_get_path(LIBRARY_PATH).'formvalidator/FormValidator.class.php');
$nameTools = get_lang('CreateDocument');

$fck_attribute['Width'] = '100%';
$fck_attribute['Height'] = '650';
$fck_attribute['ToolbarSet'] = 'Full';
$fck_attribute['Config']['FullPage'] = true;

/*
-----------------------------------------------------------
	Constants and variables
-----------------------------------------------------------
*/
$dir = isset($_GET['dir']) ? $_GET['dir'] : $_POST['dir']; // please do not modify this dirname formatting

/*
==============================================================================
		MAIN CODE
==============================================================================
*/
if (strstr($dir, '..'))
{
	$dir = '/';
}

if ($dir[0] == '.')
{
	$dir = substr($dir, 1);
}

if ($dir[0] != '/')
{
	$dir = '/'.$dir;
}

if ($dir[strlen($dir) - 1] != '/')
{
	$dir .= '/';
}

$filepath = api_get_path('SYS_COURSE_PATH').$_course['path'].'/document'.$dir;

if (!is_dir($filepath))
{
	$filepath = api_get_path('SYS_COURSE_PATH').$_course['path'].'/document/';

	$dir = '/';
}

/**************************************************/
$to_group_id = 0;

if (isset ($_SESSION['_gid']) && $_SESSION['_gid'] != '')
{
	$req_gid = '&amp;gidReq='.$_SESSION['_gid'];
	$interbreadcrumb[] = array ("url" => "../group/group_space.php?gidReq=".$_SESSION['_gid'], "name" => get_lang('GroupSpace'));
	$noPHP_SELF = true;
	$to_group_id = $_SESSION['_gid'];
	$group = GroupManager :: get_group_properties($to_group_id);
	$path = explode('/', $dir);
	if ('/'.$path[1] != $group['directory'])
	{
		api_not_allowed();
	}
}
$interbreadcrumb[] = array ("url" => "./document.php?curdirpath=".urlencode($_GET['dir']).$req_gid, "name" => get_lang('Documents'));

if (!$is_allowed_in_course)
	api_not_allowed();

$is_allowedToEdit = api_is_allowed_to_edit();
if (!($is_allowedToEdit || $_SESSION['group_member_with_upload_rights']))
{
	api_not_allowed();
}
/*
-----------------------------------------------------------
	Header
-----------------------------------------------------------
*/

event_access_tool(TOOL_DOCUMENT);
$display_dir = $dir;
if (isset ($group))
{
	$display_dir = explode('/', $dir);
	unset ($display_dir[0]);
	unset ($display_dir[1]);
	$display_dir = implode('/', $display_dir);
}

// Create a new form
$form = new FormValidator('create_document');

$form->addElement('header', 'header', get_lang('CreateDocument'));

// Hidden element with current directory
$form->addElement('hidden', 'dir');
$default['dir'] = $dir;

$form->addElement('hidden','title_edited','false','id="title_edited"');
if (api_get_setting('use_document_title') == 'true')
{
	$form->add_textfield('filename', get_lang('FileName'),true,'class="input_titles" id="filename"  onblur="check_if_still_empty()"');
	$form->add_textfield('title', get_lang('Title'),false,'class="input_titles" id="title"');
}
else 
{
	$form->add_textfield('filename', get_lang('Title'),true,'class="input_titles" id="filename"  onblur="check_if_still_empty()"');
}
// HTML-editor
$form->add_html_editor('content', get_lang('Content'), false, true);

$group = array ();
$group[] = $form->createElement('submit', 'submit', get_lang('Ok'), 'class="inputSubmit"');
$form->addGroup($group, 'submit', '&nbsp;', null, false);

$form->setDefaults($default);

Display::setTemplateBorder($form, '95%');

// If form validates -> save the new document
if ($form->validate())
{
	$values = $form->exportValues();
	
	$extension = 'html';
	if (empty($values['title']))
	{
		$filename = get_file_name($filepath, $extension);
		$title = replace_dangerous_char($values['filename']);		
	}
	else 
	{
		$filename = replace_dangerous_char($values['filename']);
		$i = 0;
		$unique = '';
		while(file_exists($filepath . $filename . $unique . '.' . $extension))
		{
			$unique = '_' . ++$i;
		}
		$filename = $filename . $unique . '.' . $extension; 
		
		$title = $values['title'];
	}
	
	$texte = $values['content'];
/*	Frames.css is unuseful. Zhong 20070926
	if (!strstr($texte, '/frames.css'))
	{
		$str = '<link rel="stylesheet" href="' . api_get_path(WEB_CSS_PATH) . 'frames.css" type="text/css" /><meta http-equiv="Content-Type" content="text/html; charset=' . SYSTEM_CHARSET . '" /></head>';
		$texte = str_replace('</head>', $str, $texte);
	}
*/
	if (!strstr($texte, 'charset='))
	{
		$str = '<meta http-equiv="Content-Type" content="text/html; charset=' . SYSTEM_CHARSET . '" /></head>';
		$texte = str_replace('</head>', $str, $texte);
	}
	
	if ($fp = @ fopen($filepath.$filename, 'w'))
	{
		$texte = text_filter($texte);
		// It is unuseful. Zhong 20070926
		//$content = str_replace(api_get_path('WEB_COURSE_PATH'), api_get_path('REL_COURSE_PATH'), $texte);
		//$texte = str_replace('mp3player.swf?son='.urlencode($path_to_remove), 'mp3player.swf?son=.%2F', $texte);

		fputs($fp, $texte);
		fclose($fp);

/*	Frames.css is unuseful. Zhong 20070926
		if (!is_dir($filepath.'css'))
		{
			mkdir($filepath.'css', CHMOD_NORMAL);

			$doc_id = add_document($_course, $dir.'css', 'folder', 0, 'css');

			api_item_property_update($_course, TOOL_DOCUMENT, $doc_id, 'FolderCreated', $_user['user_id']);
			api_item_property_update($_course, TOOL_DOCUMENT, $doc_id, 'invisible', $_user['user_id']);
		}
		if (!is_file($filepath.'css/frames.css'))
		{
			//make a copy of the current css for the new document						
			copy(api_get_path(SYS_PATH).'themes/'.api_get_setting('stylesheets').'/frames.css', $filepath.'css/frames.css');
			
			$doc_id = add_document($_course, $dir.'css/frames.css', 'file', filesize($filepath.'css/frames.css'), 'frames.css');

			api_item_property_update($_course, TOOL_DOCUMENT, $doc_id, 'DocumentAdded', $_user['user_id']);
			api_item_property_update($_course, TOOL_DOCUMENT, $doc_id, 'invisible', $_user['user_id']);
		}
*/
		$file_size = filesize($filepath.$filename);
		$save_file_path = $dir.$filename;

		$document_id = add_document($_course, $save_file_path, 'file', $file_size, $title);
		if ($document_id)
		{
			api_item_property_update($_course, TOOL_DOCUMENT, $document_id, 'DocumentAdded', $_user['user_id'], $to_group_id);

			//update parent folders
			item_property_update_on_folder($_course, $_GET['dir'], $_user['user_id']);

			$dir= substr($dir,0,-1);
			header('Location: document.php?curdirpath='.urlencode($dir));
			exit ();
		}
	}
	else
	{
		Display :: display_header($nameTools, "Doc");
		Display :: display_error_message(get_lang('Impossible'));
		Display :: display_footer();
	}
}
else
{
	Display :: display_header($nameTools, "Doc");
	
	$form->display();
	
	Display :: display_footer();
}
?>