<?php 
/*
 * FCKeditor - The text editor for internet
 * Copyright (C) 2003-2005 Frederico Caldeira Knabben
 * 
 * Licensed under the terms of the GNU Lesser General Public License:
 * 		http://www.opensource.org/licenses/lgpl-license.php
 * 
 * For further information visit:
 * 		http://www.fckeditor.net/
 * 
 * "Support Open Source software. What about a donation today?"
 * 
 * File Name: upload.php
 * 	This is the "File Uploader" for PHP.
 * 
 * File Authors:
 * 		Frederico Caldeira Knabben (fredck@fckeditor.net)
 */

include('../../../../../../global.inc.php');
require_once(api_get_path(LIBRARY_PATH)."document.lib.php");
include_once(api_get_path(LIBRARY_PATH)."fileUpload.lib.php");

require('config.php') ;
require('util.php') ;

 // This is the function that sends the results of the uploading process.
function SendResults( $errorNumber, $fileUrl = '', $fileName = '', $customMsg = '' )
{
	echo '<script type="text/javascript">' ;
	echo 'window.parent.OnUploadCompleted(' . $errorNumber . ',"' . str_replace( '"', '\\"', $fileUrl ) . '","' . str_replace( '"', '\\"', $fileName ) . '", "' . str_replace( '"', '\\"', $customMsg ) . '") ;' ;
	echo '</script>' ;
	exit ;
}

// Check if this uploader has been enabled.
if ( !$Config['Enabled'] )
{
	SendResults( '1', '', '', 'This file uploader is disabled. Please check the "editor/filemanager/upload/php/config.php" file' ) ;
}

// Check if the file has been correctly uploaded.
if ( !isset( $_FILES['NewFile'] ) || is_null( $_FILES['NewFile']['tmp_name'] ) || $_FILES['NewFile']['name'] == '' )
	SendResults( '202' ) ;

// Get the posted file.
$oFile = $_FILES['NewFile'] ;

// Get the uploaded file name and extension.
// Try to add an extension to the file if it has'nt one
$fileName = add_ext_on_mime(stripslashes($oFile['name']),$oFile['type']);
$extension = strtolower(substr($fileName, (strrpos($fileName, '.')+1))) ;
$fileTitle = get_document_title($fileName);
$fileSize = $oFile['size'];

// The the file type (from the QueryString, by default 'File').
$sType = isset( $_GET['Type'] ) ? $_GET['Type'] : 'File' ;

// Get the allowed and denied extensions arrays.
$arAllowed	= $Config['AllowedExtensions'][$sType] ;
$arDenied	= $Config['DeniedExtensions'][$sType] ;

// Check if it is an allowed extension.
if ( ( count($arAllowed) > 0 && !in_array( $extension, $arAllowed ) )  || ( count($arDenied) > 0 && in_array( $extension, $arDenied ) )){
	SendResults( '202' ) ;
}

$sErrorNumber	= '0' ;
$sFileUrl		= '' ;

// Initializes the counter used to rename the file, if another one with the same name already exists.
$iCounter = 0 ;

$currentCourseRepositorySys =  api_get_path(SYS_COURSE_PATH) . $_course["path"]."/";
$currentCourseRepositoryWeb =  api_get_path(REL_COURSE_PATH) . $_course["path"]."/";

$sType=strtolower($sType);
if(isset($_SESSION["_course"]["sysCode"])){
	//It's a teacher, so the uploaded document will be put in course documents
	if(api_is_allowed_to_edit()){
		//set the upload path according to the file type
		if($sType=="mp3"){
			$sServerDir = $currentCourseRepositorySys.'document/audio/';
			$sserverWebath=$currentCourseRepositoryWeb.'document/audio/';
			$sType="audio";
		}
		elseif($sType=="flash"){
			$sServerDir = $currentCourseRepositorySys.'document/flash/';
			$sserverWebath=$currentCourseRepositoryWeb.'document/flash/';
		}
		elseif($sType=="video"){
			$sServerDir = $currentCourseRepositorySys.'document/video/';
			$sserverWebath=$currentCourseRepositoryWeb.'document/video/';
		}
		else{
			$sServerDir = $currentCourseRepositorySys.'document/';
			$sserverWebath=$currentCourseRepositoryWeb.'document/';
		}
	}
	//It's a student, we get the upload path in parameters 
	elseif(isset($_REQUEST['uploadPath']) && $_REQUEST['uploadPath']!=""){
		$sServerDir = $currentCourseRepositorySys.$_REQUEST['uploadPath'];
		$sserverWebath=$currentCourseRepositoryWeb.$_REQUEST['uploadPath'];
	}
	//Default
	else{
		$sServerDir = $currentCourseRepositorySys.'upload/';
		$sserverWebath=$currentCourseRepositoryWeb.'upload/';
	}	
}

$fileName = get_file_name($sServerDir, $extension);
$maxFilledSpace = DocumentManager::get_course_quota();
// If it's a teacher, the uploaded file is put into course document directory, so check if there is enough space.	Zhong 20070908
if (api_is_allowed_to_edit() && !enough_space($file_size, $maxFilledSpace))
{
	$sErrorNumber = '203' ;
}
else 
{
	if(!move_uploaded_file( $oFile['tmp_name'], $sServerDir.$fileName )) 
	{
		$sErrorNumber = '203' ; //check php.ini setting
	}
}
	
if (is_file( $sServerDir.$fileName ))
{
	$oldumask = umask(0) ;
	chmod($sServerDir, CHMOD_NORMAL) ;
	umask($oldumask) ;
}

//If we are in a course and if it's a teacher who did the upload, we record the uploaded file in database
if(isset($_SESSION["_course"]["sysCode"]) && api_is_allowed_to_edit() && $sErrorNumber=='0')
{	
	if($sType=="flash"){
		$path = "/flash/";
	}	
	if($sType=="audio"){
		$path = "/audio/";
	}	
	if($sType=="video"){
		$path = "/video/";
	}
	
	$doc_id = add_document($_course, $path.$fileName, 'file', $fileSize, $fileTitle);		
	api_item_property_update($_course, TOOL_DOCUMENT, $doc_id, 'DocumentAdded', $_user['user_id']);	
}

SendResults( $sErrorNumber, $sserverWebath.$fileName, $fileName ) ;

?>
