<?php
/*
==============================================================================
	Dokeos - elearning and course management software

	Copyright (c) 2004 Dokeos S.A.
	Copyright (c) 2003 Ghent University (UGent)
	Copyright (c) 2001 Universite catholique de Louvain (UCL)
	Copyright (c) Olivier Brouckaert
	Copyright (c) Roan Embrechts, Vrije Universiteit Brussel

	For a full list of contributors, see "credits.txt".
	The full license can be read in "license.txt".

	This program is free software; you can redistribute it and/or
	modify it under the terms of the GNU General Public License
	as published by the Free Software Foundation; either version 2
	of the License, or (at your option) any later version.

	See the GNU General Public License for more details.

	Contact address: Zhong
	Mail: poopsoft@163.com
==============================================================================
*/
/**
==============================================================================
* GOAL : Dokeos installation
* As seen from the user, the installation proceeds in 7 steps.
* The user is presented with several webpages where he/she has to make choices
* and/or fill in data.
*
* The aim is, as always, to have good default settings and suggestions.
*
* @todo	reduce high level of duplication in this code
* @todo (busy) organise code into functions
* @package iilearn.install
==============================================================================
*/

/*
==============================================================================
		INIT SECTION
==============================================================================
*/
session_start();
// Including necessary files
require_once('../inc/installedVersion.inc.php');
require_once('../inc/lib/main_api.lib.php');
require_once('../inc/lib/text.lib.php');
require_once('../inc/lib/database.lib.php');

require_once('../lang/english/trad4all.inc.php');
require_once('../lang/english/install.inc.php');                          

if (!empty($_POST['language_list']))
{
	$search = array('../','\\0');
	$install_language = str_replace($search,'',urldecode($_POST['language_list']));
	include_once("../lang/$install_language/trad4all.inc.php");
	include_once("../lang/$install_language/install.inc.php");
	api_session_register('install_language');
}
elseif ( isset($_SESSION['install_language']) && $_SESSION['install_language'] )
{
	$install_language = $_SESSION['install_language'];
	include_once("../lang/$install_language/trad4all.inc.php");
	include_once("../lang/$install_language/install.inc.php");
}

$charset = '';
//force ISO-8859-15 for European languages. Leave Apache determine the encoding for others (HTML declaring UTF-8)
$euro_langs = array('english','french','french_KM','french_corporate','french_org','dutch','spanish','german','italian','greek','danish','swedish','norwegian','polish','galician','catalan','czech','finnish');
if (! isset($install_language)) {
	$install_language = '';
}
if(in_array($install_language,$euro_langs))
{
	$charset = 'ISO-8859-15';
	header('Content-Type: text/html; charset='. $charset);
}
else
// hgz 20070430
{
    $charset = SYSTEM_CHARSET;
    header('Content-Type: text/html; charset='. $charset);    
}

require_once('install_upgrade.lib.php');
require_once('install_functions.inc.php');

// Some constants
define('DOKEOS_INSTALL',1);
define('MAX_COURSE_TRANSFER',100);
define("INSTALL_TYPE_UPDATE", "update");
define("FORM_FIELD_DISPLAY_LENGTH", 40);
define("DATABASE_FORM_FIELD_DISPLAY_LENGTH", 25);
define("MAX_FORM_FIELD_LENGTH", 50);
define("DEFAULT_LANGUAGE", "english");

// setting the error reporting
error_reporting(E_COMPILE_ERROR | E_ERROR | E_CORE_ERROR);

// overriding the timelimit (for large campusses that have to be migrated)
@set_time_limit(0);

//we hope in the future to add the ability to upgrade from 1.5.x versions
//to 1.8 as well.
$old_update_from_version=array('1.5','1.5.4','1.5.5','1.6');
$update_from_version=array('1.6','1.6.1','1.6.2','1.6.3','1.6.4','1.6.5');

/*
==============================================================================
		STEP 1 : INITIALIZES FORM VARIABLES IF IT IS THE FIRST VISIT
==============================================================================
*/
$badUpdatePath=false;
$emptyUpdatePath=true;

if($_POST['step2_install'] || $_POST['step2_update'])
{
	if($_POST['step2_install'])
	{
		$installType='new';

		$_POST['step2']=1;
	}
	else
	{
		$installType='update';
		if(empty($_POST['updatePath']))
		{
			$_POST['step1']=1;
		}
		else
		{
			$emptyUpdatePath = false;
			if($_POST['updatePath'][strlen($_POST['updatePath'])-1] != '/')
			{
				$_POST['updatePath'].='/';
			}

			if(file_exists($_POST['updatePath']))
			{
				if(in_array(get_config_param('clarolineVersion'),$update_from_version))
				{
					$_POST['step2']=1;
				}
				else
				{
					$badUpdatePath=true;
				}
			}
			else
			{
				$badUpdatePath=true;
			}
		}
	}
}
elseif($_POST['step1'])
{
	$_POST['updatePath']='';
	$installType='';
	$updateFromConfigFile='';
	unset($_GET['running']);
}
else
{
	$installType=$_GET['installType'];
	$updateFromConfigFile=$_GET['updateFromConfigFile'];
}

if(!isset($_GET['running']))
{
	$dbHostForm = 'localhost';
	$dbUsernameForm = 'root';
	$dbPassForm = '';
	$temp = explode('/', $_SERVER['PHP_SELF']);
 	$dbPrefixForm = $temp[1] . '_';
	$dbNameForm = 'main_db';
	$dbStatsForm = 'stats_db';
	$dbScormForm = 'scorm_db';
	$dbUserForm = 'user_db';

	// extract the path to append to the url if Dokeos is not installed on the web root directory
	$urlAppendPath=str_replace('/main/install/index.php','',$_SERVER['PHP_SELF']);
  	$urlForm='http://'.$_SERVER['HTTP_HOST'].$urlAppendPath.'/';
	$pathForm=str_replace('\\','/',realpath('../..')).'/';

	$emailForm=$_SERVER['SERVER_ADMIN'];
	$email_parts = explode('@',$emailForm);
	if($email_parts[1] == 'localhost')
	{
		$emailForm .= '.localdomain';
	}
	$adminLastName='';
	$adminFirstName = get_lang('AdminFirstName');
	$loginForm='admin';
	$passForm=api_generate_password();

	$campusForm = get_lang('CampusForm');
	$educationForm = get_lang('EducationForm');
	$adminPhoneForm = '(0757) ';
	$institutionForm = get_lang('InstitutionForm');
	$institutionUrlForm='http://www.iilearn.org';

	$languageForm='english';

	$checkEmailByHashSent=0;
	$ShowEmailnotcheckedToStudent=1;
	$userMailCanBeEmpty=1;
	$allowSelfReg=1;
	$allowSelfRegProf=1;
	$enableTrackingForm=1;
	$singleDbForm=0;
	$encryptPassForm=1;
}
else
{
	foreach($_POST as $key=>$val)
	{
		$magic_quotes_gpc=ini_get('magic_quotes_gpc')?true:false;

		if(is_string($val))
		{
			if($magic_quotes_gpc)
			{
				$val=stripslashes($val);
			}

			$val=trim($val);

			$_POST[$key]=$val;
		}
		elseif(is_array($val))
		{
			foreach($val as $key2=>$val2)
			{
				if($magic_quotes_gpc)
				{
					$val2=stripslashes($val2);
				}

				$val2=trim($val2);

				$_POST[$key][$key2]=$val2;
			}
		}

		$GLOBALS[$key]=$_POST[$key];
	}
}

// The Steps
//$total_steps=6;
$current_step = 0;
if (!empty($_POST['step0']))
{
	$current_step = 1;
}
//elseif (!empty($_POST['language_list']) or !empty($_POST['step1']) or (!empty($_POST['step2_update']) && ($emptyUpdatePath or $badUpdatePath)))
elseif (empty($start) && (!empty($_POST['language_list']) or !empty($_POST['step1']) or (!empty($_POST['step2_update']) && ($emptyUpdatePath or $badUpdatePath))))
{
	$current_step = 2;
}
elseif (!empty($_POST['step2']) or !empty($_POST['step2_update']))
{
	$current_step = 3;
}
elseif (!empty($_POST['step3']))
{
	$current_step = 4;
}
elseif (!empty($_POST['step4']))
{
	$current_step = 5;
}
elseif (!empty($_POST['step5']))
{
	$current_step = 6;
}
elseif (!empty($_POST['step6']))
{
	$current_step = 7;
}
?>

<!DOCTYPE html
     PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN"
     "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
	<title>&mdash; <?php echo get_lang('DokeosInstallation').' &mdash; '.get_lang('Version_').' '.$dokeos_version; ?></title>
	<style type="text/css" media="screen, projection">
		/*<![CDATA[*/
		@import "../../themes/install.css";
		/*]]>*/
	</style>
<?php if(!empty($charset)){ ?>
	<meta http-equiv="Content-Type" content="text/html; charset=<?php echo $charset ?>" />
<?php } ?>
</head>
<body class="pageBg" topmargin="0" leftmargin="0" marginheight="0" marginwidth="0">

	<br><br><br>
	<!-- Table for cfgwiz starts -->
	<table border=0 cellspacing=0 cellpadding=0 width=90% align=center>
	<tr>
		<td class="headBg" align=left> <img src="../../themes/images/configwizard.gif" alt="" hspace="20" title=""></td>
		<td class="headBg" align=right><img src="../../themes/images/iilearn.gif" alt="" title=""></td>
	</tr>
	</table>
	<table border=0 cellspacing=0 cellpadding=0 width=90% align=center>
	<tr>
		<td background="../../themes/images/topInnerShadow.gif" align=left><img src="../../themes/images/topInnerShadow.gif" ></td>
	</tr>
	</table>

	<table cellspacing=0 cellpadding=10 width=90% align=center>
	<tr>
		<td bgcolor="#4572BE" align=center>
			<!-- Master display -->
			<table cellspacing=0 cellpadding=0 width=97%>
			<tr>
				<td width=20% valign=top>
				<!-- Left side tabs -->
				<?php echo display_left_menu(); ?>
				</td>
				<td width=80% valign=top align=left>
				<!-- Right side tabs -->
				<div class="contentDisplay">
				<form style="margin:0px;" method="post" action="<?php echo $_SERVER['PHP_SELF']; ?>?running=1&amp;installType=<?php echo $installType; ?>&amp;updateFromConfigFile=<?php echo urlencode($updateFromConfigFile); ?>" autocomplete="off">
<?php
echo display_hidden_form();

if ($_POST['step0'])
{
	//select language screen
	display_language_selection();
}
elseif($_POST['step1'] || $badUpdatePath)
{

	//STEP 1 : REQUIREMENTS
	display_requirements();
}
elseif($_POST['step2'])
{
	//STEP 3 : LICENSE
	display_license_agreement();
}
elseif($_POST['step3'])
{
	//STEP 4 : MYSQL DATABASE SETTINGS
	display_database_settings_form();
}
elseif($_POST['step4'])
{
	//STEP 5 : CONFIGURATION SETTINGS
	display_configuration_settings_form();
}
elseif($_POST['step5'])
{
	//STEP 6 : LAST CHECK BEFORE INSTALL
	display_before_install_message();
}
elseif($_POST['step6'])
{
	//STEP 7 : INSTALLATION PROCESS
	if($installType == 'update')
	{
		$_configuration['main_database'] = $dbNameForm;
		//$urlAppendPath = get_config_param('urlAppend');
		include('update-db-1.6.x-1.8.0.inc.php');
		include('update-files-1.6.x-1.8.0.inc.php');
	}
	else
	{
		include('install_db.inc.php');
		include('install_files.inc.php');
	}

	display_after_install_message($nbr_courses);
}
else
{
	echo display_welcome();
}
?>	
				</form>
				</div>
					
				</td>
			</tr>
			</table>
		<!-- Master display stops -->
		<br>
		</td>
	</tr>
	</table>

	<table border=0 cellspacing=0 cellpadding=0 width=90% align=center>
	<tr>
		<td align=center><img src="../../themes/images/bottomShadow.jpg"></td>
	</tr>
	</table>
	
</body>
</html>