<?php
/**
 * This function prints class=active_step $current_step=$param
 * @author Patrick Cool <patrick.cool@UGent.be>, Ghent University
 */
function step_active($param)
{
	global $current_step;

	if ($param==$current_step)
	{
		echo 'class="current_step" ';
	}
}

/**
 * This function displays the Step X of Y -
 * @return	string	String that says 'Step X of Y' with the right values
 */
function display_step_sequence()
{
	global $current_step;
//	global $total_steps;

	return get_lang('Step'.$current_step).' &ndash; ';
}
/**
 * this function checks if a php extension exists or not
 *
 * @param string  $extentionName  name of the php extension to be checked
 * @param boolean  $echoWhenOk  true => show ok when the extension exists
 * @author Christophe Gesche
 * @author Patrick Cool <patrick.cool@UGent.be>, Ghent University
 * @version Dokeos 1.8, august 2006
 */
function check_extension($extention_name,$return_success=false, $return_failure=false)
{
	if(extension_loaded($extention_name))
	{
		return '<strong><font color="green">'.$return_success.'</font></strong>';
	}
	else
		{
		return '<strong><font color="red">'.$return_failure.'</font></strong>';
		}
	}


/**
 * This function checks if a php settings matches the recommended value
 *
 * @author Patrick Cool <patrick.cool@UGent.be>, Ghent University
 * @version Dokeos 1.8, august 2006
 */
function check_php_setting($php_setting, $recommended_value, $return_success=false, $return_failure=false)
{
	$current_php_value = get_php_setting($php_setting);
	if ( $current_php_value== $recommended_value)
	{
		return '<strong><font color="green">'.$current_php_value.' '.$return_success.'</font></strong>';
	}
	else
	{
		return '<strong><font color="red">'.$current_php_value.' '.$return_failure.'</font></strong>';
	}
}
/**
 * Enter description here...
 *
 * @param string $val a php ini value
 * @return boolean: ON or OFF
 * @author Joomla <http://www.joomla.org>
 */
function get_php_setting($val) {
	$r =  (ini_get($val) == '1' ? 1 : 0);
	return $r ? 'ON' : 'OFF';
}

/**
 * This function checks if the given folder is writable
 */
function check_writable($folder)
{
	if (is_writable('../'.$folder))
	{
		return '<strong><font color="green">'.get_lang('Writable').'</font></strong>';
	}
	else
	{
		return '<strong><font color="red">'.get_lang('NotWritable').'</font></strong>';
	}
}

/**
 * this function returns a string "FALSE" or "TRUE" according to the variable in parameter
 *
 * @param integer  $var  the variable to convert
 * @return  string  the string "FALSE" or "TRUE"
 * @author Christophe Gesche
 */
function trueFalse($var)
{
	return $var?'true':'false';
}

/**
 * This function returns the value of a parameter from the configuration file
 *
 * WARNING - this function relies heavily on global variables $updateFromConfigFile
 * and $configFile, and also changes these globals. This can be rewritten.
 *
 * @param 	string  $param  the parameter of which the value is returned
 * @return  string  the value of the parameter
 * @author Olivier Brouckaert
 */
function get_config_param($param)
{
	global $configFile, $updateFromConfigFile;
	$updatePath = realpath($_POST['updatePath']).'/';
	$updateFromInstalledVersionFile = '';

	if(empty($updateFromConfigFile)) //if update from previous install was requested
	{
		//try to recover old config file from dokeos 1.6.x
		if(file_exists($updatePath.'claroline/inc/conf/claro_main.conf.php'))
		{
			$updateFromConfigFile='claroline/inc/conf/claro_main.conf.php';
			if(file_exists($updatePath.'claroline/inc/installedVersion.inc.php'))
			{
				$updateFromInstalledVersionFile = 'claroline/inc/installedVersion.inc.php';
			}
		}
		//try to recover old config file from dokeos 1.8.x
		elseif(file_exists($updatePath.'main/inc/conf/configuration.php'))
		{
			$updateFromConfigFile='main/inc/conf/configuration.php';
		}
		//give up recovering
		else
		{
			return null;
		}
	}
	//look if we already have the queried param
	if(is_array($configFile) && isset($configFile[$param]))
	{
		return $configFile[$param];
	}
	//the param was not found in global vars, so look into the old config file
	elseif(file_exists($updatePath.$updateFromConfigFile))
	{
		$configFile=array();
		$temp=file($updatePath.$updateFromConfigFile);
		$val='';
		if(file_exists($updatePath.$updateFromInstalledVersionFile))
		{
			$temp2 = file($updatePath.$updateFromInstalledVersionFile);
			$temp = array_merge($temp,$temp2);
		}

		//parse the config file (TODO clarify why it has to be so complicated)
		foreach($temp as $enreg)
		{
			if(strstr($enreg,'='))
			{
				$enreg=explode('=',$enreg);

				if($enreg[0][0] == '$')
				{
					list($enreg[1])=explode(' //',$enreg[1]);

					$enreg[0]=trim(str_replace('$','',$enreg[0]));
					$enreg[1]=str_replace('\"','"',ereg_replace('(^"|"$)','',substr(trim($enreg[1]),0,-1)));

					if(strtolower($enreg[1]) == 'true')
					{
						$enreg[1]=1;
					}
					if(strtolower($enreg[1]) == 'false')
					{
						$enreg[1]=0;
					}
					else
					{
						$implode_string=' ';

						if(!strstr($enreg[1],'." ".') && strstr($enreg[1],'.$'))
						{
							$enreg[1]=str_replace('.$','." ".$',$enreg[1]);
							$implode_string='';
						}

						$tmp=explode('." ".',$enreg[1]);

						foreach($tmp as $tmp_key=>$tmp_val)
						{
							if(eregi('^\$[a-z_][a-z0-9_]*$',$tmp_val))
							{
								$tmp[$tmp_key]=get_config_param(str_replace('$','',$tmp_val));
							}
						}

						$enreg[1]=implode($implode_string,$tmp);
					}

					$configFile[$enreg[0]]=$enreg[1];

					if($enreg[0] == $param)
					{
						$val=$enreg[1];
					}
				}
			}
		}

		return $val;
	}
}

/**
 * Get the config param from the database. If not found, return null
 * @param	string	DB Host
 * @param	string	DB login
 * @param	string	DB pass
 * @param	string	DB name
 * @param	string 	Name of param we want
 * @return	mixed	The parameter value or null if not found
 */
function get_config_param_from_db($host,$login,$pass,$db_name,$param='')
{
	$mydb = mysql_connect($host,$login,$pass);
	
	// hgz 20070628
	mysql_query("set names utf8;");

	$myconnect = mysql_select_db($db_name);
	$sql = "SELECT * FROM settings_current WHERE variable = '$param'";
	$res = api_sql_query($sql, __FILE__, __LINE__);
	if($res===false){return null;}
	if(mysql_num_rows($res)>0)
	{
		$row = mysql_fetch_array($res);
		$value = $row['selected_value'];
		return $value;
	}
	return null;
}

/**
*	Return a list of language directories.
*	@todo function does not belong here, move to code library,
*	also see infocours.php which contains similar function
*/
function get_language_folder_list($dirname)
{
	if ($dirname[strlen($dirname)-1] != '/') $dirname .= '/';
	$handle = opendir($dirname);
	$language_list = array();

	while ($entries = readdir($handle))
	{
		if ($entries=='.' || $entries=='..' || $entries=='CVS'  || $entries == '.svn') continue;
		if (is_dir($dirname.$entries))
		{
			$language_list[] = $entries;
		}
	}

	closedir($handle);

	return $language_list;
}

/**
* After installation is completed (step 6), this message is displayed.
 * @author Zhong <poopsoft@163.com>
 * @return 
*/
function display_after_install_message($nbr_courses)
{
	global $installType;
	
	$html = display_header_message(display_step_sequence() . get_lang('InstallFinish'));
	
	$html .= "<p><b>" . get_lang('FirstUseTip') . "</b></p><br>\n";
	
	if($installType == 'update' && $nbr_courses > MAX_COURSE_TRANSFER)
	{
		$html .= "<font color='red'><b>" . get_lang('Warning') . " :</b> " . sprintf(get_lang('YouHaveMoreThanXCourses'),MAX_COURSE_TRANSFER,MAX_COURSE_TRANSFER,'<a href="update_courses.php"><font color="red">','</font></a>') . "</font>\n";
	}

	$html .= "<div><img src='../../themes/images/message_warning.png' style='float:left; margin-right:10px;'/>\n";
	$html .= "<b>" . get_lang('SecurityAdvice') . "</b> : ";
	$html .= sprintf(get_lang('ToProtectYourSiteMakeXAndYReadOnly'),'main/inc/conf/configuration.php','main/install/index.php');
	$html .= "</div>\n";
	$html .= "<br><br><p style='align:center;'><a href='../../index.php'>" . get_lang('GoToYourNewlyCreatedPortal') . "</a></p>\n";

	echo $html;
}

/**
* In step 3. Test the connection to the DB in case of single or multy DB.
* After installation is completed (step 6), this message is displayed.
 * @author Zhong <poopsoft@163.com>
 * @return "1" if no problems, "0" if, in case of multiDB we can't create a new DB and "-1" if there is no connection.
*/
function test_db_connect ($dbHostForm, $dbUsernameForm, $dbPassForm, $singleDbForm, $dbPrefixForm)
{
	$dbConnect = -1;
	if($singleDbForm == 1)
	{
		if(mysql_connect($dbHostForm, $dbUsernameForm, $dbPassForm) !== false)
		{
			$dbConnect = 1;
		}
		else
		{
			$dbConnect = -1;
		}
	}
	elseif($singleDbForm == 0)
	{
		if(mysql_connect($dbHostForm, $dbUsernameForm, $dbPassForm) !== false)
		{
			$multipleDbCheck = @mysql_query("CREATE DATABASE ".$dbPrefixForm."test_dokeos_connection");
			if($multipleDbCheck !== false)
			{
				$multipleDbCheck = @mysql_query("DROP DATABASE IF EXISTS ".$dbPrefixForm."test_dokeos_connection");
				if($multipleDbCheck !== false)
				{
					$dbConnect = 1;
				}
				else
				{
					$dbConnect = 0;
				}
			}
			else
			{
				$dbConnect = 0;
			}
		}
		else
		{
			$dbConnect = -1;
		}
	}
	return($dbConnect); //return "1"if no problems, "0" if, in case of multiDB we can't create a new DB and "-1" if there is no connection.
}

/**
* Display the header message.
 * @author Zhong <poopsoft@163.com>
 * @return the html of header message
*/
function display_header_message($message)
{
	$html = "<table width='100%'>\n";
	$html .= "<tr><td class='contentHeader'>\n";
	$html .= "{$message}";
	$html .= "<hr noshade size='1'>\n";
	$html .= "</td></tr>\n";
	$html .= "</table>\n";
	
	return $html;
}

/*
==============================================================================
		DISPLAY FUNCTIONS
==============================================================================
*/

/**
* Display the welcome message.
 * @author Zhong <poopsoft@163.com>
 * @return 
*/
function display_welcome()
{
	$html = display_header_message(get_lang('WelcomToTheDokeosInstaller'));
	$html .= "<p>" . get_lang('WelcomeContent') . "</p>\n";
	$html .= "<p align='center'>\n";
	$html .= "<input type='image' src='../../themes/images/start.jpg' title='Start' style='cursor:pointer;' onClick=\"window.document.welcome_form.submit();\">\n";
	$html .= "<input type='hidden' name='step0' value='1'/>\n";
	$html .= "</p>\n";

	echo $html;
}

/**
 * Displays a form (drop down menu) so the user can select	his/her preferred language.
 * @author Zhong <poopsoft@163.com>
 * @return the dropdown select form
*/
function display_language_selection_box()
{
	//get language list
	$dirname = '../lang/';
	$language_list = get_language_folder_list($dirname);
	sort($language_list);
	//Reduce the number of languages shown to only show those with higher than 90% translation in DLTT
	//This option can be easily removed later on. The aim is to test people response to less choice
    // hgz 20070430
    $language_to_display = array('simpl_chinese', 'trad_chinese', 'english', 'japanese');
	$html = "<select name='language_list'>\n";
    $default_language = 'simpl_chinese';
	foreach ($language_to_display as $key => $value)
	{
		if ($value == $default_language) 
		{
			$option_end = ' selected="selected">';
		}
		else
		{
			$option_end = '>';
		}
		$html .= "<option value='{$value}' {$option_end}";

        $html .= ucfirst(get_lang($value));
		$html .= "</option>\n";
	}
	$html .= "</select>\n";
	
	return $html;
}

/**
 * This function displays a language dropdown box so that the installatioin
 * can be done in the language of the user
 * @author Zhong <poopsoft@163.com>
 * @return 
*/
function display_language_selection()
{ 
	$html = display_header_message(display_step_sequence() . get_lang('InstallationLanguage'));
	$html .= "<p align='center'>\n";
	$html .= get_lang('PleaseSelectInstallationProcessLanguage') . "<br><br>\n";
	$html .= display_language_selection_box();
	$html .= "</p>\n";	
	$html .= "<div style='position:absolute;bottom:10px;right:10px;'>\n";
	$html .= "<input type='submit' class='inputSubmit' name='start' value='&lt; " . get_lang('Previous') . "'/>&nbsp;\n";
	$html .= "<input type='submit' class='inputSubmit' name='step1' value='" . get_lang('Next') . " &gt;'/>\n";
	$html .= "</div>\n";	
	
	echo $html;
}

/**
 * This function displays the requirements for installing Dokeos.
 * @author Zhong <poopsoft@163.com>
 * @return 
*/
function display_requirements()
{
	global $installType, $badUpdatePath, $update_from_version;
	
	$html = display_header_message(display_step_sequence() . get_lang('Requirements'));
	
	//	SERVER REQUIREMENTS
	$html .= "<table border=0 align='center' cellpadding='0' cellspacing='0' class='contentTable'>\n";
	$html .= "<tr><th colspan='3'>" . get_lang('ServerRequirementsInfo') . "</th></tr>\n";
	$html .= "<tr><td>" . get_lang('PHPVersion') . ">= 5.0</td>\n";
	$html .= "<td colspan='2'>\n";
	if (phpversion() < '5.0')
	{
		$html .= "<strong><font color='red'>" . get_lang('PHPVersionError') . "</font></strong>\n";
	}
	else
	{
		$html .= "<strong><font color='green'>" . get_lang('PHPVersionOK') . ' ' . phpversion() . "</font></strong>\n";
	}
	$html .= "</td></tr>\n";
	$html .= "<tr><td>session " . get_lang('support') . "</td>\n";
	$html .= "<td colspan='2'>" . check_extension('session',get_lang('OK'), get_lang('ExtensionSessionsNotAvailable')) . "</td></tr>\n";
	$html .= "<tr><td>MySQL " . get_lang('support') . "</td>\n";
	$html .= "<td colspan='2'>" . check_extension('mysql',get_lang('OK'), get_lang('ExtensionMySQLNotAvailable')) . "</td></tr>\n";
	$html .= "<tr><td>zlib " . get_lang('support') . "</td>\n";
	$html .= "<td colspan='2'>" . check_extension('zlib',get_lang('OK'), get_lang('ExtensionZlibNotAvailable')) . "</td></tr>\n";
	$html .= "<tr><td>Regular Expressions " . get_lang('support') . "</td>\n";
	$html .= "<td colspan='2'>" . check_extension('pcre',get_lang('OK'), get_lang('ExtensionPCRENotAvailable')) . "</td></tr>";
	$html .= "<tr><td>XML " . get_lang('support') . "</td>";
	$html .= "<td colspan='2'>" . check_extension('xml',get_lang('OK'), get_lang('ExtensionZlibNotAvailable')) . "</td></tr>\n";
	$html .= "<tr><td>MultiByteString " . get_lang('support') . "</td>\n";
	$html .= "<td colspan='2'>" . check_extension('mbstring',get_lang('OK'), get_lang('ExtensionMBStringNotAvailable')) . "</td></tr>\n";
	$html .= "<tr><td>GD " . get_lang('support') . "</td>";
	$html .= "<td colspan='2'>" . check_extension('gd',get_lang('OK'), get_lang('ExtensionGDNotAvailable')) . "</td></tr>\n";
	$html .= "<tr><td>LDAP " . get_lang('support') . '(' . get_lang('Optional') . ")</td>\n";
	$html .= "<td colspan='2'>" . check_extension('ldap',get_lang('OK'), get_lang('ExtensionLDAPNotAvailable')) . "</td></tr>\n";
	
	// RECOMMENDED SETTINGS
	$html .= "<tr><th colspan='3'>" . get_lang('RecommendedSettings') . " : " . get_lang('RecommendedSettingsInfo') . "</th></tr>\n";
	$html .= "<tr><td>" . get_lang('Setting') . "</td><td>" . get_lang('Recommended') . "</td><td>" . get_lang('Actual') . "</td></tr>\n";
	$html .= "<tr><td>Safe Mode</td><td>OFF</td>\n";
	$html .= "<td>" . check_php_setting('safe_mode','OFF') . "</td></tr>\n";
	$html .= "<tr><td>Display Errors</td><td>OFF</td>\n";
	$html .= "<td>" . check_php_setting('display_errors','OFF') . "</td></tr>\n";
	$html .= "<tr><td>File Uploads</td><td>ON</td>\n";
	$html .= "<td>" . check_php_setting('file_uploads','ON') . "</td></tr>\n";
	$html .= "<tr><td>Magic Quotes GPC</td><td>ON</td>\n";
	$html .= "<td>" . check_php_setting('magic_quotes_gpc','ON') . "</td></tr>\n";
	$html .= "<tr><td>Magic Quotes Runtime</td><td>OFF</td>\n";
	$html .= "<td>" . check_php_setting('magic_quotes_runtime','OFF') . "</td></tr>\n";
	$html .= "<tr><td>Register Globals</td><td>OFF</td>\n";
	$html .= "<td>" . check_php_setting('register_globals','OFF') . "</td></tr>\n";
	$html .= "<tr><td>Session auto start</td><td>OFF</td>\n";
	$html .= "<td>" . check_php_setting('session.auto_start','OFF') . "</td></tr>\n";
	$html .= "<tr><td>Short Open Tag</td><td>ON</td>\n";
	$html .= "<td>" . check_php_setting('short_open_tag','ON') . "</td></tr>\n";
	$html .= "<tr><td>Maximum upload file size</td><td>10M-100M</td>\n";
	$html .= "<td>" . ini_get('upload_max_filesize') . "</td></tr>\n";
	$html .= "<tr><td>Maximum post size</td><td>10M-100M</td>\n";	
	$html .= "<td>" . ini_get('post_max_size') . "</td></tr>\n";

	// DIRECTORY AND FILE PERMISSIONS
	$temp = explode('/', $_SERVER['PHP_SELF']);
	$webRoot = $temp[1];
	$html .= "<tr><th colspan='3'>" . get_lang('DirectoryAndFilePermissions') . " : " . get_lang('DirectoryAndFilePermissionsInfo') . "</th></tr>\n";
	$html .= "<tr><td>{$webRoot}/home/</td>\n";
	$html .= "<td colspan='2'>" . check_writable('../home/') . "</td></tr>\n";
	$html .= "<tr><td>{$webRoot}/main/inc/conf/</td>\n";
	$html .= "<td colspan='2'>" . check_writable('inc/conf/') . "</td></tr>\n";
	$html .= "<tr><td>{$webRoot}/storage/archive/</td>\n";
	$html .= "<td colspan='2'>" . check_writable('../storage/archive/') . "</td></tr>\n";
	$html .= "<tr><td>{$webRoot}/storage/courses/</td>\n";
	$html .= "<td colspan='2'>" . check_writable('../storage/courses/') . "</td></tr>\n";
	$html .= "<tr><td>{$webRoot}/storage/garbage/</td>\n";
	$html .= "<td colspan='2'>" . check_writable('../storage/garbage/') . "</td></tr>\n";
	$html .= "<tr><td>{$webRoot}/storage/users_picture/</td>\n";
	$html .= "<td colspan='2'>" . check_writable('../storage/users_picture/') . "</td></tr>\n";
	$html .= "<tr><td>{$webRoot}/storage/default_course_document/images/</td>\n";
	$html .= "<td colspan='2'>" . check_writable('../storage/default_course_document/images/') . "</td></tr>\n";
	/*
	$html .= "<tr><td>{$webRoot}/main/upload/</td>\n";
	$html .= "<td colspan='2'>" . check_writable('upload/') . "</td></tr>\n";
	*/
	
	$html .= "</table>\n";

	if($installType == 'update' && (empty($_POST['updatePath']) || $badUpdatePath))
	{
		if($badUpdatePath)
		{ 
			$html .= "<div class='warning'>\n";
			$html .= "<b>" . get_lang('Error') . "!</b><br>IILearn" . implode('|',$update_from_version) . get_lang('HasNotBeenFoundInThatDir');
			$html .= "</div>\n";
		}
		else
		{
			$html .= "<br />\n";
		}
		
		$html .= "<table align='center' cellpadding='0' cellspacing='0' class='contentTable'>\n";
		$html .= "<tr><th>" . get_lang('OldVersionRootPath') . "</th></tr>\n";
		$html .= "<tr><td>\n";
		$html .= "<input type='text' name='updatePath' size='50' value='" . ($badUpdatePath ? htmlentities($_POST['updatePath'], ENT_NOQUOTES, SYSTEM_CHARSET) : $_SERVER['DOCUMENT_ROOT'].'/old_version/') . " />\n";
		$html .= "</td></tr></table>\n";
		$html .= "<p align='right'>\n";
		$html .= "<input type='submit' class='inputSubmit' name='step0' value='&lt;" . get_lang('Previous') . "'/>&nbsp;\n";
		$html .= "<input type='submit' class='inputSubmit' name='step2_update' value='" . get_lang('Next') . "&gt;'" . ($error ? "disabled='disabled'" : "") . " />\n";
	}
	else
	{
		$error=false;

		//First, attempt to set writing permissions if we don't have them yet
		//0xxx is an octal number, this is the required format
		$notwritable = array();
		if(!is_writable('../inc/conf'))
		{
			$notwritable[]='../inc/conf';
			@chmod('../inc/conf', CHMOD_NORMAL);
		}

		if(!is_writable('../../storage/garbage'))
		{
			$notwritable[]='../../storage/garbage';
			@chmod('../../storage/garbage', CHMOD_NORMAL);
		}

		if(!is_writable('../upload'))
		{
			$notwritable[]='../upload';
			@chmod('../upload', CHMOD_NORMAL);
		}

		if(!is_writable('../../storage/archive'))
		{
			$notwritable[]='../../storage/archive';
			@chmod('../../storage/archive', CHMOD_NORMAL);
		}

		if(!is_writable('../../storage/courses'))
		{
			$notwritable[]='../../storage/courses';
			@chmod('../../storage/courses', CHMOD_NORMAL);
		}

		if(!is_writable('../../home'))
		{
			$notwritable[]='../../home';
			@chmod('../../home', CHMOD_NORMAL);
		}

		if(file_exists('../inc/conf/configuration.php') && !is_writable('../inc/conf/configuration.php'))
		{
			$notwritable[]='../inc/conf/configuration.php';
			@chmod('../inc/conf/configuration.php',0666);
		}

		//Second, if this fails, report an error
		//--> the user will have to adjust the permissions manually
		if(count($notwritable)>0)
		{
			$error=true;
			$html .= "<div class='warning'>\n";
			$html .= "<b>" . get_lang('Warning') . ":</b><br /><br>\n";
			$html .= sprintf(get_lang('NoWritePermissionPleaseReadInstallGuide'),'</font><a href="../../documentation/installation_guide.html" target="blank">','</a> <font color="#cc0033">');
			//$html .= "<a href='../../documentation/installation_guide.html' target='blank'><font color='#cc0033'>" . get_lang('NoWritePermissionPleaseReadInstallGuide') . "</font></a>\n";
			$html .= "<ul>\n";
			foreach ($notwritable as $value)
			{
				$html .= "<li>" . $value . "</li>\n";
			}
			$html .= "</ul>\n";
			$html .= "</div>\n";			
		}
		// check wether a Dokeos configuration file already exists.
		elseif(file_exists('../inc/conf/configuration.php'))
		{
			$html .= "<div class='warning'>\n";
			$html .= get_lang('WarningExistingDokeosInstallationDetected');
			$html .= "</div>\n";
		}
		
		//and now display the choice buttons (go back or install)
		$html .= "<p align='right'>\n";
		//$html .= "<input type='submit' class='inputSubmit' name='step1' onclick=\"window.location='index.php';return false;\" value='&lt; " . get_lang('Previous') . "/>\n";
		$html .= "<input type='submit' class='inputSubmit' name='step0' value='&lt;" . get_lang('Previous') . "'/>&nbsp;\n";
		$html .= "<input type='submit' class='inputSubmit' name='step2_install' value='" . get_lang('Next') . "&gt;'" . ($error ? "disabled='disabled'" : "") . " />\n";
		/*
        $html .= "<input type='submit' name='step2_update' value='Upgrade from Dokeos " . implode(', ',$update_from_version) . "'";
		if($error) 
		{
			$html .= " disabled='disabled'";
		}
		$html .= " />\n";
		*/
		$html .= "</p>\n";

		echo $html;

	}
}

/**
 * Displays the license (GNU GPL) as step 2, with
 * - an "I accept" button named step3 to proceed to step 3;
 * - a "Back" button named step1 to go back to the first step.
 * @author Zhong <poopsoft@163.com>
 * @return 
*/
function display_license_agreement()
{
	$html = display_header_message(display_step_sequence() . get_lang('Licence'));
	
	$html .= "<p>" . get_lang('DokeosLicenseInfo') . "<a href='../../documentation/license.html'>" . get_lang('PrintVers') . "</a></p>\n";
	$html .= "<table align='center' width='70%'><tr><td>\n";
	$html .= "<textarea cols='65' rows='15' wrap='virtual'>\n";
	echo $html;
	include('../../documentation/license.txt');
	$html = "</textarea>\n";
	$html .= "</td></tr></table>\n";

	$html .= "<p align='right'>\n";
	$html .= "<input type='submit' class='inputSubmit' name='step1' value='&lt;" . get_lang('Previous') . "'/>&nbsp;\n";
	$html .= "<input type='submit' class='inputSubmit' name='step3' value='" . get_lang('IAccept') . "&gt;' />\n";
	$html .= "</p>\n";
		
	echo $html;
}

/**
 * Displays a parameter in a table row.
 * Used by the display_database_settings_form function.
 * @author Zhong <poopsoft@163.com>
 * @return the parameter in a table row
*/
function display_database_parameter($install_type, $parameter_name, $form_field_name, $parameter_value, $extra_notice, $display_when_update = 'true')
{
	$html = "<tr>\n";
	$html .= "<td>$parameter_name&nbsp;&nbsp;</td>\n";
	if ($install_type == INSTALL_TYPE_UPDATE && $display_when_update)
	{
		$html .= "<td><input type='hidden' name='{$form_field_name}' value='" . htmlentities($parameter_value, ENT_NOQUOTES, SYSTEM_CHARSET) . "' />{$parameter_value}</td>\n";
	}
	else
	{
		$html .= "<td><input type='text' size='" . DATABASE_FORM_FIELD_DISPLAY_LENGTH . "' maxlength='" . MAX_FORM_FIELD_LENGTH . "' name='{$form_field_name}' value='" . htmlentities($parameter_value, ENT_NOQUOTES, SYSTEM_CHARSET) . "' />&nbsp;{$extra_notice}</td>\n";
	}
	$html .= "</tr>\n";
	
	return $html;
}

/**
 * Displays step 3 - a form where the user can enter the installation settings
 * regarding the databases - login and password, names, prefixes, single
 * or multiple databases, tracking or not...
 * @author Zhong <poopsoft@163.com>
 * @return 
*/
function display_database_settings_form()
{
	global $installType, $dbHostForm, $dbUsernameForm, $dbPassForm, $dbPrefixForm, $enableTrackingForm, $singleDbForm, 
			$dbNameForm, $dbStatsForm, $dbScormForm, $dbUserForm;
	
	$html = display_header_message(display_step_sequence() . get_lang('DBSetting'));

	if($installType == 'update')
	{
		$dbHostForm = get_config_param('dbHost');
		$dbUsernameForm = get_config_param('dbLogin');
		$dbPassForm = get_config_param('dbPass');
		$dbPrefixForm = get_config_param('dbNamePrefix');
		$enableTrackingForm = get_config_param('is_trackingEnabled');
		$singleDbForm = get_config_param('singleDbEnabled');
		$dbNameForm = get_config_param('mainDbName');
		$dbStatsForm = get_config_param('statsDbName');
		$dbScormForm = get_config_param('scormDbName');

		$dbScormExists=true;

		if(empty($dbScormForm))
		{
			if($singleDbForm)
			{
				$dbScormForm=$dbNameForm;
			}
			else
			{
				$dbScormForm=$dbPrefixForm.'scorm';
				$dbScormExists=false;
			}
		}

		if($singleDbForm)
		{
			$dbUserForm=$dbNameForm;
		}
		else
		{
			$dbUserForm=$dbPrefixForm.'iilearn_user';
		}
		$html .= "<p>" . get_lang("DBSettingUpgradeIntro") . "</p>\n";
	}else{
		$html .= "<p>" . get_lang("DBSettingIntro") . "</p>\n";
	}
	
	$html .= "<table border=0 align='center' cellpadding='0' cellspacing='0' class='contentTable'>\n";
	$html .= "<tr><th colspan='2'>" . get_lang('DBSetting') . "</th></tr>\n";

	$example_host = get_lang('EG').' localhost';
	$html .= display_database_parameter($installType, get_lang('DBHost'), 'dbHostForm', $dbHostForm, $example_host);
	$example_login = get_lang('EG').' root';
	$html .= display_database_parameter($installType, get_lang('DBLogin'), 'dbUsernameForm', $dbUsernameForm, $example_login);
	$example_password = get_lang('EG').' '.api_generate_password();
	$html .= display_database_parameter($installType, get_lang('DBPassword'), 'dbPassForm', $dbPassForm, $example_password);
	$html .= display_database_parameter($installType, get_lang('DbPrefixForm'), 'dbPrefixForm', $dbPrefixForm, get_lang('DbPrefixCom'));
	$html .= display_database_parameter($installType, get_lang('MainDB'), 'dbNameForm', $dbNameForm, '&nbsp;');
	$html .= display_database_parameter($installType, get_lang('StatDB'), 'dbStatsForm', $dbStatsForm, '&nbsp;');
	$html .= display_database_parameter($installType, get_lang('ScormDB'), 'dbScormForm', $dbScormForm, '&nbsp;');
	$html .= display_database_parameter($installType, get_lang('UserDB'), 'dbUserForm', $dbUserForm, '&nbsp;');

	$html .= "<tr><td>" . get_lang('EnableTracking') . "</td>\n";
	if($installType == 'update')
	{
		$html .= "<td><input type='hidden' name='enableTrackingForm' value='{$enableTrackingForm}' />" . ($enableTrackingForm ? get_lang('Yes') : get_lang('No')) . "</td>\n";
	}
	else 
	{
		$html .= "<td>\n";
		$html .= "<input class='checkbox' type='radio' name='enableTrackingForm' value='1' id='enableTracking1'" . ($enableTrackingForm ? " checked='checked'" : "") . "/><label for='enableTracking1'>" . get_lang('Yes') . "</label>\n";
		$html .= "<input class='checkbox' type='radio' name='enableTrackingForm' value='0' id='enableTracking0'" . ($enableTrackingForm ? "" : "checked='checked'") . "<label for='enableTracking0'>" . get_lang('No') . "</label>\n";
		$html .= "</td>\n";
	}
	$html .= "</tr>\n";

	$html .= "<tr><td>" . get_lang('SingleDb') . "</td>\n";
	if($installType == 'update')
	{
		$html .= "<td><input type='hidden' name='singleDbForm' value='{$singleDbForm}' />" . ($singleDbForm ? get_lang('One') : get_lang('Several')) . "</td>\n";
	}
	else 
	{
		$html .= "<td>\n";
		$html .= "<input class='checkbox' type='radio' name='singleDbForm' value='1' id='singleDb1'" . ($singleDbForm ? "checked='checked'" : "") . " /><label for='singleDb1'>" . get_lang('One') . "</label>\n";
		$html .= "<input class='checkbox' type='radio' name='singleDbForm' value='0' id='singleDb0'" . ($singleDbForm ? "" : "checked='checked'") . " /><label for='singleDb0'>" . get_lang('Several') . "</label>\n";
		$html .= "</td>\n";
	}
	$html .= "</tr>\n";
	
	$html .= "<tr><td><input type='submit' class='inputSubmitLong' name='step3' value='" . get_lang('CheckDatabaseConnection') . "' /></td>\n";
	$dbConnect = test_db_connect ($dbHostForm, $dbUsernameForm, $dbPassForm, $singleDbForm, $dbPrefixForm);
	$html .= "<td>\n";
	if($dbConnect==1)
	{
		$html .= "<div style='float:left; margin-right:10px;'>\n";
		$html .= "<img src='../../themes/images/message_confirmation.png'/>\n";
		$html .= "</div>\n";
		$html .= "<div style='float:left;'>\n";
		$html .= "MySQL host info:" . mysql_get_host_info() . "<br />MySQL server version: " . mysql_get_server_info() . "<br />MySQL protocol version: " . mysql_get_proto_info();
		$html .= "</div>\n";
		$html .= "<div style='clear:both;'></div>\n";
	}
	else 
	{
		$html .= "<div  style='float:left; margin-right:10px;'>\n";
		$html .= "<img src='../../themes/images/message_error.png'/>\n";
		$html .= "</div>\n";
		$html .= "<div style='float:left;'>\n";
		$html .= "<strong>MySQL error: " . mysql_errno() . "</strong><br />" . mysql_error();
		$html .= "</div>\n";
		$html .= "<div style='clear:both;'></div>\n";
	}
	$html .= "</td></tr>\n";

	$html .= "</table>\n";

	$html .= "<p align='right'>\n";
	$html .= "<input type='submit' class='inputSubmit' name='step2' value='&lt;" . get_lang('Previous') . "'/>&nbsp;\n";
	$html .= "<input type='submit' class='inputSubmit' name='step4' value='" . get_lang('Next') . "&gt;' />\n";
	$html .= "</p>\n";
	
	echo $html;
}

/**
 * Displays a parameter in a table row.
 * Used by the display_configuration_settings_form function.
 * @author Zhong <poopsoft@163.com>
 * @return the html of a parameter in a table row
*/
function display_configuration_parameter($install_type, $parameter_name, $form_field_name, $parameter_value, $display_when_update = 'true')
{
	$html = "<tr>\n";

	if ($form_field_name != 'adminLastName')
	{
		$html .= "<td>$parameter_name&nbsp;&nbsp;</td>\n";
	}
	if ($install_type == INSTALL_TYPE_UPDATE && $display_when_update)
	{
		$html .= "<td><input type='hidden' name='{$form_field_name}' value='" . htmlentities($parameter_value, ENT_NOQUOTES, SYSTEM_CHARSET) . "' />{$parameter_value}</td>\n";
	}
	else
	{
		if ($form_field_name == 'adminLastName')
		{
			$html .= "<input type='hidden' size='" . FORM_FIELD_DISPLAY_LENGTH . "' maxlength='" . MAX_FORM_FIELD_LENGTH . "' name='{$form_field_name}' value='" . htmlentities($parameter_value, ENT_NOQUOTES, SYSTEM_CHARSET) . "' />\n";
		}
		else 
		{
			$html .= "<td><input type='text' size='" . FORM_FIELD_DISPLAY_LENGTH . "' maxlength='" . MAX_FORM_FIELD_LENGTH . "' name='{$form_field_name}' value='" . htmlentities($parameter_value, ENT_NOQUOTES, SYSTEM_CHARSET) . "' /></td>\n";
		}
	}
	$html .= "</tr>\n";
	
	return $html;
}

/**
 * Displays step 4 of the installation - configuration settings about IILearn itself.
 * @author Zhong <poopsoft@163.com>
 * @return 
 */
function display_configuration_settings_form()
{
	global $installType, $dbNameForm, $dbHostForm, $dbUsernameForm, $dbPassForm, $urlForm, $languageForm, $emailForm, 
			$adminFirstName, $adminLastName, $adminPhoneForm, $campusForm, $institutionForm, $institutionUrlForm, 
			$encryptPassForm, $allowSelfReg, $allowSelfRegProf, $loginForm, $passForm;
	
	//if update, try getting settings from the database...
	if($installType == 'update')
	{
		$db_name = $dbNameForm;
		$tmp = get_config_param_from_db($dbHostForm,$dbUsernameForm,$dbPassForm,$db_name,'platformLanguage');
		if(!empty($tmp)) $languageForm = $tmp;
		$tmp = get_config_param_from_db($dbHostForm,$dbUsernameForm,$dbPassForm,$db_name,'emailAdministrator');
		if(!empty($tmp)) $emailForm = $tmp;
		$tmp = get_config_param_from_db($dbHostForm,$dbUsernameForm,$dbPassForm,$db_name,'administratorName');
		if(!empty($tmp)) $adminFirstName = $tmp;
		$tmp = get_config_param_from_db($dbHostForm,$dbUsernameForm,$dbPassForm,$db_name,'administratorSurname');
		if(!empty($tmp)) $adminLastName = $tmp;
		$tmp = get_config_param_from_db($dbHostForm,$dbUsernameForm,$dbPassForm,$db_name,'administratorTelephone');
		if(!empty($tmp)) $adminPhoneForm = $tmp;
		$tmp = get_config_param_from_db($dbHostForm,$dbUsernameForm,$dbPassForm,$db_name,'siteName');
		if(!empty($tmp)) $campusForm = $tmp;
		$tmp = get_config_param_from_db($dbHostForm,$dbUsernameForm,$dbPassForm,$db_name,'Institution');
		if(!empty($tmp)) $institutionForm = $tmp;
		$tmp = get_config_param_from_db($dbHostForm,$dbUsernameForm,$dbPassForm,$db_name,'InstitutionUrl');
		if(!empty($tmp)) $institutionUrlForm = $tmp;
		$urlForm = get_config_param('rootWeb');
		$encryptPassForm = get_config_param('userPasswordCrypted');
		$allowSelfReg = get_config_param('allowSelfReg');
		$allowSelfRegProf = get_config_param('allowSelfRegProf');
	}	

	if($installType != 'update')
	{
		$languageForm = $_SESSION['install_language'];
	}

	$html = display_header_message(display_step_sequence() . get_lang('CfgSetting'));
	
	$html .= "<p>" . get_lang('ConfigSettingsInfo') . "<b>main/inc/conf/configuration.php</b></p>\n";

	$html .= "<table border=0 align='center' cellpadding='0' cellspacing='0' class='contentTable'>\n";
	$html .= "<tr><th colspan='2'>" . get_lang('CfgSetting') . "</th></tr>\n";
	$html .= "<tr><td>" . get_lang('MainLang') . "&nbsp;&nbsp;</td>\n";
	if($installType == 'update')
	{
		$html .= "<td><input type='hidden' name='languageForm' value='" . htmlentities($languageForm, ENT_NOQUOTES, SYSTEM_CHARSET) ."' />{$languageForm}</td>\n";
	}
	else
	{
		$html .= "<td>\n";
		$html .= "<select name='languageForm'>\n";
		$dirname = "../lang/";
		if ($dir=@opendir($dirname)) {
			$lang_files = array();
			while (($file = readdir($dir)) !== false) 
			{
				if($file != '.' && $file != '..' && $file != 'CVS' && $file != '.svn' && is_dir($dirname.$file))
				{
					array_push($lang_files, $file);
				}
			}
			closedir($dir);
		}
		sort($lang_files);
		
		$lange_file = '';
		foreach ($lang_files as $file) 
		{
			$html .= "<option value='" . $file . "'";
			if($file == $languageForm)
			{
				$html .= " selected='selected'";
			}
			$html .= ">" . get_lang($file) . "</option>\n";
		}
		$html .= "</select>\n";
		$html .= "</td>\n";
	}
	$html .= "</tr>\n";

	//Second parameter: Dokeos URL
	$html .= "<tr>\n";
	$html .= "<td>" . get_lang('DokeosURL') . "(<font color='#cc0033'>" . get_lang('ThisFieldIsRequired') . "</font>)&nbsp;&nbsp;</td>\n";
	$html .= "<td><input type='text' size='40' maxlength='100' name='urlForm' value='" . htmlentities($urlForm, ENT_NOQUOTES, SYSTEM_CHARSET) . "' /></td>\n";
	$html .= "</tr>\n";
	//Parameter 3: administrator's email
	$html .= display_configuration_parameter($installType, get_lang("AdminEmail"), "emailForm", $emailForm);
	//Parameter 4: administrator's last name
	$html .= display_configuration_parameter($installType, get_lang("AdminLastName"), "adminLastName", $adminLastName);
	//Parameter 5: administrator's first name
	$html .= display_configuration_parameter($installType, get_lang("AdminFirstName"), "adminFirstName", $adminFirstName);
	//Parameter 6: administrator's telephone
	$html .= display_configuration_parameter($installType, get_lang("AdminPhone"), "adminPhoneForm", $adminPhoneForm);
	//Parameter 7: administrator's login
	$html .= display_configuration_parameter($installType, get_lang("AdminLogin"), "loginForm", $loginForm, false);
	//Parameter 8: administrator's password
	$html .= display_configuration_parameter($installType, get_lang("AdminPass"), "passForm", $passForm, false);
	//Parameter 9: campus name
	$html .= display_configuration_parameter($installType, get_lang("CampusName"), "campusForm", $campusForm);
	//Parameter 10: institute (short) name
	$html .= display_configuration_parameter($installType, get_lang("InstituteShortName"), "institutionForm", $institutionForm);
	//Parameter 11: institute (short) name
	$html .= display_configuration_parameter($installType, get_lang("InstituteURL"), "institutionUrlForm", $institutionUrlForm);

	$html .= "<tr><td>" . get_lang("EncryptUserPass") . "</td>\n";
  	if($installType == 'update')
  	{
  		$html .= "<td><input type='hidden' name='encryptPassForm' value='{$encryptPassForm}'" . ($encryptPassForm ? get_lang("Yes") : get_lang("No")) . "</td>\n";
  	}
  	else 
  	{
		$html .= "<td>\n";
		$html .= "<input class='checkbox' type='radio' name='encryptPassForm' value='1' id='encryptPass1'" . ($encryptPassForm ? "checked='checked'" : "") . " /><label for='encryptPass1'>" . get_lang("Yes") . "</label>\n";
		$html .= "<input class='checkbox' type='radio' name='encryptPassForm' value='0' id='encryptPass0'" . ($encryptPassForm ? "" : "checked='checked'") . " /><label for='encryptPass0'>" . get_lang("No") . "</label>\n";
	  	$html .= "</td>\n";
  	}
  	$html .= "</tr>\n";

	$html .= "<tr><td>" . get_lang("AllowSelfReg") . "</td>\n";
  	if($installType == 'update')
  	{
  		$html .= "<td><input type='hidden' name='allowSelfReg' value='{$allowSelfReg}'/>" . ($allowSelfReg ? get_lang("Yes") : get_lang("No")) . "</td>\n";
  	}
  	else 
  	{
		$html .= "<td>\n";
		$html .= "<input class='checkbox' type='radio' name='allowSelfReg' value='1' id='allowSelfReg1'" . ($allowSelfReg ? "checked='checked'" : "") . " /><label for='allowSelfReg1'>" . get_lang("Yes") . "</label>\n";
		$html .= "<input class='checkbox' type='radio' name='allowSelfReg' value='0' id='allowSelfReg0'" . ($allowSelfReg ? "" : "checked='checked'") . " /><label for='allowSelfReg0'>" . get_lang("No") . "</label>\n";
	  	$html .= "</td>\n";
  	}
  	$html .= "</tr>\n";
	  
	$html .= "<tr><td>" . get_lang("AllowSelfRegProf") . "</td>\n";
  	if($installType == 'update')
  	{
  		$html .= "<td><input type='hidden' name='allowSelfRegProf' value='{$allowSelfRegProf}'/>" . ($allowSelfRegProf ? get_lang("Yes") : get_lang("No")) . "</td>\n";
  	}
  	else 
  	{
		$html .= "<td>\n";
		$html .= "<input class='checkbox' type='radio' name='allowSelfRegProf' value='1' id='allowSelfRegProf1'" . ($allowSelfRegProf ? "checked='checked'" : "") . " /><label for='allowSelfRegProf1'>" . get_lang("Yes") . "</label>\n";
		$html .= "<input class='checkbox' type='radio' name='allowSelfRegProf' value='0' id='allowSelfRegProf0'" . ($allowSelfRegProf ? "" : "checked='checked'") . " /><label for='allowSelfRegProf0'>" . get_lang("No") . "</label>\n";
	  	$html .= "</td>\n";
  	}
  	$html .= "</tr>\n";
 	
	$html .= "</table>\n";	
	
	$html .= "<p align='right'>\n";
	$html .= "<input type='submit' class='inputSubmit' name='step3' value='&lt;" . get_lang('Previous') . "'/>&nbsp;\n";
	$html .= "<input type='submit' class='inputSubmit' name='step5' value='" . get_lang('Next') . "&gt;' />\n";
	$html .= "</p>\n";

	echo $html;
}

/**
 * Before installation (step 5), this message is displayed.
 * @author Zhong <poopsoft@163.com>
 * @return 
*/
function display_before_install_message()
{
	global $languageForm, $dbHostForm, $dbUsernameForm, $dbPassForm, $dbPrefixForm, $dbNameForm, $dbStatsForm, 
			$dbScormForm, $dbUserForm, $enableTrackingForm, $singleDbForm, $allowSelfReg, $encryptPassForm, $allowSelfRegProf,
			$emailForm, $adminLastName,$adminFirstName, $adminPhoneForm, $loginForm, $passForm, $campusForm,
			$institutionForm, $institutionUrlForm, $urlForm, $installType;
			
	$html = display_header_message(display_step_sequence() . get_lang('LastCheck'));
	$html .= "<p><b>" . get_lang('PrintThisPageToRememberPassAndOthers') . "</b></p>\n";
	$html .= "<p>" . get_lang('HereAreTheValuesYouEntered') . "</p>\n";
	
	$html .= "<blockquote>\n";
	$html .= get_lang('MainLang') . ' : ' . $languageForm . "<br><br>\n";
	$html .= get_lang('DBHost') . ' : ' . $dbHostForm . "<br>\n";
	$html .= get_lang('DBLogin') . ' : ' . $dbUsernameForm . "<br>\n";
	$html .= get_lang('DBPassword') . ' : ' . $dbPassForm . "<br>\n";
	if(!empty($dbPrefixForm))
	{
		$html .= get_lang('DbPrefixForm') . ' : ' . $dbPrefixForm . '<br>';
	}
	$html .= get_lang('MainDB') . ' : <b>' . $dbNameForm . "</b>\n";
	if($installType == 'new')
	{
		$html .= ' (<font color="#cc0033">' . get_lang('ReadWarningBelow') . '</font>)<br>';
	}
	if(!$singleDbForm) 
	{
		$html .= get_lang('StatDB') . ' : <b>' . $dbStatsForm . "</b>\n";
		if($installType == 'new') 
		{
			$html .= ' (<font color="#cc0033">' . get_lang('ReadWarningBelow') . '</font>)<br>';
		}
		$html .= get_lang('ScormDB') . ' : <b>' . $dbScormForm . "</b>\n";
		if($installType == 'new')
		{
			$html .= ' (<font color="#cc0033">' . get_lang('ReadWarningBelow') . '</font>)<br>';
		}
		$html .= get_lang('UserDB') . ' : <b>' . $dbUserForm . '</b>';
		if($installType == 'new')
		{
			$html .= ' (<font color="#cc0033">' . get_lang('ReadWarningBelow') . '</font>)<br>';
		}
	}
	$html .= get_lang('EnableTracking') . ' : ' . ($enableTrackingForm ? get_lang('Yes') : get_lang('No')) . '<br>';
	$html .= get_lang('SingleDb') . ' : ' . ($singleDbForm ? get_lang('One') : get_lang('Several')) . '<br><br>';

	$html .= get_lang('AllowSelfReg').' : '.($allowSelfReg ? get_lang('Yes') : get_lang('No')) . '<br>';
	$html .= get_lang('EncryptUserPass') . ' : ' . ($encryptPassForm ? get_lang('Yes') : get_lang('No')) . '<br>';
	$html .= get_lang('AllowSelfRegProf') . ' : ' . ($allowSelfRegProf ? get_lang('Yes') : get_lang('No')) . '<br><br>';

	$html .= get_lang('AdminEmail') . ' : ' . $emailForm . '<br>';
	//$html .= get_lang('AdminLastName') . ' : ' . $adminLastName . '<br>';
	$html .= get_lang('AdminFirstName') . ' : ' . $adminFirstName . '<br>';
	$html .= get_lang('AdminPhone') . ' : ' . $adminPhoneForm . '<br>';

	if($installType == 'new')
	{
		$html .= get_lang('AdminLogin') . ' : <b>' . $loginForm . '</b><br>';
		$html .= get_lang('AdminPass') . ' : <b>' . $passForm . '</b><br><br>';
	}
	else
	{
		$html .= '<br>';	
	}
	
	$html .= get_lang('CampusName') . ' : ' . $campusForm . '<br>';
	$html .= get_lang('InstituteShortName') . ' : ' . $institutionForm . '<br>';
	$html .= get_lang('InstituteURL') . ' : ' . $institutionUrlForm . '<br>';
	$html .= get_lang('DokeosURL') . ' : ' . $urlForm . '<br>';

	$html .= "</blockquote>\n";

	if($installType == 'new')
	{
		$html .= "<div style='background-color:#FFFFFF'>\n";
		$html .= "<p align='center'><b><font color='red'>" . get_lang('Warning') . " !<br>" . get_lang('TheInstallScriptWillEraseAllTables') . "</font></b></p>\n";
		$html .= "</div>\n";
	}

	$html .= "<p align='right'>\n";
	$html .= "<input type='submit' class='inputSubmit' name='step4' value='&lt;" . get_lang('Previous') . "'/>&nbsp;\n";
	$html .= "<input type='submit' class='inputSubmit' name='step6' value='" . get_lang('InstallDokeos') . "&gt;' />\n";
	$html .= "</p>\n";

	echo $html;
}

/**
 * Display the left menu.
 * @author Zhong <poopsoft@163.com>
 * @return the html of left menu
*/
function display_left_menu()
{
	global $current_step;
	
	$html = "<table cellspacing='0' cellpadding='10' width='100%'>\n";
	$html .= "<tr><td class='" . ($current_step==0 ? 'selectedTab' : 'unSelectedTab') . "' align='left'>" . get_lang('Welcome') . "</td></tr>\n";
	$html .= "<tr><td class='" . ($current_step==1 ? 'selectedTab' : 'unSelectedTab') . "' align='left'>" . get_lang('InstallationLanguage') . "</td></tr>\n";
	$html .= "<tr><td class='" . ($current_step==2 ? 'selectedTab' : 'unSelectedTab') . "' align='left'>" . get_lang('Requirements') . "</td></tr>\n";
	$html .= "<tr><td class='" . ($current_step==3 ? 'selectedTab' : 'unSelectedTab') . "' align='left'>" . get_lang('Licence') . "</td></tr>\n";
	$html .= "<tr><td class='" . ($current_step==4 ? 'selectedTab' : 'unSelectedTab') . "' align='left'>" . get_lang('DBSetting') . "</td></tr>\n";
	$html .= "<tr><td class='" . ($current_step==5 ? 'selectedTab' : 'unSelectedTab') . "' align='left'>" . get_lang('CfgSetting') . "</td></tr>\n";
	$html .= "<tr><td class='" . ($current_step==6 ? 'selectedTab' : 'unSelectedTab') . "' align='left'>" . get_lang('PrintOverview') . "</td></tr>\n";
	$html .= "<tr><td class='" . ($current_step==7 ? 'selectedTab' : 'unSelectedTab') . "' align='left'>" . get_lang('Installing') . "</td></tr>\n";
	$html .= "</table>\n";
	
	return $html;
}

/**
 * Display the hidden form.
 * @author Zhong <poopsoft@163.com>
 * @return 
*/
function display_hidden_form()
{
	global $badUpdatePath, $urlAppendPath, $pathForm, $urlForm, $dbHostForm, $dbUsernameForm, $dbPassForm, $singleDbForm, 
			$dbPrefixForm, $dbNameForm, $dbStatsForm, $dbScormForm, $dbUserForm, $enableTrackingForm, $allowSelfReg, 
			$allowSelfRegProf, $emailForm, $adminLastName, $adminFirstName, $adminPhoneForm, $loginForm, $passForm, 
			$languageForm, $campusForm, $educationForm,	$institutionForm, $institutionUrlForm, $checkEmailByHashSent, 
			$ShowEmailnotcheckedToStudent, $userMailCanBeEmpty,	$encryptPassForm;
			
	$html = '<input type="hidden" name="updatePath" value="' . (!$badUpdatePath ? htmlentities($_POST['updatePath'], ENT_NOQUOTES, SYSTEM_CHARSET) : '') . '" />';
	$html .= '<input type="hidden" name="urlAppendPath" value="' . htmlentities($urlAppendPath, ENT_NOQUOTES, SYSTEM_CHARSET) . '" />';
	$html .= '<input type="hidden" name="pathForm" value="' . htmlentities($pathForm, ENT_NOQUOTES, SYSTEM_CHARSET) . '" />';
	$html .= '<input type="hidden" name="urlForm" value="' . htmlentities($urlForm, ENT_NOQUOTES, SYSTEM_CHARSET) . '" />';
	$html .= '<input type="hidden" name="dbHostForm" value="' . htmlentities($dbHostForm, ENT_NOQUOTES, SYSTEM_CHARSET) . '" />';
	$html .= '<input type="hidden" name="dbUsernameForm" value="' . htmlentities($dbUsernameForm, ENT_NOQUOTES, SYSTEM_CHARSET) . '" />';
	$html .= '<input type="hidden" name="dbPassForm" value="' . htmlentities($dbPassForm, ENT_NOQUOTES, SYSTEM_CHARSET) . '" />';
	$html .= '<input type="hidden" name="singleDbForm" value="' . htmlentities($singleDbForm, ENT_NOQUOTES, SYSTEM_CHARSET) . '" />';
	$html .= '<input type="hidden" name="dbPrefixForm" value="' . htmlentities($dbPrefixForm, ENT_NOQUOTES, SYSTEM_CHARSET) . '" />';
	$html .= '<input type="hidden" name="dbNameForm" value="' . htmlentities($dbNameForm, ENT_NOQUOTES, SYSTEM_CHARSET) . '" />';
	$html .= '<input type="hidden" name="dbStatsForm" value="' . htmlentities($dbStatsForm, ENT_NOQUOTES, SYSTEM_CHARSET) . '" />';
	$html .= '<input type="hidden" name="dbScormForm" value="' . htmlentities($dbScormForm, ENT_NOQUOTES, SYSTEM_CHARSET) . '" />';
	$html .= '<input type="hidden" name="dbUserForm" value="' . htmlentities($dbUserForm, ENT_NOQUOTES, SYSTEM_CHARSET) . '" />';
	$html .= '<input type="hidden" name="enableTrackingForm" value="' . htmlentities($enableTrackingForm, ENT_NOQUOTES, SYSTEM_CHARSET) . '" />';
	$html .= '<input type="hidden" name="allowSelfReg" value="' . htmlentities($allowSelfReg, ENT_NOQUOTES, SYSTEM_CHARSET) . '" />';
	$html .= '<input type="hidden" name="allowSelfRegProf" value="' . htmlentities($allowSelfRegProf, ENT_NOQUOTES, SYSTEM_CHARSET) . '" />';
	$html .= '<input type="hidden" name="emailForm" value="' . htmlentities($emailForm, ENT_NOQUOTES, SYSTEM_CHARSET) . '" />';
	$html .= '<input type="hidden" name="adminLastName" value="' . htmlentities($adminLastName, ENT_NOQUOTES, SYSTEM_CHARSET) . '" />';
	$html .= '<input type="hidden" name="adminFirstName" value="' . htmlentities($adminFirstName, ENT_NOQUOTES, SYSTEM_CHARSET) . '" />';
	$html .= '<input type="hidden" name="adminPhoneForm" value="' . htmlentities($adminPhoneForm, ENT_NOQUOTES, SYSTEM_CHARSET) . '" />';
	$html .= '<input type="hidden" name="loginForm" value="' . htmlentities($loginForm, ENT_NOQUOTES, SYSTEM_CHARSET) . '" />';
	$html .= '<input type="hidden" name="passForm" value="' . htmlentities($passForm, ENT_NOQUOTES, SYSTEM_CHARSET) . '" />';
	$html .= '<input type="hidden" name="languageForm" value="' . htmlentities($languageForm, ENT_NOQUOTES, SYSTEM_CHARSET) . '" />';
	$html .= '<input type="hidden" name="campusForm" value="' . htmlentities($campusForm, ENT_NOQUOTES, SYSTEM_CHARSET) . '" />';
	$html .= '<input type="hidden" name="educationForm" value="' . htmlentities($educationForm, ENT_NOQUOTES, SYSTEM_CHARSET) . '" />';
	$html .= '<input type="hidden" name="institutionForm" value="' . htmlentities($institutionForm, ENT_NOQUOTES, SYSTEM_CHARSET) . '" />';
	$html .= '<input type="hidden" name="institutionUrlForm" value="' . (stristr($institutionUrlForm,'http://') ? htmlentities($institutionUrlForm, ENT_NOQUOTES, SYSTEM_CHARSET) : 'http://'.htmlentities($institutionUrlForm, ENT_NOQUOTES, SYSTEM_CHARSET)) . '" />';
	$html .= '<input type="hidden" name="checkEmailByHashSent" value="' . htmlentities($checkEmailByHashSent, ENT_NOQUOTES, SYSTEM_CHARSET) . '" />';
	$html .= '<input type="hidden" name="ShowEmailnotcheckedToStudent" value="' . htmlentities($ShowEmailnotcheckedToStudent, ENT_NOQUOTES, SYSTEM_CHARSET) . '" />';
	$html .= '<input type="hidden" name="userMailCanBeEmpty" value="' . htmlentities($userMailCanBeEmpty, ENT_NOQUOTES, SYSTEM_CHARSET) . '" />';
	$html .= '<input type="hidden" name="encryptPassForm" value="' . htmlentities($encryptPassForm, ENT_NOQUOTES, SYSTEM_CHARSET) . '" />';
	
	return $html;
}

?>