<?php //$id:$
/*
==============================================================================
	Dokeos - elearning and course management software

	Copyright (c) 2004-2006 Dokeos S.A.
	Copyright (c) 2004 Denes Nagy
	Copyright (c) 2003 University of Ghent (UGent)
	Copyright (c) 2001 Universite catholique de Louvain (UCL)

	For a full list of contributors, see "credits.txt".
	The full license can be read in "license.txt".

	This program is free software; you can redistribute it and/or
	modify it under the terms of the GNU General Public License
	as published by the Free Software Foundation; either version 2
	of the License, or (at your option) any later version.

	See the GNU General Public License for more details.

	Contact: Zhong 	poopsoft@163.com
==============================================================================
*/
/**
==============================================================================
* This file was origially the copy of document.php, but many modifications happened since then ;
* the direct file view is not any more needed, if the user uploads a scorm zip file, a directory
* will be automatically created for it, and the files will be uncompressed there for example ;
*
* @package iilearn.learnpath
* @author Yannick Warnier <ywarnier@beeznest.org>
==============================================================================
*/
/**
 * Script
 */
if(empty($lp_controller_touched) || $lp_controller_touched!=1){
	header('location: lp_controller.php?action=list');
}

require_once('back_compat.inc.php');
$courseDir   = api_get_course_path().'/scorm';
$baseWordDir = $courseDir;

require_once('learnpathList.class.php');
require_once('learnpath.class.php');
require_once('learnpathItem.class.php');

/**
 * Display initialisation and security checks
 */
//extra javascript functions for in html head:
$htmlHeadXtra[] =
"<script language='javascript' type='text/javascript'>
function confirmation (name)
{
	if (confirm(\" ".get_lang('AreYouSureToDelete')." \"+ name + \" ?\"))
		{return true;}
	else
		{return false;}
}
</script>";
// hgz 20070426
//$nameTools = get_lang("Doc");
$nameTools = get_lang("lang_learning_path");
event_access_tool(TOOL_LEARNPATH);

if (! $is_allowed_in_course) api_not_allowed();

$this_section=SECTION_COURSES;

$htmlHeadXtra[] = get_table_style_ie6();

Display::display_header($nameTools,"Path");

/*
-----------------------------------------------------------
	Introduction section
	(editable by course admins)
-----------------------------------------------------------
*/
if($my_version=='1.8'){
	Display::display_introduction_section(TOOL_LEARNPATH);
}else{
	api_introductionsection(TOOL_LEARNPATH);
}

if(api_is_allowed_to_edit())
{


  /*--------------------------------------
    DIALOG BOX SECTION
    --------------------------------------*/
  if ($dialog_box)
  {
    Display::display_normal_message($dialog_box);
  }
  if (api_failure::get_last_failure())
  {
    Display::display_normal_message(api_failure::get_last_failure());
  }
  
  if($_REQUEST['action']=='add_lp' && !($new_lp_id>0)){
  	require('lp_add.php');
  }

  include('content_makers.inc.php');
  echo	'<a href="'.$_SERVER['PHP_SELF'].'?action=add_lp">'.
		Display::return_icon('wizard.gif', get_lang('_add_learnpath'), array('align'=>'absmiddle')) . '&nbsp;' . get_lang('_add_learnpath').
		'</a>' .
		str_repeat('&nbsp;',3).
		'<a href="upload.php">' . Display::return_icon('file_zip.gif', get_lang('UploadScorm'), array('align'=>'absmiddle')) . '&nbsp;' . get_lang("UploadScorm") . '</a>';
		/* hgz 20070531 do not use the ppt to lp function now
		if(api_get_setting('service_ppt2lp','active')==true)
		{
			echo  str_repeat('&nbsp;',3).'<a href="../upload/upload_ppt.php?curdirpath=/&tool='.TOOL_LEARNPATH.'"><img src="../img/powerpoint.gif" border="0" alt="scormbuilder" align="absmiddle">&nbsp;'.get_lang("PowerPointConvert").'</a>';
       }
       */
}

echo '<table width="100%" border="0" cellspacing="0" class="data_table">';
api_is_allowed_to_edit() ? $colspan = 9 : $colspan = 3;

if ($curDirPath)
{
  if(substr($curDirPath,1,1)=='/'){
  	$tmpcurDirPath=substr($curDirPath,1,strlen($curDirPath));
  }else{
  	$tmpcurDirPath = $curDirPath;
  }
  ?>
  <!-- current dir name -->
  <tr>
    <td colspan="<?php echo $colspan ?>" align="left" bgcolor="#4171B5">
	<?php echo Display::return_icon('opendir.gif', get_lang('open_dir'), array('align'=>'absbottom','vspace'=>'2','hspace'=>'3')); ?>		    
      <font color="#ffffff"><b><?php echo $tmpcurDirPath ?></b></font>
    </td>
  </tr>
  <?php
}

/* CURRENT DIRECTORY */

echo	'<tr>';
echo	'<th>'.get_lang("Name").'</th>'."\n" .
		'<th>'.get_lang("progress")."</th>\n";
if (api_is_allowed_to_edit())
{
  echo "<th>" . get_lang("Description") . "</th>\n" .
  		"<th>" . get_lang("ExportShort") . "</th>\n" .
		"<th>&nbsp;</th>\n";
}

echo "</tr>\n";

/*--------------------------------------
	  DISPLAY SCORM LIST
  --------------------------------------*/
$list = new LearnpathList(api_get_user_id());
$flat_list = $list->get_flat_list();
$is_allowed_to_edit = api_is_allowed_to_edit();

if (is_array($flat_list))
{
	$counter = 0;
	foreach ($flat_list as $id => $details)
	{
	    if(!$is_allowed_to_edit && $details['lp_visibility'] == "i")
	    {
	    	// This is a student and this path is invisible, skip
	    	continue;		
	    }

	    $counter++;
	    if (($counter % 2)==0) { $oddclass="row_odd"; } else { $oddclass="row_even"; }
	
		$url_start_lp = 'lp_controller.php?'.api_get_cidreq().'&action=view&lp_id='.$id;
		$name = $details['lp_name'];
		$image = Display::return_icon('kcmdf.gif', get_lang('Learnpath'), array('align'=>'absmiddle')) . "\n";
	    $dsp_line =	'<tr align="center" class="'.$oddclass.'">'."\n" .
        	'<td align="left" valign="top">' .
			'<div style="float: left; width: 35px; height: 22px;"><a href="'.$url_start_lp.'" '.$style.'>' .
			$image . '</a></div><a href="'.$url_start_lp.'" '.$style.'>' . $name . '</a>' .
			"</td>\n";
	    $dsp_desc = '';
	    
	    $dsp_export = '';
	    $dsp_edit = '';
	    $dsp_delete = '';
	    $dsp_visible = '';
	    $dsp_progress = '<td>'.learnpath::get_progress_bar('%',learnpath::get_db_progress($id,api_get_user_id(),'both'),'').'</td>';
	    if(api_is_allowed_to_edit())
	    {
		    $dsp_desc = '<td valign="middle" style="color: grey; padding-top:1em;">'.$details['lp_proximity'].' &nbsp;&nbsp; '.$details['lp_encoding'].'<a href="lp_controller.php?'.api_get_cidreq().'&action=edit&lp_id='.$id.'">&nbsp;&nbsp;' . Display::return_icon('edit.gif', get_lang('_edit_learnpath')) . "</a></td>\n";
			$fileExtension=explode('.',$dspFileName);
			$fileExtension=strtolower($fileExtension[sizeof($fileExtension)-1]);
			
			/* export */
			//export not available for normal lps yet
			/* hgz 20070729 This function does not be used now.*/
			//if($details['lp_type']==1){
			if(false){
				$dsp_export = '<td align="center">' .
					"<a href='".$_SERVER['PHP_SELF']."?".api_get_cidreq()."&action=export&lp_id=$id'>" .
					Display::return_icon('cd.gif', get_lang('Export')) .
					"</a>" .
					"";
			}
			/* hgz 20070729 This function does not be used now.*/
			//elseif($details['lp_type']==2){
			elseif(false){
				$dsp_export = '<td align="center">' .
					"<a href='".$_SERVER['PHP_SELF']."?".api_get_cidreq()."&action=export&lp_id=$id&export_name=".replace_dangerous_char($name,'strict').".zip'>" .
					"<img src=\"../img/cd.gif\" border=\"0\" title=\"".get_lang('Export')."\">" .
					"</a>" .
					"";
			}
			else{
				$dsp_export = '<td align="center">' .
					Display::return_icon('cd_gray.gif', get_lang('Export')) .
					"";
			}	

			/* edit title and description */	
			$dsp_edit = '<td align="center">';
			
			/* DELETE COMMAND */
			$dsp_delete = "<a href=\"lp_controller.php?".api_get_cidreq()."&action=delete&lp_id=$id\" " .
			"onClick=\"return confirmation('".addslashes($dspFileName)."');\">" .
			Display::return_icon('delete.gif', get_lang('Delete')) .
			"</a>";
			
			/* VISIBILITY COMMAND */
			
			if ($details['lp_visibility'] == "i")
			{
		        $dsp_visible =	"<a href=\"".$_SERVER['PHP_SELF']."?".api_get_cidreq()."&lp_id=$id&action=toggle_visible&new_status=v\">" .
				Display::return_icon('invisible_LP_list.gif', get_lang('_no_publish')) .
				"</a>&nbsp;";
			}
			else
			{
				$dsp_visible =	"<a href='".$_SERVER['PHP_SELF']."?".api_get_cidreq()."&lp_id=$id&action=toggle_visible&new_status=i'>" .
				Display::return_icon('visible_LP_list.gif', get_lang('_publish')) .
				"</a>&nbsp;";
			}
			/* Default view mode settings (fullscreen/embedded) */
			if($details['lp_view_mode'] == 'fullscreen'){
				$dsp_default_view = '<a href="lp_controller.php?'.api_get_cidreq().'&action=switch_view_mode&lp_id='.$id.'">' .
						Display::return_icon('view_fullscreen.gif', get_lang('ViewModeFullScreen')) .
						'</a>&nbsp;';
			}else{
				$dsp_default_view = '<a href="lp_controller.php?'.api_get_cidreq().'&action=switch_view_mode&lp_id='.$id.'">' .
						Display::return_icon('view_choose.gif', get_lang('ViewModeEmbedded')) .
						'</a>&nbsp;';
			}

			/* Increase SCORM recording */
			/*  This function does not be used now. 	Zhong 20070729
			if($details['lp_force_commit'] == 1){
				$dsp_force_commit = '<a href="lp_controller.php?'.api_get_cidreq().'&action=switch_force_commit&lp_id='.$id.'">' .
						Display::return_icon('clock.gif', get_lang('MakeScormRecordingExtra')) .
						'</a>&nbsp;';
			}else{
				$dsp_force_commit = '<a href="lp_controller.php?'.api_get_cidreq().'&action=switch_force_commit&lp_id='.$id.'">' .
						Display::return_icon('clock_gray.gif', get_lang('MakeScormRecordingNormal')) .
						'</a>&nbsp;';
			}
			
			if($details['lp_prevent_reinit']==1){
				$dsp_reinit = '<a href="lp_controller.php?'.api_get_cidreq().'&action=switch_reinit&lp_id='.$id.'">' .
						Display::return_icon('kaboodleloop.gif', get_lang('AllowMultipleAttempts')) .
						'</a>&nbsp;';
			}else{
				$dsp_reinit = '<a href="lp_controller.php?'.api_get_cidreq().'&action=switch_reinit&lp_id='.$id.'">' .
						Display::return_icon('kaboodleloop_gray.gif', get_lang('PreventMultipleAttempts')) .
						'</a>&nbsp;';
			}
			*/
			if($details['lp_type']==1){
				$dsp_build = '<a href="lp_controller.php?'.api_get_cidreq().'&amp;action=build&amp;lp_id='.$id.'">' . Display::return_icon('wizard.gif', get_lang('Build')) . '</a>&nbsp;';
			}else{
				$dsp_build = Display::return_icon('wizard_gray.gif', get_lang('Build')) . '&nbsp;';
			}
			if($details['lp_scorm_debug']==1){
				$dsp_debug = '<a href="lp_controller.php?'.api_get_cidreq().'&action=switch_scorm_debug&lp_id='.$id.'">' .
						Display::return_icon('bug.gif', get_lang('HideDebug')) .
						'</a>&nbsp;';
			}else{
				$dsp_debug = '<a href="lp_controller.php?'.api_get_cidreq().'&action=switch_scorm_debug&lp_id='.$id.'">' .
						Display::return_icon('bug_gray.gif', get_lang('ShowDebug')) .
						'</a>&nbsp;';
			}
		
	    }	// end if($is_allowedToEdit)
	    //echo $dsp_line.$dsp_progress.$dsp_desc.$dsp_export.$dsp_edit.$dsp_build.$dsp_visible.$dsp_reinit.$dsp_force_commit.$dsp_delete;
	    echo $dsp_line.$dsp_progress.$dsp_desc.$dsp_export.$dsp_edit.$dsp_build.$dsp_default_view.$dsp_visible.$dsp_reinit.$dsp_force_commit.$dsp_delete;
	    echo	"</tr>\n";
      
	}	// end foreach ($flat_list)
	
	if ($counter == 0)
	{
		echo "<tr><td colspan='" . (api_is_allowed_to_edit() ? '5' : '2') . "' align='center'><i>" . get_lang('TheListIsEmpty') . "</i></td></tr>\n";		
	}
}// end if ( is_array($flat_list)
echo "</table>";
echo "<br/><br/>";
/*
==============================================================================
  FOOTER
==============================================================================
*/
Display::display_footer();
?>