<?php //$id: $
/**
 * Script managing the learnpath upload. To best treat the uploaded file, make sure we can identify it.
 * @package iilearn.learnpath
 * @author Yannick Warnier <ywarnier@beeznest.org>
 */
/**
 * Script initialisations
 */

//require_once('back_compat.inc.php');
require_once('learnpath.class.php');

$course_dir  = api_get_course_path().'/scorm';
$course_sys_dir = api_get_path(SYS_COURSE_PATH).$course_dir;
$current_dir = replace_dangerous_char(trim($_POST['current_dir']),'strict');
$uncompress  = 1;

$title = $_POST['title'];
$proximity = $_POST['content_proximity'];
$maker = $_POST['content_maker'];

/*
 * check the request method in place of a variable from POST
 * because if the file size exceed the maximum file upload
 * size set in php.ini, all variables from POST are cleared !
 */

if ($_SERVER['REQUEST_METHOD'] == 'POST' && count($_FILES)>0 && !empty($_FILES['user_file']['name']))
{
	// A file upload has been detected, now deal with the file...
	//directory creation

	$stopping_error = false;

	$s=$_FILES['user_file']['name'];
	//get name of the zip file without the extension
	$info = pathinfo($s);
	$filename = $info['basename'];
	$extension = $info['extension'];
	$file_base_name = str_replace('.'.$extension,'',$filename);
	
	$new_dir = replace_dangerous_char(trim($file_base_name),'strict');

	$type = learnpath::get_package_type($_FILES['user_file']['tmp_name'],$_FILES['user_file']['name']);
	switch($type){
		case 'scorm':
			require_once('scorm.class.php');
			$oScorm = new scorm();
			$manifest = $oScorm->import_package($_FILES['user_file'],$current_dir);
			if(!empty($manifest)){
				$oScorm->parse_manifest($manifest);						
				$oScorm->import_manifest(api_get_course_id(), $title, $proximity, $maker);
			}else{
				//show error message stored in $oScrom->error_msg
			}
		
			break;
		case 'aicc':
			require_once('aicc.class.php');
			$oAICC = new aicc();	
			$config_dir = $oAICC->import_package($_FILES['user_file']);
			if(!empty($config_dir)){
				$oAICC->parse_config_files($config_dir);
				$oAICC->import_aicc(api_get_course_id(), $title, $proximity);
			}
			break;
		case 'ppt':
			require_once('presentation.class.php');
			$o_ppt = new presentation();
			$first_item_id = $o_ppt -> convert_presentation($_FILES['user_file']);				
			break;
		case '':
		default:
			api_failure::set_failure(get_lang('NotImportScormAicc'));
	}
} // end if is_uploaded_file
elseif($_SERVER['REQUEST_METHOD'] == 'POST')
{
	// A file upload has been detected, now deal with the file...
	//directory creation

	//escape path with basename so it can only be directly into the claroline/upload directory
	$s = api_get_path(SYS_PATH) . 'storage/ftp/scorm_aicc/' . basename($_POST['file_name']);

	$type = learnpath::get_package_type($s,basename($s));
	switch($type){
		case 'scorm':
			require_once('scorm.class.php');
			$oScorm = new scorm();
			$manifest = $oScorm->import_local_package($s,$current_dir);
			if(!empty($manifest)){
				$oScorm->parse_manifest($manifest);
				//$oScorm->import_manifest(api_get_course_id());
				$oScorm->import_manifest(api_get_course_id(), $title, $proximity, $maker);
			}
		
			break;
		case 'aicc':
			require_once('aicc.class.php');
			$oAICC = new aicc();
			$config_dir = $oAICC->import_local_package($s,$current_dir);
			if(!empty($config_dir)){
				$oAICC->parse_config_files($config_dir);
				//$oAICC->import_aicc(api_get_course_id());
				$oAICC->import_aicc(api_get_course_id(), $title, $proximity);
			}
			break;
		case '':
		default:
			api_failure::set_failure(get_lang('NotImportScormAicc'));
	}	
}
?>