<?php // $Id: upload.php 
/*
==============================================================================
	IILearn - elearning and course management software

	For a full list of contributors, see "credits.txt".
	The full license can be read in "license.txt".

	This program is free software; you can redistribute it and/or
	modify it under the terms of the GNU General Public License
	as published by the Free Software Foundation; either version 2
	of the License, or (at your option) any later version.

	See the GNU General Public License for more details.

*
* @package iilearn.newscorm
* @author zhong <poopsoft@163.com>
==============================================================================

/**
 * INIT SECTION
*/
// name of the language file that needs to be included
$language_file[] = "document";
$language_file[] = "scorm";
$language_file[] = "scormdocument";
$language_file[] = "learnpath";

include("../inc/global.inc.php");

if(! api_is_allowed_to_edit()){
	api_not_allowed();
}

/*
-----------------------------------------------------------
	Libraries
-----------------------------------------------------------
*/

require_once(api_get_path(LIBRARY_PATH) . 'fileUpload.lib.php');
require_once(api_get_path(LIBRARY_PATH) . 'events.lib.inc.php');
require_once(api_get_path(LIBRARY_PATH) . 'document.lib.php');
require_once (api_get_path(LIBRARY_PATH) . 'pclzip/pclzip.lib.php');
require_once (api_get_path(LIBRARY_PATH).'formvalidator/FormValidator.class.php');
require_once('content_makers.inc.php');

function get_zip_files_in_garbage()
{
	$list = array();
	$list[''] = '---' . get_lang('None') . '---';
	$handle = opendir(api_get_path(SYS_PATH).'storage/ftp/scorm_aicc/');
	if($handle)
	{
		while(false !== ($entry = readdir($handle)))
		{
			if(substr($entry,0,1) != '.')
			{
				if(preg_match('/^.*\.zip$/i',$entry))
				{
					$list[$entry] = $entry;
				}
			}
		}
		natcasesort($list);
		closedir($dh);
	}
	return $list;
}

function get_maker()
{
	global $content_origins;
	
	$list = array();
	foreach($content_origins as $index => $origin)
	{
		$list[$origin] = $origin;
	}
	return $list;
}

function get_proximity()
{
	$list = array('local'=>get_lang('Local'), 'remote'=>get_lang('Remote'));	
	return $list;
}

event_access_tool(TOOL_UPLOAD);

$nameTools = get_lang("UploadScorm");
$interbreadcrumb[]= array ("url"=>"../newscorm/lp_controller.php?action=list", "name"=> get_lang("lang_learning_path"));
$this_section=SECTION_COURSES;

ob_start();
Display::display_header($nameTools,"Path");

$form = new FormValidator('upload','POST',$_SERVER['PHP_SELF'],'','enctype="multipart/form-data"');

$form->addElement('header', 'header', get_lang("Learnpath") . " - " . get_lang("FileUpload") . $add_group_to_title);
$form->addElement('file','user_file',get_lang('FileToUpload'),array('size' => '40'));
$form->addElement('select', 'file_name', get_lang('UploadLocalFileFromGarbageDir'), get_zip_files_in_garbage());
$form->addElement('text', 'title', get_lang('Title'),array('size' => '30'));
$form->addElement('select','content_maker',get_lang('ContentMaker'), get_maker());
$form->addElement('select', 'content_proximity', get_lang('ContentProximity'), get_proximity());

$group = array ();
$group[] = $form->createElement('submit', 'submit', get_lang('Send'), 'class="inputSubmit"');
$form->addGroup($group, 'submit', '&nbsp;', null, false);

$form->add_real_progress_bar('uploadScorm','user_file');

if ($form->validate())
{
	$upload_ok = ! empty($_FILES['user_file']['name']) ? process_uploaded_file($_FILES['user_file']) : true;
	if($upload_ok)
	{
		$cwdir = getcwd();
		require_once('lp_upload.php');
		//reinit current working directory as many functions in upload change it
		chdir($cwdir);

		$message = api_failure::get_last_failure();
		if (empty($message)) 
		{
			$message = get_lang('UplUploadSucceeded');
		}
		header('location: lp_controller.php?action=list&dialog_box=' . urlencode($message));
	}
}

Display::setTemplateBorder($form, '60%');
$form->display();


/*
==============================================================================
		FOOTER
==============================================================================
*/
Display::display_footer();

?>