<?php
// $Id: add_meeting.php 10926 2007-01-26 14:34:47Z Zhong $
/*
==============================================================================
	IILearn - elearning and course management software

	Copyright (c) 2007 IILearn CN.

	For a full list of contributors, see "credits.txt".
	The full license can be read in "license.txt".

	This program is free software; you can redistribute it and/or
	modify it under the terms of the GNU General Public License
	as published by the Free Software Foundation; either version 2
	of the License, or (at your option) any later version.

	See the GNU General Public License for more details.

	Contact: Zhong 	poopsoft@163.com
==============================================================================
*/
/**
==============================================================================
*	@package iilearn.online_meeting
==============================================================================
*/

$language_file = 'online_meeting';

require_once('../inc/global.inc.php');
require_once (api_get_path(LIBRARY_PATH).'formvalidator/FormValidator.class.php');
require_once('meeting_manage.lib.php');

api_protect__course_admin_script();

$this_section = SECTION_COURSES;
$nameTools = get_lang("AddMeeting");
$interbreadcrumb[] = array('url' => 'index.php', 'name' => get_lang('OnlineMeeting'));

$fck_attribute['Width'] = '100%';
$fck_attribute['Height'] = '120';
$fck_attribute['ToolbarSet'] = 'Middle';

$form = new FormValidator('add_meeting');
$form->addElement('header', 'header', get_lang('AddMeeting'));
$form->add_textfield('conf_name', get_lang('MeetingName'), true, array('size'=>50));
$form->add_html_editor('intro', get_lang('MeetingIntroduction'), false);

$options = array();
$options[0]  = get_lang('No');
$options[1] = get_lang('Yes');
$form->addElement('select', 'lobby', get_lang('WaitingArea'), $options);

$options = array();
$options[20]  = '20';
$options[40]  = '40';
$options[60]  = '60';
$options[80]  = '80';
$options[100]  = '100';
$options[200]  = '200';
$options[300]  = '300';
$options[400]  = '400';
$options[500]  = '500';
$form->addElement('select', 'max_participants', get_lang('MaxParticipants'), $options);

$group = array();
$options_hour = array();
$options_minute = array();
$options_hour[0]  = '0';
$options_hour[1]  = '1';
$options_hour[2]  = '2';
$options_hour[3]  = '3';
$options_hour[4]  = '4';
$options_hour[5]  = '5';
$options_minute[0] = '0';
$options_minute[15] = '15';
$options_minute[30] = '30';
$options_minute[45] = '45';
$group[] = $form->createElement('select', 'meeting_hours', null, $options_hour);
$group[] = $form->createElement('static', null, null, get_lang('Hours'));
$group[] = $form->createElement('select', 'meeting_minutes', null, $options_minute);
$group[] = $form->createElement('static', null, null, get_lang('Minutes'));
$form->addGroup($group, null, get_lang('MeetingHoursMinutes'), '&nbsp;', false);

$options = array();
$options['audio']  = get_lang('Audio');
$options['av'] = get_lang('AudioVideo');
$form->addElement('select', 'presenter_av', get_lang('AudioVideo'), $options);

$options = array();
$options[0]  = '0';
$options[1]  = '1';
$options[2]  = '2';
$options[3]  = '3';
$options[4]  = '4';
$options[5]  = '5';
$form->addElement('select', 'max_mikes', get_lang('MaxMikes'), $options);

$options = array();
$options[1]  = get_lang('DialUp');
$options[2] = get_lang('CableDsl');
$options[3] = get_lang('Lan');
$form->addElement('select', 'network_profile', get_lang('NetworkProfile'), $options);

$form->add_datepicker('start_time', get_lang('StartTime'));

$options = array();
$options[0]  = get_lang('RepeatNone');
$options[1] = get_lang('RepeatDaily');
$options[2] = get_lang('RepeatWeekly');
$form->addElement('select', 'schedule', get_lang('Repeat'), $options);

$form->addElement('hidden','email_user');
$form->addElement('hidden','display_name');
$form->addElement('hidden','conf_key');
$form->addElement('hidden','start_now');
$form->addElement('hidden','timezone');
$form->addElement('hidden','time_str');

$defaults['email_user'] = $_user['mail'];
$defaults['display_name'] = $_user['firstName'];
$defaults['conf_key'] = MeetingManage::get_key();
$defaults['start_now'] = 'on';
$defaults['timezone'] = 'Asia/Shanghai';
$defaults['time_str'] = '';
$defaults['meeting_hours'] = '1';
$time = strtotime("now");
$defaults['start_time']['d']=date('d',$time);
$defaults['start_time']['F']=date('m',$time);
$defaults['start_time']['Y']=date('Y',$time);

$form->setDefaults($defaults);

$group = array ();
$group[] = $form->createElement('submit', 'submit', get_lang('Ok'), 'class="inputSubmit"');
$form->addGroup($group, 'submit', '&nbsp;', null, false);

if($form->validate())
{
	$values = $form->exportValues();
	$values = Database::escape_string($values);
	MeetingManage::add_meeting($values);
	
	header('Location: index.php?message=' . urlencode(get_lang('AddedMeeting')));
	exit();
}

Display::display_header($nameTools);

Display::setTemplateBorder($form, '70%');
$form->display();

/*
==============================================================================
		FOOTER
==============================================================================
*/
Display::display_footer();

?>