<?php
// $Id: index.php 10926 2007-01-26 14:34:47Z Zhong $
/*
==============================================================================
	IILearn - elearning and course management software

	Copyright (c) 2007 IILearn CN.

	For a full list of contributors, see "credits.txt".
	The full license can be read in "license.txt".

	This program is free software; you can redistribute it and/or
	modify it under the terms of the GNU General Public License
	as published by the Free Software Foundation; either version 2
	of the License, or (at your option) any later version.

	See the GNU General Public License for more details.

	Contact: Zhong 	poopsoft@163.com
==============================================================================
*/
/**
==============================================================================
*	@package iilearn.online_meeting
==============================================================================
*/

$language_file = 'online_meeting';
require_once('../inc/global.inc.php');
require_once(api_get_path(LIBRARY_PATH).'events.lib.inc.php');
require_once('meeting_manage.lib.php');

api_protect_course_script();

event_access_tool(TOOL_ONLINE_MEETING);

$this_section = SECTION_COURSES;
$htmlHeadXtra[] = get_table_style_ie6();
$nameTools = get_lang("OnlineMeeting");
Display::display_header($nameTools);

if(api_is_allowed_to_edit() || api_is_platform_admin())
{
	if (isset($_GET['message']))
	{
		Display::display_normal_message($_GET['message']);
	}
	
	if (isset($_POST['action']))
	{
		switch ($_POST['action'])	
		{
			case 'delete_meetings':
				$meetings = $_POST['meetings'];
				foreach ($meetings as $key=>$id)
				{
					$id = intval($id);
					MeetingManage::delete_meeting($id);
				}
				Display :: display_normal_message(get_lang('MeetingDeleted'));
				break;
		}
	}
	
	if (isset($_GET['action']))
	{
		switch ($_GET['action'])
		{
			case 'delete_meeting' :
				$id = intval($_GET['id']);
				MeetingManage::delete_meeting($id);
				Display :: display_normal_message(get_lang('MeetingDeleted'));
				break;
		}
	}
	
	$html = "<div class='subMenuLeft'>\n";
	$html .= "<a href='add_meeting.php'>\n";
	$html .= Display::return_icon('visio_meeting.gif',get_lang('AddMeeting'));
	$html .= "&nbsp;" . get_lang('AddMeeting') . "</a>\n";
	$html .= "</div><div class='clear'></div>\n";
	echo $html;

	$table = new SortableTable('meetings', 'get_number_of_meetings', 'get_meeting_data', 1, NUMBER_PAGE);
	$table->set_header(0, '', false);
	$table->set_header(1, get_lang('MeetingName'));
	$table->set_header(2, get_lang('MeetingHoursMinutes'));
	$table->set_header(3, get_lang('StartTime'));
	$table->set_header(4, '', false);
	$table->set_column_filter(4, 'modify_filter');
	$table->set_form_actions(array ('delete_meetings' => get_lang('DeleteSelectedMeetings')),'meetings');
}
else 
{
	$table = new SortableTable('meetings', 'get_number_of_meetings', 'get_meeting_data', 0, NUMBER_PAGE);
	$table->set_header(0, get_lang('MeetingName'));
	$table->set_header(1, get_lang('MeetingHoursMinutes'));
	$table->set_header(2, get_lang('StartTime'));
	$table->set_header(3, '', false);
	$table->set_column_filter(3, 'modify_filter');
}

$table->display();

/**
 * Gets the total number of meetings
 */
function get_number_of_meetings()
{
	$tbl_meeting = Database :: get_course_table(TABLE_ONLINE_MEETING);
	$sql = "SELECT COUNT(*) FROM {$tbl_meeting}";
	$res = api_sql_query($sql, __FILE__, __LINE__);
	$row = mysql_fetch_row($res);
	
	return $row[0];
}

/**
 * Gets the information about some classes
 * @param int $from
 * @param int $number_of_items
 * @param string $direction
 */
function get_meeting_data($from, $number_of_items, $column, $direction)
{
	global $_course;
	
	$from = Database::escape_string($from);
	$number_of_items = Database::escape_string($number_of_items);
	$column = Database::escape_string($column);
	$direction = Database::escape_string($direction);
	
	$tbl_meeting = Database :: get_course_table(TABLE_ONLINE_MEETING);
	if(api_is_allowed_to_edit() || api_is_platform_admin())
	{
		$sql = "SELECT 	id AS col0,	conf_name AS col1, concat(meeting_hours,' hours ',meeting_minutes,' minutes') AS col2, start_time AS col3, id AS col4 FROM {$tbl_meeting} ";
	}
	else 
	{
		$sql = "SELECT	conf_name AS col0, concat(meeting_hours,' hours ',meeting_minutes,' minutes') AS col1, start_time AS col2, id AS col3 FROM {$tbl_meeting} ";		
	}
	$sql .= "GROUP BY id,conf_name ORDER BY col{$column} {$direction} LIMIT {$from},{$number_of_items}";
	$res = api_sql_query($sql, __FILE__, __LINE__);
	$meetings = array ();
	while ($row = mysql_fetch_row($res))
	{
		$meetings[] = $row;
	}

	return $meetings;
}

/**
 * Filter for sortable table to display edit icons for class
 */
function modify_filter($meeting_id)
{
	global $_user;
		
	$meeting_id = Database::escape_string($meeting_id);
	
	if(api_is_allowed_to_edit() || api_is_platform_admin())
	{
		$html = "<a href='edit_meeting.php?id={$meeting_id}'>" . Display::return_icon('edit.gif',get_lang('Edit')) . "</a>\n";
		$html .= "<a href='index.php?action=delete_meeting&amp;id={$meeting_id}' onclick=\"javascript:if(!confirm('" . get_lang('ConfirmYourChoice') . "')) return false;\">" . Display::return_icon('delete.gif',get_lang('Delete')) . "</a>\n";
		//@Todo
		//$html .= "<a href='#'>" . Display::return_icon('add_multiple_users.gif',get_lang('AddUsersToAClass')) . "</a>&nbsp;&nbsp;";

		$meeting = MeetingManage::get_meeting($meeting_id);
		$url = "http://" . api_get_setting('online_meeting_server_host') . ":" . api_get_setting('online_meeting_server_port');
		$url .= "/dimdim/html/signin/signin.action?action=host&email={$meeting['email_user']}&confKey={$meeting['conf_key']}";
		$url .= "&displayName=" . urlencode($meeting['display_name']) . "&confName=" . urlencode($meeting['conf_name']) . "&lobby=" . ($meeting['lobby'] == 0 ? 'false' : 'true');
		$url .= "&networkProfile={$meeting['network_Profile']}&meetingHours={$meeting['meeting_hours']}&meetingMinutes={$meeting['meeting_minutes']}"; 
		$url .= "&maxParticipants={$meeting['max_participants']}&presenterAV={$meeting['presenter_av']}&maxAttendeeMikes={$meeting['max_mikes']}";
		$url .= "&returnUrl=" . api_get_path(WEB_PATH) . "&submitFormOnLoad=true";
		
		$html .= "<a href='{$url}' target='blank'>" . Display::return_icon('2rightarrow.gif',get_lang('EnterMeeting')) . "</a>\n";
	}
	else 
	{
		$meeting = MeetingManage::get_meeting($meeting_id);
		$url = "http://" . api_get_setting('online_meeting_server_host') . ":" . api_get_setting('online_meeting_server_port');
		$url .= "/dimdim/html/signin/signin.action?action=join&email={$_user['mail']}&confKey={$meeting['conf_key']}";
		$url .= "&displayName=" . urlencode($_user['firstName']) . "&submitFormOnLoad=true";
		
		$html .= "<a href='{$url}' target='blank'>" . Display::return_icon('2rightarrow.gif',get_lang('EnterMeeting')) . "</a>\n";		
	}
	
	return $html;
}


/*
==============================================================================
		FOOTER
==============================================================================
*/
Display :: display_footer();

?>