<?php
// $Id: meeting_manage.lib.php 10926 2007-01-26 14:34:47Z Zhong $
/*
==============================================================================
	IILearn - elearning and course management software

	Copyright (c) 2007 IILearn CN.

	For a full list of contributors, see "credits.txt".
	The full license can be read in "license.txt".

	This program is free software; you can redistribute it and/or
	modify it under the terms of the GNU General Public License
	as published by the Free Software Foundation; either version 2
	of the License, or (at your option) any later version.

	See the GNU General Public License for more details.

	Contact: Zhong 	poopsoft@163.com
==============================================================================
*/
/**
==============================================================================
*	@package iilearn.online_meeting
==============================================================================
*/

/**
 * This library contains some functions for class-management.
 * @author Zhong
 * @package iilearn.online_meeting
 */

class MeetingManage
{

	function get_key()
	{
		srand((double)microtime() * 1000000);
		$vowels = array("a", "e", "i", "o", "u");
		$cons = array("b", "c", "d", "g", "h", "j", "k", "l", "m", "n", "p", "r", "s", "t", "u", "v", "w", "tr",
		"cr", "br", "fr", "th", "dr", "ch", "ph", "wr", "st", "sp", "sw", "pr", "sl", "cl");
		$num_vowels = count($vowels);
		$num_cons = count($cons);

		for($i = 0; $i < 5; $i++)
		{
			$password .= $cons[rand(0, $num_cons - 1)] . $vowels[rand(0, $num_vowels - 1)];
		}
		
		return $password;
	}
/**
 * Create a online meeting
 * @param string $values
 */
	function add_meeting($values)
	{
		global $_course;
		
		$table_meeting = Database :: get_course_table(TABLE_ONLINE_MEETING);
		$sql = "INSERT INTO {$table_meeting}
							(conf_name,intro,start_time,schedule,conf_key,email_user,
							 display_name,start_now,timezone,time_str,lobby,network_profile,meeting_hours,
							 meeting_minutes,max_participants,presenter_av,max_mikes) 
							 VALUES(
							 '{$values['conf_name']}','{$values['intro']}','{$values['start_time']}',
							 '{$values['schedule']}','{$values['conf_key']}','{$values['email_user']}','{$values['display_name']}',
							 '{$values['start_now']}','{$values['timezone']}','{$values['time_str']}',{$values['lobby']},
							 {$values['network_profile']},{$values['meeting_hours']},{$values['meeting_minutes']},
							 {$values['max_participants']},'{$values['presenter_av']}',{$values['max_mikes']}
							 )";
		api_sql_query($sql, __FILE__, __LINE__);
		
		api_item_property_update($_course, TOOL_ONLINE_MEETING, mysql_insert_id(), "MeetingAdded", $_user['user_id']);
		
		return mysql_affected_rows() == 1;	
	}

/**
 * Edit a online meeting
 * @param string $values
 */
	function edit_meeting($values)
	{
		global $_course;
		
		$table_meeting = Database :: get_course_table(TABLE_ONLINE_MEETING);
		$sql = "UPDATE {$table_meeting}	SET 
						conf_name='{$values['conf_name']}',
						intro='{$values['intro']}',
						start_time='{$values['start_time']}',
						schedule='{$values['schedule']}',
						conf_key='{$values['conf_key']}',
						email_user='{$values['email_user']}',
						display_name='{$values['display_name']}',
						start_now='{$values['start_now']}',
						timezone='{$values['timezone']}',
						time_str='{$values['time_str']}',
						lobby={$values['lobby']},
						network_profile={$values['network_profile']},
						meeting_hours={$values['meeting_hours']},
						meeting_minutes={$values['meeting_minutes']},
						max_participants={$values['max_participants']},
						presenter_av='{$values['presenter_av']}',
						max_mikes={$values['max_mikes']}
						where id={$values['id']}";
		api_sql_query($sql, __FILE__, __LINE__);
		
		api_item_property_update($_course, TOOL_ONLINE_MEETING, $values['id'], "MeetingUpdated", $_user['user_id']);
		
		return mysql_affected_rows() == 1;	
		
	}
	
/**
 * Get a online meeting date
 * @param string $id
 */
	function get_meeting($id) 
	{
		$table_meeting = Database :: get_course_table(TABLE_ONLINE_MEETING);
		$sql = "SELECT * FROM {$table_meeting} where id={$id}";
		$res = api_sql_query($sql, __FILE__, __LINE__);
		$row = mysql_fetch_array($res, MYSQL_ASSOC);
	
		return $row;
	}

/**
 * Delete an online meeting date
 * @param string $id
 */
	function delete_meeting($id) 
	{
		global $_course;
		
		$table_meeting = Database :: get_course_table(TABLE_ONLINE_MEETING);
		$sql = "DELETE FROM {$table_meeting} where id={$id}";
		$res = api_sql_query($sql, __FILE__, __LINE__);
		
		api_item_property_update($_course, TOOL_ONLINE_MEETING, $id, "delete", $_user['user_id']);
		
		return mysql_affected_rows() == 1;	
	}
	
}

?>