<?php //$id: $
/**
 * Display part of the SCORM sub-process for upload. This script MUST BE included by upload/index.php
 * as it prepares most of the variables needed here.
 * @package iilearn.upload
 * @author Yannick Warnier <ywarnier@beeznest.org>
 */
/**
 * Small function to list files in garbage/
 */
function get_zip_files_in_garbage(){
	$list = array();
	$dh = opendir(api_get_path(SYS_PATH).'storage/ftp/scorm_aicc/');
	if($dh === false){
		//ignore
	}else{
		while($entry = readdir($dh)){
			if(substr($entry,0,1) == '.'){/*ignore files starting with . */}
			else
			{
				if(preg_match('/^.*\.zip$/i',$entry)){
					$list[] = $entry;
				}
			}
		}
		natcasesort($list);
		closedir($dh);
	}
	return $list;
}
/**
 * Just display the form needed to upload a SCORM and give its settings
 */
$nameTools = get_lang("UploadScorm");
$interbreadcrumb[]= array ("url"=>"../newscorm/lp_controller.php?action=list", "name"=> get_lang("lang_learning_path"));
Display::display_header($nameTools,"Path");

require_once (api_get_path(LIBRARY_PATH).'formvalidator/FormValidator.class.php');
include('../newscorm/content_makers.inc.php');

$form = new FormValidator('','POST','upload.php','','id="upload_form" enctype="multipart/form-data"');

$form->addElement('header', 'header', get_lang("Learnpath") . " - " . get_lang("FileUpload") . $add_group_to_title);

$form->addElement('hidden', 'curdirpath', $path);
$form->addElement('hidden', 'tool', $my_tool);

$form->addElement('file','user_file',get_lang('FileToUpload'),array('size' => '40'));
$form->addElement('text', 'title', get_lang('Title'),array('size' => '30'));

$select_content_marker = &$form->addElement('select','content_maker',get_lang('ContentMaker'));

foreach($content_origins as $index => $origin){
	$select_content_marker->addOption($origin,$origin);
	if($index == 1){
		$select_content_marker -> setSelected($origin);
	}
}

$select_content_proximity = &$form->addElement('select','content_proximity',get_lang('ContentProximity'));
$select_content_proximity->addOption(get_lang('Local'),"local");
$select_content_proximity->addOption(get_lang('Remote'),"remote");
$select_content_proximity -> setSelected("local");

$group = array ();
$group[] = $form->createElement('submit', 'submit', get_lang('Send'), 'class="inputSubmit"');
$form->addGroup($group, 'submit', '&nbsp;', null, false);

$form->add_real_progress_bar('uploadScorm','user_file');

$form->setDefaults($defaults);

Display::setTemplateBorder($form, '60%');

$form->display();

?>

<br/>
<?php
/*
==============================================================================
		FOOTER
==============================================================================
*/
Display::display_footer();
?>