<?php
// $Id: user_export.php 11999 2007-07-03 21:31:57Z pcool $
/*
==============================================================================
	IILearn - elearning and course management software

	Copyright (c) 2007 iilearn.org China

	For a full list of contributors, see "credits.txt".
	The full license can be read in "license.txt".

	This program is free software; you can redistribute it and/or
	modify it under the terms of the GNU General Public License
	as published by the Free Software Foundation; either version 2
	of the License, or (at your option) any later version.

	See the GNU General Public License for more details.

	Contact: www.iilearn.org, poopsoft@163.com
==============================================================================
*/
/**
==============================================================================
*	@package iilearn.user
==============================================================================
*/
// name of the language file that needs to be included
$language_file = 'admin';

include ('../inc/global.inc.php');

include (api_get_path(LIBRARY_PATH)."course.lib.php");
include (api_get_path(LIBRARY_PATH).'fileManage.lib.php');
include (api_get_path(LIBRARY_PATH).'export.lib.inc.php');
include (api_get_path(LIBRARY_PATH).'formvalidator/FormValidator.class.php');

$this_section = SECTION_COURSES;

 if( !isset ($_cid))
{
	header("location: ".$_configuration['root_web']);
}

$currentCourseID = $_course['sysCode'];

$tool_name = get_lang('ExportUserListXMLCSV');
$interbreadcrumb[] = array ("url" => "user.php", "name" => get_lang("Users"));

set_time_limit(0);

$form = new FormValidator('export_users');

$form->addElement('header', 'header', get_lang('ExportUserListXMLCSV'));

$group = array();
$group[] = $form->createElement('radio', 'file_type', null, 'Excel','xls');
$group[] = $form->createElement('radio', 'file_type', null, 'XML','xml');
$group[] = $form->createElement('radio', 'file_type', null, 'CSV','csv');
$form->addGroup($group,'file_type',get_lang('OutputFileType'),null,false);

$form->addElement('checkbox', 'addcsvheader', get_lang('AddCSVHeader'), get_lang('YesAddCSVHeader'),'1');

$encodings = get_encodings();
$form->addElement('select', 'export_encoding', get_lang('ExportEncoding'), $encodings);

$group = array ();
$group[] = $form->createElement('submit', 'submit', get_lang('Ok'), 'class="inputSubmit"');
$form->addGroup($group, 'submit', '&nbsp;', null, false);

$defaults['export_encoding'] = get_default_encoding();
$defaults['file_type'] = 'xls';
$form->setDefaults($defaults);

Display::setTemplateBorder($form, '60%');

if ($form->validate())
{
	$export = $form->exportValues();
	$file_type = $export['file_type'];
	$export_encoding = $export['export_encoding'];

	if(api_get_setting('use_session_mode')!="true"){
		$table_user = Database::get_main_table(TABLE_MAIN_USER);
		$table_course_user = Database::get_main_table(TABLE_MAIN_COURSE_USER);
		$course = api_get_course_info();
		$sql = "SELECT u.user_id as UserId,
					   u.official_code as OfficialCode,
					   u.firstname as FirstName,
					   u.email as Email 
				FROM $table_user u, $table_course_user cu WHERE cu.user_id = u.user_id AND cu.course_code = '" . $currentCourseID . "' ORDER BY lastname ASC";
	} else {
		$table_user = Database::get_main_table(TABLE_MAIN_USER);
		$table_course_user = Database::get_main_table(TABLE_MAIN_SESSION_COURSE_USER);
		$table_session = Database::get_main_table(TABLE_MAIN_SESSION);
		$sql = "SELECT `user`.`user_id` as UserId,
               		   `user`.`official_code` as OfficialCode,
		               `user`.`firstname` as FirstName,
               		   `user`.`email` as Email,
               		   `session`.`name` as Name
               FROM " . $table_user . " `user`, " . $table_course_user . " cu, " . $table_session . " session
               WHERE `user`.`user_id`= cu.`id_user`
               AND cu.`course_code`='".$currentCourseID."'
			   AND session.id=cu.id_session
			   AND session.id='".$_SESSION['id_session']."'";
	}
	
	$filename = 'export_users_' . $currentCourseID . '_' . date('Y-m-d_H-i-s');

	$data = array();
	if ($export['addcsvheader']=='1' && ($export['file_type']=='csv' || $export['file_type']=='xls' ))
	{
		if (api_get_setting('use_session_mode')!="true") {
			$data[] = array('UserId', 'OfficialCode', 'FirstName', 'Email');
		} else {
			$data[] = array('UserId', 'OfficialCode', 'FirstName', 'Email', 'Session');
		}
	}
	
	$res = api_sql_query($sql,__FILE__,__LINE__);

	while($user = mysql_fetch_array($res,MYSQL_ASSOC))
	{
		if (strtolower($export_encoding) != strtolower(SYSTEM_CHARSET)) {
			//$user['LastName'] = mb_convert_encoding($user['LastName'], $export_encoding, SYSTEM_CHARSET);
			$user['FirstName'] = mb_convert_encoding($user['FirstName'], $export_encoding, SYSTEM_CHARSET);
		}
		$data[] = $user	;
	}
	switch($file_type)
	{
		case 'xml':
			Export::export_table_xml($data,$filename,'Contact','Contacts');
			break;
		case 'csv':
			Export::export_table_csv($data,$filename);
			break;
		case 'xls':
			Export::export_table_xls($data,$filename);
			break;
	}
}

Display :: display_header($tool_name, 'User');

$form->display();

/*
==============================================================================
		FOOTER
==============================================================================
*/
Display :: display_footer();
?>