/*
 * Decompiled with CFR 0.152.
 */
package com.google.gdata.client;

import com.google.common.collect.ConcurrentHashMultiset;
import com.google.common.collect.Multiset;
import com.google.gdata.client.CookieManager;
import com.google.gdata.client.http.GoogleGDataRequest;
import java.util.Iterator;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimpleCookieManager
implements CookieManager {
    protected Multiset<GoogleGDataRequest.GoogleCookie> cookies = ConcurrentHashMultiset.create();
    protected boolean cookiesEnabled = true;

    @Override
    public void setCookiesEnabled(boolean cookiesEnabled) {
        this.cookiesEnabled = cookiesEnabled;
        if (!this.cookiesEnabled) {
            this.clearCookies();
        }
    }

    @Override
    public boolean cookiesEnabled() {
        return this.cookiesEnabled;
    }

    @Override
    public void clearCookies() {
        this.cookies.clear();
    }

    @Override
    public void addCookie(GoogleGDataRequest.GoogleCookie cookie) {
        assert (this.cookiesEnabled);
        this.cookies.remove(cookie);
        this.cookies.add(cookie);
    }

    @Override
    public Set<GoogleGDataRequest.GoogleCookie> getCookies() {
        Iterator<GoogleGDataRequest.GoogleCookie> cookieIter = this.cookies.iterator();
        while (cookieIter.hasNext()) {
            GoogleGDataRequest.GoogleCookie cookie = cookieIter.next();
            if (!cookie.hasExpired()) continue;
            cookieIter.remove();
        }
        return this.cookies.elementSet();
    }
}

