/*
 * Decompiled with CFR 0.152.
 */
package com.google.gdata.data;

import com.google.gdata.client.Service;
import com.google.gdata.data.TextConstruct;
import com.google.gdata.util.Namespaces;
import com.google.gdata.util.ParseException;
import com.google.gdata.util.XmlParser;
import com.google.gdata.util.common.xml.XmlWriter;
import java.io.IOException;
import java.util.ArrayList;

public class PlainTextConstruct
extends TextConstruct {
    protected String text;

    public PlainTextConstruct() {
    }

    public PlainTextConstruct(String text) {
        this.text = text;
    }

    public PlainTextConstruct(String text, String lang) {
        this.text = text;
        this.lang = lang;
    }

    public int getType() {
        return 1;
    }

    public boolean isEmpty() {
        return this.getText() == null;
    }

    public String getText() {
        return this.text;
    }

    public void setText(String v) {
        this.text = v;
    }

    public String getPlainText() {
        return this.text != null ? new String(this.text) : null;
    }

    public void generateAtom(XmlWriter w, String elementName) throws IOException {
        ArrayList<XmlWriter.Attribute> attrs = new ArrayList<XmlWriter.Attribute>();
        if (Service.getVersion().isCompatible(Service.Versions.V1)) {
            attrs.add(new XmlWriter.Attribute("type", "text"));
        }
        if (this.lang != null) {
            attrs.add(new XmlWriter.Attribute("xml:lang", this.lang));
        }
        w.simpleElement(Namespaces.atomNs, elementName, attrs, this.text);
    }

    public void generateRss(XmlWriter w, String elementName, TextConstruct.RssFormat rssFormat) throws IOException {
        w.simpleElement(Namespaces.rssNs, elementName, null, this.text);
    }

    public class AtomHandler
    extends XmlParser.ElementHandler {
        public void processAttribute(String namespace, String localName, String value) throws ParseException {
            if (!namespace.equals("") || !localName.equals("type")) {
                super.processAttribute(namespace, localName, value);
            }
        }

        public void processEndElement() throws ParseException {
            if (this.value == null) {
                this.value = "";
            }
            PlainTextConstruct.this.text = this.value;
            PlainTextConstruct.this.lang = this.xmlLang;
        }
    }
}

