/*
 * Decompiled with CFR 0.152.
 */
package com.google.gdata.data.geo.impl;

import com.google.gdata.data.ExtensionDescription;
import com.google.gdata.data.ExtensionPoint;
import com.google.gdata.data.ExtensionProfile;
import com.google.gdata.data.geo.GeoLat;
import com.google.gdata.data.geo.GeoLong;
import com.google.gdata.data.geo.Namespaces;
import com.google.gdata.data.geo.Point;
import com.google.gdata.util.ParseException;
import com.google.gdata.util.XmlParser;
import com.google.gdata.util.common.xml.XmlWriter;
import java.io.IOException;
import org.xml.sax.Attributes;

public class W3CPoint
extends ExtensionPoint
implements Point {
    static final String NAME = "Point";

    public W3CPoint() {
    }

    public W3CPoint(Double lat, Double lon) {
        this.setGeoLocation(lat, lon);
    }

    public W3CPoint(Point copyFrom) {
        this(copyFrom == null ? null : copyFrom.getLatitude(), copyFrom == null ? null : copyFrom.getLongitude());
    }

    public static ExtensionDescription getDefaultDescription(boolean repeatable) {
        ExtensionDescription desc = new ExtensionDescription();
        desc.setExtensionClass(W3CPoint.class);
        desc.setNamespace(Namespaces.W3C_GEO_NAMESPACE);
        desc.setLocalName(NAME);
        desc.setRepeatable(repeatable);
        return desc;
    }

    public static ExtensionDescription getDefaultDescription() {
        return W3CPoint.getDefaultDescription(true);
    }

    public void declareExtensions(ExtensionProfile extProfile) {
        extProfile.declare(W3CPoint.class, ExtensionDescription.getDefaultDescription(GeoLat.class));
        extProfile.declare(W3CPoint.class, ExtensionDescription.getDefaultDescription(GeoLong.class));
        super.declareExtensions(extProfile);
    }

    public Double getLatitude() {
        GeoLat lat = this.getExtension(GeoLat.class);
        return lat != null ? lat.getLatitude() : null;
    }

    public Double getLongitude() {
        GeoLong lon = this.getExtension(GeoLong.class);
        return lon != null ? lon.getLongitude() : null;
    }

    public void setGeoLocation(Double lat, Double lon) {
        if (lat != null && lon != null) {
            this.setExtension(new GeoLat(lat));
            this.setExtension(new GeoLong(lon));
        } else {
            if (lat != null || lon != null) {
                throw new IllegalArgumentException("'lat' and 'lon' must either both be null or non-null.");
            }
            this.removeExtension(GeoLat.class);
            this.removeExtension(GeoLong.class);
        }
    }

    public void generate(XmlWriter w, ExtensionProfile extProfile) throws IOException {
        this.generateStartElement(w, Namespaces.W3C_GEO_NAMESPACE, NAME, null, null);
        this.generateExtensions(w, extProfile);
        w.endElement(Namespaces.W3C_GEO_NAMESPACE, NAME);
    }

    public XmlParser.ElementHandler getHandler(ExtensionProfile extProfile, String namespace, String localName, Attributes attrs) {
        return new Handler(extProfile);
    }

    protected class Handler
    extends ExtensionPoint.ExtensionHandler {
        public Handler(ExtensionProfile extProfile) {
            super(extProfile, W3CPoint.class);
        }

        public void processEndElement() throws ParseException {
            super.processEndElement();
            GeoLat lat = W3CPoint.this.getExtension(GeoLat.class);
            GeoLong lon = W3CPoint.this.getExtension(GeoLong.class);
            if (lat != null || lon != null) {
                if (lat == null) {
                    throw new ParseException("All geo:Point elements must have a latitude coordinate.");
                }
                if (lon == null) {
                    throw new ParseException("All geo:Point elements must have a longitude coordinate.");
                }
            }
        }
    }
}

