/*
 * Decompiled with CFR 0.152.
 */
package jp.ikikko.bti;

import java.awt.Color;
import java.awt.Desktop;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Collection;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.border.LineBorder;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Element;
import javax.swing.text.html.HTMLDocument;
import jp.ikikko.bti.backlogapi.BacklogApiClient;
import jp.ikikko.bti.entity.Issue;
import jp.ikikko.bti.entity.Project;
import jp.ikikko.bti.gdata.GdataService;
import jp.ikikko.bti.util.HTMLDocumentUtil;

public class BacklogTemplateIssue
extends JFrame {
    private static final long serialVersionUID = 1L;
    private JTextField backlogId;
    private JPasswordField backlogPassword;
    private JTextField backlogProject;
    private JTextField backlogSpace;
    private JTextField googleId;
    private JPasswordField googlePassword;
    private JTextField googleUrl;
    private JButton jButton1;
    private JButton jButton2;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JLabel jLabel7;
    private JLabel jLabel8;
    private JLabel jLabel9;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JPanel jPanel4;
    private JScrollPane jScrollPane2;
    private JEditorPane logPane;

    public BacklogTemplateIssue() {
        this.initComponents();
    }

    private void initComponents() {
        this.jPanel1 = new JPanel();
        this.jLabel1 = new JLabel();
        this.jLabel2 = new JLabel();
        this.googleId = new JTextField();
        this.jLabel6 = new JLabel();
        this.googleUrl = new JTextField();
        this.jLabel7 = new JLabel();
        this.googlePassword = new JPasswordField();
        this.jPanel2 = new JPanel();
        this.jLabel3 = new JLabel();
        this.jLabel4 = new JLabel();
        this.jLabel5 = new JLabel();
        this.backlogSpace = new JTextField();
        this.backlogId = new JTextField();
        this.backlogPassword = new JPasswordField();
        this.jLabel8 = new JLabel();
        this.jLabel9 = new JLabel();
        this.backlogProject = new JTextField();
        this.jPanel3 = new JPanel();
        this.jButton1 = new JButton();
        this.jButton2 = new JButton();
        this.jPanel4 = new JPanel();
        this.jScrollPane2 = new JScrollPane();
        this.logPane = new JEditorPane();
        this.setDefaultCloseOperation(3);
        this.setTitle("Backlog Template Issue");
        this.jPanel1.setBorder(new LineBorder(new Color(0, 0, 0), 1, true));
        this.jLabel1.setText("ID");
        this.jLabel2.setText("\u30d1\u30b9\u30ef\u30fc\u30c9");
        this.jLabel6.setText("URL");
        this.googleUrl.setText("http://spreadsheets.google.com/ccc?key=0Ajq41fTDA49TdDVIUlRTeldUV2dVNFdBbTNONmtYZ3c&hl=ja");
        this.jLabel7.setFont(new Font("MS UI Gothic", 1, 14));
        this.jLabel7.setHorizontalAlignment(0);
        this.jLabel7.setIcon(new ImageIcon(this.getClass().getResource("/jp/ikikko/bti/google_document.gif")));
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel7, -1, 415, Short.MAX_VALUE).addGroup(jPanel1Layout.createSequentialGroup().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addComponent(this.jLabel1, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addComponent(this.jLabel2, GroupLayout.Alignment.LEADING)).addComponent(this.jLabel6)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.googleUrl, -1, 356, Short.MAX_VALUE).addGroup(jPanel1Layout.createSequentialGroup().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addComponent(this.googlePassword, GroupLayout.Alignment.LEADING, 0, 0, Short.MAX_VALUE).addComponent(this.googleId, GroupLayout.Alignment.LEADING, -1, 140, Short.MAX_VALUE)).addGap(200, 200, 200))))).addContainerGap()));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jPanel1Layout.createSequentialGroup().addContainerGap().addComponent(this.jLabel7).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 16, Short.MAX_VALUE).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel1).addComponent(this.googleId, -2, 19, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel2).addComponent(this.googlePassword, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel6).addComponent(this.googleUrl, -2, -1, -2)).addContainerGap()));
        this.jPanel2.setBorder(new LineBorder(new Color(0, 0, 0), 1, true));
        this.jLabel3.setText("\u30e6\u30fc\u30b6ID");
        this.jLabel4.setText("\u30d1\u30b9\u30ef\u30fc\u30c9");
        this.jLabel5.setText("\u30b9\u30da\u30fc\u30b9ID");
        this.jLabel8.setFont(new Font("MS UI Gothic", 1, 14));
        this.jLabel8.setHorizontalAlignment(0);
        this.jLabel8.setIcon(new ImageIcon(this.getClass().getResource("/jp/ikikko/bti/backlog.gif")));
        this.jLabel9.setText("\u30d7\u30ed\u30b8\u30a7\u30af\u30c8");
        GroupLayout jPanel2Layout = new GroupLayout(this.jPanel2);
        this.jPanel2.setLayout(jPanel2Layout);
        jPanel2Layout.setHorizontalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addContainerGap().addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addComponent(this.jLabel8, -1, 415, Short.MAX_VALUE).addContainerGap()).addGroup(jPanel2Layout.createSequentialGroup().addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addComponent(this.jLabel5).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.backlogSpace, -2, 138, -2)).addGroup(jPanel2Layout.createSequentialGroup().addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addComponent(this.jLabel3, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addComponent(this.jLabel4, GroupLayout.Alignment.LEADING)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.backlogPassword, -1, 140, Short.MAX_VALUE).addComponent(this.backlogId, -1, 140, Short.MAX_VALUE).addComponent(this.backlogProject, -1, 140, Short.MAX_VALUE)))).addGap(228, 228, 228)).addGroup(jPanel2Layout.createSequentialGroup().addComponent(this.jLabel9).addContainerGap()))));
        jPanel2Layout.setVerticalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addContainerGap().addComponent(this.jLabel8).addGap(18, 18, 18).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel5).addComponent(this.backlogSpace, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel3).addComponent(this.backlogId, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel4).addComponent(this.backlogPassword, -2, 19, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel9).addComponent(this.backlogProject, -2, -1, -2)).addContainerGap(-1, Short.MAX_VALUE)));
        this.jPanel3.setBorder(new LineBorder(new Color(0, 0, 0), 1, true));
        this.jButton1.setText("\u30c6\u30f3\u30d7\u30ec\u30fc\u30c8\u767b\u9332");
        this.jButton1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                BacklogTemplateIssue.this.jButton1ActionPerformed(evt);
            }
        });
        this.jButton2.setText("\u30af\u30ea\u30a2");
        this.jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                BacklogTemplateIssue.this.jButton2ActionPerformed(evt);
            }
        });
        GroupLayout jPanel3Layout = new GroupLayout(this.jPanel3);
        this.jPanel3.setLayout(jPanel3Layout);
        jPanel3Layout.setHorizontalGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel3Layout.createSequentialGroup().addContainerGap().addComponent(this.jButton1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButton2).addContainerGap(254, Short.MAX_VALUE)));
        jPanel3Layout.setVerticalGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jPanel3Layout.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jButton1).addComponent(this.jButton2)).addContainerGap()));
        this.jPanel4.setBorder(new LineBorder(new Color(0, 0, 0), 1, true));
        this.logPane.setBackground(Color.lightGray);
        this.logPane.setContentType("text/html");
        this.logPane.setEditable(false);
        this.logPane.setFont(new Font("Monospaced", 0, 13));
        this.logPane.addHyperlinkListener(new HyperlinkListener(){

            @Override
            public void hyperlinkUpdate(HyperlinkEvent evt) {
                BacklogTemplateIssue.this.logPaneHyperlinkUpdate(evt);
            }
        });
        this.jScrollPane2.setViewportView(this.logPane);
        GroupLayout jPanel4Layout = new GroupLayout(this.jPanel4);
        this.jPanel4.setLayout(jPanel4Layout);
        jPanel4Layout.setHorizontalGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane2, -1, 439, Short.MAX_VALUE));
        jPanel4Layout.setVerticalGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane2, -1, 172, Short.MAX_VALUE));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanel4, -1, -1, Short.MAX_VALUE).addComponent(this.jPanel2, -1, -1, Short.MAX_VALUE).addComponent(this.jPanel1, -1, -1, Short.MAX_VALUE).addComponent(this.jPanel3, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jPanel1, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanel2, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanel3, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanel4, -2, -1, -2).addContainerGap(-1, Short.MAX_VALUE)));
        this.pack();
    }

    private void jButton1ActionPerformed(ActionEvent evt) {
        HTMLDocument document = (HTMLDocument)this.logPane.getDocument();
        Element body = HTMLDocumentUtil.getBodyElement(document);
        try {
            GdataService service = new GdataService();
            service.login(this.googleId.getText(), new String(this.googlePassword.getPassword()));
            Collection<Issue> issues = service.getTemplateIssues(new URL(this.googleUrl.getText()));
            BacklogApiClient client = new BacklogApiClient();
            client.login(this.backlogSpace.getText(), this.backlogId.getText(), new String(this.backlogPassword.getPassword()));
            Project project = client.getProject(this.backlogProject.getText());
            for (Issue newIssue : issues) {
                Issue issue = client.createIssue(project.getId(), newIssue);
                document.insertBeforeStart(body, "ISSUE : <a href='" + issue.getUrl() + "'>" + "[" + issue.getKey() + "] " + issue.getSummary() + "</a><br>");
            }
        }
        catch (BadLocationException e) {
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        catch (Exception e) {
            try {
                document.insertBeforeStart(body, e + "<br>");
            }
            catch (BadLocationException e1) {
                throw new RuntimeException(e1);
            }
            catch (IOException e1) {
                throw new RuntimeException(e1);
            }
        }
    }

    private void jButton2ActionPerformed(ActionEvent evt) {
        this.googleId.setText("");
        this.googlePassword.setText("");
        this.googleUrl.setText("");
        this.backlogSpace.setText("");
        this.backlogId.setText("");
        this.backlogPassword.setText("");
    }

    private void logPaneHyperlinkUpdate(HyperlinkEvent evt) {
        if (evt.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
            try {
                Desktop.getDesktop().browse(evt.getURL().toURI());
            }
            catch (URISyntaxException e) {
                throw new RuntimeException(e);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public static void main(String[] args) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                new BacklogTemplateIssue().setVisible(true);
            }
        });
    }
}

