/*
 * Decompiled with CFR 0.152.
 */
package jp.ikikko.bti.backlogapi;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.Map;
import jp.ikikko.bti.backlogapi.Method;
import jp.ikikko.bti.backlogapi.util.ConvertUtil;
import jp.ikikko.bti.entity.Issue;
import jp.ikikko.bti.entity.Project;
import jp.ikikko.bti.entity.User;
import org.apache.xmlrpc.XmlRpcException;
import org.apache.xmlrpc.client.XmlRpcClient;
import org.apache.xmlrpc.client.XmlRpcClientConfigImpl;

public class BacklogApiClient {
    private XmlRpcClient client = new XmlRpcClient();

    public void login(String space, String userName, String password) {
        String url = "https://" + space + ".backlog.jp/XML-RPC";
        try {
            XmlRpcClientConfigImpl config = new XmlRpcClientConfigImpl();
            config.setServerURL(new URL(url));
            config.setBasicUserName(userName);
            config.setBasicPassword(password);
            this.client.setConfig(config);
            this.getUser(userName);
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
        catch (XmlRpcException e) {
            throw new IllegalArgumentException("Login Failed.");
        }
    }

    public User getUser(String userId) throws XmlRpcException {
        Object[] params = new Object[]{userId};
        Object result = this.client.execute(Method.GET_USER.getName(), params);
        User user = ConvertUtil.responseToUser(result);
        return user;
    }

    public Project getProject(String key) throws XmlRpcException {
        Object[] params = new Object[]{key};
        Object result = this.client.execute(Method.GET_PROJECT.getName(), params);
        Project project = ConvertUtil.responseToProject(result);
        return project;
    }

    public Issue createIssue(int projectId, Issue newIssue) throws XmlRpcException {
        Map<String, Object> request = ConvertUtil.issueToRequest(newIssue);
        request.put("projectId", projectId);
        Object[] params = new Object[]{request};
        Object result = this.client.execute(Method.CREATE_ISSUE.getName(), params);
        Issue issue = ConvertUtil.responseToIssue(result);
        return issue;
    }
}

