/*
 * Decompiled with CFR 0.152.
 */
package com.google.gdata.model;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.gdata.model.AttributeKey;
import com.google.gdata.model.AttributeMetadata;
import com.google.gdata.model.Element;
import com.google.gdata.model.ElementKey;
import com.google.gdata.model.ElementMetadata;
import com.google.gdata.model.Metadata;
import com.google.gdata.model.MetadataKey;
import com.google.gdata.model.Path;
import com.google.gdata.util.ParseException;
import com.google.gdata.util.common.base.Preconditions;
import com.google.gdata.wireformats.ContentCreationException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class PathAdapter {
    static ElementAdapter elementAdapter(Path path) {
        return new ElementAdapter(path);
    }

    static ValueAdapter valueAdapter(Path path) {
        return new ValueAdapter(path);
    }

    static Element getParentElement(Path path, Element rootElement) {
        Preconditions.checkNotNull(path, "path");
        Preconditions.checkNotNull(rootElement, "rootElement");
        List<MetadataKey<?>> steps = path.getSteps();
        if (steps.isEmpty()) {
            return null;
        }
        Element parent = rootElement;
        for (int i = 0; i < steps.size() - 1; ++i) {
            ElementKey childKey = (ElementKey)steps.get(i);
            if ((parent = parent.getElement(childKey)) != null) continue;
            return null;
        }
        return parent;
    }

    static Element getFinalElement(Path path, Element rootElement) {
        Element parent = PathAdapter.getParentElement(path, rootElement);
        if (path.selectsAttribute() || parent == null) {
            return parent;
        }
        return parent.getElement(path.getSelectedElementKey());
    }

    static Collection<? extends Element> getFinalElements(Path path, Element rootElement) {
        List<Element> parents = ImmutableList.of(rootElement);
        for (MetadataKey<?> part : path.getSteps()) {
            if (part instanceof AttributeKey) break;
            ElementKey childKey = (ElementKey)part;
            if (parents.size() > 1) {
                ArrayList next = Lists.newArrayListWithCapacity(parents.size());
                for (Element e : parents) {
                    next.add(e.getElement(childKey));
                }
                parents = next;
            } else {
                Element parent = (Element)parents.get(0);
                parents = ((Element)parents.get(0)).getElements(childKey);
            }
            if (!parents.isEmpty()) continue;
            return parents;
        }
        return parents;
    }

    static Element createParentElement(Path path, Element rootElement) throws ParseException {
        Preconditions.checkNotNull(path, "path");
        Preconditions.checkNotNull(rootElement, "rootElement");
        List<MetadataKey<?>> steps = path.getSteps();
        if (steps.isEmpty()) {
            return null;
        }
        Element parent = rootElement;
        for (int i = 0; i < steps.size() - 1; ++i) {
            ElementKey childKey = (ElementKey)steps.get(i);
            parent = PathAdapter.getOrCreateChild(parent, childKey);
        }
        return parent;
    }

    static Collection<Element> createParentElements(Path path, Element rootElement, ElementMetadata<?, ?> rootMetadata, int elementCount) throws ParseException {
        Preconditions.checkNotNull(path, "path");
        Preconditions.checkNotNull(rootElement, "rootElement");
        List<MetadataKey<?>> steps = path.getSteps();
        if (steps.isEmpty()) {
            return ImmutableList.of();
        }
        Element parent = rootElement;
        ArrayList<Element> parents = null;
        ElementMetadata<Object, Object> parentMetadata = rootMetadata;
        for (int i = 0; i < steps.size() - 1; ++i) {
            ArrayList<Element> children;
            ElementMetadata childMetadata;
            ElementKey childKey = (ElementKey)steps.get(i);
            ElementMetadata elementMetadata = childMetadata = parentMetadata == null ? null : parentMetadata.bindElement(childKey);
            if (parents != null) {
                PathAdapter.checkNotMultiple(childMetadata);
                children = Lists.newArrayListWithCapacity(parents.size());
                for (Element p : parents) {
                    children.add(PathAdapter.getOrCreateChild(p, childKey));
                }
                parents = children;
                parentMetadata = childMetadata;
                continue;
            }
            if (childMetadata == null || childMetadata.getCardinality() == ElementMetadata.Cardinality.SINGLE) {
                Element child;
                parent = child = PathAdapter.getOrCreateChild(parent, childKey);
                parentMetadata = childMetadata;
                continue;
            }
            children = Lists.newArrayListWithCapacity(elementCount);
            for (int j = 0; j < elementCount; ++j) {
                try {
                    Object child = Element.createElement(childKey);
                    parent.addElement((Element)child);
                    children.add((Element)child);
                    continue;
                }
                catch (ContentCreationException e) {
                    throw new ParseException(e);
                }
            }
            parents = children;
            parentMetadata = childMetadata;
        }
        if (parents != null) {
            return parents;
        }
        return ImmutableList.of(parent);
    }

    static Element createFinalElement(Path path, Element rootElement) throws ParseException {
        Element parent = PathAdapter.createParentElement(path, rootElement);
        if (path.selectsAttribute() || parent == null) {
            return parent;
        }
        ElementKey<?, ?> childKey = path.getSelectedElementKey();
        Object child = parent.getElement(childKey);
        if (child == null) {
            try {
                child = Element.createElement(childKey);
                parent.addElement((Element)child);
            }
            catch (ContentCreationException e) {
                throw new ParseException(e);
            }
        }
        return child;
    }

    private static Element getOrCreateChild(Element parent, ElementKey<?, ?> childKey) throws ParseException {
        Object child = parent.getElement(childKey);
        if (child != null) {
            return child;
        }
        try {
            child = Element.createElement(childKey);
            parent.addElement((Element)child);
            return child;
        }
        catch (ContentCreationException e) {
            throw new ParseException(e);
        }
    }

    private static void checkNotMultiple(ElementMetadata<?, ?> meta) {
        if (meta != null && meta.getCardinality() != ElementMetadata.Cardinality.SINGLE) {
            throw new IllegalStateException("Metadata for key " + meta.getKey() + " represents a multiple-cardinality element." + " The path cannot contain more than one multiple-cardinality" + " element.");
        }
    }

    static Object generateAttributeValue(Element element, ElementMetadata<?, ?> metadata, AttributeKey<?> attKey, AttributeMetadata<?> attMeta) {
        if (metadata != null && attMeta != null) {
            return attMeta.generateValue(element, metadata);
        }
        return element.getAttributeValue(attKey);
    }

    static void parseAttributeValue(Element element, ElementMetadata<?, ?> metadata, AttributeKey<?> attKey, AttributeMetadata<?> attMeta, Object value) throws ParseException {
        if (attMeta == null) {
            element.setAttributeValue(attKey, value);
        } else {
            attMeta.parseValue(element, metadata, value);
        }
    }

    static Object generateTextValue(Element element, ElementMetadata<?, ?> metadata) {
        if (metadata != null) {
            return metadata.generateValue(element, metadata);
        }
        return element.getTextValue();
    }

    static void parseTextValue(Element element, ElementMetadata<?, ?> metadata, Object value) throws ParseException {
        if (metadata != null) {
            metadata.parseValue(element, metadata, value);
        } else {
            element.setTextValue(value);
        }
    }

    private PathAdapter() {
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class ValueAdapter
    implements Metadata.VirtualValue {
        private final Path path;

        ValueAdapter(Path path) {
            this.path = path;
        }

        @Override
        public Object generate(Element element, ElementMetadata<?, ?> metadata) {
            Path bound = this.path.toAbsolute(metadata);
            element = PathAdapter.getFinalElement(bound, element);
            if (element == null) {
                return null;
            }
            if (bound.selectsAttribute()) {
                return PathAdapter.generateAttributeValue(element, bound.getSelectedElement(), bound.getSelectedAttributeKey(), bound.getSelectedAttribute());
            }
            return PathAdapter.generateTextValue(element, bound.getSelectedElement());
        }

        @Override
        public void parse(Element element, ElementMetadata<?, ?> metadata, Object value) throws ParseException {
            Path bound = this.path.toAbsolute(metadata);
            element = PathAdapter.createFinalElement(this.path, element);
            if (bound.selectsAttribute()) {
                PathAdapter.parseAttributeValue(element, bound.getSelectedElement(), bound.getSelectedAttributeKey(), bound.getSelectedAttribute(), value);
            } else {
                PathAdapter.parseTextValue(element, bound.getSelectedElement(), value);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class ElementAdapter
    implements ElementMetadata.SingleVirtualElement,
    ElementMetadata.MultipleVirtualElement {
        private final Path path;

        ElementAdapter(Path path) {
            this.path = path;
        }

        @Override
        public Element generateSingle(Element parent, ElementMetadata<?, ?> parentMetadata, ElementMetadata<?, ?> metadata) {
            Preconditions.checkState(this.path.selectsElement(), "An attribute path cannot be used to generate elements.");
            Element element = PathAdapter.getFinalElement(this.path, parent);
            if (element == null) {
                return null;
            }
            try {
                ElementKey<?, ?> realKey = ElementAdapter.mergeKeys(element.getElementKey(), metadata.getKey());
                return Element.createElement(realKey, element);
            }
            catch (ContentCreationException e) {
                throw new IllegalArgumentException("Invalid metadata", e);
            }
        }

        @Override
        public void parse(Element parent, ElementMetadata<?, ?> parentMetadata, Element element, ElementMetadata<?, ?> metadata) throws ParseException {
            Preconditions.checkState(this.path.selectsElement(), "An attribute path cannot be used to parse elements.");
            parent = PathAdapter.createParentElement(this.path, parent);
            ElementKey<?, ?> lastKey = this.path.getSelectedElementKey();
            try {
                Object child = Element.createElement(lastKey, element);
                parent.addElement((Element)child);
            }
            catch (ContentCreationException e) {
                throw new ParseException(e);
            }
        }

        @Override
        public Collection<? extends Element> generateMultiple(Element parent, ElementMetadata<?, ?> parentMetadata, ElementMetadata<?, ?> metadata) {
            Preconditions.checkState(this.path.selectsElement(), "An attribute path cannot be used to generate elements.");
            Collection<? extends Element> elements = PathAdapter.getFinalElements(this.path, parent);
            if (elements.isEmpty()) {
                return elements;
            }
            ArrayList<?> result = Lists.newArrayListWithCapacity(elements.size());
            for (Element element : elements) {
                try {
                    ElementKey<?, ?> realKey = ElementAdapter.mergeKeys(element.getElementKey(), metadata.getKey());
                    result.add(Element.createElement(realKey, element));
                }
                catch (ContentCreationException ex) {
                    throw new IllegalArgumentException("Invalid metadata", ex);
                }
            }
            return result;
        }

        @Override
        public void parse(Element parent, ElementMetadata<?, ?> parentMetadata, Collection<Element> elements, ElementMetadata<?, ?> metadata) throws ParseException {
            Preconditions.checkState(this.path.selectsElement(), "An attribute path cannot be used to parse elements.");
            Path bound = this.path.toAbsolute(parentMetadata);
            Collection<Element> parents = PathAdapter.createParentElements(bound, parent, parentMetadata, elements.size());
            ElementKey<?, ?> childKey = bound.getSelectedElementKey();
            ElementMetadata<?, ?> childMetadata = bound.getSelectedElement();
            Iterator<Element> pIter = parents.iterator();
            Iterator<Element> eIter = elements.iterator();
            if (parents.size() > 1) {
                PathAdapter.checkNotMultiple(childMetadata);
                while (pIter.hasNext() && eIter.hasNext()) {
                    Element p = pIter.next();
                    p.addElement(eIter.next());
                }
                return;
            }
            if (elements.size() > 1 && childMetadata != null && childMetadata.getCardinality() == ElementMetadata.Cardinality.SINGLE) {
                throw new IllegalStateException("Metadata for key " + childKey + " represents a single-cardinality element." + " The path must contain at least one multiple-cardinality" + " element in order to parse multiple elements.");
            }
            parent = pIter.next();
            while (eIter.hasNext()) {
                parent.addElement(eIter.next());
            }
        }

        private static ElementKey<?, ?> mergeKeys(ElementKey<?, ?> sourceKey, ElementKey<?, ?> metadataKey) {
            if (!metadataKey.getId().equals(sourceKey.getId())) {
                return ElementKey.of(metadataKey.getId(), sourceKey.getDatatype(), sourceKey.getElementType());
            }
            return sourceKey;
        }
    }
}

