/*  esecannaserver --- pseudo canna server that wraps another IME.
 *  Copyright (C) 1999-2000 Yasuhiro Take
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <time.h>
#include <pwd.h>
#include <sys/types.h>
#include <signal.h>
#include <dlfcn.h>

#include "def.h"

#include "misc.h"
#include "winimm.h"

#define IW_ERROR16(_buf) { \
  cannaheader_t *he; \
  he = (cannaheader_t *)(_buf); \
  he->datalen = LSBMSB16(2); \
  he->err.e16 = LSBMSB16(-1); \
}

#define IW_ERROR8(_buf) { \
  cannaheader_t *he; \
  he = (cannaheader_t *)(_buf); \
  he->datalen = LSBMSB16(1); \
  he->err.e8 = -1; \
}

typedef int (*imefunc_t)();

static char *funcsymbols[] = {
  "_finalize",
  "_create_context",
  "_duplicate_context",
  "_close_context",
  "_define_word",
  "_delete_word",
  "_begin_convert",
  "_end_convert",
  "_get_candidacy_list",
  "_get_yomi",
  "_subst_yomi",
  "_store_yomi",
  "_store_range",
  "_get_lastyomi",
  "_flush_yomi",
  "_remove_yomi",
  "_get_simplekanji",
  "_resize_pause",
  "_get_hinshi",
  "_get_lex",
  "_get_status",
  "_set_locale",
  "_auto_convert",
  "_initialize",
  "_init_rootclient",
  "_end_client",
  "_end_rootclient",
  "_clear_client_data"
};

/* ʥߥå󥯤ؿֹȤбդ */
/*
  _finalize 0
  _create_context 1
  _duplicate_context 2
  _close_context 3
  _define_word 4
  _delete_word 5
  _begin_convert 6
  _end_convert 7
  _get_candidacy_list 8
  _get_yomi 9
  _subst_yomi 10
  _store_yomi 11
  _store_range 12
  _get_lastyomi 13
  _flush_yomi 14
  _remove_yomi 15
  _get_simplekanji 16
  _resize_pause 17
  _get_hinshi 18
  _get_lex 19
  _get_status 20
  _set_locale 21
  _auto_convert 22
  _initialize 23
  _init_rootclient 24
  _end_client 25
  _end_rootclient 26
  _clear_client_data 27
  */

#define F_initialize 23
#define F_init_rootclient 24
#define F_end_client 25
#define F_end_rootclient 26
#define F_clear_client_data 27

#define F_COMMON_END 27

static imefunc_t imm32func[28] = 
{
	imm32wrapper_finalize,
	imm32wrapper_create_context,
	imm32wrapper_duplicate_context,
	imm32wrapper_close_context,
	imm32wrapper_define_word,
	imm32wrapper_delete_word,
	imm32wrapper_begin_convert,
	imm32wrapper_end_convert,
	imm32wrapper_get_candidacy_list,
	imm32wrapper_get_yomi,
	imm32wrapper_subst_yomi,
	imm32wrapper_store_yomi,
	imm32wrapper_store_range,
	imm32wrapper_get_lastyomi,
	imm32wrapper_flush_yomi,
	imm32wrapper_remove_yomi,
	imm32wrapper_get_simplekanji,
	imm32wrapper_resize_pause,
	imm32wrapper_get_hinshi,
	imm32wrapper_get_lex,
	imm32wrapper_get_status,
	imm32wrapper_set_locale,
	imm32wrapper_auto_convert,
	imm32wrapper_initialize,
	imm32wrapper_init_rootclient,
	imm32wrapper_end_client,
	imm32wrapper_end_rootclient,
	imm32wrapper_clear_client_data
};

static imefunc_t *imefunc[IME_END] = {imm32func};
static char ime_connected_flag[IME_END];
static void *ime_dl_handler[IME_END];

extern char *protocol_name[], *e_protocol_name[];
extern client_t client[];

extern HWND hWnd_IMM;		/* ʴưѤΥɥ */

/*
 * ե졼եɤߡɤ IME ³뤫֤
 */

static char *iw_get_conf_file_path(char *home)
{
  char *path = NULL;

  if (strlen(home) != 0)
  {
    if ((path = m_makepath(home, ".canna2imm32rc")) == NULL)
    {
      m_msg("out of memory!\n");
      return NULL;
    }

    if (access(path, R_OK) == 0)
    {
      m_msg("Config file %s\n", path);
      return path;
    }
  }

  /* home  .canna2imm32rc ̵Ȥ /etc/canna2imm32rc õ */
  MYFREE(path);
  if ((path = strdup(ESECANNA_RC_PATH)) == NULL)
  {
    m_msg("out of memory!\n");
    return NULL;
  }

  if (access(path, R_OK))
  {
    m_msg("No %s found.\n", path);
    return NULL;
  }

  m_msg("Config file %s\n", path);
  return path;
}

static int iw_read_conf_file(char *path)
{
  FILE *fp;
  char buf[1024];
  char *ope, *val;
  int ret = IME_NON;

  if ((fp = fopen(path, "r")) == NULL) {
    m_msg("Cannot open Conffile %s.\n", path);
    return IME_NON;
  }
  
  while (fgets(buf, 1024, fp)) {
    if (buf[0] != '#' && m_conf1_parse(buf, &ope, &val) == 0) {
      if (m_conf_isequal(ope, "IME", val, "IMM32") == 2)
        ret = IME_IMM32;
      if (ret == IME_NON && m_conf_isequal(ope, "IME", val, "dummy"))
        m_msg("Unsupported IME: [%s]\n", val);
      
      if (ret != IME_NON)
        break;
    }
  }

  fclose(fp);

  return ret;
}

/*
 * ʥߥå⥸塼ɤ
 */
static int iw_retrieve_imm32_symbols(void *handler)
{
	return imm32wrapper_dl_started(client);
}

static int iw_load_library(int ime)
{
	iw_retrieve_imm32_symbols(ime_dl_handler[ime - 1]);
	m_msg("Use internal Module.\n");
	return 0;
}

/*
 * ʥߥå⥸塼򥢥ɤ
 */

static int iw_unload_library(int ime)
{
  return 0;
}

/*
 *  饤Ȥνλ򤹤 
 */

int imewrapper_end_client(int id)
{
  int ime = client[id].ime;
  
  if (ime > 0 && ime_dl_handler[ime - 1]) {
    SendMessage(hWnd_IMM, WM_USER + F_end_client, id, 0);
  }
  
  return 0;
}

/*
 *  IME νλ򤹤롣
 */
 
int imewrapper_end_rootclient(int ime)
{
  imefunc_t *func;
  
  if (ime > 0 && ime_dl_handler[ime - 1] != NULL) {
    /* ʥߥå⥸塼뤬ɤƤΤʤ齪λ򤹤 */
    SendMessage(hWnd_IMM, WM_USER + F_end_rootclient, 0, 0);
    
    /* ⥸塼 */
    iw_unload_library(ime);

    /* ³ե饰򥯥ꥢ */
    ime_connected_flag[ime - 1] = FALSE;
  }
  
  return 0;
}

/*
 * client[] Υǡ򥯥ꥢؿƤ
 */

int imewrapper_clear_client_data(int id)
{
  int ime = client[id].ime;
  
  if (ime > 0 && ime_dl_handler[ime - 1]) {
    SendMessage(hWnd_IMM, WM_USER + F_clear_client_data, id, 0);
  }
  
  MYFREE(client[id].host);
  MYFREE(client[id].homedir);
  
  client[id].ime = IME_NON;

  memset(&(client[id]), 0, sizeof(client_t));
  
  client[id].sockfd = -1;

  return 0;
}
      


/*
 * IME ۾ｪλȤνطδؿs
 */

static int iw_imm32_aborted(int ime)
{
  return -ime;
}

int imewrapper_ime_aborted(int ime)
{
  switch (ime) {
    case IME_IMM32:
      return iw_imm32_aborted(ime);
  }

  return -1;
}

/*
 * ʤλ뤿δؿ
 */

static int iw_send_term_signal()
{
  raise(SIGTERM);

  return 0;
}

/*
 * Windows IMM ˤޤ³Ƥʤ˸ƤФ
 */

static int iw_imm32_connect(int ime)
{
	/* ⥸塼 */
	if (iw_load_library(ime) == 0)
	{
		/*  */
		if (SendMessage(hWnd_IMM, WM_USER + F_init_rootclient, 0, 0) == 0)
		{
			/* Wnn ³ & */
			client[IMM32_ROOT_CLIENT].ime = ime;
			ime_connected_flag[ime - 1] = TRUE;

			return 0;
		} else {
			SendMessage(hWnd_IMM, WM_USER + F_end_rootclient, 0, 0);
		}

		iw_unload_library(ime);
	}

	return -1;
}
    
/*
 * IME ˤޤ³Ƥʤ˸ƤФ
 */

static int iw_ime_connect(int ime)
{
	switch (ime)
	{
		case IME_IMM32:
			return iw_imm32_connect(ime);
		default:
			break;
	}

	return -1;
}

/*
 * ʥץȥ wrap ؿs
 */

/*
  ʴѴФȥ饤ȤȤ³ΩʴѴĶۤ롥
*/
int imewrapper_initialize(int id, buffer_t *cbuf)
{
	int ime = IME_NON, errflag, *ip = (int *)cbuf->buf;
	short *sp = (short *)cbuf->buf;
	short cx_num;
	char *p, *major_p, *minor_p, *user = NULL, *home;
	short major, minor;
	struct passwd *pwd;
	char *conffile = NULL;

	errflag = 0;

	major_p = &(cbuf->buf[0]); /* Initialize ˸¤, cbuf->buf ˥إå
	                              ʤ */
	home = NULL;
	major = minor = -1;

	if ((p = strchr(major_p, '.')) == NULL)
		errflag = 1;
	else
	{
		*p = 0;

		minor_p = p + 1;

		if ((p = strchr(minor_p, ':')) == NULL)
			errflag = 2;
		else
		{
			*p = 0;
			user = p + 1;

			if (user[0] == 0)
				errflag = 3;
			else
			{
				if ((pwd = getpwnam(user)) == NULL)
					errflag = 4;
				else
				{
					if ((home = pwd->pw_dir) == NULL)
						errflag = 5;
				}
			}
			/* 桼̵Ƥ /etc/canna2imm32rc  OK ˤ */
			if (errflag  != 0)
			{
				MYFREE(home);
				home = (char*)malloc(1);
				home[0] = '\0';
			}
			if ((conffile = iw_get_conf_file_path(home)) == NULL)
				errflag = 6;
			else
				errflag = 0;

			major = atoi(major_p);
			minor = atoi(minor_p);
		}
	}

	/* FIXME: major, minor ǾˤäƤϥ顼֤褦 */

	if (errflag)
		m_msg("Header invalid. Maybe server version mismatch? (%d)\n", errflag);

	if (errflag == 0)
	{
		if ((ime = client[id].ime = iw_read_conf_file(conffile)) != 0)
		{
			if (ime_connected_flag[ime - 1] == FALSE)
			{
				/* ³׵ᤵ줿 IME ˤޤ³Ƥʤ */
				iw_ime_connect(ime);
			}
		} else
		{
			m_msg("IME not determined.\n");
		}
	}

	if (errflag == 0 && ime > 0 && ime_connected_flag[ime - 1] == TRUE)
	{
		/* client[]  user ̾, ۡǥ쥯ȥΥѥݴ */
		strncpy(client[id].user, user, 10);
		client[id].user[9] = 0;
		client[id].homedir = strdup(home);

		cx_num = SendMessage(hWnd_IMM, WM_USER + F_initialize, id, (LPARAM)conffile);
	} else
	{
		cx_num = -1;
	}

	if (cx_num == -1)
	{
		m_msg("Initialize failed. #%d %s@%s refused.\n", id, user ? user : "", client[id].host);

		/* ꥽եɤ߹ʳǤμԡޤϥƥȤγ
		   ԡ饤ȤȤ³ڤäƤޤ */
		client[id].need_terminate = TRUE; /* main.c ǽλ򤷤Ƥ餦 */
		*ip = LSBMSB32(-1);
	} else
	{	/* Success */
		sp[0] = LSBMSB16(3);
		sp[1] = LSBMSB16(cx_num);
	}

	if (conffile)
		free(conffile);

	return 1;
}

#define CALLFUNC(_num) return SendMessage(hWnd_IMM, WM_USER+_num, (WPARAM)id, (LPARAM)cbuf);

/*
  ʴѴλ롥еڤӥ饤Ȥ˳ݤƤ٤Ƥλ񸻤롥
  ޤؽƤǼȿǤƤʤΤмȿǤ롥
*/
int imewrapper_finalize(int id, buffer_t *cbuf)
{
	CALLFUNC(0);
}

/*
  ѴƥȤѴƥȤɽƥֹ֤
*/
int imewrapper_create_context(int id, buffer_t *cbuf)
{
	CALLFUNC(1);
}

/*
  ꤵ줿ѴƥȤʣѴƥȤɽƥ
  ֹ֤
*/
int imewrapper_duplicate_context(int id, buffer_t *cbuf)
{
	CALLFUNC(2);
}

/*
  ƥȤѤƤ񸻤롥θ女ƥȤ̤Ȥʤ롥
*/
int imewrapper_close_context(int id, buffer_t *cbuf)
{
	CALLFUNC(3);
}

/*
  ơ֥ϿƤ뼭롥
*/
int imewrapper_get_dictionary_list(int id, buffer_t *cbuf)
{
	cannaheader_t *header = (cannaheader_t *)cbuf->buf;

	header->datalen = LSBMSB16(2);
	header->err.e16 = 0;

	return 1;
}

/*
  ǥ쥯ȥˤ뼭ΰ롥
*/
int imewrapper_get_directory_list(int id, buffer_t *cbuf)
{
	cannaheader_t *header = (cannaheader_t *)cbuf->buf;

	header->datalen = LSBMSB16(2);
	header->err.e16 = 0;

	return 1;
}

/*
  ꤵ줿򤫤ʴѴѤ褦ˤ롣
*/
int imewrapper_mount_dictionary(int id, buffer_t *cbuf)
{
	cannaheader_t *header = (cannaheader_t *)cbuf->buf;

	header->datalen = LSBMSB16(1);
	header->err.e8 = 0;

	return 1;
}

/*
  ꤵ줿񤬤ʴѴѤʤ褦ˤ롣
*/
int imewrapper_unmount_dictionary(int id, buffer_t *cbuf)
{
	cannaheader_t *header = (cannaheader_t *)cbuf->buf;

	header->datalen = LSBMSB16(1);
	header->err.e8 = 0;

	return 1;
}

/*
  ѼμꥹȤν֤ѹ롥
*/
int imewrapper_remount_dictionary(int id, buffer_t *cbuf)
{
	cannaheader_t *header = (cannaheader_t *)cbuf->buf;

	header->datalen = LSBMSB16(1);
	header->err.e8 = 0;

	return 1;
}

/*
  ơ֥ϿƤ뼭ꥹ
*/
int imewrapper_get_mountdictionary_list(int id, buffer_t *cbuf)
{
	cannaheader_t *header = (cannaheader_t *)cbuf->buf;

	header->datalen = LSBMSB16(2);
	header->err.e16 = 0;

	return 1;
}

/*
  ꤷξ
*/
int imewrapper_query_dictionary(int id, buffer_t *cbuf)
{
	cannaheader_t *header = (cannaheader_t *)cbuf->buf;

	header->datalen = LSBMSB16(1);
	header->err.e8 = -1;

	return 1;
}

/*
  ˿ñϿ
*/
int imewrapper_define_word(int id, buffer_t *cbuf)
{
	CALLFUNC(4);
}

/*
  񤫤ñ롥
*/
int imewrapper_delete_word(int id, buffer_t *cbuf)
{
	CALLFUNC(5);
}

/*
  ɤߤΤʸФϢʸѴ⡼ɤǤʴѴԤ
*/
int imewrapper_begin_convert(int id, buffer_t *cbuf)
{
	CALLFUNC(6);
}

/*
  ߤΤʴѴȤλɬפ˱ƳؽԤ
*/
int imewrapper_end_convert(int id, buffer_t *cbuf)
{
	CALLFUNC(7);
}

/*
  ꤵ줿ʸΤ٤Ƥθʸɤߤ롥
*/
int imewrapper_get_candidacy_list(int id, buffer_t *cbuf)
{
	CALLFUNC(8);
}

/*
  ʸɤߤʤ롥
*/
int imewrapper_get_yomi(int id, buffer_t *cbuf)
{
	CALLFUNC(9);
}

/*
  ưѴ⡼ɻɤߥХåեƤѹѴԤ
*/
int imewrapper_subst_yomi(int id, buffer_t *cbuf)
{
	CALLFUNC(10);
}

/*
  ʸɤߤʤѹʹߤʸѴ롥
*/
int imewrapper_store_yomi(int id, buffer_t *cbuf)
{
	CALLFUNC(11);
}

/*
  ʸɤߤʤѹʸΤߤñʸѴ롥
*/
int imewrapper_store_range(int id, buffer_t *cbuf)
{
	CALLFUNC(12);
}

/*
  ̤ʸɤߤ롥
*/
int imewrapper_get_lastyomi(int id, buffer_t *cbuf)
{
	CALLFUNC(13);
}

/*
  ̤ʸŪѴ롥
*/
int imewrapper_flush_yomi(int id, buffer_t *cbuf)
{
	CALLFUNC(14);
}

/*
  Ƭʸᤫ饫ʸޤɤߤɤߥХåե
*/
int imewrapper_remove_yomi(int id, buffer_t *cbuf)
{
	CALLFUNC(15);
}

/*
  ꤵ줿񤫤餽μ˴ޤޤƤΤߤ롥
*/
int imewrapper_get_simplekanji(int id, buffer_t *cbuf)
{
	CALLFUNC(16);
}

/*
  ꤵ줿ʸ򡤻ꤵ줿Ĺ˶ڤľơ٤ʴѴ롥
*/
int imewrapper_resize_pause(int id, buffer_t *cbuf)
{
	CALLFUNC(17);
}

/*
  ȸФʻʸǼ롥
*/
int imewrapper_get_hinshi(int id, buffer_t *cbuf)
{
	CALLFUNC(18);
}

/*
  ʸηǾ롥
*/
int imewrapper_get_lex(int id, buffer_t *cbuf)
{
	CALLFUNC(19);
}

/*
  ȸ˴ؤϾ롥
*/
int imewrapper_get_status(int id, buffer_t *cbuf)
{
	CALLFUNC(20);
}

/*
  locale ѹԤ
*/
int imewrapper_set_locale(int id, buffer_t *cbuf)
{
	CALLFUNC(21);
}

/*
  ưѴ⡼ɤǤʴѴԤ
*/
int imewrapper_auto_convert(int id, buffer_t *cbuf)
{
	CALLFUNC(22);
}

/*
  ΥФγĥץȥ䤤碌
*/
int imewrapper_query_extensions(int id, buffer_t *cbuf)
{
	cannaheader_t *header = (cannaheader_t *)cbuf->buf;

	header->datalen = LSBMSB16(1);
	header->err.e8 = 0;

	return 1;
}

/*
  饤ȤΥץꥱ̾򤽤ΥФΤϿ롥
*/
int imewrapper_set_applicationname(int id, buffer_t *cbuf)
{
	cannaheader_t *header = (cannaheader_t *)cbuf->buf;

	header->datalen = LSBMSB16(1);
	header->err.e8 = 0;

	return 1;
}

/*
  饤ȤΥ롼̾򥵡ФΤϿ롣
*/
int imewrapper_notice_groupname(int id, buffer_t *cbuf)
{
	cannaheader_t *header = (cannaheader_t *)cbuf->buf;

	header->datalen = LSBMSB16(1);
	header->err.e8 = 0;

	return 1;
}

/*
  
*/
int imewrapper_through(int id, buffer_t *cbuf)
{
	cannaheader_t *header = (cannaheader_t *)cbuf->buf;

	header->datalen = LSBMSB16(2);
	header->err.e16 = 0;

	return 1;
}

/*
  Ф˽λ׵ΤФλ롣
*/
int imewrapper_kill_server(int id, buffer_t *cbuf)
{
	cannaheader_t *header = (cannaheader_t *)cbuf->buf;
	int err = 0;
	char buf[128];
	struct passwd *pw;
	uid_t pid;

	if (gethostname(buf, 128))
		buf[0] = 0;
	pw = getpwnam(client[id].user);
	pid = getuid();

	if (strcmp(client[id].host, "UNIX") &&
		strcmp(client[id].host, buf) &&
		strcmp(client[id].host, "localhost"))
	{
		err = -111; /* NOTUXSRV */
	} else if (pw->pw_uid != 0 && pw->pw_gid != 0 && pw->pw_uid != pid)
		err = -112; /* NOTOWNSRV */

	header->datalen = LSBMSB16(1);
	header->err.e8 = err;

	if (err == 0)
	{
		signal(SIGALRM, (void(*)())iw_send_term_signal);
		alarm(1);

		m_msg("KillServer from %s@%s accepted.\n", client[id].user, client[id].host);
	}

	return 1;
}

/*
  Ф³Ƥ륯饤ȿʤɤΥо롥
*/
int imewrapper_get_serverinfo(int id, buffer_t *cbuf)
{
	cannaheader_t *header = (cannaheader_t *)cbuf->buf;
	int protocol_num, e_protocol_num, datalen, protocol_datalen, pnt;
	int i;
	uint ui;
	short s;

	for (protocol_num = 0; protocol_name[protocol_num] != NULL; protocol_num++)
		;
	for (e_protocol_num = 0; e_protocol_name[e_protocol_num] != NULL;
		e_protocol_num++);

	protocol_datalen = 0;
	for (i = 0; i < protocol_num; i++)
		protocol_datalen += strlen(protocol_name[i]) + 1;
	for (i = 0; i < e_protocol_num; i++)
		protocol_datalen += strlen(e_protocol_name[i]) + 1;
	protocol_datalen++;

	datalen = 17 + protocol_datalen + (protocol_num + e_protocol_num) * 4;

	buffer_check(cbuf, datalen + 4);
	header = (cannaheader_t *)cbuf->buf;

	header->type = 0x01;
	header->extra = 0x01;
	header->datalen = LSBMSB16(datalen);

	cbuf->buf[4] = 0;
	cbuf->buf[5] = 3; /* Major Server Version */
	cbuf->buf[6] = 5; /* Minor Server Version */

	ui = (uint)time(NULL); ui = LSBMSB32(ui);
	memcpy(&(cbuf->buf[7]), &ui, 4);

	i = protocol_num + e_protocol_num;
	s = LSBMSB16(i);
	memcpy(&(cbuf->buf[11]), &s, 2);

	s = LSBMSB16(protocol_datalen);
	memcpy(&(cbuf->buf[13]), &s, 2);

	pnt = 15;
	for (i = 0; i < protocol_num; i++)
	{
		strcpy(&(cbuf->buf[pnt]), protocol_name[i]);
		pnt += strlen(protocol_name[i]) + 1;
	}

	for (i = 0; i < e_protocol_num; i++)
	{
		strcpy(&(cbuf->buf[pnt]), e_protocol_name[i]);
		pnt += strlen(e_protocol_name[i]) + 1;
	}

	cbuf->buf[pnt++] = 0;

	memset(&(cbuf->buf[pnt]), 0, 4 * (protocol_num + e_protocol_num));
	pnt += 4 * (protocol_num + e_protocol_num);

	memset(&(cbuf->buf[pnt]), 0, 6);
	pnt += 6;

	return 1;
}

/*
  ФλѵĤλȤԤ
*/
int imewrapper_get_access_control_list(int id, buffer_t *cbuf)
{
	cannaheader_t *header = (cannaheader_t *)cbuf->buf;

	header->datalen = LSBMSB16(2);
	header->err.e16 = LSBMSB16(-1);

	return 1;
}

/*
  ƥȼdics.dir Ƥ򹹿롥
*/
int imewrapper_create_dictionary(int id, buffer_t *cbuf)
{
	cannaheader_t *header = (cannaheader_t *)cbuf->buf;

	header->datalen = LSBMSB16(1);
	header->err.e8 = -1;

	return 1;
}

/*
  ƥȼdics.dir Ƥ򹹿롥
*/
int imewrapper_delete_dictionary(int id, buffer_t *cbuf)
{
	cannaheader_t *header = (cannaheader_t *)cbuf->buf;

	header->datalen = LSBMSB16(1);
	header->err.e8 = -1;

	return 1;
}

/*
  桼μ̾ѹ롥
*/
int imewrapper_rename_dictionary(int id, buffer_t *cbuf)
{
	cannaheader_t *header = (cannaheader_t *)cbuf->buf;

	header->datalen = LSBMSB16(1);
	header->err.e8 = -1;

	return 1;
}

/*
  ƥȼñ롥
*/
int imewrapper_get_wordtext_dictionary(int id, buffer_t *cbuf)
{
	cannaheader_t *header = (cannaheader_t *)cbuf->buf;

	header->datalen = LSBMSB16(2);
	header->err.e16 = LSBMSB16(-1);

	return 1;
}

/*
  ꤷǥ쥯ȥˤ뼭ơ֥롥
*/
int imewrapper_list_dictionary(int id, buffer_t *cbuf)
{
	cannaheader_t *header = (cannaheader_t *)cbuf->buf;

	header->datalen = LSBMSB16(1);
	header->err.e8 = -1;

	return 1;
}

/*
  ݻƤ뼭򼭽˽񤭹ࡥ
*/
int imewrapper_sync(int id, buffer_t *cbuf)
{
	cannaheader_t *header = (cannaheader_t *)cbuf->buf;

	header->datalen = LSBMSB16(1);
	header->err.e8 = 0;

	return 1;
}

/*
  READ/WRITE ѹԤ
*/
int imewrapper_chmod_dictionary(int id, buffer_t *cbuf)
{
	cannaheader_t *header = (cannaheader_t *)cbuf->buf;

	header->datalen = LSBMSB16(1);
	header->err.e8 = -1;

	return 1;
}

/*
  ʣ
*/
int imewrapper_copy_dictionary(int id, buffer_t *cbuf)
{
	cannaheader_t *header = (cannaheader_t *)cbuf->buf;

	header->datalen = LSBMSB16(1);
	header->err.e8 = -1;

	return 1;
}
