<?xml version="1.0" encoding="utf-8"?>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.1//EN"
  "http://www.w3.org/TR/xhtml11/DTD/xhtml11.dtd">

<html xmlns="http://www.w3.org/1999/xhtml" xml:lang="ja">
<head>
<title><?cs var:html_escape(BBS_TITLE) ?></title>
<meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
<meta http-equiv="Content-Script-Type" content="text/javascript" />
<meta http-equiv="Content-Style-Type" content="text/css" />
<meta name="generator" content="<?cs var:html_escape(VERSION) ?>" />
<link media="screen" href="<?cs var:html_escape(StaticURI) ?>/tdiary/base.css" rel="stylesheet" type="text/css" />
<link media="screen" href="<?cs var:html_escape(StaticURI) ?>/tdiary/<?cs if:BBS_TYPE_THEME ?><?cs var:html_escape(BBS_TYPE_THEME) ?>/<?cs var:html_escape(BBS_TYPE_THEME) ?>.css<?cs else ?>default/default.css<?cs /if ?>" rel="stylesheet" type="text/css" />
<link media="handheld" href="<?cs var:html_escape(BBSURI) ?>/i/" rel="alternate" type="text/html" />
<script type="text/javascript" src="<?cs var:html_escape(StaticURI) ?>/js/img0ch.js" charset="UTF-8"></script>
<script type="text/javascript">
//<![CDATA[
var app = Img0ch.App;
app.setBBS("<?cs var:html_escape(BBS) ?>");
app.setBBSURI("<?cs var:html_escape(BBSURI) ?>");
app.setCGIURI("<?cs var:html_escape(CGIURI) ?>");
app.setStaticURI("<?cs var:html_escape(StaticURI) ?>");
app.initForm("<?cs var:html_escape(BBS_COOKIE_PATH) ?>");
function redir(element) {
    app.redirectRenderer( element,
        { "theme": "<?cs var:html_escape(BBS_TYPE_THEME) ?>" } );
    return true;
}
//]]>
</script>
<style type="text/css">
@charset "utf-8";
fieldset { border: 0px; }
img { border: 0px; }
.center { text-align:center !important;  }
.clear { clear: both !important; }
.icon-align { vertical-align: top; }
.image { border: none; float: left; margin-right: 4px; margin-bottom: 1px; }
.right { text-align: right !important; }
.res_body {
  font-size: 12pt;
  font-family: "Mona","IPA モナー Pゴシック","IPA MONAPGOTHIC","MS PGothic","ＭＳ Ｐゴシック","MS Pゴシック","MS Pゴシック",sans-serif;
  line-height: 115% !important;
}
</style>
<?cs var:META ?>
</head>
<body>

<div class="center" id="top">
<h1>
<?cs if:BBS_TITLE_PICTURE ?>
 <?cs if:BBS_TITLE_LINK ?>
  <a href="<?cs var:html_escape(BBS_TITLE_LINK) ?>">
   <img src="<?cs var:html_escape(BBS_TITLE_PICTURE) ?>" alt="<?cs var:html_escape(BBS_TITLE) ?>の看板" />
  </a>
 <?cs else ?>
  <img src="<?cs var:html_escape(BBS_TITLE_PICTURE) ?>" alt="<?cs var:html_escape(BBS_TITLE) ?>の看板" />
 <?cs /if ?>
<?cs else ?>
 <?cs var:html_escape(BBS_TITLE) ?>
<?cs /if ?>
</h1>
</div>

<div class="day" id="info">
 <h2><span class="title"><?cs var:html_escape(BBS_SUBTITLE) ?></span></h2>
 <div class="body">
  <div class="section">
   <?cs var:HEAD ?>
  </div>
 </div>
</div>

<?cs if:Banner ?>
<hr class="sep" />
<div class="day" id="mainBanner">
 <h2><span class="title">告知欄</span></h2>
 <div class="body">
  <div class="section">
   <?cs var:Banner ?>
  </div>
 </div>
</div>
<?cs /if ?>

<?cs if:SubBanner ?>
<hr class="sep" />
<div class="day" id="subBanner">
 <h2><span class="title">副告知欄</span></h2>
 <?cs var:SubBanner ?>
</div>
<?cs /if ?>

<hr class="sep" />

<div class="day" id="menu">
 <h2><span class="title">スレッド一覧</span></h2>
 <div class="body">
  <div class="section" id="floated_threads">
  <?cs each:item = Threads ?>
   <a href="<?cs var:html_escape(CGIURI) ?>/<?cs var:html_escape(Renderer) ?><?cs var:html_escape(RendererSeparator) ?><?cs var:html_escape(BBS) ?>/<?cs var:html_escape(item.key) ?>/l50" onclick="redir(this)"><?cs var:html_escape(item.index) ?>:</a>
   <a href="#f_<?cs var:html_escape(item.index) ?>"><?cs var:html_escape(item.subject) ?>(<?cs var:html_escape(item.res) ?>)</a><br />
  <?cs /each ?>
  </div>
  <div class="section" id="hidden_threads">
  <?cs each: item = Stored ?>
   <a href="<?cs var:html_escape(CGIURI) ?>/<?cs var:html_escape(Renderer) ?><?cs var:html_escape(RendererSeparator) ?><?cs var:html_escape(BBS) ?>/<?cs var:html_escape(item.key) ?>/l50" onclick="redir(this)">
   <?cs var:html_escape(item.index) ?>:<?cs var:html_escape(item.subject) ?> (<?cs var:html_escape(item.res) ?>)</a><br />
  <?cs /each ?>
  </div>
  <div class="section" id="more_threads">
   <a href="<?cs var:html_escape(BBSURI) ?>/subback.html">スレッド一覧はこちら</a>
  </div>
 </div>
</div>

<hr class="sep" />

<?cs each:t = Threads ?>
<div class="day" id="f_<?cs var:html_escape(t.index) ?>">
 <h2 class="thread_header">
  <span class="date">
   <span class="thread_info"><a href="#menu">■</a><a href="#f_<?cs var:html_escape(t.up) ?>">▲</a><a href="#f_<?cs var:html_escape(t.down) ?>">▼</a>&nbsp;【<?cs var:html_escape(t.index) ?>:<?cs var:html_escape(t.res) ?>】</span>
  </span>
  <span class="title thread_subject"><?cs var:html_escape(t.subject) ?></span>
 </h2>
 <div class="body thread_body" id="t_<?cs var:html_escape(t.key) ?>">
  <?cs each:r = t.Thread ?>
   <div class="section" id="r_<?cs var:html_escape(t.key) ?>_<?cs var:html_escape(r.resno) ?>">
    <div class="caption res_header">
     <?cs var:html_escape(r.resno) ?>
     名前：<span class="commentator">
     <?cs if:r.mail ?>
      <a href="mailto:<?cs var:html_escape(r.mail) ?>" rel="nofollow"><b><?cs var:r.name ?></b></a>
     <?cs else ?>
      <span class="nomail"><b><?cs var:r.name ?></b></span>
     <?cs /if ?>
     </span>:<span class="commenttime"><?cs var:r.date ?></span>
    </div>
    <p class="res_body"><?cs var:r.text ?></p>
   </div>
  <?cs /each ?>
 </div>
 <div class="form">
  <form class="comment" method="post" action="<?cs var:html_escape(CGIURI) ?>/bbs.cgi?guid=on" enctype="multipart/form-data">
   <div class="hidden_field">
    <input type="hidden" name="bbs" value="<?cs var:html_escape(BBS) ?>" />
    <input type="hidden" name="key" value="<?cs var:html_escape(t.key) ?>" />
    <input type="hidden" name="time" value="<?cs var:html_escape(TimeStamp) ?>" />
		<input type="hidden" name="utf8" value="1" />
   </div>
   <div>
    <div class="field name">
     名前：<input type="text" name="FROM" size="19" />
    </div>
    <div class="field mail">
     メール：<input type="text" name="mail" size="19" />
    </div>
   </div>
   <?cs if:UploadableFromRes ?>
   <div>
    <div class="field name">
     画像：<input type="file" name="file" />
    </div>
    <div class="field mail">
     削除パス：<input type="password" name="pass" />
    </div>
   </div>
   <?cs /if ?>
   <?cs if:Icon ?>
   <div class="textarea">
    アイコン：<select name="icon"><option value="" selected="selected">なし</option>
    <?cs each:item = Icons ?><option value="<?cs var:item.id ?>"><?cs var:item.name ?></option>
    <?cs /each ?></select>
   </div>
   <?cs /if ?>
   <div class="textarea">
    コメント：<textarea rows="5" cols="64" name="MESSAGE"></textarea>
   </div>
   <div class="button">
    <input type="submit" name="submit" value="書き込む" />
   </div>
  </form>
 </div>
 <div class="referer">
  <a href="<?cs var:html_escape(CGIURI) ?>/<?cs var:html_escape(Renderer) ?><?cs var:html_escape(RendererSeparator) ?><?cs var:html_escape(BBS) ?>/<?cs var:html_escape(t.key) ?>/" onclick="redir(this)">全部読む</a>
  <a href="<?cs var:html_escape(CGIURI) ?>/<?cs var:html_escape(Renderer) ?><?cs var:html_escape(RendererSeparator) ?><?cs var:html_escape(BBS) ?>/<?cs var:html_escape(t.key) ?>/l50" onclick="redir(this)">最新50</a>
  <a href="<?cs var:html_escape(CGIURI) ?>/<?cs var:html_escape(Renderer) ?><?cs var:html_escape(RendererSeparator) ?><?cs var:html_escape(BBS) ?>/<?cs var:html_escape(t.key) ?>/1-100" onclick="redir(this)">1-100</a>
  <?cs if:Uploadable ?><a href="<?cs var:html_escape(CGIURI) ?>/img0ch-ufm.cgi/<?cs var:html_escape(BBS) ?>/<?cs var:html_escape(t.key) ?>/">ファイル管理</a><?cs /if  ?>
  <a href="#top">板のトップ</a>
  <a href="./index.html">リロード</a>
 </div>
</div>
<?cs /each ?>

<hr class="sep" />

<div class="day" id="thread_builder_form">
 <h2><span class="title">スレッド新規作成</span></h2>
 <div class="form">
  <form class="comment" method="post" action="<?cs var:html_escape(CGIURI) ?>/bbs.cgi?guid=on" enctype="multipart/form-data">
   <div class="hidden_field">
    <input type="hidden" name="bbs" value="<?cs var:html_escape(BBS) ?>" />
    <input type="hidden" name="time" value="<?cs var:html_escape(TimeStamp) ?>" />
		<input type="hidden" name="utf8" value="1" />
   <?cs if:BBS_PASSWORD_CHECK ?>
    <input type="hidden" name="FROM" value="" />
    <input type="hidden" name="mail" value="" />
   </div>
   <div class="button">
    <input type="submit" value=" 新規スレッド作成画面へ " />
   </div>
   <?cs else ?>
   </div>
   <div class="textarea">
    タイトル：<input type="text" name="subject" size="25" />
   </div>
   <div>
    <div class="field name">
     名前：<input type="text" name="FROM" size="19" />
    </div>
    <div class="field mail">
     E-mail：<input type="text" name="mail" size="19" />
    </div>
   </div>
   <?cs if:UploadableFromThread ?>
   <div>
    <div class="field name">
     画像：<input type="file" name="file" />
    </div>
    <div class="field mail">
     削除パス：<input type="password" name="pass" />
    </div>
   </div>
   <?cs /if ?>
   <?cs if:Icon ?>
   <div class="textarea">
    アイコン：<select name="icon"><option value="" selected="selected">なし</option>
    <?cs each:item = Icons ?><option value="<?cs var:item.id ?>"><?cs var:item.name ?></option>
    <?cs /each ?></select>
   </div>
   <?cs /if ?>
   <div class="textarea">
    コメント：<textarea rows="5" cols="64" name="MESSAGE"></textarea>
   </div>
   <div class="button">
    <input type="submit" name="submit" value="新規スレッド作成" />
   </div>
   <?cs /if ?>
  </form>
 </div>
</div>

<hr class="sep" />

<div class="footer">
 <?cs var:FOOT ?>
</div>

</body>
</html>
