<?xml version="1.0" encoding="utf-8"?>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.1//EN"
  "http://www.w3.org/TR/xhtml11/DTD/xhtml11.dtd">

<html xmlns="http://www.w3.org/1999/xhtml" xml:lang="ja">
<head>
<title>img0ch - 「<?cs var:html_escape(BBS_TITLE) ?>」の添付ファイル管理</title>
<meta http-equiv=Content-Type content="text/html; charset=ShiftJIS" />
<meta http-equiv="Content-Script-Type" content="text/javascript" />
<meta http-equiv="Content-Style-Type" content="text/css" />
<meta name="generator" content="<?cs var:html_escape(VERSION) ?>" />
<link media="screen" href="<?cs var:html_escape(StaticURI) ?>/tdiary/base.css" rel="stylesheet" />
<link media="screen" href="<?cs var:html_escape(StaticURI) ?>/tdiary/<?cs if:BBS_TYPE_THEME ?><?cs var:html_escape(BBS_TYPE_THEME) ?>/<?cs var:html_escape(BBS_TYPE_THEME) ?>.css<?cs else ?>default/default.css<?cs /if ?>" rel="stylesheet" />
<script type="text/javascript" src="<?cs var:html_escape(StaticURI) ?>/js/img0ch.js" charset="UTF-8"></script>
<script type="text/javascript">
//<![CDATA[
var app = Img0ch.App;
app.setBBS("<?cs var:html_escape(BBS) ?>");
app.setBBSURI("<?cs var:html_escape(BBSURI) ?>");
app.setCGIURI("<?cs var:html_escape(CGIURI) ?>");
app.setStaticURI("<?cs var:html_escape(StaticURI) ?>");
function redir(element) {
    app.redirectRenderer( element,
        { "theme": "<?cs var:html_escape(BBS_TYPE_THEME) ?>" } );
    return true;
}
//]]>
</script>
<style type="text/css">
/* from zeromin2.css */
.noticeFailed {
  margin: 0 1em 0 1em;
  padding: 0;
  color: #ff0000;
  background: #ffeeee;
  border: 1px solid #ff9999;
}
.noticeSuccess {
  margin: 0 1em 0 1em;
  padding: 0;
  color: #008000;
  background: #eeffee;
  border: 1px solid #99ff99;
}
<?cs var:TagCloudCSS ?>
</style>
<?cs var:META ?>
</head>

<body>

<?cs if:Banner ?>
<div class="day" id="mainBanner">
 <h2><span class="title">告知欄</span></h2>
 <div class="body">
  <div class="section">
   <?cs var:Banner ?>
  </div>
 </div>
</div>
<hr class="sep" />
<?cs /if ?>

<div class="day">
 <h2 class="thread_header">
  <span class="title thread_subject">img0ch - 「<?cs var:html_escape(BBS_TITLE) ?>」の添付ファイル管理</span>
 </h2>
 <div class="body">
  <div class="caption">
   <a href="<?cs var:html_escape(BBSURI) ?>/">掲示板に戻る</a>
   <a href="<?cs var:html_escape(CGIURI) ?>/img0ch-sf.cgi/<?cs var:html_escape(BBS) ?>/">添付ファイル検索</a>
   <?cs if:KEY ?><a href="<?cs var:html_escape(CGIURI) ?>/read.cgi/<?cs var:html_escape(BBS) ?>/<?cs var:html_escape(KEY) ?>/l50" onclick="redir(this)">スレッドに戻る</a>
   <a href="<?cs var:html_escape(CGIURI) ?>/img0ch-vta.cgi/<?cs var:html_escape(BBS) ?>/<?cs var:html_escape(KEY) ?>/">仮想スレッド管理</a><?cs /if ?>
  </div>
  <div class="section">
   <p>
   <?cs if:Password ?>
    <?cs if:Removed ?><div class="noticeSuccess" id="notify"><p>指定されたファイルを削除しました</p></div><?cs /if ?>
    <?cs if:Failed ?><div class="noticeFailed" id="notify"><p>指定されたファイルの操作が出来ません<br />パスワードが間違っているか、設定されていません</p></div><?cs /if ?>
   <?cs elif:TaggedOK ?><div class="noticeSuccess" id="nofity"><p>添付ファイルのタグ付けをしました</p></div>
   <?cs elif:TaggedNG ?><div class="noticeFailed" id="notify"><p>以下のうちひとつ以上該当するため添付ファイルのタグ付けが出来ませんでした<ul><li>管理者によってタグ付け機能を停止させている</li><li>投稿元がプロクシ経由または規制されている</li></ul></p></div>
   <?cs elif:RatedOK ?><div class="noticeSuccess" id="notify"><p>添付ファイルの評価をしました</p></div>
   <?cs elif:RatedNG ?><div class="noticeFailed" id="notify"><p>以下のうちひとつ以上該当するため添付ファイルの評価が出来ませんでした<ul><li>コメントが無いか長すぎる</li><li>投稿元がプロクシ経由または規制されている</li><li>既にその添付ファイルに対して投票済み</li></ul></p></div>
   <?cs elif:PolledOK ?><div class="noticeSuccess" id="notify"><p>添付ファイルの停止投票をしました<br /><?cs if:Freezed ?>また、投票数が<?cs var:html_escape(BBS_IMG_POLL_REQUIRE_TO_STOP) ?>票を達したため、添付ファイルの凍結を行いました<?cs /if ?></p></div>
   <?cs elif:PolledNG ?><div class="noticeFailed" id="notify"><p>以下のうちひとつ以上該当するため添付ファイルの停止投票が出来ませんでした<ul><li>元のレスに添付ファイルが存在しない</li><li>コメントが無いか長すぎる</li><li>投稿元がプロクシ経由または規制されている</li><li>投票可能数を超えている</li><li>既にその添付ファイルに対して投票済み</li></ul></p></div><?cs /if ?>
   </p>
  </div>
 </div>
 <div class="form">
  <form action="<?cs var:html_escape(CGIURI) ?>/img0ch-ufm.cgi/<?cs var:html_escape(BBS) ?>" method="post">
   <div class="section">
    <div class="caption"><label for="inputTextResno">レス番号</label></div>
    <div class="section"><p><input id="inputTextResno" name="resno" type="text" value="<?cs var:html_escape(Resno) ?>" size="5" /></p></div>
    <div class="caption"><label for="inputPasswordPass">パスワード</label></div>
    <div class="section"><p><input id="inputPasswordPass" name="pass" type="password" /></p></div>
    <div class="caption">方法</div>
    <div class="section"><p><input id="radioBoxRemove" type="radio" name="type" value="remove" checked="checked" /><label for="radioBoxRemove">削除</label><input id="radioBoxDownload" type="radio" name="type" value="download" /><label for="radioBoxDownload">ダウンロード</label></p></div>
    <div class="caption"><label for="selectKey">スレッド</label></div>
    <div class="section"><p><select id="selectKey" name="key">
    <?cs each:item = Threads ?><option value="<?cs var:html_escape(item.key) ?>"<?cs if:item.selected ?> selected="selected"<?cs /if ?>><?cs var:html_escape(item.subject) ?> (<?cs var:html_escape(item.res) ?>)</option>
<?cs /each ?></select></p></div>
    <input type="hidden" name="bbs" value="<?cs var:html_escape(BBS) ?>" />
    <div class="button"><input type="submit" name="submit" value="&nbsp;実行&nbsp;" /></div>
   </div>
  </form>
 </div>
 <?cs if:Resno ?>
 <div class="form">
  <form action="<?cs var:html_escape(CGIURI) ?>/img0ch-ufm.cgi/<?cs var:html_escape(BBS) ?>/<?cs var:html_escape(KEY) ?>/<?cs var:html_escape(Resno) ?>" method="post">
   <div class="caption">添付ファイルのタグ</div>
   <div class="section">
    <p><?cs var:TagCloudHTML ?></p>
   </div>
   <div class="caption">タグ編集フォーム</div>
   <div class="section">
    <p>
     タグはスペースで区切って入力する必要があります。<br />
     タグ1つにつき最大<?cs var:html_escape(TagMaxLength) ?>バイト、10個まで指定できます。<br />
     <input type="text" name="tag" size="80" value="<?cs var:html_escape(MyTags) ?>" />
     <input type="submit" value="タグ付けをする" />
     <input type="hidden" name="type" value="tagging" />
    </p>
   </div>
  </form>
 </div>
 <div class="form">
  <form action="<?cs var:html_escape(CGIURI) ?>/img0ch-ufm.cgi/<?cs var:html_escape(BBS) ?>/<?cs var:html_escape(KEY) ?>/<?cs var:html_escape(Resno) ?>" method="post">
   <div class="caption">添付ファイルの評価&nbsp;-&nbsp;<?cd var:html_escape(RateAverage) ?></div>
   <div class="section">
    <p>同じIPからの連続評価は出来ません。</p>
   </div>
   <div class="caption">評価のコメント</div>
   <div class="section">
    <div class="body thread_body">
     <?cs each:item = Reviews ?>
     <div class="section" id="r_<?cs var:html_escape(item.resno) ?>">
      <div class="caption res_header">
       <?cs var:html_escape(item.resno) ?>
       名前：<span class="commentator">
       <span class="nomail"><b><?cs if:DisplayPolledIP ?><?cs var:html_escape(item.ip) ?><?cs else ?>非公開<?cs /if ?></b></span>
       </span>:<span class="commenttime"><?cs var:html_escape(item.reviewed) ?></span>
      </div>
      <p class="res_body"><?cs var:html_escape(item.comment) ?></p>
     </div>
     <?cs /each ?>
    </div>
   </div>
   <div class="caption">評価フォーム</div>
   <div class="section">
    <p>
     <input type="text" name="comment" size="80" /><br />
     <select name="rate">
      <option value="5">★★★★★:5</option>
      <option value="4">★★★★☆:4</option>
      <option value="3">★★★☆☆:3</option>
      <option value="2">★★☆☆☆:2</option>
      <option value="1">★☆☆☆☆:1</option>
     </select>
     <input type="submit" value="評価する" />
     <input type="hidden" name="type" value="rate" />
    </p>
   </div>
  </form>
 </div>
 <div class="form">
  <form action="<?cs var:html_escape(CGIURI) ?>/img0ch-ufm.cgi/<?cs var:html_escape(BBS) ?>/<?cs var:html_escape(KEY) ?>/<?cs var:html_escape(Resno) ?>" method="post">
   <div class="caption">添付ファイルの停止投票</div>
   <div class="section">
    <p>
     添付されたファイルが適切で無い場合はコメントを書いて「停止投票」を行ってください。<br />
     投票数が<strong><?cs var:html_escape(BBS_IMG_POLL_REQUIRE_TO_STOP) ?>票以上</strong>で閲覧及びダウンロードが停止されます。<br />
     投票者の<strong>IPアドレスは公開<?cs if:DisplayPolledIP ?>されます<?cs else ?>されません<?cs /if ?></strong>。
    </p>
    <p>
     <?cs if:PollableCount ?>現時点であと<strong><?cs var:html_escape(PollableCount) ?>回投票出来ます</strong>。0になると投票が出来なくなります。<?cs else ?>投票可能数に達したため現在投票出来ません。しばらくすると投票可能になります。<?cs /if ?>
    </p>
   </div>
   <div class="caption">投票のコメント</div>
   <div class="section">
    <div class="body thread_body">
     <?cs each:item = PollForBad ?>
     <div class="section" id="r_<?cs var:html_escape(item.resno) ?>">
      <div class="caption res_header">
       <?cs var:html_escape(item.resno) ?>
       名前：<span class="commentator">
       <span class="nomail"><b><?cs if:DisplayPolledIP ?><?cs var:html_escape(item.ip) ?><?cs else ?>非公開<?cs /if ?></b></span>
       </span>:<span class="commenttime"><?cs var:html_escape(item.polled) ?></span>
      </div>
      <p class="res_body"><?cs var:html_escape(item.comment) ?></p>
     </div>
     <?cs /each ?>
    </div>
   </div>
   <div class="caption">投票フォーム</div>
   <div class="section">
    <p>
     <input type="text" name="comment" size="80" />
     <input type="submit" value="停止投票を行う" />
     <input type="hidden" name="type" value="poll" />
    </p>
   </div>
  </form>
 </div>
 <?cs /if ?>
</div>

<div class="footer" id="VERSION"><a href="http://img0ch.sourceforge.jp">img0ch-ufm.cgi - img0ch BBS</a></div>

</body>
</html>
