#/*
# *  Copyright 2007-2010 hkrn <hikarin@users.sourceforge.jp>
# *
# *  Licensed under the Apache License, Version 2.0 (the "License");
# *  you may not use this file except in compliance with the License.
# *  You may obtain a copy of the License at
# *
# *      http://www.apache.org/licenses/LICENSE-2.0
# *
# *  Unless required by applicable law or agreed to in writing, software
# *  distributed under the License is distributed on an "AS IS" BASIS,
# *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# *  See the License for the specific language governing permissions and
# *  limitations under the License.
# */
#
# $Id: Read.pm 1901 2009-12-31 02:40:20Z hikarin $
#

package Img0ch::App::Mock::Read;

use strict;
use base qw(Img0ch::App::Read);
use Img0ch::Request::Mock qw();

sub new {
    my ( $iClass, $iBBS, $key, $option ) = @_;
    my $iApp = $iClass->SUPER::new( $iBBS->get_kernel() );
    my $path_info = '/' . join '/', $iBBS->get_name(), $key, $option;
    my $iRequest
        = Img0ch::Request::Mock->new( {}, {}, { path_info => $path_info } );
    $iApp->{_request} = $iRequest;
    return $iApp;
}

sub run {
    my ($iApp) = @_;
    my $template_tags;

    if ($iApp->init(
            {   disable => 'DisableReadInitPlugin',
                type    => 'read.init',
                mobile  => 0,
            }
        )
        )
    {
        $template_tags = $iApp->load_thread(
            {},
            {   filter   => undef,
                mobile   => 0,
                template => 'read',
                type     => 'read.rewrite',
            },
            1
        );
    }
    else {
        $template_tags = $iApp->redirect_error(1);
    }
    return $template_tags;
}

1;
__END__
