#/*
# *  Copyright 2007-2010 hkrn <hikarin@users.sourceforge.jp>
# *
# *  Licensed under the Apache License, Version 2.0 (the "License");
# *  you may not use this file except in compliance with the License.
# *  You may obtain a copy of the License at
# *
# *      http://www.apache.org/licenses/LICENSE-2.0
# *
# *  Unless required by applicable law or agreed to in writing, software
# *  distributed under the License is distributed on an "AS IS" BASIS,
# *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# *  See the License for the specific language governing permissions and
# *  limitations under the License.
# */
#
# $Id: RemoteHost.pm 1901 2009-12-31 02:40:20Z hikarin $
#

package Img0ch::Filter::RemoteHost;

use strict;

sub new {
    my ( $iClass, $iBBS ) = @_;
    my $iKernel = $iBBS->get_kernel();

    bless {
        _bbs => ( $iBBS->get_name() || 'test' ),
        _rs => $iKernel->get_repos( $iKernel->get_repos_path('host') ),
    }, $iClass;
}

sub load { $_[0]->{_rs}->load(); return 1 }

sub write_ok {
    my ( $iFRH, $remote_host ) = @_;
    my $iRepos = $iFRH->{_rs};
    my $bbs    = $iFRH->{_bbs};

    if ( my $local_restrict_regexp = $iRepos->get("I:F:R.${bbs}.0") ) {
        $remote_host =~ /$local_restrict_regexp/xms and return 0;
    }
    if ( my $global_restrict_regexp = $iRepos->get('I:F:R.test.0') ) {
        $remote_host =~ /$global_restrict_regexp/xms and return 0;
    }
    return 1;
}

1;
__END__
