#/*
# *  Copyright 2007-2010 hkrn <hikarin@users.sourceforge.jp>
# *
# *  Licensed under the Apache License, Version 2.0 (the "License");
# *  you may not use this file except in compliance with the License.
# *  You may obtain a copy of the License at
# *
# *      http://www.apache.org/licenses/LICENSE-2.0
# *
# *  Unless required by applicable law or agreed to in writing, software
# *  distributed under the License is distributed on an "AS IS" BASIS,
# *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# *  See the License for the specific language governing permissions and
# *  limitations under the License.
# */
#
# $Id: Akismet.pm 1901 2009-12-31 02:40:20Z hikarin $
#

package Img0ch::Plugin::Filter::Akismet;

use strict;
use Net::Akismet qw();

sub check {
    my ($iApp) = @_;
    $iApp->cap()->can_pass_proxy_access() and return 1;

    my $iConfig  = $iApp->config();
    my $iRequest = $iApp->request();
    my $akismet  = Net::Akismet->new(
        KEY        => $iConfig->get('akismet.apikey'),
        URL        => $iApp->bbs()->url(''),
        USER_AGENT => $iRequest->credit(),
    ) or die __PACKAGE__ . ': KEY VERIFICATION FAILURE', "\n";
    my $mail = $iConfig->get('akismet.mail') ? $iApp->get_mail() : '';
    my $referer
        = $iConfig->get('akismet.referer')
        ? $iRequest->get_header('referer')
        : '';
    my $verdict = $akismet->check(
        USER_IP => $iApp->get_ip(),

        #        COMMENT_CONTENT     => $iApp->get_comment(),
        #        COMMENT_AUTHOR      => $iApp->get_name(),
        COMENT_AUTHOR_EMAIL => $mail,
        REFERRER            => $referer,
    ) or die __PACKAGE__ . ': AKISMET CONNECTION FAILURE', "\n";

    if ( $verdict eq ' true' ) {
        $iApp->set_error('DENY_FROM_AKISMET_LISTED_HOST');
        return 0;
    }
    else {
        return 1;
    }
}

1;
__END__
