#/*
# *  Copyright 2007-2010 hkrn <hikarin@users.sourceforge.jp>
# *
# *  Licensed under the Apache License, Version 2.0 (the "License");
# *  you may not use this file except in compliance with the License.
# *  You may obtain a copy of the License at
# *
# *      http://www.apache.org/licenses/LICENSE-2.0
# *
# *  Unless required by applicable law or agreed to in writing, software
# *  distributed under the License is distributed on an "AS IS" BASIS,
# *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# *  See the License for the specific language governing permissions and
# *  limitations under the License.
# */
#
# $Id: YouTube.pm 1969 2010-01-23 13:56:50Z hikarin $
#

package Img0ch::Plugin::Rewrite::StreamService::YouTube;

use strict;

sub new {
    my ( $iClass, $iBBS ) = @_;
    bless [ $iBBS->get_name() ], $iClass;
}

sub from_bbs {
    my ( $iObject, $key, $count, $resno, $text ) = @_;
    my ($bbs) = @$iObject;
    my $id = join '_', $bbs, $key, $resno;

    $$text =~ s{
        (?:\<a[^>]+>)?
        http://(?:\w+\.)?youtube\.com/watch\?v=([\w\-]+)
        (?:\</a>)?}{<b><a href="http://youtu.be/$1"
onclick="Img0ch.App.toggleVideoPlayer('Youtube', '$1', '${id}_youtube_$1');return false">
[youtube.com:$1]</a></b><div style="display:inline" id="${id}_youtube_$1"></div>}gxms;

    return;
}

*from_read = \&from_bbs;

1;
__END__
