############################################
# ImageBBS Zope2.6.2 Products By Python 2.2.3
# 饤󥹤 Zope ˽򤷤ޤ
# Copyright (c) 2003/11/12 yosiki.jp by kiyoharu ueno
# EMail kiyo@yosiki.jp
#
############################################
__doc__="ImageBBS Database Classes"
__version__='$Revision: 0.2.6b $'[11:-2]

import string, os, sys, re, tempfile
from Globals import Persistent, DTMLFile, InitializeClass, package_home,MessageDialog
from AccessControl.Role import RoleManager
from operator import truth
import Acquisition, sys, types, mimetools
import OFS.SimpleItem
from OFS.DTMLMethod import DTMLMethod
from OFS.Folder import Folder
from OFS.content_types import guess_content_type
from StringIO import StringIO
from AccessControl import ClassSecurityInfo, getSecurityManager
from DateTime import DateTime
from Products.ZSQLMethods.SQL import SQL
from PIL import Image
from Templates import Templates, PGSqls, IBSqls, MYSqls, Scripts
from Binarydb import _insertIbSQL, _insertPgSQL, _updateIbSQL, _updatePgSQL
from encodeconv import conv, get_string_part

manage_addImgBBSForm=DTMLFile('dtml'+os.sep+
    'manage_addImgBBSForm',globals())

package_path = package_home(globals())
DBCON_ID = 'conid'


def createscript(ob,idst,param,body):
  ob.manage_addProduct['PythonScripts'].manage_addPythonScript(
      id=idst)
  ob[idst].ZPythonScript_edit(params=param,body=body)



def createsql(ob, idst, title, arguments, template):
  ob.manage_addProduct['ZSQLMethods'].manage_addZSQLMethod(
      id=idst,title=title,connection_id=DBCON_ID,
      arguments=arguments,template=template)


def manage_addImgBBS( self, id, title='',selectdb='' ,
    dbhost='',dbusername='',dbpasswd='', dbname='',
    dbcharset='', REQUEST=None ):
    ' add  ImageBBS Databse into the system '
    dbcharset=string.lower(dbcharset)
    if selectdb=='i' and dbname=='':
      dbname=os.path.join(package_path,'imgbbs.fdb')
    ob = ImgBBS( id, title, selectdb,dbhost, dbusername,
         dbpasswd,dbname,dbcharset )
    self._setObject( id, ob )
    ob = self._getOb(id)

    ob.manage_addProduct['MailHost'].manage_addMailHost(
      'mailhost',smtp_host=REQUEST.get('smtphost','localhost'))


    if selectdb =='p':
      constr = "dbname=%s user=%s" % (dbname,dbusername)
      if dbpasswd != '':
	constr = constr + "password=%s " % dbpasswd
      if dbhost != '':
	constr = constr + "host=%s" % dbhost
      ob.manage_addProduct['ZPsycopgDA'].manage_addZPsycopgConnection(
          DBCON_ID,'',constr)
    elif selectdb =='m':
      if dbhost != '':
        constr = "%s@%s %s %s" % (dbname,dbhost, dbusername,dbpasswd)
      else:
        constr = "%s %s %s" % (dbname, dbusername,dbpasswd)
      ob.manage_addProduct['ZMySQLDA'].manage_addZMySQLConnection(
          DBCON_ID,'',constr)
    else:
      utf8='UNICODE_FSS'
      euc='EUCJ_0208'
      sjis='SJIS_0208'
      unicodest=euc
      if dbcharset =='utf-8':
        unicodest=utf8
      elif dbcharset=='shift_jis':
        unicodest = sjis

      if dbname=='':
         dbname = os.path.join(package_path,'imgbbs.fdb')
      if dbhost != '':
        constr = "%s:%s %s %s %s" % (dbhost, dbname,
	     dbusername,dbpasswd,unicodest)
      else:
        constr = "%s %s %s %s" % (dbname, dbusername,dbpasswd,unicodest)
      ob.manage_addProduct['kInterbasdbDA'].manage_addKInterbaseConnection(
          DBCON_ID,'',constr)

    # dtmlMethod create module
    for (id, data) in Templates.items():
       ob.addDTMLMethod(id, file=conv(data,dbcharset))
    # ZSQLMethod create module
    if selectdb =='p':
       for (id,arg) in PGSqls.items():
         createsql(ob,id,'', arg[0], arg[1])
    elif selectdb=='i':
       for (id,arg) in IBSqls.items():
         createsql(ob,id,'', arg[0], arg[1])
    elif selectdb=='m':
       for (id,arg) in MYSqls.items():
         createsql(ob,id,'', arg[0], arg[1])
    # pythonScript create module
    for (id,arg) in Scripts.items():
       createscript(ob,id, arg[0], conv(arg[1],dbcharset))

    if REQUEST is not None:
        return self.manage_main(self, REQUEST, update_menu=1)


#######################
class ImgBBS(Persistent, Folder):
    """
    class Image BBS Database bater
    """
    meta_type ="Image BBS Database"

    #index_html=DTMLFile('dtml'+os.sep+'manageIndex',globals())
    imgbbslogo='misc_/ImgBBS/ImgBBSlogo'
    manage_changeImgBBSForm=DTMLFile('dtml'+os.sep+
    'manage_changeImgBBSForm', globals())
    security = ClassSecurityInfo()
    manage_options= Folder.manage_options + (
      {"icon":"", "label":"Edit", "action":"manage_changeImgBBSForm"},
    )
    _properties=(
        {'id':'title', 'type': 'string', 'mode':'w'},
	{'id':'admin_address', 'type': 'string', 'mode':'w'},
	{'id':'content_type', 'type': 'string', 'mode':'w'},
	{'id':'rss_image_url', 'type': 'string', 'mode':'w'},
	{'id':'IsMail', 'type': 'int', 'mode':'w'},
	{'id':'CreateTitle', 'type': 'int', 'mode':'w'},
	{'id':'RecordNum', 'type': 'int', 'mode':'w'},
	{'id':'SkipRow', 'type': 'int', 'mode':'w'},
        )

    admin_address = "postmaster@host.com"
    content_type = "text/plain; charset=ISO-2022-JP"
    rss_image_url = ""
    IsMail = 0
    CreateTitle = 0
    RecordNum = 10
    SkipRow = 10

    def _manage_createsql(self, methodid, title, arg, cmd):
        """
	"""
	setattr(self,  methodid,
	SQL(methodid, title, DBCON_ID, arg, cmd)
	)

    def _manage_createsql_main(self):
        """
	"""
	### ###
	cmd = """delete from imgbbssub
	  where (mid=<dtml-sqlvar mid type=int>) and (pid=<dtml-sqlvar pid type=int>)
	"""
	arg = """mid
pid"""
	methodid ="DeleteSubEntrySQL"
	self._manage_createsql(methodid, "", arg, cmd)
	### ###
	cmd = """delete from imgbbsblob
	  where ((mid=<dtml-sqlvar mid type=int>) and (pid=<dtml-sqlvar pid type=int>) and (ptype=<dtml-sqlvar ptype type=string>))
	"""
	arg = """mid
pid
ptype"""
	methodid ="DeleteImgSQL"
	self._manage_createsql(methodid, "", arg, cmd)
	### ###
	cmd = """select * from imgbbsmain
 order by mid
	"""
	arg = ""
	methodid ="GetMainAllSQL"
	self._manage_createsql(methodid, "", arg, cmd)
	### ###
	cmd = """select * from imgbbsmain
	   where mid=<dtml-sqlvar mid type=int>
	    order by mid
	"""
	arg = """mid"""
	methodid ="GetMainIdSQL"
	self._manage_createsql(methodid, "", arg, cmd)
	### ###
	cmd = """select MAX(mid) as maxid from imgbbsmain
	"""
	arg = ""
	methodid ="GetMainMaxIdSQL"
	self._manage_createsql(methodid, "", arg, cmd)
	### ###
	cmd = """select * from imgbbssub
 where mid=<dtml-sqlvar mid type=int>
  <dtml-if "reverse==1">
  order by sid
  <dtml-else>
  order by sid DESC
  </dtml-if>
	"""
	arg = """mid
reverse=0"""
	methodid ="GetSubAllSQL"
	self._manage_createsql(methodid, "", arg, cmd)
	### ###
	cmd = """select * from imgbbssub
 where <dtml-sqltest comment   op="like" type="string" optional>
 order by sid DESC
	"""
	arg = """comment"""
	methodid ="GetSerchSQL"
	self._manage_createsql(methodid, "", arg, cmd)
	### ###
	cmd = """select DISTINCT M.title, M.mid, S.pid,S.subject, S.sakuseibi, S.comment from imgbbsmain M, imgbbssub S
  where (S.mid = M.mid)
  order by S.sakuseibi DESC
	"""
	arg = """"""
	methodid ="GetRssSQL"
	self._manage_createsql(methodid, "", arg, cmd)
	### ###
	cmd = """select * from imgbbssub
  where (mid=<dtml-sqlvar mid type=int> and pid=<dtml-sqlvar pid type=int>)"""
	arg = """mid
pid"""
	methodid ="GetOneSQL"
	self._manage_createsql(methodid, "", arg, cmd)
	### ###
	cmd = """select MAX(pid)  from imgbbssub
 where mid=<dtml-sqlvar mid type=int>
	"""
	arg = """mid"""
	methodid ="GetSubMaxPidSQL"
	self._manage_createsql(methodid, "", arg, cmd)
	### ###
	cmd = """select MAX(sid)  from imgbbssub
 where mid=<dtml-sqlvar mid type=int>
	"""
	arg = """mid"""
	methodid ="GetSubMaxSidSQL"
	self._manage_createsql(methodid, "", arg, cmd)
	### ###
	cmd = """select * from imgbbsblob
	where (mid=<dtml-sqlvar mid type=int> and pid=<dtml-sqlvar pid type=int> and ptype=<dtml-sqlvar ptype type=string>)"""
	arg = """mid
pid
ptype"""
	methodid ="GetImgIdSQL"
	self._manage_createsql(methodid, "", arg, cmd)
	### ###
	cmd = """insert into imgbbsmain values(
  <dtml-sqlvar  mid   type=int>,
  <dtml-sqlvar  title type=string>,
  <dtml-sqlvar  comment type=string>,
  <dtml-sqlvar  kisya type=string>,
  <dtml-sqlvar  tantousya type=string>,
  <dtml-sqlvar  saveyear  type=int>,
  <dtml-sqlvar  savemonth type=int>,
  <dtml-sqlvar  saveday  type=int>
)"""
	arg = """mid
title
comment
kisya
tantousya
saveyear
savemonth
saveday"""
	methodid ="InsertMainSQL"
	self._manage_createsql(methodid, "", arg, cmd)
	### ###
	cmd = """update imgbbsmain set
mid=<dtml-sqlvar mid type=int>,
title=<dtml-sqlvar title type=string>,
comment=<dtml-sqlvar comment type=string>,
kisya=<dtml-sqlvar kisya type=string>,
tantousya=<dtml-sqlvar tantousya type=string>,
saveyear=<dtml-sqlvar saveyear type=int>,
savemonth=<dtml-sqlvar savemonth type=int>,
saveday=<dtml-sqlvar saveday type=int>
where (mid=<dtml-sqlvar mid type=int>)"""
	arg = """mid
title
comment
kisya
tantousya
saveyear
savemonth
saveday"""
	methodid ="UpdateMainSQL"
	self._manage_createsql(methodid, "", arg, cmd)
	### ###
	cmd = """insert into imgbbssub values(
  <dtml-sqlvar  mid   type=int>,
  <dtml-sqlvar  pid    type=int>,
  <dtml-sqlvar  sid    type=int>,
  <dtml-sqlvar  uname type=string>,
  <dtml-sqlvar  upass  type=string>,
  <dtml-sqlvar  email  type=string>,
  <dtml-sqlvar  subject  type=string>,
  <dtml-sqlvar  comment  type=string>,
  <dtml-sqlvar  sakuseibi  type=string>
)"""
	arg = """mid
pid
sid
uname
upass
email
subject
comment
sakuseibi"""
	methodid ="_InsertSubSQL"
	self._manage_createsql(methodid, "", arg, cmd)
	### ###
	cmd = """update imgbbssub set
mid=<dtml-sqlvar mid type=int>,
pid=<dtml-sqlvar pid type=int>,
sid=<dtml-sqlvar sid type=int>,
uname=<dtml-sqlvar  uname type=string>,
upass=<dtml-sqlvar  upass  type=string>,
email=<dtml-sqlvar  email  type=string>,
subject=<dtml-sqlvar  subject  type=string>,
comment=<dtml-sqlvar comment type=string>,
sakuseibi=<dtml-sqlvar  sakuseibi  type=string>
where (mid=<dtml-sqlvar mid type=int> and pid=<dtml-sqlvar pid type=int>)"""
	arg = """mid
pid
sid
uname
upass
email
subject
comment
sakuseibi"""
	methodid ="_UpdateSubSQL"
	self._manage_createsql(methodid, "", arg, cmd)
	### ###
	cmd = """insert into imgbbsblob set
  <dtml-sqltest mid op="eq" type="int">,
  <dtml-sqltest pid op="eq" type="int">,
  <dtml-sqltest ptype op="eq" type="string">,
  <dtml-sqltest pic op="eq" type="string">,
  <dtml-sqltest contenttype op="eq" type="string">
"""
	arg = """mid
pid
ptype
pic
contenttype"""
	methodid ="_insertMySQL"
	self._manage_createsql(methodid, "", arg, cmd)
	### ###
	cmd = """update imgbbsblob set
  mid=<dtml-sqlvar mid type=int>,
  pid=<dtml-sqlvar pid type=int>,
  ptype=<dtml-sqlvar ptype type=string>,
  pic=<dtml-sqlvar pic type=string>,
  contenttype=<dtml-sqlvar contenttype type=string>
where (imgid=<dtml-sqlvar imgid type=int>)"""
	arg = """imgid
mid
pid
ptype
pic
contenttype
"""
	methodid ="_updateMySQL"
	self._manage_createsql(methodid, "", arg, cmd)
	### ###
	cmd = """insert into imgbbsmail values(
  <dtml-sqlvar mid type="int">,
  <dtml-sqlvar maillist type="string">
)"""
	arg = """mid
maillist"""
	methodid ="_insertmailSQL"
	self._manage_createsql(methodid, "", arg, cmd)
	### ###
	cmd = """update imgbbsmail set
    maillist=<dtml-sqlvar maillist type="string">
    where mid=<dtml-sqlvar mid type="int">
"""
	arg = """mid
maillist"""
	methodid ="_updatemailSQL"
	self._manage_createsql(methodid, "", arg, cmd)
	### ###
	cmd = """select * from imgbbsmail
where mid=<dtml-sqlvar mid type="int">
"""
	arg = """mid"""
	methodid ="_selectmailSQL"
	self._manage_createsql(methodid, "", arg, cmd)



    def _connection_string(self):
        """
	"""
	# PostgrSQL(psycopg)
	if self.selectdb =='p':
            constr = "dbname=%s user=%s " % (self.dbname,self.dbusername)
	    if self.dbpasswd != '':
	      constr = constr + "password=%s " % self.dbpasswd
	    if self.dbhost != '':
	      constr = constr + "host=%s" % self.dbhost
            return constr

	# MySQL
	elif self.selectdb =='m':
            if self.dbhost != '':
               constr = "%s@%s %s %s" % (
	       self.dbname, self.dbhost, self.dbusername, self.dbpasswd)
            else:
               constr = "%s %s %s" % (
	       self.dbname, self.dbusername, self.dbpasswd)
            return constr

	# kinterbasdb(Firebird 1.03 or Interbase 6.x)
	else:
            utf8='UNICODE_FSS'
            euc='EUCJ_0208'
            sjis='SJIS_0208'
            unicodest=euc
            if self.dbcharset =='utf-8':
              unicodest=utf8
            elif self.dbcharset=='shift_jis':
              unicodest = sjis
            if self.dbhost != '':
               constr = "%s:%s %s %s %s" % (
	       self.dbhost, self.dbname,self.dbusername,
	       self.dbpasswd, unicodest)
            else:
               constr = "%s %s %s %s" % (
	       self.dbname, self.dbusername,
	       self.dbpasswd, unicodest)
            return constr



    def __init__(self, id, title, selectdb,dbhost,
      dbusername, dbpasswd,dbname,dbcharset):
        """
	"""
	self.id = id

	#management_page_charset = dbcharset
        self.manage_changeImgBBS(title, selectdb,dbhost,
	dbusername, dbpasswd,dbname,dbcharset,chg=1)



    security.declareProtected( 'Change ImgBBS', 'manage_changeImgBBS' )
    def manage_changeImgBBS(self, title='', selectdb='',
      dbhost='', dbusername='', dbpasswd='', dbname='',
      dbcharset='', chg=None , REQUEST=None):
        """
	"""
	title = str(title)
	selectdb = str(selectdb)
	dbhost = str(dbhost)
	dbusername = str(dbusername)
	dbpasswd = str(dbpasswd)
	dbname = str(dbname)
	dbcharset = str(dbcharset)



        self.title = title
	self.selectdb = selectdb
	self.dbhost = dbhost
	self.dbusername = dbusername
	self.dbpasswd = dbpasswd
	self.dbname = dbname
	self.dbcharset = dbcharset


	if chg==None:
	   self.manage_delObjects(DBCON_ID)
           if selectdb =='p':
               self.manage_addProduct['ZPsycopgDA'].manage_addZPsycopgConnection(
	               DBCON_ID,'', self._connection_string())
           elif selectdb =='m':
	       self.manage_addProduct['ZMySQLDA'].manage_addZMySQLConnection(
	                DBCON_ID,'',self._connection_string())
           else:
	       self.manage_addProduct['kInterbasdbDA'].manage_addKInterbaseConnection(
          DBCON_ID,'',self._connection_string())

        self._manage_createsql_main()

        if REQUEST:
            message="Image BBS %s connected." % self.id
            return self.manage_main(
	    self,REQUEST,manage_tabs_message=message)



    def _mydebug(self, val):
        """
	"""
	fp = open(os.path.join(package_path ,'debug.txt'), 'a')
	fp.write('\n')
	fp.write(val)
	fp.write('\n--------------\n')
	fp.close()



    def _insertsql(self, mid, pid, pic, spic,
      contenttype, sid, uname, upass, email, subject,
      comment, sakuseibi):
        """
	"""
	self._InsertSubSQL(mid=mid, pid=pid, sid=sid,
	  uname=uname, upass=upass, email=email,
	  subject=subject, comment=comment, sakuseibi=sakuseibi)

	if pic == '':
	  return
        constr = self._connection_string()


        if self.selectdb =='p':

          _insertPgSQL(constr, mid, pid, 'S', spic, contenttype)
          _insertPgSQL(constr, mid, pid, 'L', pic, contenttype)


        elif self.selectdb =='m':
	  mid = int(mid)
	  pid = int(pid)
          self._insertMySQL(mid=mid, pid=pid, ptype='S',
	    pic=spic, contenttype=contenttype)
          self._insertMySQL(mid=mid, pid=pid, ptype='L',
	    pic=pic, contenttype=contenttype)

        else:

          _insertIbSQL(constr, mid, pid, 'S', spic, contenttype)
          _insertIbSQL(constr, mid, pid, 'L', pic, contenttype)




    def _updatesql(self, mid, pid, pic, spic, contenttype,
      sid, uname, upass, email, subject, comment, sakuseibi):
        """
	"""
	self._UpdateSubSQL(mid=mid, pid=pid, sid=sid,
	  uname=uname, upass=upass, email=email,
	  subject=subject, comment=comment,
	  sakuseibi=sakuseibi)
	if pic =='':
	  return
        constr = self._connection_string()
	imgid_s = self.GetImgIdSQL(mid=mid,pid=pid,ptype='S')
	imgid_l = self.GetImgIdSQL(mid=mid,pid=pid,ptype='L')
	if self.selectdb == 'p':
          _updatePgSQL(constr, imgid_s[0].imgid,
	    mid, pid, 'S', spic, contenttype)
	  _updatePgSQL(constr, imgid_l[0].imgid,
	    mid, pid, 'L', pic, contenttype)
	elif self.selectdb == 'm':
	  mid=int(mid)
	  pid=int(pid)
          self._updateMySQL(imgid=imgid_s[0].imgid,
	    mid=mid, pid=pid, ptype='S', pic=spic,
	    contenttype=contenttype)
	  self._updateMySQL(imgid=imgid_l[0].imgid,
	    mid=mid, pid=pid, ptype='L', pic=pic,
	    contenttype=contenttype)
	else:
          _updateIbSQL(constr, imgid_s[0].imgid, mid,
	    pid, 'S', spic, contenttype)
	  _updateIbSQL(constr, imgid_l[0].imgid, mid,
	    pid,  'L', pic, contenttype)



    def InsertSubSQL(self,  infile, mid, pid, sid, uname,
      upass, email, subject, comment='', sakuseibi='',
      xsize=128, ysize=128):
        """
	"""

        if hasattr(infile,'filename'):
            filename = infile.filename
        else:
            filename = infile.name
        infile.seek(0,2)
        contentsize = infile.tell()
        infile.seek(0,0)
        imgobj = infile.read(contentsize)
        contenttype = string.split(guess_content_type(filename)[0], "/")[1]


        outputfile = tempfile.mktemp()
	#outputfile = StringIO()
        outputfile1 = tempfile.mktemp()
        outputfile2 = tempfile.mktemp()
        outfile = open(outputfile,'wb')
        #outputfile.write(imgobj)
	outfile.write(imgobj)
        outfile.close()

        bmp_flg = None
        if contenttype=='bmp' or contenttype=='BMP':
          contenttype = 'jpeg'
          bmp_flg = 1
          lgimg = Image.open(outputfile)
          lgimg.save(outputfile1,'JPEG')
          objIn = open(outpufile1,'rb').read()
        else:
          objIn = open(outputfile,'rb').read()


        tsimg = Image.open(outputfile)
        tsimg = tsimg.convert('RGB')
        tsimg.thumbnail((xsize,ysize))
        tsimg.save(outputfile2,'JPEG')
        sobjIn = open(outputfile2,'rb').read()


	self._insertsql(mid, pid, objIn,sobjIn,
	  contenttype, sid, uname, upass, email,
	  subject, comment, sakuseibi)

        os.remove(outputfile)
        if bmp_flg:
          os.remove(outputfile1)
        os.remove(outputfile2)



    def UpdateSubSQL(self, mid, pid, imgobj, contenttype,
      sid, uname, upass, email, subject, comment, sakuseibi,
      xsize=128,ysize=128):
        """
	"""
        outputfile = tempfile.mktemp()
        outputfile2 = tempfile.mktemp()
        outputfile.write(imgobj)
        objIn = open(outputfile,'rb').read()

        tsimg = Image.open(outputfile)
        tsimg = tsimg.convert('RGB')
        tsimg.thumbnail((xsize,ysize))
        tsimg.save(outputfile2,'JPEG')
        sobjIn = open(outputfile2,'rb').read()
        self._updatesql(mid, pid, objIn, sobjIn, contenttype,
	  sid, uname, upass, email, subject, comment, sakuseibi)
        os.remove(outputfile)
        os.remove(outputfile2)


    def MaxMainId(self):
        """
	"""
	results = self.GetMainMaxIdSQL()
	maxid = None
	for row in results:
	  maxid = row[0]
	if maxid == None:
	  maxid = 0
	maxid = int(maxid) + 1
        return maxid

    def pyaddNewmain(self, mid='', title='', kisya='', comment='', tantousya=''):
        """
	"""
	if title=='' or comment=='':
           return MessageDialog(
	      title=conv('ϥ顼', self.dbcharset),
	      message=conv("ȥȤɬܤǤ", self.dbcharset),
	      action = self.absolute_url())

	if not mid:
           mid = MaxMainId()
        maxid = int(mid)
	try:
	  syear = '%s' % (DateTime().year())
	  smonth = '%2s' % string.zfill(DateTime().month(),2)
	  sday = '%2s' % string.zfill(DateTime().day(),2)

	  self.InsertMainSQL(mid=maxid, title=title,
	    comment=comment, kisya=kisya, tantousya=tantousya,
	    saveyear=int(syear), savemonth=int(smonth), saveday=int(sday))

	  self.REQUEST.RESPONSE.redirect(self.absolute_url())
	except:
	   return MessageDialog(
	      title=conv("񤭹ߥ顼", self.dbcharset),
	      message=conv("ǡ١ν񤭹ߤ˼Ԥޤ", self.dbcharset),
	      action = self.absolute_url())


    def maildelete(self, REQUEST=None):
        """
	"""
	retHTML="""%s""" % (self.absolute_url())
	if REQUEST is None:
	  return
	mid = REQUEST.form['mid']
	passwd = REQUEST.form['passwd']
	email = REQUEST.form['email']
	if (not mid) or (not email) or (not passwd) or (not REQUEST.has_key('_IMGBBS_PASSWD') ):
	  return
        sessionpasswd = str(REQUEST['_IMGBBS_PASSWD'])

	if (str(passwd)<>sessionpasswd):
	    messt ="""Ǥޤ󡢴ԤޤϢƲ """ 
            return MessageDialog(
	      title=conv('顼', self.dbcharset),
	      message=conv(messt, self.dbcharset),
	      action = retHTML)


	mid = int(mid)
	mlist = self._selectmailSQL(mid=mid)
	slist = mlist[0].maillist
	if string.find(slist, ",") != -1:
	  splist = string.split(slist,',')
	else:
	  splist = None

	emaillist = ''
        if splist:
          for l in splist:
	   if l <> email:
	     if emaillist:
	       emaillist = emaillist + ',%s' % l
	     else:
               emaillist = '%s' % l
        else:
	  if slist <> email:
            emaillist = slist

	try:
	  #if emaillist:
          self._updatemailSQL(mid=mid, maillist=emaillist)
	  messt = "%s ͭ񤦤ޤ" % (email)
          return MessageDialog(
	      title=conv('', self.dbcharset),
	      message=conv(messt, self.dbcharset),
	      action = retHTML)

	except:
	  messt ="""**顼ȯޤ**"""
          return MessageDialog(
	      title=conv('顼', self.dbcharset),
	      message=conv(messt, self.dbcharset),
	      action = retHTML)



    def _sendmail(self,mid, pid, comment, uname, email, subject, mailchk):
        """
	"""
	mid = int(mid)
	pid = int(pid)

	mlist = self._selectmailSQL(mid=mid)
	emaillist = self.getProperty('admin_address')


	if len(mlist) <= 0:
            self._insertmailSQL(mid=mid, maillist='')
	    if mailchk:
	      self._updatemailSQL(mid=mid, maillist=email)
        else:
          slist = mlist[0].maillist
	  splist = string.split(slist,',')
	  flg=0
	  for l in splist:
	    if l == email:
	      flg =1
	      break;

          if slist:
	    emaillist = emaillist + ",%s" % slist
	  if not flg:
	    if slist:
	      slist = slist + ',%s' % email
	    else:
              slist = '%s' % email
	  if mailchk:
	    self._updatemailSQL(mid=mid, maillist=slist)

	retHTML="""%s/indexsub_html?mid=%s""" % (self.absolute_url(),mid)
	#for onemail in emaillist:
        try:
	    mailhost = self.mailhost
	    mail = self.mail_html(self,self.REQUEST,mid=mid,pid=pid,
	       EmailList=emaillist, comment=comment,
	       uname=uname,subject=subject)
	    messt = "%s ͭ񤦤ޤ" % uname
            return MessageDialog(
	      title=conv('', self.dbcharset),
	      message=conv(messt, self.dbcharset),
	      action = retHTML)

	except:
	    messt ="""**顼ȯޤ**"""
            return MessageDialog(
	      title=conv('顼', self.dbcharset),
	      message=conv(messt, self.dbcharset),
	      action = retHTML)




    def pyaddNewsub(self, mid='', comment='', uname='',
       upass='', email='', subject='', mailchk='', ImgFile=''):
        """
	"""
	if mid=='' or comment=='':
          return MessageDialog(
	      title=conv('ϥ顼', self.dbcharset),
	      message=conv("ȥȤɬܤǤ", self.dbcharset),
	      action = self.absolute_url())


	presults = self.GetSubMaxPidSQL(mid=mid)
	sresults=self.GetSubMaxSidSQL(mid=mid)

	maxpid = None
	for prow in presults:
	  maxpid = prow[0]
	for srow in sresults:
	  maxsid = srow[0]
	if maxpid == None:
	  maxpid = 0
	  maxsid = 0

	maxpid = int(maxpid) + 1
	maxsid = int(maxsid) + self.SkipRow

        RETHTML = '%s/indexsub_html?mid=%s' % (self.absolute_url(),mid)
        nowdate = '%s/%2s/%2s %2s:%2s' % (
	  DateTime().year(),string.zfill(DateTime().month(),2),
	  string.zfill(DateTime().day(),2),string.zfill(DateTime().hour(),2),
	  string.zfill(DateTime().minute(),2)
	  )

	try:
	  if ImgFile.filename=='':
	    self._InsertSubSQL(mid=mid, pid=maxpid,
	      sid=maxsid, uname=uname, upass=upass,
	      email=email,subject=subject,
	      comment=comment, sakuseibi=nowdate)


	  else:
	    self.InsertSubSQL(infile=ImgFile, mid=mid,
	      pid=maxpid, sid=maxsid,  uname=uname,
	      upass=upass, email=email,subject=subject,
	      comment=comment, sakuseibi=nowdate)

	  #self.REQUEST.RESPONSE.redirect(RETHTML)
	except:

	  return MessageDialog(
	      title=conv("񤭹ߥ顼", self.dbcharset),
	      message=conv(
	        "ǡ١ν񤭹ߤ˼Ԥޤ", self.dbcharset),
		action = RETHTML)


	if self.getProperty('IsMail',0)<>0:
	  self._sendmail(mid=mid, pid=maxpid,
	    comment=comment, uname=uname, email=email,
	    subject=subject, mailchk=mailchk)

	self.REQUEST.RESPONSE.redirect(RETHTML)



    def pydeletesub(self, mid='', pid='', retHTML=''):
        """
	"""
	self.DeleteSubEntrySQL(mid=mid,pid=pid)
	self.DeleteImgSQL(mid=mid,pid=pid, ptype='S')
	self.DeleteImgSQL(mid=mid,pid=pid, ptype='L')
	self.REQUEST.RESPONSE.redirect(retHTML)



    def pyfetchone(self, mid='',pid=''):
        """
	"""
	phote = self.GetImgIdSQL(mid=int(mid), pid=int(pid), ptype='S')
	#if len(phote) >= 0:
	#  return None

	self.REQUEST.RESPONSE.setHeader(
	   'content-type', 'image/' + phote[0].contenttype)
	return phote[0].pic



    def pylargefetchone(self, mid='', pid=''):
        """
	"""
	phote = self.GetImgIdSQL(mid=int(mid), pid=int(pid), ptype='L')
	#if len(phote) <= 0:
	#  return None
	self.REQUEST.RESPONSE.setHeader(
	   'content-type', 'image/' + phote[0].contenttype)
	return phote[0].pic



    def pyShowInpSession(self):
        """
	"""
	session = self.REQUEST.SESSION
	if session.get("Set_Inp_Show", None) == None:
	  session.set("Set_Inp_Show", 1)
	else:
	  session.set("Set_Inp_Show", None)
	self.REQUEST.RESPONSE.redirect(self.absolute_url())



    def pyupdatemain(self,mid, title, comment, kisya,
      tantousya, saveyear, savemonth, saveday, retHTML):
        """
	"""
	upmainSQL = self.UpdateMainSQL
	response = self.REQUEST.RESPONSE
	upmainSQL(mid =mid, title=title,
          comment=comment,kisya=kisya,tantousya=tantousya,
          saveyear=saveyear,savemonth=savemonth,saveday=saveday)
	response.redirect(retHTML)



    def pyupdatesub(self, mid, pid, sid, uname, upass,
      email, subject, comment, sakuseibi, retHTML):
        """
	"""
	response = self.REQUEST.RESPONSE
	upSQL = self._UpdateSubSQL
	Mid = int(mid)
	Pid = int(pid)
	Sid = int(sid)

	upSQL(mid=Mid, pid=Pid, sid=Sid, uname=uname,
	  upass=upass, email=email, subject=subject,
	  comment=comment, sakuseibi=sakuseibi)
	response.redirect(retHTML)



    def _set_cookie(self, aname, aval, side=365):
        """
	"""
	cokie = self.REQUEST.RESPONSE.setCookie
        cookie_side=(DateTime()+int(side)).rfc822()
	#if side:
	#  cookie_side=(DateTime()+int(side)).rfc822()
	#else:
	#  cookie_side=(DateTime()+365).rfc822()
	cokie(name=aname,value=aval,expires=cookie_side)



    def set_cookie(self):
        """
	"""
	response = self.REQUEST.RESPONSE
        slide_id = self.REQUEST.form['uname']
	slide_pass = self.REQUEST.form['upass']
	slide_email = self.REQUEST.form['email']

	self._set_cookie('_IMGBBS_ID', slide_id)
	self._set_cookie('_IMGBBS_PASSWD', slide_pass)
	self._set_cookie('_IMGBBS_EMAIL', slide_email)

	return MessageDialog(
	      title=conv('Ŀ', self.dbcharset),
	      message=conv("괰λޤ", self.dbcharset),
	      action = self.absolute_url())



    def retconv(self, st):
        """
	"""
	return conv(st, self.dbcharset)

    def catjpstring(self, st, length):
        """
	"""
	return get_string_part(st, length, self.dbcharset)
