/* -*- Mode: C; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 4 -*- */
/* $Id: test-reparent.c,v 1.2 2003/07/24 12:02:37 makeinu Exp $ */


#include <string.h>
#include <gtk/gtk.h>


static GtkWidget *win1 = NULL, *win2 = NULL, *win3 = NULL;
static GtkWidget *entry = NULL;


GtkTargetEntry dnd_types[] = {
   {"TEST_REPARENT", 0, 0},
};
const gint dnd_types_num = sizeof(dnd_types) / sizeof(GtkTargetEntry);


#define DRAG_DEST_SET(widget) \
{ \
    gtk_drag_dest_set(widget, \
                      GTK_DEST_DEFAULT_ALL, \
                      dnd_types, dnd_types_num, \
                      GDK_ACTION_ASK  | GDK_ACTION_COPY | \
                      GDK_ACTION_MOVE | GDK_ACTION_LINK); \
    g_signal_connect (G_OBJECT (widget), "drag_data_received", \
                      G_CALLBACK (drag_data_received_cb), NULL); \
}


static void
drag_data_get_cb (GtkWidget *widget,
                  GdkDragContext *context,
                  GtkSelectionData *seldata,
                  guint info,
                  guint time,
                  gpointer data)
{
    const gchar *str = "dummy";
    gtk_selection_data_set(seldata, seldata->target,
                           8, str, strlen(str));
}


static void
drag_data_received_cb (GtkWidget *widget,
                       GdkDragContext *context,
                       gint x, gint y,
                       GtkSelectionData *seldata,
                       guint info,
                       guint32 time,
                       gpointer data)
{
    GtkWidget *src_widget = gtk_drag_get_source_widget (context);

    gtk_widget_reparent (src_widget, widget);
    gtk_widget_grab_focus (src_widget);
}


/*
 *  initial window
 */
static GtkWidget *
create_window1 (void)
{
    GtkWidget *window, *hbox;

    window = gtk_window_new (GTK_WINDOW_TOPLEVEL);
    gtk_window_move (GTK_WINDOW (window), 10, 50);
    gtk_window_resize (GTK_WINDOW (window), 150, 150);

    hbox = gtk_hbox_new (FALSE, 0);
    gtk_container_add (GTK_CONTAINER (window), hbox);
    gtk_widget_show (hbox);
    DRAG_DEST_SET (hbox);

    entry = gtk_entry_new ();
    gtk_box_pack_start (GTK_BOX (hbox), entry, TRUE, TRUE, 0);
    gtk_widget_show (entry);
    gtk_drag_source_set(entry,
                        GDK_BUTTON1_MASK | GDK_BUTTON2_MASK | GDK_BUTTON3_MASK,
                        dnd_types, dnd_types_num,
                        GDK_ACTION_ASK  | GDK_ACTION_COPY |
                        GDK_ACTION_MOVE | GDK_ACTION_LINK);
    g_signal_connect (G_OBJECT (entry), "drag_data_get",
                      G_CALLBACK (drag_data_get_cb), NULL);

    gtk_widget_show (window);

    return window;
}


/*
 *  with GtkVPaned
 */
static GtkWidget *
create_window2 (void)
{
    GtkWidget *window, *vpaned, *hbox;

    window = gtk_window_new (GTK_WINDOW_TOPLEVEL);
    gtk_window_move (GTK_WINDOW (window), 210, 50);
    gtk_window_resize (GTK_WINDOW (window), 150, 150);

    vpaned = gtk_vpaned_new ();
    gtk_container_add (GTK_CONTAINER (window), vpaned);
    gtk_widget_show (vpaned);

    hbox = gtk_hbox_new (FALSE, 0);
    gtk_paned_add1 (GTK_PANED (vpaned), hbox);
    gtk_widget_show (hbox);
    DRAG_DEST_SET (hbox);

    hbox = gtk_hbox_new (FALSE, 0);
    gtk_paned_add2 (GTK_PANED (vpaned), hbox);
    gtk_widget_show (hbox);
    DRAG_DEST_SET (hbox);

    gtk_widget_show (window);

    return window;
}


/*
 *  with GtkHandleBox
 */
static GtkWidget *
create_window3 (void)
{
    GtkWidget *window, *handle, *hbox;

    window = gtk_window_new (GTK_WINDOW_TOPLEVEL);
    gtk_window_move (GTK_WINDOW (window), 410, 50);
    gtk_window_resize (GTK_WINDOW (window), 150, 150);
 
    handle = gtk_handle_box_new ();
    gtk_container_add (GTK_CONTAINER (window), handle);
    gtk_widget_show (handle);

    hbox = gtk_hbox_new (FALSE, 0);
    gtk_container_add (GTK_CONTAINER (handle), hbox);
    gtk_widget_show (hbox);
    DRAG_DEST_SET (hbox);

    gtk_widget_show (window);

    return window;
}


static void
destroy_window_cb (GtkWidget *widget, gpointer data)
{
    GtkWindow **window = data;

    if (window)
        *window = NULL;

    if (!win1 && !win2 && ! win3)
        gtk_main_quit ();
}


int
main (int argc, char *argv[])
{
    gtk_set_locale ();
    gtk_init (&argc, &argv);

    win1 = create_window1 ();
    win2 = create_window2 ();
    win3 = create_window3 ();

    g_signal_connect (G_OBJECT (win1), "destroy",
                      G_CALLBACK (destroy_window_cb), &win1);
    g_signal_connect (G_OBJECT (win2), "destroy",
                      G_CALLBACK (destroy_window_cb), &win2);
    g_signal_connect (G_OBJECT (win3), "destroy",
                      G_CALLBACK (destroy_window_cb), &win3);

    gtk_main ();

    return 0;
}
