/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.imodoki.extractor;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import jp.sourceforge.imodoki.extractor.ClassPattern;
import jp.sourceforge.imodoki.extractor.ClassUtils;
import jp.sourceforge.imodoki.extractor.LinkageException;
import jp.sourceforge.imodoki.extractor.Mark;
import jp.sourceforge.imodoki.extractor.Marker;
import jp.sourceforge.imodoki.extractor.Remover;
import jp.sourceforge.imodoki.extractor.Repository;
import org.apache.bcel.classfile.Field;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.classfile.Method;

public class Extractor {
    private Repository m_repository;
    private ClassPattern m_includePattern;
    private Mark m_mark;
    private Marker m_marker;
    private JavaClass[] m_result;
    private PrintStream m_logStream;
    private boolean m_verbose;
    static /* synthetic */ Class class$jp$sourceforge$imodoki$extractor$Extractor;

    public Extractor(String classPath, ClassPattern includePattern) {
        this.m_repository = new Repository(classPath);
        this.m_includePattern = includePattern;
        this.m_mark = new Mark();
        this.m_marker = new Marker(this.m_repository, this.m_includePattern, this.m_mark);
        this.m_logStream = null;
        this.m_verbose = false;
    }

    public void preserveMethod(String className, String name, String signature) throws IOException, LinkageException {
        this.m_marker.preserveMethod(className, name, signature);
    }

    public void preserveMethod(String spec) throws IOException, LinkageException {
        int idx = spec.lastIndexOf(46);
        if (idx == -1) {
            throw new LinkageException("Bad method spec: " + spec);
        }
        int idx2 = spec.indexOf(40);
        if (idx2 == -1) {
            throw new LinkageException("Bad method spec: " + spec);
        }
        String className = spec.substring(0, idx);
        String name = spec.substring(idx + 1, idx2);
        String signature = spec.substring(idx2);
        this.preserveMethod(className, name, signature);
    }

    public void preserveField(String className, String name) throws IOException, LinkageException {
        this.m_marker.preserveField(className, name);
    }

    public void preserveField(String spec) throws IOException, LinkageException {
        int idx = spec.lastIndexOf(46);
        if (idx == -1) {
            throw new LinkageException("Bad field spec: " + spec);
        }
        String className = spec.substring(0, idx);
        String name = spec.substring(idx + 1);
        this.preserveField(className, name);
    }

    public void process() throws IOException, LinkageException {
        this.m_marker.postProcess();
        this.log("Removing ...");
        Remover remover = new Remover(this.m_mark);
        ArrayList<JavaClass> result = new ArrayList<JavaClass>();
        JavaClass[] classes = this.m_repository.getClasses();
        int i = 0;
        while (i < classes.length) {
            JavaClass clazz = classes[i];
            String className = clazz.getClassName();
            if (this.m_includePattern.matches(className)) {
                if (this.m_verbose) {
                    this.logProcess(clazz);
                }
                result.add(remover.processClass(clazz));
            }
            ++i;
        }
        this.m_mark.clear();
        this.m_repository.close();
        this.m_result = result.toArray(new JavaClass[0]);
    }

    public JavaClass[] getJavaClasses() {
        return this.m_result;
    }

    public void dumpToDirectory(File dir) throws IOException {
        JavaClass[] classes = this.getJavaClasses();
        int i = 0;
        while (i < classes.length) {
            JavaClass clazz = classes[i];
            String pathName = clazz.getClassName().replace('.', File.separatorChar) + ".class";
            File path = new File(dir, pathName);
            File parent = path.getParentFile();
            if (!parent.exists() && !parent.mkdirs()) {
                throw new IOException("mkdirs() failed: " + parent);
            }
            clazz.dump(path);
            ++i;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dumpToZipFile(File file, int compressionLevel) throws IOException {
        JavaClass[] classes = this.getJavaClasses();
        Arrays.sort(classes, new Comparator(){

            public int compare(Object o1, Object o2) {
                return ((JavaClass)o1).getClassName().compareTo(((JavaClass)o2).getClassName());
            }
        });
        ZipOutputStream zos = new ZipOutputStream(new FileOutputStream(file));
        zos.setLevel(compressionLevel);
        try {
            int i = 0;
            while (i < classes.length) {
                JavaClass clazz = classes[i];
                String pathName = clazz.getClassName().replace('.', '/') + ".class";
                ZipEntry entry = new ZipEntry(pathName);
                zos.putNextEntry(entry);
                zos.write(clazz.getBytes());
                zos.closeEntry();
                ++i;
            }
            Object var10_9 = null;
        }
        catch (Throwable throwable) {
            Object var10_10 = null;
            zos.close();
            throw throwable;
        }
        zos.close();
    }

    public void dumpToZipFile(File file) throws IOException {
        this.dumpToZipFile(file, -1);
    }

    public void setLogStream(PrintStream stream) {
        this.m_logStream = stream;
    }

    public void setVerbose(boolean flag) {
        this.m_verbose = flag;
    }

    private void logProcess(JavaClass clazz) {
        if (this.m_logStream == null) {
            return;
        }
        String className = clazz.getClassName();
        this.log("Including Class: " + className);
        Method[] methods = clazz.getMethods();
        int j = 0;
        while (j < methods.length) {
            Method method = methods[j];
            if (!this.m_mark.isMethodMarked(className, method.getName(), method.getSignature())) {
                this.log("Removing method: " + method.getName() + ClassUtils.canonicalizeMethodSignature(method.getSignature()));
            }
            ++j;
        }
        Field[] fields = clazz.getFields();
        int j2 = 0;
        while (j2 < fields.length) {
            Field field = fields[j2];
            if (!this.m_mark.isFieldMarked(className, field.getName())) {
                this.log("Removing field: " + field.getName());
            }
            ++j2;
        }
    }

    private void log(String mesg) {
        if (this.m_logStream != null) {
            this.m_logStream.println(mesg);
        }
    }

    public static void main(String[] args_ary) throws IOException {
        String classPath = ".";
        String output = null;
        ArrayList includePackages = new ArrayList();
        ArrayList includeClasses = new ArrayList();
        ArrayList preserves = new ArrayList();
        boolean verbose = false;
        List<String> args = Arrays.asList(args_ary);
        Iterator<String> i = args.iterator();
        while (i.hasNext()) {
            String arg = i.next();
            if (arg.charAt(0) == '-') {
                if (arg.equals("-classpath")) {
                    classPath = Extractor.requireNextArg(i, arg);
                    continue;
                }
                if (arg.equals("-output")) {
                    output = Extractor.requireNextArg(i, arg);
                    continue;
                }
                if (arg.equals("-includepackage") || arg.equals("-includepkg")) {
                    includePackages.addAll(Extractor.split(Extractor.requireNextArg(i, arg), ","));
                    continue;
                }
                if (arg.equals("-includeclass") || arg.equals("-includecls")) {
                    includeClasses.addAll(Extractor.split(Extractor.requireNextArg(i, arg), ","));
                    continue;
                }
                if (arg.equals("-preserve")) {
                    preserves.addAll(Extractor.split(Extractor.requireNextArg(i, arg), ","));
                    continue;
                }
                if (arg.equals("-verbose")) {
                    verbose = true;
                    continue;
                }
                System.err.println("Unrecognized option: " + arg);
                System.exit(1);
                continue;
            }
            System.err.println("Unrecognized argument: " + arg);
            System.exit(1);
        }
        if (output == null || preserves.isEmpty()) {
            System.err.println("usage: java " + (class$jp$sourceforge$imodoki$extractor$Extractor == null ? (class$jp$sourceforge$imodoki$extractor$Extractor = Extractor.class$("jp.sourceforge.imodoki.extractor.Extractor")) : class$jp$sourceforge$imodoki$extractor$Extractor).getName() + " [-classpath path] [-includepkg package,...]" + " [-includecls class,...]" + " [-preserve method|field] [-output dir|zip]" + " [-verbose]");
            System.exit(1);
        }
        ClassPattern includePattern = new ClassPattern();
        Iterator itr = includePackages.iterator();
        while (itr.hasNext()) {
            includePattern.addPackagePattern((String)itr.next());
        }
        Iterator itr2 = includeClasses.iterator();
        while (itr2.hasNext()) {
            includePattern.addClassPattern((String)itr2.next());
        }
        Extractor extr = new Extractor(classPath, includePattern);
        extr.setLogStream(System.out);
        extr.setVerbose(verbose);
        extr.log("Marking ...");
        Iterator itr3 = preserves.iterator();
        while (itr3.hasNext()) {
            String item = (String)itr3.next();
            if (item.indexOf(40) != -1) {
                extr.preserveMethod(item);
                continue;
            }
            extr.preserveField(item);
        }
        extr.process();
        String out = output.toLowerCase();
        if (out.endsWith(".zip") || out.endsWith(".jar")) {
            extr.dumpToZipFile(new File(output));
        } else {
            extr.dumpToDirectory(new File(output));
        }
    }

    private static String requireNextArg(Iterator itr, String option) {
        if (!itr.hasNext()) {
            System.err.println("Missing argument: " + option);
            System.exit(1);
        }
        return (String)itr.next();
    }

    public static List split(String str, String delim) {
        StringTokenizer st = new StringTokenizer(str, delim);
        ArrayList<String> list = new ArrayList<String>(st.countTokens());
        while (st.hasMoreTokens()) {
            list.add(st.nextToken());
        }
        return list;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

