/*
 * $Id: Connector.java,v 1.5 2003/04/06 01:50:46 ymakise Exp $
 */

/*
 * ΥեΥ饤󥹤ϰʲΤ褦 BSD 饤󥹤˽򤷤ޤ
 * 㳰ȤơiɤѴġˤäѴ줿Ѵ
 *  MIDP ץꥱղä줿󥿥饤֥ΥХʥ
 * ˤĤƤϡiɤԤϤʤ븢ĥʤΤȤޤ
 *
 * Copyright (c) 2002-2003, MAKISE Yoshitaro
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above
 *    copyright notice, this list of conditions and the following
 *    disclaimer in the documentation and/or other materials provided
 *    with the distribution.
 *
 * 3. Neither the name of the iModoki nor the names of its
 *    contributors may be used to endorse or promote products derived
 *    from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS
 * FOR A PARTICULAR PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE
 * COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
 * STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED
 * OF THE POSSIBILITY OF SUCH DAMAGE.
 */

package imodoki.wrapper;

import java.io.*;
import javax.microedition.io.Connection;
import javax.microedition.io.InputConnection;
import javax.microedition.io.OutputConnection;

/**
 * javax.microedition.io.Connector Υåѡ
 */
public class Connector {
    public static final int READ       = javax.microedition.io.Connector.READ;
    public static final int WRITE      = javax.microedition.io.Connector.WRITE;
    public static final int READ_WRITE = javax.microedition.io.Connector.READ_WRITE;

    public static Connection open(String name) throws IOException {
        return open(name, READ_WRITE, false);
    }

    public static Connection open(String name, int mode) throws IOException {
        return open(name, mode, false);
    }

    public static Connection open(String name, int mode, boolean timeouts)
        throws IOException {
        if (name.startsWith("resource://")) {
//#STRICTER_ERROR_CHECKING{
            if (mode != READ) {
                throw new IllegalArgumentException();
            }
//#STRICTER_ERROR_CHECKING}
            return new ResourceInputConnection(name.substring(11));
        }
//#USE_SCRATCHPAD_CONNECTION{
        else if (name.startsWith("scratchpad://")) {
            return new ScratchPadStreamConnection(name.substring(13));
        }
//#USE_SCRATCHPAD_CONNECTION}
//#USE_HTTP_CONNECTION{
        else if (name.startsWith("http://") ||
                 name.startsWith("https://")) {
            return new com.nttdocomo.io.HttpConnectionImpl(
                (javax.microedition.io.HttpConnection)
                  javax.microedition.io.Connector.open(name, mode, timeouts)
            );
        }
//#USE_HTTP_CONNECTION}
        else {
            return javax.microedition.io.Connector.open(name, mode, timeouts);
        }
    }

    public static DataInputStream openDataInputStream(String name)
        throws IOException {
        InputConnection conn = (InputConnection)open(name, READ);
        return conn.openDataInputStream();
    }

    public static DataOutputStream openDataOutputStream(String name)
        throws IOException {
        OutputConnection conn = (OutputConnection)open(name, WRITE);
        return conn.openDataOutputStream();
    }

    public static InputStream openInputStream(String name)
        throws IOException {
        InputConnection conn = (InputConnection)open(name, READ);
        return conn.openInputStream();
    }

    public static OutputStream openOutputStream(String name)
        throws IOException {
        OutputConnection conn = (OutputConnection)open(name, WRITE);
        return conn.openOutputStream();
    }
}
