<?php
/*
 * $Horde: turba/advanced.php,v 1.15.2.9 2002/05/27 03:04:21 chuck Exp $
 *
 * Turba: Copyright 2000-2002 Charles J. Hagenbuch <chuck@horde.org>
 *        Copyright 2000-2002 Alcove, Christian Couder <christian@alcove.fr>
 *
 * You should have received a copy of the GNU Public
 * License along with this package; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

define('TURBA_BASE', dirname(__FILE__));
require_once TURBA_BASE . '/lib/base.php';
require_once TURBA_BASE . '/lib/Source.php';
require TURBA_BASE . '/config/attributes.php';

$title = _("Advanced Search");
$js_onLoad = null;
require TURBA_TEMPLATES . '/common-header.inc';

// Make sure the search session variable is registered in the session,
// and obtain a global-scope reference to it.
if (!session_is_registered('turba_search_results')) {
    $turba_search_results = null;
    $HTTP_SESSION_VARS['turba_search_results'] = &$turba_search_results;

    session_register('turba_search_results');
} else {
    if (!isset($turba_search_results)) {
        $turba_search_results = &$HTTP_SESSION_VARS['turba_search_results'];
    }
    if (Horde::getFormData('clear')) {
        $turba_search_results = null;
    } elseif (!empty($turba_search_results)) {
        require_once TURBA_BASE . '/lib/List.php';
        require_once TURBA_BASE . '/lib/Object.php';
        $turba_search_results = Turba_List::unserialize($turba_search_results);
    }
}

/* run search if there is one */
$source = Horde::getFormData('source');
if (!isset($source) && isset($cfgSources) && is_array($cfgSources) && count($cfgSources) > 0) {
    reset($cfgSources);
    $source = key($cfgSources);
}

/* Build the directory sources select widget. */
if (count($cfgSources) > 1) {
    $source_options  = '<tr><td class="light" align="right"><b>' . _("Directory") . '</b></td>';
    $source_options .= '<td align="left"><select name="source" onchange="dirsearch.submit()">';
    foreach ($cfgSources as $key => $entry) {
        $selection = (isset($source) && $source == $key) ? ' selected="selected"' : '';
        $source_options .= "<option value=\"$key\"$selection>";
        $source_options .= $entry['title'] . "</option>\n";
    }
    $source_options .= '</select></td></tr>';
} else {
    $source_options = '<input type="hidden" name="source" value="';
    reset($cfgSources);
    $source_options .= key($cfgSources);
    $source_options .= '" />';
}

$driver = &Turba_Source::singleton($source, $cfgSources[$source]);
if (PEAR::isError($driver)) {
    Horde::raiseMessage(_("Failed to connect to the specified directory."), HORDE_ERROR);
    $map = array();
} else {
    $map = $driver->getCriteria();

    $criteria = array();
    foreach ($map as $key => $value) {
        if ($key != '__key') {
            $val = Horde::getFormData($key);
            if (!empty($val)) {
                $criteria[$key] = $val;
            }
        }
    }

    if (count($criteria)) {
        if (is_object($results = $driver->search($criteria))) {
            if (!is_object($turba_search_results)) {
                $turba_search_results = new Turba_List();
            }
            $turba_search_results->merge($results);
        } else {
            Horde::raiseMessage(sprintf(_("Failed to search the directory: %s"), ''), HORDE_ERROR);
        }
    }
}

// Read the columns to display from the preferences
$sources = Turba::string2Columns($GLOBALS['prefs']->getValue('columns'));
$columns = isset($sources[$source]) ? $sources[$source] : array();
$width = floor(100 / (count($columns) + 1));

// has to be after for wap
require TURBA_BASE . '/menu.php';
require TURBA_BASE . '/status.php';
require TURBA_TEMPLATES . '/advanced/head.inc';

foreach ($map as $name => $v) {
    if ($name != '__owner') {
        include TURBA_TEMPLATES . '/advanced/criteria.inc';
    }
}

$addresses = Horde::getFormData('addresses');
if (is_object($turba_search_results) && $turba_search_results->count() > 0) {
    include TURBA_TEMPLATES . '/advanced/results_head.inc';
}

$numDisplayed = 0;
if (is_object($turba_search_results) && $turba_search_results->count() > 0) {
    include_once TURBA_BASE . '/lib/ListView.php';
    $display = new Turba_ListView($turba_search_results, TURBA_TEMPLATES . '/search/row.inc');
    $numDisplayed = $display->display();
    $turba_search_results = $turba_search_results->serialize();
}

require TURBA_TEMPLATES . '/advanced/foot.inc';

if (!$browser->hasFeature('wml')) {
    $registry->shutdown();
}

require TURBA_TEMPLATES . '/common-footer.inc';

?>
