<?php
/*
 * $Horde: turba/editobjectaction.php,v 1.7.2.3 2002/03/08 17:50:47 chuck Exp $
 *
 * Turba: Copyright 2000-2002 Charles J. Hagenbuch <chuck@horde.org>
 *
 * You should have received a copy of the GNU Public
 * License along with this package; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

define('TURBA_BASE', dirname(__FILE__));
require_once TURBA_BASE . '/lib/base.php';
require_once TURBA_BASE . '/lib/Source.php';
require TURBA_BASE . '/config/attributes.php';

$source = Horde::getFormData('source');
$driver = &Turba_Source::singleton($source, $cfgSources[$source]);

$edited_object = Horde::getFormData('object');
$object = $driver->getObject($edited_object['__key']);

foreach ($edited_object as $key => $value) {
    if ($key != '__key') {
        if ($attributes[$key]['type'] == 'date') {
            if ($value['month'] == '' || $value['day'] == '' || $value['year'] == '') {
                $value = null;
            } else {
                $value = mktime(0, 0, 0, $value['month'], $value['day'], $value['year']);
            }
        }
        $object->setValue($key, $value);
    }
}

// store
$object->store();

// get out of here
header('Location: ' . Horde::url('displayobject.php?source=' . urlencode($source) . '&key=' . urlencode($object->getValue('__key')), true));

?>
