<?php
// $Horde: turba/lib/AbstractObject.php,v 1.12.2.2 2002/11/01 17:12:00 chuck Exp $

require_once TURBA_BASE . '/lib/Source.php';

/**
 * The Turba_AbstractObject:: class provides an interface for Turba objects -
 * people, groups, restaurants, etc.
 *
 * @author  Chuck Hagenbuch <chuck@horde.org>
 * @author  Jon Parise <jon@csh.rit.edu>
 * @version $Revision: 1.2 $
 * @since   Turba 0.0.1
 * @package turba
 */
class Turba_AbstractObject {

    /** Underlying instance of Turba_Source. */
    var $source;

    /** Hash of attributes for this contact. */
    var $attributes;

    /**
     * Constructs a new Turba_AbstractObject object.
     *
     * @param Turba_Source $source  The source that this object came from.
     * @param array $attributes     (optional) Hash of attributes for this contact.
     */
    function Turba_AbstractObject(&$source, $attributes = array())
    {
        $this->source = &$source;
        $this->attributes = $attributes;
    }

    /**
     * Returns a key-value hash containing all properties of this
     * object.
     *
     * @return array All properties of this object.
     */
    function getAttributes()
    {
        return $this->attributes;
    }

    /**
     * Return the name of the Turba_Source that this object is from.
     */
    function getSource()
    {
        return $this->source->name;
    }

    /**
     * Returns the value of the specified attribute.
     *
     * @param string $attribute    The attribute to retrieve.
     *
     * @return string              The value of $attribute, or the empty string.
     */
    function getValue($attribute)
    {
        return (isset($this->attributes[$attribute]) ? $this->attributes[$attribute] : '');
    }

    /**
     * Sets the value of the specified attribute.
     *
     * @param $attribute    The attribute to set.
     */
    function setValue($attribute, $value)
    {
        $this->attributes[$attribute] = $value;
    }

    /**
     * Determines whether or not the object has a value for the specified attribute.
     *
     * @param $attribute    The attribute to check.
     *
     * @return boolean $has Whether or not there is a value for
     *                      $attribute.
     */
    function hasValue($attribute)
    {
        return (!empty($this->attributes[$attribute]));
    }

    /**
     * Returns true if this instance is a member of a group.
     *
     * @return              True if this instances is the member of a group.
     */
    function isGroup()
    {
        return false;
    }

    /**
     * Returns true if this object is editable by the current user.
     *
     * @return boolean Whether or not the current user can edit this object
     */
    function isEditable()
    {
        if ($this->source->readonly) {
            return false;
        } else if ($this->hasValue('__owner') &&
                   $this->getValue('__owner') != Auth::getAuth()) {
            return false;
        }

        return true;
    }

    /**
     * Save the current state of the object to the storage backend.
     */
    function store()
    {
        return $this->source->setObject($this);
    }

}
?>
