<?php
// Build the columns to display
$show = array();
$address = '';
foreach ($GLOBALS['columns'] as $column) {
    if ($ob->hasValue($column)) {
        $show[$column] = htmlspecialchars($ob->getValue($column));
        if ($GLOBALS['attributes'][$column]['type'] == 'email') {
            // Format the address according to RFC822.
            $mailbox_host = explode('@', $show[$column]);
            if (!isset($mailbox_host[1])) {
                $mailbox_host[1] = '';
            }
            $name = $ob->getValue('name');
            $address = imap_rfc822_write_address($mailbox_host[0], $mailbox_host[1], $name);
            // Get rid of the trailing @ (when no host is included in the email address).
            $address = str_replace('@>', '>', $address);
            $mail_link = $GLOBALS['registry']->link('mail/compose', array('to' => addslashes($address)));
            if (PEAR::isError($mail_link)) {
                $mail_link = 'mailto:' . urlencode($address);
            }

            $show[$column] = '<a href="' . $mail_link . '">' . htmlspecialchars($show[$column]) . '</a>';
        }
    } else {
        $show[$column] = '&nbsp;';
    }
}

if ($this->list->isFresh($ob)) {
    $class = 'listitem';
    $hi = $css['.listitem-hi']['background-color'];
    $lo = $css['.listitem']['background-color'];
} else {
    $class = 'oldlistitem';
    $hi = $css['.oldlistitem-hi']['background-color'];
    $lo = $css['.oldlistitem']['background-color'];
}

if ($ob->hasValue('name')) {
    $link_text = htmlspecialchars(Turba::formatName($ob->getValue('name')));
} else {
    $link_text = _("[Edit]");
}

if ($ob->hasValue('__key')) {
    if ($ob->isGroup()) {
        $url = 'browse.php';
    } else {
        $url = 'displayobject.php';
    }
    $url = Turba::addParameter($url, 'source=' . urlencode($ob->getSource()));
    $url = Turba::addParameter($url, 'key=' . urlencode($ob->getValue('__key')));

    $cell = Horde::link(Horde::applicationUrl($url), sprintf(_("Edit '%s'"), $ob->getValue('name')));
    $cell .= $link_text . '</a>';
    if ($ob->isGroup() && $ob->isEditable()) {
        $url = Turba::addParameter('editobject.php', 'source=' . urlencode($ob->getSource()));
        $url = Turba::addParameter($url, 'key=' . urlencode($ob->getValue('__key')));
        $cell .= ' ' . Horde::link(Horde::applicationUrl($url), sprintf(_("Edit '%s'"), $ob->getValue('name')));
        $cell .= _("[Edit]") . '</a>';
    }
} else {
    $cell = $link_text;
}
?>
<tr class="<?php echo $class ?>" onmouseover="javascript:style.backgroundColor='<?php echo $hi ?>';" onmouseout="javascript:style.backgroundColor='<?php echo $lo ?>';">
  <td>
    <input type="checkbox" name="objectkeys[]" value="<?php echo htmlspecialchars($ob->getValue('__key')) ?>" />
    <?php echo $ob->isGroup() ? Horde::img('group.gif', 'alt="' . _("Group") . '"') : '' ?>
  </td>
  <td><?php echo $cell ?></td>
<?php foreach ($show as $field): ?>
  <td><?php echo $field ?></td>
<?php endforeach; ?>
</tr>
