/*
 * Decompiled with CFR 0.152.
 */
package osm.jp.gpx;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Comparator;
import java.util.Date;
import java.util.logging.LogManager;
import java.util.logging.Logger;

public class Restamp
extends Thread {
    public Exception ex = null;
    protected static final String LOGGING_PROPERTIES_DATA = "handlers=java.util.logging.ConsoleHandler\n.level=FINEST\njava.util.logging.ConsoleHandler.level=INFO\njava.util.logging.ConsoleHandler.formatter=osm.jp.gpx.YuuLogFormatter";
    public static final Logger logger = Logger.getLogger("CommandLogging");
    public File imgDir;
    public Date baseTime1;
    public Date baseTime2;
    public int bCount1 = 0;
    public int bCount2 = 0;
    public long span = 0L;
    public ArrayList<File> jpgFiles = new ArrayList();

    public static void main(String[] argv) throws Exception {
        if (argv.length < 5) {
            System.out.println("java Restamp <imgDir> <baseFile1> <timeStr1> <baseFile2> <timeStr2>");
            return;
        }
        File imgDir = new File(argv[0]);
        if (!imgDir.exists()) {
            System.out.println("[error] <imgDir>\u304c\u5b58\u5728\u3057\u307e\u305b\u3093\u3002");
            return;
        }
        if (!imgDir.isDirectory()) {
            System.out.println("[error] <imgDir>\u304c\u30d5\u30a9\u30eb\u30c0\u3058\u3083\u306a\u3044");
            return;
        }
        File baseFile1 = new File(imgDir, argv[1]);
        if (!baseFile1.exists()) {
            System.out.println("[error] <baseFile1>\u304c\u5b58\u5728\u3057\u307e\u305b\u3093\u3002");
            return;
        }
        if (!baseFile1.isFile()) {
            System.out.println("[error] <baseFile1>\u304c\u30d5\u30a1\u30a4\u30eb\u3058\u3083\u306a\u3044");
            return;
        }
        SimpleDateFormat df1 = new SimpleDateFormat("yyyy-MM-dd'_'HH:mm:ss");
        Date baseTime1 = df1.parse(argv[2]);
        File baseFile2 = new File(imgDir, argv[3]);
        if (!baseFile2.exists()) {
            System.out.println("[error] <baseFile2>\u304c\u5b58\u5728\u3057\u307e\u305b\u3093\u3002");
            return;
        }
        if (!baseFile2.isFile()) {
            System.out.println("[error] <baseFile2>\u304c\u30d5\u30a1\u30a4\u30eb\u3058\u3083\u306a\u3044");
            return;
        }
        SimpleDateFormat df2 = new SimpleDateFormat("yyyy-MM-dd'_'HH:mm:ss");
        Date baseTime2 = df2.parse(argv[4]);
        Restamp obj = new Restamp();
        obj.setUp(imgDir, baseFile1, baseTime1, baseFile2, baseTime2);
    }

    public void setUp(File imgDir, File baseFile1, Date baseTime1, File baseFile2, Date baseTime2) throws Exception {
        File[] files = imgDir.listFiles();
        Arrays.sort(files, new Comparator<File>(){

            @Override
            public int compare(File file1, File file2) {
                return file1.getName().compareTo(file2.getName());
            }
        });
        this.bCount1 = 0;
        this.bCount2 = 0;
        boolean base1 = false;
        boolean base2 = false;
        for (File file : files) {
            String filename;
            if (!file.isFile() || !(filename = file.getName().toUpperCase()).toUpperCase().endsWith(".JPG")) continue;
            this.jpgFiles.add(file);
            this.bCount1 += base1 ? 0 : 1;
            this.bCount2 += base2 ? 0 : 1;
            if (file.getName().equals(baseFile1.getName())) {
                base1 = true;
            }
            if (!file.getName().equals(baseFile2.getName())) continue;
            base2 = true;
        }
        try {
            long span = baseTime2.getTime() - baseTime1.getTime();
            span /= (long)(this.bCount2 - this.bCount1);
            int i = 0;
            for (File jpgFile : this.jpgFiles) {
                long deltaMsec = (long)(i - this.bCount1) * span;
                ++i;
                Calendar cal = Calendar.getInstance();
                cal.setTime(baseTime1);
                cal.add(14, (int)deltaMsec);
                jpgFile.setLastModified(cal.getTimeInMillis());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            this.ex = new Exception(e);
        }
    }

    public static boolean checkFile(String name) {
        return name != null && name.toUpperCase().endsWith(".JPG");
    }

    static {
        ByteArrayInputStream inStream = null;
        try {
            inStream = new ByteArrayInputStream(LOGGING_PROPERTIES_DATA.getBytes("UTF-8"));
            try {
                LogManager.getLogManager().readConfiguration(inStream);
                logger.config("\u30ed\u30b0\u8a2d\u5b9a: LogManager\u3092\u8a2d\u5b9a\u3057\u307e\u3057\u305f\u3002");
            }
            catch (IOException e) {
                logger.warning("\u30ed\u30b0\u8a2d\u5b9a: LogManager\u8a2d\u5b9a\u306e\u969b\u306b\u4f8b\u5916\u304c\u767a\u751f\u3057\u307e\u3057\u305f\u3002:" + e.toString());
            }
        }
        catch (UnsupportedEncodingException e) {
            logger.severe("\u30ed\u30b0\u8a2d\u5b9a: UTF-8\u30a8\u30f3\u30b3\u30fc\u30c7\u30a3\u30f3\u30b0\u304c\u30b5\u30dd\u30fc\u30c8\u3055\u308c\u3066\u3044\u307e\u305b\u3093\u3002:" + e.toString());
        }
        finally {
            try {
                if (inStream != null) {
                    ((InputStream)inStream).close();
                }
            }
            catch (IOException e) {
                logger.warning("\u30ed\u30b0\u8a2d\u5b9a: \u30ed\u30b0\u8a2d\u5b9a\u30d7\u30ed\u30d1\u30c6\u30a3\u30d5\u30a1\u30a4\u30eb\u306e\u30b9\u30c8\u30ea\u30fc\u30e0\u30af\u30ed\u30fc\u30ba\u6642\u306b\u4f8b\u5916\u304c\u767a\u751f\u3057\u307e\u3057\u305f\u3002:" + e.toString());
            }
        }
    }

    class JpegFileFilter
    implements FilenameFilter {
        JpegFileFilter() {
        }

        @Override
        public boolean accept(File dir, String name) {
            return name.toUpperCase().matches(".*\\.JPG$");
        }
    }

    static class FileSort
    implements Comparator<File> {
        FileSort() {
        }

        @Override
        public int compare(File src, File target) {
            int diff = src.getName().compareTo(target.getName());
            return diff;
        }
    }
}

