/*
 * Decompiled with CFR 0.152.
 */
package osm.jp.gpx.matchtime.gui;

import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Menu;
import java.awt.MenuBar;
import java.awt.MenuItem;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import org.apache.commons.imaging.Imaging;
import org.apache.commons.imaging.common.ImageMetadata;
import org.apache.commons.imaging.formats.jpeg.JpegImageMetadata;
import org.apache.commons.imaging.formats.tiff.TiffImageMetadata;
import org.apache.commons.imaging.formats.tiff.constants.ExifTagConstants;
import osm.jp.gpx.AppParameters;
import osm.jp.gpx.ImportPicture;
import osm.jp.gpx.matchtime.gui.AboutDialog;
import osm.jp.gpx.matchtime.gui.DoDialog;
import osm.jp.gpx.matchtime.gui.ImageFileView;
import osm.jp.gpx.matchtime.gui.ImageFilter;
import osm.jp.gpx.matchtime.gui.ImagePreview;
import osm.jp.gpx.matchtime.gui.ParameterPanel;
import osm.jp.gpx.matchtime.gui.ParameterPanelFolder;
import osm.jp.gpx.matchtime.gui.ParameterPanelGpx;
import osm.jp.gpx.matchtime.gui.ParameterPanelImageFile;
import osm.jp.gpx.matchtime.gui.QuitDialog;

public class AdjustTime
extends JFrame {
    public static final String PROGRAM_NAME = "AdjustTime for JOSM";
    public static final String PROGRAM_VARSION = "3.2";
    public static final String PROGRAM_UPDATE = "2017/06/28";
    AppParameters params;
    SimpleDateFormat dfjp = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss Z");
    boolean fComponentsAdjusted = false;
    JPanel cardPanel;
    JPanel[] cards;
    int cardPanelNo = 0;
    JPanel argsPanel;
    JScrollPane imageSPane;
    JLabel imageLabel;
    ButtonGroup baseTimeGroup;
    JRadioButton exifBase;
    JRadioButton fupdateBase;
    JCheckBox noFirstNode;
    JCheckBox gpxReuse;
    JTextArea textArea;
    ParameterPanelFolder arg1_srcFolder;
    ParameterPanelImageFile arg2_baseTimeImg;
    ParameterPanel arg3_basetime;
    JCheckBox outputIMG;
    JCheckBox outputIMG_all;
    JCheckBox exifON;
    JCheckBox gpxOutputWpt;
    JCheckBox gpxOverwriteMagvar;
    JCheckBox gpxOutputSpeed;
    ParameterPanelFolder arg5_outputFolder;
    ParameterPanelGpx arg4_gpxFolder;
    JPanel buttonPanel;
    JButton openButton;
    JButton zoomInButton;
    JButton zoomOutButton;
    JButton nextButton;
    JButton backButton;
    JButton doButton;
    MenuBar mainMenuBar;
    Menu menu1;
    MenuItem miDoNewFileList;
    MenuItem miDoDirSize;
    MenuItem miDoReadXML;
    MenuItem miExit;
    Menu menu3;
    MenuItem miAbout;
    ImageIcon refImage;

    public AdjustTime() throws IOException {
        this.dfjp.setTimeZone(TimeZone.getTimeZone("JST"));
        Container container = this.getContentPane();
        container.setLayout(new BorderLayout());
        this.setSize(this.getInsets().left + this.getInsets().right + 960, this.getInsets().top + this.getInsets().bottom + 480);
        this.setTitle("AdjustTime for JOSM v3.2");
        this.params = new AppParameters();
        this.cardPanel = new JPanel();
        this.cardPanel.setLayout(new CardLayout());
        container.add((Component)this.cardPanel, "Center");
        this.nextButton = new JButton("\u6b21\u3078");
        container.add((Component)this.nextButton, "East");
        this.backButton = new JButton("\u623b\u308b");
        container.add((Component)this.backButton, "West");
        this.cards = new JPanel[5];
        for (int i = 0; i < 5; ++i) {
            this.cards[i] = new JPanel();
            this.cardPanel.add((Component)this.cards[i], String.valueOf(i));
        }
        this.cardPanelNo = 0;
        int cardNo = 0;
        this.cards[cardNo].setLayout(new BorderLayout());
        JLabel label1 = new JLabel();
        label1.setText("<html><p>1. \u4f4d\u7f6e\u60c5\u5831\u3092\u4ed8\u52a0\u3057\u305f\u3044\u753b\u50cf\u30d5\u30a1\u30a4\u30eb\u304c\u683c\u7d0d\u3055\u308c\u3066\u3044\u308b\u30d5\u30a9\u30eb\u30c0\u3092\u9078\u629e\u3057\u3066\u304f\u3060\u3055\u3044\u3002</p><ul><li>\u30b3\u30d4\u30fc\u52d5\u4f5c\u3092\u884c\u3046\u3068\u3001\u30d5\u30a1\u30a4\u30eb\u66f4\u65b0\u6642\u523b\u304c\u30b3\u30d4\u30fc\u3092\u5b9f\u884c\u3057\u305f\u6642\u523b\u306b\u66f8\u304d\u63db\u308f\u3063\u3066\u3057\u307e\u3046\u3053\u3068\u304c\u3042\u308a\u307e\u3059\u3002\u30aa\u30ea\u30b8\u30ca\u30eb\u306e\u30ab\u30e1\u30e9USB\u5185\u306e\u30d5\u30a9\u30eb\u30c0\u3092\u76f4\u63a5\u6307\u5b9a\u3059\u308b\u3053\u3068\u3092\u304a\u3059\u3059\u3081\u3057\u307e\u3059\u3002</li></ul>");
        this.cards[cardNo].add((Component)label1, "North");
        this.argsPanel = new JPanel();
        this.argsPanel.setLayout(new BoxLayout(this.argsPanel, 1));
        this.arg1_srcFolder = new ParameterPanelFolder("\u5bfe\u8c61\u30d5\u30a9\u30eb\u30c0: ", this.params.getProperty(AppParameters.IMG_SOURCE_FOLDER));
        this.argsPanel.add(this.arg1_srcFolder);
        this.cards[cardNo].add((Component)this.argsPanel, "Center");
        this.cards[++cardNo].setLayout(new BorderLayout());
        JLabel label2 = new JLabel();
        label2.setText("<html><p>2. \u6b63\u78ba\u306a\u64ae\u5f71\u6642\u523b\u304c\u5224\u660e\u3067\u304d\u308b\u753b\u50cf\u3092\u9078\u3093\u3067\u304f\u3060\u3055\u3044\u3002</p><ul><li>\u30b9\u30de\u30fc\u30c8\u30d5\u30a9\u30f3\u306e\u6642\u8a08\u753b\u9762\uff08\u79d2\u304c\u5224\u5225\u3067\u304d\u308b\u3053\u3068\uff09\u3092\u64ae\u5f71\u3057\u305f\u753b\u50cf</li><li>\u30ab\u30e1\u30e9\u306e\u6642\u8a08\u304c\u6b63\u78ba\u306a\u3089\u3070\u3001\u3069\u306e\u753b\u50cf\u3092\u9078\u3093\u3067\u3082\u69cb\u3044\u307e\u305b\u3093\u3002</li></ul>");
        this.cards[cardNo].add((Component)label2, "North");
        this.argsPanel = new JPanel();
        this.argsPanel.setLayout(new BoxLayout(this.argsPanel, 1));
        this.arg2_baseTimeImg = new ParameterPanelImageFile("\u57fa\u6e96\u6642\u523b\u753b\u50cf: ", this.params.getProperty(AppParameters.IMG_BASE_FILE), this.arg1_srcFolder);
        this.argsPanel.add(this.arg2_baseTimeImg);
        this.baseTimeGroup = new ButtonGroup();
        this.exifBase = new JRadioButton("EXIF\u306e\u65e5\u6642\u3092\u57fa\u6e96\u306b\u3059\u308b");
        this.fupdateBase = new JRadioButton("File\u66f4\u65b0\u65e5\u6642\u3092\u57fa\u6e96\u306b\u3059\u308b");
        this.baseTimeGroup.add(this.exifBase);
        this.baseTimeGroup.add(this.fupdateBase);
        this.argsPanel.add(this.exifBase);
        this.argsPanel.add(this.fupdateBase);
        if (this.params.getProperty(AppParameters.GPX_BASETIME).equals("EXIF_TIME")) {
            this.fupdateBase.setSelected(false);
            this.exifBase.setSelected(true);
        } else {
            this.fupdateBase.setSelected(true);
            this.exifBase.setSelected(false);
        }
        this.cards[cardNo].add((Component)this.argsPanel, "Center");
        this.cards[++cardNo].setLayout(new BorderLayout());
        this.argsPanel = new JPanel();
        this.argsPanel.setLayout(new GridLayout(2, 1));
        JLabel label3 = new JLabel();
        label3.setText("<html><p>3. \u6b63\u78ba\u306a\u64ae\u5f71\u6642\u523b\u3092\u5165\u529b\u3057\u3066\u304f\u3060\u3055\u3044\u3002</p><ul><li>\u30ab\u30e1\u30e9\u306e\u6642\u8a08\u304c\u6b63\u78ba\u306a\u3089\u3070\u3001\u8a2d\u5b9a\u3092\u5909\u66f4\u3059\u308b\u5fc5\u8981\u306f\u3042\u308a\u307e\u305b\u3093\u3002</li></ul>");
        this.argsPanel.add(label3);
        this.arg3_basetime = new ParameterPanel("\u3000\u3000\u57fa\u6e96\u6642\u523b: ", "yyyy-MM-dd'T'HH:mm:ss'Z'");
        this.argsPanel.add(this.arg3_basetime);
        this.cards[cardNo].add((Component)this.argsPanel, "North");
        this.imageLabel = new JLabel();
        this.imageSPane = new JScrollPane(this.imageLabel);
        this.cards[cardNo].add((Component)this.imageSPane, "Center");
        this.buttonPanel = new JPanel();
        this.buttonPanel.setLayout(new BoxLayout(this.buttonPanel, 0));
        this.openButton = new JButton(AdjustTime.createImageIcon("images/Fit16.gif"));
        this.buttonPanel.add(this.openButton);
        this.zoomInButton = new JButton(AdjustTime.createImageIcon("images/ZoomIn16.gif"));
        this.buttonPanel.add(this.zoomInButton);
        this.zoomOutButton = new JButton(AdjustTime.createImageIcon("images/ZoomOut16.gif"));
        this.buttonPanel.add(this.zoomOutButton);
        this.cards[cardNo].add((Component)this.buttonPanel, "South");
        this.cards[++cardNo].setLayout(new BorderLayout());
        JLabel label4 = new JLabel();
        label4.setText("<html><p>4. \u30d2\u30e2\u4ed8\u3092\u884c\u3046GPX\u30d5\u30a1\u30a4\u30eb\u3092\u9078\u629e\u3057\u3066\u304f\u3060\u3055\u3044\u3002</p><ul><li>\u30d5\u30a9\u30eb\u30c0\u3092\u6307\u5b9a\u3059\u308b\u3068\u3001\u30d5\u30a9\u30eb\u30c0\u5185\u306b\u3042\u308b\u3059\u3079\u3066\u306eGPX\u30d5\u30a1\u30a4\u30eb\u3092\u5bfe\u8c61\u3068\u3057\u307e\u3059\u3002</li><li>\u30ab\u30e1\u30e9\u306e\u6642\u8a08\u304c\u6b63\u78ba\u306a\u3089\u3070\u3001\u3069\u306e\u753b\u50cf\u3092\u9078\u3093\u3067\u3082\u69cb\u3044\u307e\u305b\u3093\u3002</li></ul>");
        this.cards[cardNo].add((Component)label4, "North");
        JPanel tmpPanel4a = new JPanel();
        tmpPanel4a.setLayout(new BoxLayout(tmpPanel4a, 1));
        this.arg4_gpxFolder = new ParameterPanelGpx("GPX\u30d5\u30a9\u30eb\u30c0: ", this.params.getProperty(AppParameters.GPX_SOURCE_FOLDER));
        tmpPanel4a.add(this.arg4_gpxFolder);
        this.noFirstNode = new JCheckBox("<trkseg>\u30bb\u30b0\u30e1\u30f3\u30c8\u306e\u6700\u521d\u306e\uff11\u30ce\u30fc\u30c9\u306f\u7121\u8996\u3059\u308b\u3002", this.params.getProperty(AppParameters.GPX_NO_FIRST_NODE).equals("ON"));
        tmpPanel4a.add(this.noFirstNode);
        this.gpxReuse = new JCheckBox("\u751f\u6210\u3055\u308c\u305fGPX\u30d5\u30a1\u30a4\u30eb\uff08\u30d5\u30a1\u30a4\u30eb\u540d\u304c'_.gpx'\u3067\u7d42\u308f\u308b\u3082\u306e\uff09\u3082\u5bfe\u8c61\u306b\u3059\u308b\u3002", this.params.getProperty(AppParameters.GPX_REUSE).equals("ON"));
        this.gpxReuse.setEnabled(true);
        tmpPanel4a.add(this.gpxReuse);
        this.cards[cardNo].add((Component)tmpPanel4a, "Center");
        this.cards[++cardNo].setLayout(new BorderLayout());
        JLabel label5 = new JLabel();
        label5.setText("<html><p>5. EXIF\u5909\u63db\u3092\u884c\u3046\u304b\u3069\u3046\u304b\u3092\u9078\u629e\u3057\u3066\u304f\u3060\u3055\u3044\u3002</p><ul><li>EXIF\u5909\u63db\u3092\u884c\u3046\u5834\u5408\u306b\u306f\u3001\u5909\u63db\u30d5\u30a1\u30a4\u30eb\u3092\u51fa\u529b\u3059\u308b\u30d5\u30a9\u30eb\u30c0\u3082\u6307\u5b9a\u3059\u308b\u5fc5\u8981\u304c\u3042\u308a\u307e\u3059\u3002</li><li>\u51fa\u529b\u30d5\u30a9\u30eb\u30c0\u306b\u306f\u3001\u66f8\u304d\u8fbc\u307f\u6a29\u9650\u3068\u3001\u5341\u5206\u306a\u7a7a\u304d\u5bb9\u91cf\u304c\u5fc5\u8981\u3067\u3059\u3002</li></ul>");
        this.cards[cardNo].add((Component)label5, "North");
        JPanel tmpPanel5 = new JPanel();
        tmpPanel5.setLayout(new BoxLayout(tmpPanel5, 1));
        this.outputIMG = new JCheckBox("IMG\u306e\u5909\u63db\u3092\u3059\u308b", Boolean.parseBoolean(this.params.getProperty(AppParameters.IMG_OUTPUT)));
        tmpPanel5.add(this.outputIMG);
        this.outputIMG_all = new JCheckBox("GPX\u30d5\u30a1\u30a4\u30eb\u6642\u9593\u5916\u306e\u30d5\u30a1\u30a4\u30eb\u3082\u30b3\u30d4\u30fc\u3059\u308b", Boolean.parseBoolean(this.params.getProperty(AppParameters.IMG_OUTPUT_ALL)));
        tmpPanel5.add(this.outputIMG_all);
        this.arg5_outputFolder = new ParameterPanelFolder("\u51fa\u529b\u30d5\u30a9\u30eb\u30c0: ", this.params.getProperty(AppParameters.IMG_OUTPUT_FOLDER));
        tmpPanel5.add(this.arg5_outputFolder);
        this.exifON = new JCheckBox("EXIF\u306e\u5909\u63db\u3092\u3059\u308b", Boolean.parseBoolean(this.params.getProperty(AppParameters.IMG_OUTPUT_EXIF)));
        tmpPanel5.add(this.exifON);
        this.gpxOutputWpt = new JCheckBox("\u51fa\u529bGPX\u306b\u30dd\u30a4\u30f3\u30c8\u30de\u30fc\u30ab\u30fc<WPT>\u3092\u66f8\u304d\u51fa\u3059", Boolean.parseBoolean(this.params.getProperty(AppParameters.GPX_OUTPUT_WPT)));
        this.gpxOutputWpt.setEnabled(true);
        tmpPanel5.add(this.gpxOutputWpt);
        this.gpxOverwriteMagvar = new JCheckBox("\u30bd\u30fc\u30b9GPX\u306e<MAGVAR>\u3092\u7121\u8996\u3059\u308b", Boolean.parseBoolean(this.params.getProperty(AppParameters.GPX_OVERWRITE_MAGVAR)));
        this.gpxOverwriteMagvar.setEnabled(true);
        tmpPanel5.add(this.gpxOverwriteMagvar);
        this.gpxOutputSpeed = new JCheckBox("\u51fa\u529bGPX\u306b<SPEED>\u3092\u4e0a\u66f8\u304d\u3059\u308b", Boolean.parseBoolean(this.params.getProperty(AppParameters.GPX_OUTPUT_SPEED)));
        this.gpxOutputSpeed.setEnabled(true);
        tmpPanel5.add(this.gpxOutputSpeed);
        this.cards[cardNo].add((Component)tmpPanel5, "Center");
        this.doButton = new JButton("\u51e6\u7406\u5b9f\u884c", AdjustTime.createImageIcon("images/media_playback_start.png"));
        this.cards[cardNo].add((Component)this.doButton, "South");
        this.menu1 = new Menu("File");
        this.miExit = new MenuItem("\u7d42\u4e86\uff1f");
        this.miExit.setFont(new Font("Dialog", 0, 12));
        this.menu1.add(this.miExit);
        this.miAbout = new MenuItem("About...");
        this.miAbout.setFont(new Font("Dialog", 0, 12));
        this.menu3 = new Menu("Help");
        this.menu3.setFont(new Font("Dialog", 0, 12));
        this.menu3.add(this.miAbout);
        this.mainMenuBar = new MenuBar();
        this.mainMenuBar.setHelpMenu(this.menu3);
        this.mainMenuBar.add(this.menu1);
        this.mainMenuBar.add(this.menu3);
        this.setMenuBar(this.mainMenuBar);
        SymWindow aSymWindow = new SymWindow();
        this.addWindowListener(aSymWindow);
        SymAction lSymAction = new SymAction();
        this.miAbout.addActionListener(lSymAction);
        this.miExit.addActionListener(lSymAction);
        this.openButton.addActionListener(lSymAction);
        this.zoomOutButton.addActionListener(lSymAction);
        this.zoomInButton.addActionListener(lSymAction);
        this.arg2_baseTimeImg.argField.addActionListener(lSymAction);
        this.arg2_baseTimeImg.openButton.addActionListener(lSymAction);
        this.doButton.addActionListener(lSymAction);
        this.outputIMG_all.addActionListener(lSymAction);
        this.exifON.addActionListener(lSymAction);
        this.gpxOutputSpeed.addActionListener(lSymAction);
        this.noFirstNode.addActionListener(lSymAction);
        this.gpxReuse.addActionListener(lSymAction);
        this.nextButton.addActionListener(lSymAction);
        this.backButton.addActionListener(lSymAction);
    }

    @Override
    public void setVisible(boolean b) {
        if (b) {
            this.setLocation(50, 50);
        }
        super.setVisible(b);
    }

    public static void main(String[] args) {
        SwingUtilities.invokeLater(() -> {
            try {
                AdjustTime.createAndShowGUI();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        });
    }

    private static void createAndShowGUI() throws IOException {
        new AdjustTime().setVisible(true);
    }

    @Override
    public void addNotify() {
        Component[] components;
        Dimension d = this.getSize();
        super.addNotify();
        if (this.fComponentsAdjusted) {
            return;
        }
        this.setSize(this.getInsets().left + this.getInsets().right + d.width, this.getInsets().top + this.getInsets().bottom + d.height);
        for (Component component : components = this.getComponents()) {
            Point p = component.getLocation();
            p.translate(this.getInsets().left, this.getInsets().top);
            component.setLocation(p);
        }
        this.fComponentsAdjusted = true;
    }

    void DbMang_WindowClosing(WindowEvent event) {
        this.setVisible(false);
        this.dispose();
        System.exit(0);
    }

    void miAbout_Action(ActionEvent event) {
        new AboutDialog((Frame)this, true).setVisible(true);
    }

    void miExit_Action(ActionEvent event) {
        new QuitDialog(this, true).setVisible(true);
    }

    public void imageView_Action(ActionEvent ev) {
        ImageIcon tmpIcon;
        String path;
        block6: {
            path = new File(this.arg1_srcFolder.getText(), this.arg2_baseTimeImg.getText()).getPath();
            File timeFile = new File(path);
            if (this.exifBase.isSelected()) {
                try {
                    ImageMetadata meta = Imaging.getMetadata((File)timeFile);
                    JpegImageMetadata jpegMetadata = (JpegImageMetadata)meta;
                    if (jpegMetadata == null) break block6;
                    TiffImageMetadata exif = jpegMetadata.getExif();
                    if (exif != null) {
                        String dateTimeOriginal = exif.getFieldValue(ExifTagConstants.EXIF_TAG_DATE_TIME_ORIGINAL)[0];
                        long lastModifyTime = new SimpleDateFormat("yyyy:MM:dd HH:mm:ss").parse(dateTimeOriginal).getTime();
                        this.arg3_basetime.argField.setText(this.dfjp.format(new Date(lastModifyTime)));
                        break block6;
                    }
                    this.arg3_basetime.argField.setText("exif == null");
                }
                catch (Exception meta) {}
            } else {
                long lastModifyTime = timeFile.lastModified();
                this.arg3_basetime.argField.setText(this.dfjp.format(new Date(lastModifyTime)));
            }
        }
        int size_x = this.imageSPane.getWidth() - 8;
        this.refImage = tmpIcon = new ImageIcon(path);
        if (tmpIcon.getIconWidth() > size_x) {
            this.refImage = new ImageIcon(tmpIcon.getImage().getScaledInstance(size_x, -1, 1));
        }
        this.imageLabel.setIcon(this.refImage);
        this.repaint();
    }

    public void zoomin_Action(ActionEvent ev) {
        if (this.refImage != null) {
            int size_x = this.imageLabel.getWidth();
            String path = new File(this.arg1_srcFolder.getText(), this.arg2_baseTimeImg.getText()).getPath();
            ImageIcon tmpIcon = new ImageIcon(path);
            this.refImage = new ImageIcon(tmpIcon.getImage().getScaledInstance(size_x * 2, -1, 1));
            this.imageLabel.setIcon(this.refImage);
            this.repaint();
        }
    }

    public void zoomout_Action(ActionEvent ev) {
        if (this.refImage != null) {
            int size_x = this.imageLabel.getWidth();
            ImageIcon tmpIcon = this.refImage;
            this.refImage = new ImageIcon(tmpIcon.getImage().getScaledInstance(size_x / 2, -1, 1));
            this.imageLabel.setIcon(this.refImage);
            this.repaint();
        }
    }

    public void selectSource_Action(ActionEvent ev) {
    }

    public void selectImage_Action(ActionEvent ev) {
        File sdir = new File(this.arg1_srcFolder.getText());
        System.out.println(sdir.getPath());
        JFileChooser fc = sdir.isDirectory() ? new JFileChooser(sdir) : new JFileChooser();
        fc.addChoosableFileFilter(new ImageFilter());
        fc.setAcceptAllFileFilterUsed(false);
        fc.setFileView(new ImageFileView());
        fc.setAccessory(new ImagePreview(fc));
        int returnVal = fc.showDialog(this, "\u9078\u629e");
        if (returnVal == 0) {
            File file = fc.getSelectedFile();
            this.arg2_baseTimeImg.argField.setText(file.getName());
        }
        fc.setSelectedFile(null);
    }

    public static ImageIcon createImageIcon(String path) {
        URL imgURL = AdjustTime.class.getResource(path);
        if (imgURL != null) {
            return new ImageIcon(imgURL);
        }
        System.err.println("Couldn't find file: " + path);
        return null;
    }

    void outputIMG_Action(ActionEvent event) {
        this.arg5_outputFolder.setEnabled(this.outputIMG.isEnabled());
    }

    void outputIMGall_Action(ActionEvent event) {
    }

    void exifON_Action(ActionEvent event) {
    }

    void gpxOutputWpt_Action(ActionEvent event) {
    }

    void gpxOutputSpeed_Action(ActionEvent event) {
    }

    void doButton_Action(ActionEvent event) {
        this.doButton.setEnabled(false);
        String[] argv = new String[]{};
        this.params.setProperty(AppParameters.GPX_NO_FIRST_NODE, String.valueOf(this.noFirstNode.isSelected()));
        this.params.setProperty(AppParameters.GPX_REUSE, String.valueOf(this.gpxReuse.isSelected()));
        this.params.setProperty(AppParameters.GPX_SOURCE_FOLDER, this.arg4_gpxFolder.getText());
        if (this.exifBase.isSelected()) {
            this.params.setProperty(AppParameters.GPX_BASETIME, "EXIF_TIME");
        } else {
            this.params.setProperty(AppParameters.GPX_BASETIME, "FILE_UPDATE");
        }
        try {
            this.params.setProperty(AppParameters.IMG_SOURCE_FOLDER, this.arg1_srcFolder.getText());
            this.params.setProperty(AppParameters.IMG_BASE_FILE, this.arg2_baseTimeImg.getText());
            this.params.setProperty(AppParameters.IMG_TIME, ImportPicture.toUTCString(this.dfjp.parse(this.arg3_basetime.getText())));
            this.params.setProperty(AppParameters.IMG_OUTPUT, String.valueOf(this.outputIMG.isSelected()));
            this.params.setProperty(AppParameters.IMG_OUTPUT_FOLDER, this.arg5_outputFolder.getText());
            this.params.setProperty(AppParameters.IMG_OUTPUT_ALL, String.valueOf(this.outputIMG_all.isSelected()));
            this.params.setProperty(AppParameters.IMG_OUTPUT_EXIF, String.valueOf(this.exifON.isSelected()));
            this.params.setProperty(AppParameters.GPX_OVERWRITE_MAGVAR, String.valueOf(this.gpxOverwriteMagvar.isSelected()));
            this.params.setProperty(AppParameters.GPX_OUTPUT_SPEED, String.valueOf(this.gpxOutputSpeed.isSelected()));
            this.params.setProperty(AppParameters.GPX_OUTPUT_WPT, String.valueOf(this.gpxOutputWpt.isSelected()));
            this.params.store();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        new DoDialog(this, argv).setVisible(true);
        this.doButton.setEnabled(true);
    }

    void nextButton_Action(ActionEvent event) {
        if (this.cardPanelNo + 1 < this.cards.length) {
            ++this.cardPanelNo;
            CardLayout cl = (CardLayout)this.cardPanel.getLayout();
            cl.show(this.cardPanel, String.valueOf(this.cardPanelNo));
        }
    }

    void backButton_Action(ActionEvent event) {
        if (this.cardPanelNo - 1 >= 0) {
            --this.cardPanelNo;
            CardLayout cl = (CardLayout)this.cardPanel.getLayout();
            cl.show(this.cardPanel, String.valueOf(this.cardPanelNo));
        }
    }

    class SymAction
    implements ActionListener {
        SymAction() {
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            Object object = event.getSource();
            if (object == AdjustTime.this.miAbout) {
                AdjustTime.this.miAbout_Action(event);
            } else if (object == AdjustTime.this.miExit) {
                AdjustTime.this.miExit_Action(event);
            } else if (object == AdjustTime.this.openButton) {
                AdjustTime.this.imageView_Action(event);
            } else if (object == AdjustTime.this.zoomInButton) {
                AdjustTime.this.zoomin_Action(event);
            } else if (object == AdjustTime.this.zoomOutButton) {
                AdjustTime.this.zoomout_Action(event);
            } else if (object == AdjustTime.this.arg2_baseTimeImg.argField) {
                AdjustTime.this.imageView_Action(event);
            } else if (object == AdjustTime.this.arg2_baseTimeImg.openButton) {
                AdjustTime.this.selectImage_Action(event);
                AdjustTime.this.imageView_Action(event);
            } else if (object == AdjustTime.this.outputIMG) {
                AdjustTime.this.outputIMG_Action(event);
            } else if (object == AdjustTime.this.outputIMG_all) {
                AdjustTime.this.outputIMGall_Action(event);
            } else if (object == AdjustTime.this.exifON) {
                AdjustTime.this.exifON_Action(event);
            } else if (object == AdjustTime.this.gpxOutputWpt) {
                AdjustTime.this.gpxOutputWpt_Action(event);
            } else if (object == AdjustTime.this.gpxOutputSpeed) {
                AdjustTime.this.gpxOutputSpeed_Action(event);
            } else if (object == AdjustTime.this.doButton) {
                AdjustTime.this.doButton_Action(event);
            } else if (object == AdjustTime.this.nextButton) {
                AdjustTime.this.nextButton_Action(event);
            } else if (object == AdjustTime.this.backButton) {
                AdjustTime.this.backButton_Action(event);
            }
        }
    }

    class SymWindow
    extends WindowAdapter {
        SymWindow() {
        }

        @Override
        public void windowClosing(WindowEvent event) {
            Object object = event.getSource();
            if (object == AdjustTime.this) {
                AdjustTime.this.DbMang_WindowClosing(event);
            }
        }
    }
}

