require 'time'
require 'nkf'
require 'mobile'

class IndexController < EntriesController
	before_filter :mobile_filter
	after_filter :template_set_filter

	cache_sweeper :entry_sweeper, :only => [:edit, :create]

	protected
	def mobile_filter
		if Mobile::is_mobile?(@request.env['HTTP_USER_AGENT'])
			redirect_to :controller => "mobile"
		end
	end

	def template_set_filter
		unless @performed_redirect
			erase_render_results
			render_action 'index'
		end
	end
end

