require 'time'
require 'nkf'
require 'mobile'

class EntriesController < ApplicationController
	cache_sweeper :entry_sweeper, :only => [:edit, :create]

	def index
		@pages, @entries = paginate(:entry, :per_page => 20, :order_by => 'id DESC')
	end

	def create
		body = @params['entry']['body']
		@entry = Entry.new(
			'hostname'       => @request.remote_addr,
			'body'           => body
		)

		if @entry.save
			flash[:notice] = "Entry was successfully created"
			redirect_to :action => "index"
		else
			@entries = []
			render_action "index"
		end
	end

	def show
		@entries = Entry.find(@params[:id].split(',').select {|id| Entry.exists?(id)})
		render_action "index"
	end

	def search
		# FIXME: DRY! DRY! ... ajax search
		@pages, @entries = paginate(:entry, :conditions => ['body LIKE CONCAT("%", ?, "%")', @params['keyword']], :per_page => 20, :order_by => 'id DESC')
		render_action "index"
	end

	def edit
		id = @params['entry']['id']

		@entry = Entry.find(id)

		if Time.parse(@params['entry']['updated_on']) != @entry.updated_on
			@entries = []
			@entry.errors.add 'updated_on', "update conflict: #{@params['entry']['body']}\n:#{@entry.body}"
			render_action "index"
			return
		end

		@entry.body = @params['entry']['body']
		if @entry.save
			flash[:notice] = "Entry was successfully updated"
			redirect_to :action => "index"
		else
			@entries = []
			render_action "index"
		end
	end
end

