/******************************************************************************/
/*! @file table_utf8_gb18030.cc
    @brief UTF-8/GB18030 table.
    @author Masashi Astro Tachibana, Apolloron Project.
 ******************************************************************************/

#include "table_utf8_gb18030.h"

namespace apolloron {

const T_UTF8_GB18030 utf8_gb18030[UTF8_GB18030_TABLE_MAX] ={
    {"\xC2\x80", "\x81\x30\x81\x30", 36},
    {"\xC2\xA5", "\x81\x30\x84\x36", 2},
    {"\xC2\xA9", "\x81\x30\x84\x38", 7},
    {"\xC2\xB2", "\x81\x30\x85\x35", 5},
    {"\xC2\xB8", "\x81\x30\x86\x30", 31},
    {"\xC3\x98", "\x81\x30\x89\x31", 8},
    {"\xC3\xA2", "\x81\x30\x89\x39", 6},
    {"\xC3\xAB", "\x81\x30\x8A\x35", 1},
    {"\xC3\xAE", "\x81\x30\x8A\x36", 4},
    {"\xC3\xB4", "\x81\x30\x8B\x30", 3},
    {"\xC3\xB8", "\x81\x30\x8B\x33", 1},
    {"\xC3\xBB", "\x81\x30\x8B\x34", 1},
    {"\xC3\xBD", "\x81\x30\x8B\x35", 4},
    {"\xC4\x82", "\x81\x30\x8B\x39", 17},
    {"\xC4\x94", "\x81\x30\x8D\x36", 7},
    {"\xC4\x9C", "\x81\x30\x8E\x33", 15},
    {"\xC4\xAC", "\x81\x30\x8F\x38", 24},
    {"\xC5\x85", "\x81\x30\x92\x32", 3},
    {"\xC5\x89", "\x81\x30\x92\x35", 4},
    {"\xC5\x8E", "\x81\x30\x92\x39", 29},
    {"\xC5\xAC", "\x81\x30\x95\x38", 98},
    {"\xC7\x8F", "\x81\x30\x9F\x36", 1},
    {"\xC7\x91", "\x81\x30\x9F\x37", 1},
    {"\xC7\x93", "\x81\x30\x9F\x38", 1},
    {"\xC7\x95", "\x81\x30\x9F\x39", 1},
    {"\xC7\x97", "\x81\x30\xA0\x30", 1},
    {"\xC7\x99", "\x81\x30\xA0\x31", 1},
    {"\xC7\x9B", "\x81\x30\xA0\x32", 1},
    {"\xC7\x9D", "\x81\x30\xA0\x33", 28},
    {"\xC7\xBA", "\x81\x30\xA3\x31", 87},
    {"\xC9\x92", "\x81\x30\xAB\x38", 15},
    {"\xC9\xA2", "\x81\x30\xAD\x33", 101},
    {"\xCB\x88", "\x81\x30\xB7\x34", 1},
    {"\xCB\x8C", "\x81\x30\xB7\x35", 13},
    {"\xCB\x9A", "\x81\x30\xB8\x38", 183},
    {"\xCE\xA2", "\x81\x30\xCB\x31", 1},
    {"\xCE\xAA", "\x81\x30\xCB\x32", 7},
    {"\xCF\x82", "\x81\x30\xCB\x39", 1},
    {"\xCF\x8A", "\x81\x30\xCC\x30", 55},
    {"\xD0\x82", "\x81\x30\xD1\x35", 14},
    {"\xD1\x90", "\x81\x30\xD2\x39", 1},
    {"\xD1\x92", "\x81\x30\xD3\x30", 942},
    {"\xE0\xA0\x80", "\x81\x31\xB3\x32", 2048},
    {"\xE1\x80\x80", "\x81\x33\x84\x30", 3647},
    {"\xE1\xB9\x80", "\x81\x35\xF4\x38", 448},
    {"\xE2\x80\x80", "\x81\x36\xA3\x36", 16},
    {"\xE2\x80\x91", "\x81\x36\xA5\x32", 2},
    {"\xE2\x80\x97", "\x81\x36\xA5\x34", 1},
    {"\xE2\x80\x9A", "\x81\x36\xA5\x35", 2},
    {"\xE2\x80\x9E", "\x81\x36\xA5\x37", 7},
    {"\xE2\x80\xA7", "\x81\x36\xA6\x34", 9},
    {"\xE2\x80\xB1", "\x81\x36\xA7\x33", 1},
    {"\xE2\x80\xB4", "\x81\x36\xA7\x34", 1},
    {"\xE2\x80\xB6", "\x81\x36\xA7\x35", 5},
    {"\xE2\x80\xBC", "\x81\x36\xA8\x30", 112},
    {"\xE2\x82\xAD", "\x81\x36\xB3\x32", 86},
    {"\xE2\x84\x84", "\x81\x36\xBB\x38", 1},
    {"\xE2\x84\x86", "\x81\x36\xBB\x39", 3},
    {"\xE2\x84\x8A", "\x81\x36\xBC\x32", 12},
    {"\xE2\x84\x97", "\x81\x36\xBD\x34", 10},
    {"\xE2\x84\xA2", "\x81\x36\xBE\x34", 62},
    {"\xE2\x85\xAC", "\x81\x36\xC4\x36", 4},
    {"\xE2\x85\xBA", "\x81\x36\xC5\x30", 22},
    {"\xE2\x86\x94", "\x81\x36\xC7\x32", 2},
    {"\xE2\x86\x9A", "\x81\x36\xC7\x34", 110},
    {"\xE2\x88\x89", "\x81\x36\xD2\x34", 6},
    {"\xE2\x88\x90", "\x81\x36\xD3\x30", 1},
    {"\xE2\x88\x92", "\x81\x36\xD3\x31", 3},
    {"\xE2\x88\x96", "\x81\x36\xD3\x34", 4},
    {"\xE2\x88\x9B", "\x81\x36\xD3\x38", 2},
    {"\xE2\x88\xA1", "\x81\x36\xD4\x30", 2},
    {"\xE2\x88\xA4", "\x81\x36\xD4\x32", 1},
    {"\xE2\x88\xA6", "\x81\x36\xD4\x33", 1},
    {"\xE2\x88\xAC", "\x81\x36\xD4\x34", 2},
    {"\xE2\x88\xAF", "\x81\x36\xD4\x36", 5},
    {"\xE2\x88\xB8", "\x81\x36\xD5\x31", 5},
    {"\xE2\x88\xBE", "\x81\x36\xD5\x36", 10},
    {"\xE2\x89\x89", "\x81\x36\xD6\x36", 3},
    {"\xE2\x89\x8D", "\x81\x36\xD6\x39", 5},
    {"\xE2\x89\x93", "\x81\x36\xD7\x34", 13},
    {"\xE2\x89\xA2", "\x81\x36\xD8\x37", 2},
    {"\xE2\x89\xA8", "\x81\x36\xD8\x39", 6},
    {"\xE2\x89\xB0", "\x81\x36\xD9\x35", 37},
    {"\xE2\x8A\x96", "\x81\x36\xDD\x32", 3},
    {"\xE2\x8A\x9A", "\x81\x36\xDD\x35", 11},
    {"\xE2\x8A\xA6", "\x81\x36\xDE\x36", 25},
    {"\xE2\x8B\x80", "\x81\x36\xE1\x31", 82},
    {"\xE2\x8C\x93", "\x81\x36\xE9\x33", 333},
    {"\xE2\x91\xAA", "\x81\x37\x8C\x36", 10},
    {"\xE2\x92\x9C", "\x81\x37\x8D\x36", 100},
    {"\xE2\x95\x8C", "\x81\x37\x97\x36", 4},
    {"\xE2\x95\xB4", "\x81\x37\x98\x30", 13},
    {"\xE2\x96\x90", "\x81\x37\x99\x33", 3},
    {"\xE2\x96\x96", "\x81\x37\x99\x36", 10},
    {"\xE2\x96\xA2", "\x81\x37\x9A\x36", 16},
    {"\xE2\x96\xB4", "\x81\x37\x9C\x32", 8},
    {"\xE2\x96\xBE", "\x81\x37\x9D\x30", 8},
    {"\xE2\x97\x88", "\x81\x37\x9D\x38", 3},
    {"\xE2\x97\x8C", "\x81\x37\x9E\x31", 2},
    {"\xE2\x97\x90", "\x81\x37\x9E\x33", 18},
    {"\xE2\x97\xA6", "\x81\x37\xA0\x31", 31},
    {"\xE2\x98\x87", "\x81\x37\xA3\x32", 2},
    {"\xE2\x98\x8A", "\x81\x37\xA3\x34", 54},
    {"\xE2\x99\x81", "\x81\x37\xA8\x38", 1},
    {"\xE2\x99\x83", "\x81\x37\xA8\x39", 2110},
    {"\xE2\xBA\x82", "\x81\x38\xFD\x39", 2},
    {"\xE2\xBA\x85", "\x81\x38\xFE\x31", 3},
    {"\xE2\xBA\x89", "\x81\x38\xFE\x34", 2},
    {"\xE2\xBA\x8D", "\x81\x38\xFE\x36", 10},
    {"\xE2\xBA\x98", "\x81\x39\x81\x36", 15},
    {"\xE2\xBA\xA8", "\x81\x39\x83\x31", 2},
    {"\xE2\xBA\xAB", "\x81\x39\x83\x33", 3},
    {"\xE2\xBA\xAF", "\x81\x39\x83\x36", 4},
    {"\xE2\xBA\xB4", "\x81\x39\x84\x30", 2},
    {"\xE2\xBA\xB8", "\x81\x39\x84\x32", 3},
    {"\xE2\xBA\xBC", "\x81\x39\x84\x35", 14},
    {"\xE2\xBB\x8B", "\x81\x39\x85\x39", 293},
    {"\xE2\xBF\xBC", "\x81\x39\xA3\x32", 4},
    {"\xE3\x80\x84", "\x81\x39\xA3\x36", 1},
    {"\xE3\x80\x98", "\x81\x39\xA3\x37", 5},
    {"\xE3\x80\x9F", "\x81\x39\xA4\x32", 2},
    {"\xE3\x80\xAA", "\x81\x39\xA4\x34", 20},
    {"\xE3\x80\xBF", "\x81\x39\xA6\x34", 2},
    {"\xE3\x82\x94", "\x81\x39\xA6\x36", 7},
    {"\xE3\x82\x9F", "\x81\x39\xA7\x33", 2},
    {"\xE3\x83\xB7", "\x81\x39\xA7\x35", 5},
    {"\xE3\x83\xBF", "\x81\x39\xA8\x30", 6},
    {"\xE3\x84\xAA", "\x81\x39\xA8\x36", 246},
    {"\xE3\x88\xAA", "\x81\x39\xC1\x32", 7},
    {"\xE3\x88\xB2", "\x81\x39\xC1\x39", 113},
    {"\xE3\x8A\xA4", "\x81\x39\xCD\x32", 234},
    {"\xE3\x8E\x90", "\x81\x39\xE4\x36", 12},
    {"\xE3\x8E\x9F", "\x81\x39\xE5\x38", 2},
    {"\xE3\x8E\xA2", "\x81\x39\xE6\x30", 34},
    {"\xE3\x8F\x85", "\x81\x39\xE9\x34", 9},
    {"\xE3\x8F\x8F", "\x81\x39\xEA\x33", 2},
    {"\xE3\x8F\x93", "\x81\x39\xEA\x35", 2},
    {"\xE3\x8F\x96", "\x81\x39\xEA\x37", 113},
    {"\xE3\x91\x88", "\x81\x39\xF6\x30", 43},
    {"\xE3\x91\xB4", "\x81\x39\xFA\x33", 298},
    {"\xE3\x96\x9F", "\x82\x30\x9A\x31", 111},
    {"\xE3\x98\x8F", "\x82\x30\xA5\x32", 11},
    {"\xE3\x98\x9B", "\x82\x30\xA6\x33", 765},
    {"\xE3\xA4\x99", "\x82\x30\xF2\x38", 85},
    {"\xE3\xA5\xAF", "\x82\x30\xFB\x33", 96},
    {"\xE3\xA7\x91", "\x82\x31\x86\x39", 14},
    {"\xE3\xA7\xA0", "\x82\x31\x88\x33", 147},
    {"\xE3\xA9\xB4", "\x82\x31\x97\x30", 218},
    {"\xE3\xAD\x8F", "\x82\x31\xAC\x38", 287},
    {"\xE3\xB1\xAF", "\x82\x31\xC9\x35", 113},
    {"\xE3\xB3\xA1", "\x82\x31\xD4\x38", 799},
    {"\xE4\x80\x80", "\x82\x32\xA6\x37", 86},
    {"\xE4\x81\x97", "\x82\x32\xAF\x33", 264},
    {"\xE4\x85\xA0", "\x82\x32\xC9\x37", 471},
    {"\xE4\x8C\xB8", "\x82\x32\xF8\x38", 116},
    {"\xE4\x8E\xAD", "\x82\x33\x86\x34", 4},
    {"\xE4\x8E\xB2", "\x82\x33\x86\x38", 43},
    {"\xE4\x8F\x9E", "\x82\x33\x8B\x31", 248},
    {"\xE4\x93\x97", "\x82\x33\xA3\x39", 373},
    {"\xE4\x99\x8D", "\x82\x33\xC9\x32", 20},
    {"\xE4\x99\xA2", "\x82\x33\xCB\x32", 193},
    {"\xE4\x9C\xA4", "\x82\x33\xDE\x35", 5},
    {"\xE4\x9C\xAA", "\x82\x33\xDF\x30", 82},
    {"\xE4\x9D\xBD", "\x82\x33\xE7\x32", 16},
    {"\xE4\x9E\x8E", "\x82\x33\xE8\x38", 441},
    {"\xE4\xA5\x88", "\x82\x34\x96\x39", 50},
    {"\xE4\xA5\xBB", "\x82\x34\x9B\x39", 2},
    {"\xE4\xA5\xBE", "\x82\x34\x9C\x31", 4},
    {"\xE4\xA6\x84", "\x82\x34\x9C\x35", 1},
    {"\xE4\xA6\x87", "\x82\x34\x9C\x36", 20},
    {"\xE4\xA6\x9C", "\x82\x34\x9E\x36", 3},
    {"\xE4\xA6\xA0", "\x82\x34\x9E\x39", 22},
    {"\xE4\xA6\xB8", "\x82\x34\xA1\x31", 703},
    {"\xE4\xB1\xB8", "\x82\x34\xE7\x34", 39},
    {"\xE4\xB2\xA4", "\x82\x34\xEB\x33", 111},
    {"\xE4\xB4\x9A", "\x82\x34\xF6\x34", 148},
    {"\xE4\xB6\xAF", "\x82\x35\x87\x32", 81},
    {"\xE9\xBE\xA6", "\x82\x35\x8F\x33", 14},
    {"\xE9\xBE\xBC", "\x82\x35\x91\x35", 68},
    {"\xEA\x80\x80", "\x82\x35\x98\x33", 4096},
    {"\xEB\x80\x80", "\x82\x38\xB7\x39", 4096},
    {"\xEC\x80\x80", "\x83\x31\xD7\x35", 4096},
    {"\xED\x80\x80", "\x83\x34\xF7\x31", 2048},
    {"\xEE\x9D\xAC", "\x83\x36\xC7\x39", 1},
    {"\xEE\x9F\x87", "\x81\x35\xF4\x37", 1},
    {"\xEE\x9F\x88", "\x83\x36\xC8\x30", 1},
    {"\xEE\x9F\xA7", "\x83\x36\xC8\x31", 13},
    {"\xEE\xA0\x95", "\x83\x36\xC9\x34", 1},
    {"\xEE\xA0\x99", "\x83\x36\xC9\x35", 5},
    {"\xEE\xA0\x9F", "\x83\x36\xCA\x30", 7},
    {"\xEE\xA0\xA7", "\x83\x36\xCA\x37", 4},
    {"\xEE\xA0\xAD", "\x83\x36\xCB\x31", 4},
    {"\xEE\xA0\xB3", "\x83\x36\xCB\x35", 8},
    {"\xEE\xA0\xBC", "\x83\x36\xCC\x33", 7},
    {"\xEE\xA1\x84", "\x83\x36\xCD\x30", 16},
    {"\xEE\xA1\x96", "\x83\x36\xCE\x36", 14},
    {"\xEE\xA1\xA5", "\x83\x36\xD0\x30", 1947},
    {"\xEF\x80\x80", "\x83\x38\x96\x37", 2348},
    {"\xEF\xA4\xAD", "\x84\x30\x85\x35", 76},
    {"\xEF\xA5\xBA", "\x84\x30\x8D\x31", 27},
    {"\xEF\xA6\x96", "\x84\x30\x8F\x38", 81},
    {"\xEF\xA7\xA8", "\x84\x30\x97\x39", 9},
    {"\xEF\xA7\xB2", "\x84\x30\x98\x38", 26},
    {"\xEF\xA8\x90", "\x84\x30\x9B\x34", 1},
    {"\xEF\xA8\x92", "\x84\x30\x9B\x35", 1},
    {"\xEF\xA8\x95", "\x84\x30\x9B\x36", 3},
    {"\xEF\xA8\x99", "\x84\x30\x9B\x39", 6},
    {"\xEF\xA8\xA2", "\x84\x30\x9C\x35", 1},
    {"\xEF\xA8\xA5", "\x84\x30\x9C\x36", 2},
    {"\xEF\xA8\xAA", "\x84\x30\x9C\x38", 998},
    {"\xEF\xB8\x9A", "\x84\x31\x83\x36", 22},
    {"\xEF\xB8\xB2", "\x84\x31\x85\x38", 1},
    {"\xEF\xB9\x85", "\x84\x31\x85\x39", 4},
    {"\xEF\xB9\x93", "\x84\x31\x86\x33", 1},
    {"\xEF\xB9\x98", "\x84\x31\x86\x34", 1},
    {"\xEF\xB9\xA7", "\x84\x31\x86\x35", 1},
    {"\xEF\xB9\xAC", "\x84\x31\x86\x36", 149},
    {"\xEF\xBD\x9F", "\x84\x31\x95\x35", 129},
    {"\xEF\xBF\xA6", "\x84\x31\xA2\x34", 26},
    {"\xF0\x90\x80\x80", "\x90\x30\x81\x30", 65671},
    {"\xF0\xA0\x82\x88", "\x95\x32\x90\x32", 1},
    {"\xF0\xA0\x82\x8A", "\x95\x32\x90\x34", 66},
    {"\xF0\xA0\x83\x8D", "\x95\x32\x97\x31", 5386},
    {"\xF0\xA1\x97\x98", "\x95\x36\xB9\x38", 5047},
    {"\xF0\xA2\xA6\x90", "\x96\x30\xBA\x36", 6254},
    {"\xF0\xA4\x87\xBF", "\x96\x35\xB6\x31", 114177},
    {"\xF1\x80\x80\x80", "\x9F\x36\x85\x38", 262144},
    {"\xF2\x80\x80\x80", "\xB4\x34\x8C\x32", 262144},
    {"\xF3\x80\x80\x80", "\xC9\x32\x92\x36", 262144},
    {"\xF4\x80\x80\x80", "\xDE\x30\x99\x30", 65536},
    {"\xF7\xBF\xBF\xBF", "\xFE\x39\xFE\x39", 1}
};

} // namespace apolloron
