#include <mach-o/dyld.h>
#include <CoreFoundation/CoreFoundation.h>
#include <Carbon/Carbon.h>
#include <ApplicationEnhancer/ApplicationEnhancer.h>
#include <ApplicationEnhancer/APETools.h>


struct objc_method {
  char *method_name;
  char *method_types;
  void *method_imp;
};

void * NSSelectorFromString(CFStringRef string);
void * objc_msgSend(void *target, char *selector, ...);
void objc_msgSend_stret(void *stret, void *target, char *selector, ...);
struct objc_method * class_getInstanceMethod(void *inClass, void *selector);
void * objc_getClass(const char *name);

extern void *NSFontAttributeName;
extern void *NSParagraphStyleAttributeName;
extern void *NSForegroundColorAttributeName;
extern void *NSUnderlineStyleAttributeName;
extern void *NSSuperscriptAttributeName;
extern void *NSBackgroundColorAttributeName;
extern void *NSAttachmentAttributeName;
extern void *NSLigatureAttributeName;
extern void *NSBaselineOffsetAttributeName;
extern void *NSKernAttributeName;
extern void *NSLinkAttributeName;


// NSTextView
//   - (void)setMarkedText:(id)aString selectedRange:(NSRange)selRange
typedef void (*NSTextView_setMarkedText_selectedRangeProcPtr)(void *inObj, char *inSel, void *aString, CFRange selRange);

NSTextView_setMarkedText_selectedRangeProcPtr
  gNSTextView_setMarkedText_selectedRange = NULL;

void
IH_NSTextView_setMarkedText_selectedRange(void *inObj, char *inSel, void *aString, CFRange selRange);

// NSTextView
//   - (NSArray *)validAttributesForMarkedText
typedef void * (*NSTextView_validAttributesForMarkedTextProcPtr)(void *inObj, char *inSel);

NSTextView_validAttributesForMarkedTextProcPtr
  gNSTextView_validAttributesForMarkedText = NULL;

void *
IH_NSTextView_validAttributesForMarkedText(void *inObj, char *inSel);


// reloads our preferences
static void My_ReloadPrefs();

void
APEBundleMainEarlyLoad(CFBundleRef inBundle, CFStringRef inAPEToolsApplicationID)
{
  void *nsClass;
  struct objc_method* method;
  
  // check if this application is in the exclude list;
  if (APEToolsIsInExcludeList(CFSTR("info.yatsu.InputHiliter"), NULL)) {
     apeprintf("InputHiliter: not loading as this application is excluded.\n");
     return;
  }
  
  // load preferences
  My_ReloadPrefs();
  
  if ((nsClass = objc_getClass("NSTextView"))) {
    if ((method =
         class_getInstanceMethod(nsClass,
                                 NSSelectorFromString(CFSTR("setMarkedText:selectedRange:"))))) {
      gNSTextView_setMarkedText_selectedRange =
        (NSTextView_setMarkedText_selectedRangeProcPtr)
          APEPatchCreate(method->method_imp,
                         &IH_NSTextView_setMarkedText_selectedRange);
    }
  
    /*
    if ((method =
         class_getInstanceMethod(nsClass,
                                 NSSelectorFromString(CFSTR("validAttributesForMarkedText"))))) {
      gNSTextView_validAttributesForMarkedText =
        (NSTextView_validAttributesForMarkedTextProcPtr)
          APEPatchCreate(method->method_imp,
                         &IH_NSTextView_validAttributesForMarkedText);
    }
    */
  }

  apeprintf("InputHiliter: APEBundleMainEarlyLoad()...done\n");
}

void
IH_NSTextView_setMarkedText_selectedRange(void *inObj, char *inSel, void *aString, CFRange selRange)
{
  CFRange range = CFRangeMake(0, 0);
  unsigned index = range.location + range.length;
  unsigned length = (unsigned) objc_msgSend(aString, NSSelectorFromString(CFSTR("length")));
  void *layoutManager = NULL;
  static void *nsColor = NULL;
  static void *activeForeground = NULL;
  static void *otherForeground = NULL;
  static void *activeBackground = NULL;
  static void *otherBackground = NULL;
  CFDictionaryRef attr;
  CFRange markedRange = {0, 0};
  
  gNSTextView_setMarkedText_selectedRange(inObj, inSel, aString, selRange);
  
#if 1
  {
    CFStringRef desc;
    char buf[BUFSIZ];
    
    desc = (CFStringRef) objc_msgSend(aString, NSSelectorFromString(CFSTR("description")));
    CFStringGetCString(desc, buf, BUFSIZ - 1, kCFStringEncodingUTF8);
    
    apeprintf("IH_NSInputManager_setMarkedText_selectedRange() aString='%s' selRange=(%d,%d)\n",
              buf, selRange.location, selRange.length);
  }
#endif
  
  objc_msgSend_stret(&markedRange, inObj, NSSelectorFromString(CFSTR("markedRange")));
  
  //apeprintf("markedRange=(%d,%d)\n",
  //          markedRange.location, markedRange.length);
  
  if (!layoutManager) {
    layoutManager = objc_msgSend(inObj, NSSelectorFromString(CFSTR("layoutManager")));
    if (!layoutManager) return;
  }
  
  if (!nsColor) {
    nsColor = objc_getClass("NSColor");
    if (!nsColor) return;
  }
  
  if (!activeForeground)
    activeForeground =
      objc_msgSend(nsColor, NSSelectorFromString(CFSTR("selectedMenuItemTextColor")));

  if (!otherForeground)
    otherForeground =
      objc_msgSend(nsColor, NSSelectorFromString(CFSTR("selectedTextColor")));
  
  if (!activeBackground)
    activeBackground =
      objc_msgSend(nsColor, NSSelectorFromString(CFSTR("selectedMenuItemColor")));
  
  if (!otherBackground)
    otherBackground =
      objc_msgSend(nsColor, NSSelectorFromString(CFSTR("selectedTextBackgroundColor")));
  
  while (index < length &&
         (attr = (CFDictionaryRef)
          objc_msgSend(aString, NSSelectorFromString(CFSTR("attributesAtIndex:effectiveRange:")),
                       index, &range))) {
    CFNumberRef underline;
    int val = 0;
    CFRange updateRange = {
      markedRange.location + range.location,
      range.length
    };

#if 0
    CFStringRef desc;
    char buf[BUFSIZ];
    
    desc = (CFStringRef) objc_msgSend((void *) attr, NSSelectorFromString(CFSTR("description")));
    CFStringGetCString(desc, buf, BUFSIZ - 1, kCFStringEncodingUTF8);
    apeprintf("attr %u: range=(%d,%d) updateRange=(%d,%d) %s\n",
              index, range.location, range.length,
              updateRange.location, updateRange.length,
              buf);
#endif
    
    underline = CFDictionaryGetValue(attr, NSUnderlineStyleAttributeName);
    if (underline) {
      CFNumberGetValue(underline, kCFNumberIntType, &val);
      //apeprintf("underline=%d\n", val);
    }
    
    if (val) {
      CFMutableDictionaryRef mAttr = CFDictionaryCreateMutableCopy(kCFAllocatorDefault, 0, attr);
      switch (val) {
        case 1:
          CFDictionaryAddValue(mAttr, NSForegroundColorAttributeName,
                               otherForeground);
          CFDictionaryAddValue(mAttr, NSBackgroundColorAttributeName,
                               otherBackground);
        break;
          
        case 2:
          CFDictionaryAddValue(mAttr, NSForegroundColorAttributeName,
                               activeForeground);
          CFDictionaryAddValue(mAttr, NSBackgroundColorAttributeName,
                               activeBackground);
        break;
      }
      objc_msgSend(layoutManager,
                   NSSelectorFromString(CFSTR("setTemporaryAttributes:forCharacterRange:")),
                   mAttr, updateRange);
    }
    index = range.location + range.length;
  }
}

void *
IH_NSTextView_validAttributesForMarkedText(void *inObj, char *inSel)
{
  CFArrayRef array = (CFArrayRef) gNSTextView_validAttributesForMarkedText(inObj, inSel);
  CFStringRef attr;
  CFIndex i;

  apeprintf("IH_NSTextView_validAttributesForMarkedText()\n");
  
  for (i = 0; i < CFArrayGetCount(array); i++) {
    char buf[BUFSIZ];
    
    attr = (CFStringRef) CFArrayGetValueAtIndex(array, i);
    CFStringGetCString(attr, buf, BUFSIZ - 1, kCFStringEncodingUTF8);
    apeprintf("attr %d: '%s'\n", i, buf);
  }
  
  return (void *) array;
}

OSStatus
APEBundleMessage(CFStringRef message,CFDataRef inData,CFDataRef *outData)
{
  apeprintf("InputHiliter: message '%@' (inData = %@)\n", message, inData);
    
  // request to reload prefs from our preference pane
  if (CFStringCompare(message, CFSTR("Refresh"), NULL) == kCFCompareEqualTo) {
    My_ReloadPrefs();
  }
    
  return noErr;
}

// Reload our settings from the info.yatsu.InputHiliter.plist
static void
My_ReloadPrefs()
{
  //Boolean keyExists;
  CFPreferencesAppSynchronize(CFSTR("info.yatsu.InputHiliter"));
}
