#!/bin/bash

if [ "$1" ] ; then
    TARGETROOT=$1

    # copy files.
    cp -pf ./src/liblpr.la ${TARGETROOT}/lib
    cp -pf ./src/.libs/liblpr.a ${TARGETROOT}/lib

    cp -pf ./src/lpq ${TARGETROOT}/usr/bin
    cp -pf ./src/lprm ${TARGETROOT}/usr/bin
    cp -pf ./src/lpr ${TARGETROOT}/usr/bin
    cp -pf ./src/lpstat ${TARGETROOT}/usr/bin
    cp -pf ./src/lpc ${TARGETROOT}/usr/sbin
    cp -pf ./src/lpd ${TARGETROOT}/usr/sbin
#    cp -pf ./lpf ${TARGETROOT}/

    cp -pf ./lpd.conf ${TARGETROOT}/etc/lpd
    cp -pf ./lpd.perms ${TARGETROOT}/etc/lpd


    # change mode and owner, group.
    chmod 755 ${TARGETROOT}/lib/liblpr.la
    chmod 755 ${TARGETROOT}/lib/liblpr.a

    chmod 755 ${TARGETROOT}/usr/bin/lpq
    chmod 755 ${TARGETROOT}/usr/bin/lprm
    chmod 755 ${TARGETROOT}/usr/bin/lpr
    chmod 755 ${TARGETROOT}/usr/bin/lpstat
    chmod 755 ${TARGETROOT}/usr/sbin/lpc
    chmod 755 ${TARGETROOT}/usr/sbin/lpd

    chmod 644 ${TARGETROOT}/etc/lpd/lpd.conf 
    chmod 644 ${TARGETROOT}/etc/lpd/lpd.perms


    chown root:root ${TARGETROOT}/lib/liblpr.la
    chown root:root ${TARGETROOT}/lib/liblpr.a

    chown lp:lp ${TARGETROOT}/usr/bin/lpq
    chown lp:lp ${TARGETROOT}/usr/bin/lprm
    chown lp:lp ${TARGETROOT}/usr/bin/lpr
    chown lp:lp ${TARGETROOT}/usr/bin/lpstat
    chown lp:lp ${TARGETROOT}/usr/sbin/lpc
    chown root:root ${TARGETROOT}/usr/sbin/lpd

    chown root:root ${TARGETROOT}/etc/lpd/lpd.conf 
    chown root:root ${TARGETROOT}/etc/lpd/lpd.perms

fi

