/*
 * linux/arch/sh/kernel/mach_julian.c
 *
 * Minor tweak of mach_se.c file to reference julian-specific items.
 *
 * May be copied or modified under the terms of the GNU General Public
 * License.  See linux/COPYING for more information.
 *
 * Machine vector for the I-O DATA Device, Inc. Julian
 */

#include <linux/config.h>
#include <linux/init.h>

#include <asm/machvec.h>
#include <asm/rtc.h>
#include <asm/machvec_init.h>

#include <asm/io_julian.h>

extern void heartbeat_julian(void);
extern int julian_rtc_settimeofday(const struct timeval *tv);

extern void setup_julian(void);
extern void init_julian_IRQ(void);
extern void *julian_ioremap(unsigned long, unsigned long);
extern void julian_iounmap(void *);

/*
 * The Machine Vector
 */

struct sh_machine_vector mv_julian __initmv = {
	mv_name:		"7751R Julian",

	mv_nr_irqs:		72,

	mv_inb:			julian_inb,
	mv_inw:			julian_inw,
	mv_inl:			julian_inl,
	mv_outb:		julian_outb,
	mv_outw:		julian_outw,
	mv_outl:		julian_outl,

	mv_inb_p:		julian_inb_p,
	mv_inw_p:		julian_inw,
	mv_inl_p:		julian_inl,
	mv_outb_p:		julian_outb_p,
	mv_outw_p:		julian_outw,
	mv_outl_p:		julian_outl,

	mv_insb:		julian_insb,
	mv_insw:		julian_insw,
	mv_insl:		julian_insl,
	mv_outsb:		julian_outsb,
	mv_outsw:		julian_outsw,
	mv_outsl:		julian_outsl,

	mv_readb:		julian_readb,
	mv_readw:		julian_readw,
	mv_readl:		julian_readl,
	mv_writeb:		julian_writeb,
	mv_writew:		julian_writew,
	mv_writel:		julian_writel,

	mv_ioremap:		julian_ioremap,
	mv_iounmap:		julian_iounmap,

	mv_isa_port2addr:	julian_isa_port2addr,

	mv_init_arch:		setup_julian,
	mv_init_irq:		init_julian_IRQ,
#ifdef CONFIG_HEARTBEAT
	mv_heartbeat:		heartbeat_julian,
#endif

	mv_rtc_gettimeofday:	sh_rtc_gettimeofday,
	mv_rtc_settimeofday:	julian_rtc_settimeofday,

	mv_hw_julian:		1,
};
ALIAS_MV(julian)
