/*
 * include/asm-sh/io_julian.h
 *
 * Modified version of io_se.h for the julian-specific functions.
 *
 * May be copied or modified under the terms of the GNU General Public
 * License.  See linux/COPYING for more information.
 *
 * IO functions for an I-O DATA Device, Inc. Julian
 */

#ifndef _ASM_SH_IO_JULIAN_H
#define _ASM_SH_IO_JULIAN_H

#include <asm/io_generic.h>

extern unsigned char julian_inb(unsigned long port);
extern unsigned short julian_inw(unsigned long port);
extern unsigned int julian_inl(unsigned long port);

extern void julian_outb(unsigned char value, unsigned long port);
extern void julian_outw(unsigned short value, unsigned long port);
extern void julian_outl(unsigned int value, unsigned long port);

extern unsigned char julian_inb_p(unsigned long port);
extern void julian_outb_p(unsigned char value, unsigned long port);

extern void julian_insb(unsigned long port, void *addr, unsigned long count);
extern void julian_insw(unsigned long port, void *addr, unsigned long count);
extern void julian_insl(unsigned long port, void *addr, unsigned long count);
extern void julian_outsb(unsigned long port, const void *addr, unsigned long count);
extern void julian_outsw(unsigned long port, const void *addr, unsigned long count);
extern void julian_outsl(unsigned long port, const void *addr, unsigned long count);

extern unsigned char julian_readb(unsigned long addr);
extern unsigned short julian_readw(unsigned long addr);
extern unsigned int julian_readl(unsigned long addr);
extern void julian_writeb(unsigned char b, unsigned long addr);
extern void julian_writew(unsigned short b, unsigned long addr);
extern void julian_writel(unsigned int b, unsigned long addr);

extern void *julian_ioremap(unsigned long offset, unsigned long size);
extern void julian_iounmap(void *addr);

extern unsigned long julian_isa_port2addr(unsigned long offset);

#ifdef __WANT_IO_DEF

# define __inb			julian_inb
# define __inw			julian_inw
# define __inl			julian_inl
# define __outb			julian_outb
# define __outw			julian_outw
# define __outl			julian_outl

# define __inb_p		julian_inb_p
# define __inw_p		julian_inw
# define __inl_p		julian_inl
# define __outb_p		julian_outb_p
# define __outw_p		julian_outw
# define __outl_p		julian_outl

# define __insb			julian_insb
# define __insw			julian_insw
# define __insl			julian_insl
# define __outsb		julian_outsb
# define __outsw		julian_outsw
# define __outsl		julian_outsl

# define __readb		julian_readb
# define __readw		julian_readw
# define __readl		julian_readl
# define __writeb		julian_writeb
# define __writew		julian_writew
# define __writel		julian_writel

# define __isa_port2addr	julian_isa_port2addr
# define __ioremap		julian_ioremap
# define __iounmap		julian_iounmap

#endif

#endif /* _ASM_SH_IO_JULIAN_H */
