/* $Id: init-julian.S,v 0.01 2002/08/21 09:09:19 gniibe Exp $
 *
 *  gdb-sh-stub/init-julian.S
 *
 *  I-O DATA Julian (SH7751R based)
 */

#include "config.h"
#include "linkage.h"

#define LED_ADDRESS	0xB0000001 /* Address of LED register */
#define SDMR3_ADDRESS	0xFF940022 /* SDMR3 address on 32-bit bus */


ENTRY(init_bsc)
	mov.l	FRQCR_A,r1	/* FRQCR Address */
	mov.l	FRQCR_D,r0	/* FRQCR Data */
	mov.w	r0,@r1

	mov.l	BCR1_A,r1	/* BCR1 Address */
	mov.l	BCR1_D,r0	/* BCR1 Data */
	mov.l	r0,@r1

	mov.l	BCR2_A,r1	/* BCR2 Address */
	mov.l	BCR2_D,r0	/* BCR2 Data */
	mov.w	r0,@r1

	mov.l	WCR1_A,r1	/* WCR1 Address */
	mov.l	WCR1_D,r0	/* WCR1 Data */
	mov.l	r0,@r1

	mov.l	WCR2_A,r1	/* WCR2 Address */
	mov.l	WCR2_D,r0	/* WCR2 Data */
	mov.l	r0,@r1

	mov.l	WCR3_A,r1	/* WCR3 Address */
	mov.l	WCR3_D,r0	/* WCR3 Data */
	mov.l	r0,@r1

	mov.l	PCR_A,r1	/* PCR Address */
	mov.l	PCR_D,r0	/* PCR Data */
	mov.l	r0,@r1

!	mov.l	LED_A,r1	/* LED Address */
!	mov	#0,r0		/* LED "0" */
!	mov.b	r0,@r1

	mov.l	MCR_A,r1	/* MCR Address */
	mov.l	MCR_D1,r0	/* MCR Data1 */
	mov.l	r0,@r1

!	mov.l	SDMR3_A,r1	/* Set SDRAM mode */
!	mov	#0,r0
!	mov.b	r0,@r1

	! Do you need PCMCIA setting?	
	! If so, please add the lines here...

	mov.l	RTCNT_A,r1	/* RTCNT Address */
	mov.l	RTCNT_D,r0	/* RTCNT Data */
	mov.w	r0,@r1

	mov.l	RTCOR_A,r1	/* RTCOR Address */
	mov.l	RTCOR_D,r0	/* RTCOR Data */
	mov.w	r0,@r1

	mov.l	RTCSR_A,r1	/* RTCSR Address */
	mov.l	RTCSR_D,r0	/* RTCSR Data */
	mov.w	r0,@r1

	mov.l	RFCR_A,r1	/* RFCR Address */
	mov.l	RFCR_D,r0	/* RFCR Data */
	mov.w	r0,@r1		/* Clear reflesh counter */
	/* Wait DRAM refresh 30 times */
	mov	#30,r3
1:
	mov.w	@r1,r0
	extu.w	r0,r2
	cmp/hi	r3,r2
	bf	1b

	mov.l	MCR_A,r1	/* MCR Address */
	mov.l	MCR_D2,r0	/* MCR Data2 */
	mov.l	r0,@r1

	mov.l	SDMR3_A,r1	/* Set SDRAM mode */
	mov	#0,r0
	mov.b	r0,@r1

	mov.l	PTEA_A,r1	/* PTEA Address */
	mov.l	PTEA_D,r0	/* PTEA Data */
	mov.l	r0,@r1

	mov.l	CPLD_A,r1	/* CPLD Address */
	mov.l	CPLD_D,r0	/* CPLD Data */
	mov.b	r0,@r1

	rts
	 nop

	.align	2

FRQCR_A:
	.long	0xFFC00000	/* FRQCR Address */
FRQCR_D:
	.long	0x00000E0A	/* 6:3:3/2	Mode4/Clock 27.8MHz */
!	.long	0x00000E0C	/* 6:3:3/4	Mode4/Clock:27.8MHz */
!	.long	0x00000E13	/* 6:2:1	Mode2/Clock 33.3MHz */
BCR1_A:
	.long	0xFF800000	/* BCR1 Address */
BCR1_D:
	.long	0x8000C009	/* Area 3 SDRAM */
BCR2_A:
	.long	0xFF800004	/* BCR2 Address */
BCR2_D:
	.long	0xA9E8		/* Area 1-6 width: 16/16/32/8/16/16 */
BCR3_A:
	.long	0xFF800050	/* BCR3 Address */
BCR3_D:
	.long	0x0001		/*  */
BCR4_A:
	.long	0xFE0A00F0	/* BCR4 Address */
BCR4_D:
	.long	0x00000000	/*  */
WCR1_A:
	.long	0xFF800008	/* WCR1 Address */
WCR1_D:
	.long	0x77777777	/* DMA:15 A0-A6:15 */
WCR2_A:
	.long	0xFF80000C	/* WCR2 Address */
WCR2_D:
	.long	0xDF7E66DF	/* A6:12 A6B:7 A5:12 A5B:7 A4:15
				   A3:   A2:3  A1:3  A0:3  A0B:7  */
WCR3_A:
	.long	0xFF800010	/* WCR3 Address */
WCR3_D:
	.long	0x07777777	/* A6: 1-3 A5: 1-3 A4: 1-3 A3: 1-3
				   A2: 1-3 A1: 1-3 A0: 1-3 */

LED_A:
	.long	LED_ADDRESS	/* LED Address */

RTCNT_A:
	.long	0xFF800020	/* RTCNT Address */
RTCNT_D:
	.long	0xA500		/* RTCNT Write Code A5h Data 00h */

RTCOR_A:
	.long	0xFF800024	/* RTCOR Address */
RTCOR_D:
	.long	0xA5F8		/* Write code A5, data 0D (~15us?) */

RTCSR_A:
	.long	0xFF80001C	/* RTCSR Address */
RTCSR_D:
	.long	0xA508		/* RTCSR Write Code A5h Data 08h */

SDMR3_A:
	.long	SDMR3_ADDRESS
MCR_A:
	.long	0xFF800014	/* MCR Address */
MCR_D1:
!	.long	0x100A21F6	/* SDRAM 32-bit, CAS/RAS Refresh, ... */
	.long	0x100A21F4	/* SDRAM 32-bit, CAS/RAS Refresh, ... */
MCR_D2:
!	.long	0x500A21F6	/* Same w/MRSET now 1 (mode reg cmd) */
	.long	0x500A21F4	/* Same w/MRSET now 1 (mode reg cmd) */
RFCR_A:
	.long	0xFF800028	/* RFCR Address */
RFCR_D:
	.long	0xA400		/* RFCR Write Code A4h Data 00h */
PCR_A:
	.long	0xFF800018	/* PCR Address */
PCR_D:
	.long	0x0912		/* PCMCIA Control Register */
PTEA_A:
	.long	0xFF000034	/* PTEA Address */
PTEA_D:
	.long	0x0003		/* TC:0 SA2-0:011 A5PCW/A5TED/A5TEH/16bit I/O Access */
CPLD_A:
	.long	0xB0000000	/* CPLD Address */
CPLD_D:
	.long	0x0003		/* IDE Primary/Secondry */
