/* $Id: init-sesh3.S,v 1.9 2001/01/09 05:58:21 gniibe Exp $
 *
 *  gdb-sh-stub/init-sesh3.S
 *
 *  Data taken from Chapter 11 of "SH7709A SolutionEngine Manual"
 *
 */

#include "linkage.h"

ENTRY(init_bsc)
	mov.l	WTCSR_A,r1	/*WTCSR Address*/
	mov.l	WTCSR_D,r0	/*WTCSR Data*/
	mov.w	r0,@r1

	mov.l	WTCNT_A,r1	/*WTCNT Address*/
	mov.l	WTCNT_D,r0	/*WTCNT Data*/
	mov.w	r0,@r1

	mov.l	FRQCR_A,r1	/* FRQCR Address */
	mov.l	FRQCR_D,r0	/* FRQCR Data */
	mov.w	r0,@r1

	mov.l	BCR1_A,r1	/* BCR1 Address */
	mov.l	BCR1_D,r0	/* BCR1 Data */
	mov.w	r0,@r1

	mov.l	BCR2_A,r1	/* BCR2 Address */
	mov.l	BCR2_D,r0	/* BCR2 Data */
	mov.w	r0,@r1

	mov.l	BCR3_A,r1	/* BCR3 Address */
	mov.l	BCR3_D,r0	/* BCR3 Data */
	mov.w	r0,@r1

	mov.l	WCR1_A,r1	/* WCR1 Address */
	mov.l	WCR1_D,r0	/* WCR1 Data */
	mov.w	r0,@r1

	mov.l	WCR2_A,r1	/* WCR2 Address */
	mov.l	WCR2_D,r0	/* WCR2 Data */
	mov.w	r0,@r1

	mov.l	MCR_A,r1	/* MCR Address */
	mov.l	MCR_D1,r0	/* MCR Data */
	mov.w	r0,@r1

	mov.l	LOOP_COUNT,r0	/*DELAY LOOP*/
	mov	#1,r1
loop_1:
	sub	r1,r0
	cmp/eq	#0,r0
	bt	loop_1
	nop

	mov.l	MCR_A,r1	/* MCR Address */
	mov.l	MCR_D2,r0	/* MCR Data */
	mov.w	r0,@r1

	mov.l	DCR_A,r1	/* DCR Address */
	mov.l	DCR_D,r0	/* DCR Data */
	mov.w	r0,@r1

	mov.l	PCR_A,r1	/* PCR Address */
	mov.l	PCR_D,r0	/* PCR Data */
	mov.w	r0,@r1

!	mov.l	MCR_A,r1	/* MCR Address */
!	mov.l	MCR_D,r0	/* MCR Data */
!	mov.w	r0,@r1

!	mov.l	DCR_A,r1	/* DCR Address */
!	mov.l	DCR_D,r0	/* DCR Data */
!	mov.w	r0,@r1

	! Do you need PCMCIA setting?
	! If so, please add the lines here...

	mov.l	RTCSR_A,r1	/* RTCSR Address */
	mov.l	RTCSR_D,r0	/* RTCSR Data */
	mov.w	r0,@r1

	mov.l	RTCNT_A,r1	/* RTCNT Address */
	mov.l	RTCNT_D,r0	/* RTCNT Data */
	mov.w	r0,@r1

	mov.l	RTCOR_A,r1	/* RTCOR Address */
	mov.l	RTCOR_D,r0	/* RTCOR Data */
	mov.w	r0,@r1

	mov.l	RFCR_A,r1	/* RFCR Address */
	mov.l	RFCR_D,r0	/* RFCR Data */
	mov.w	r0,@r1		/* Clear reflesh counter */

	/* Wait DRAM refresh 8 times */
	mov.l	RFCR_A,r1	/* RFCR Address */
	mov	#8,r3
1:
	mov.w	@r1,r0
	extu.w	r0,r2
	cmp/hi	r3,r2
	bf	1b

	mov.l	SDMR3_A,r1	/* Set SDRAM mode */
	mov	#0,r0
	mov.b	r0,@r1

!ATOM debug
	mov.l	SCPCR_A,r1
	mov.l	SCPCR_D,r0
	mov.w	r0,@r1

!interrupt set
	mov.l	ICR1_A,r1
	mov.l	ICR1_D,r0
	mov.w	r0,@r1

	mov.l	BOOT_CONFIG_WORD,r1
	mov.w	@r1,r0
	exts.b	r0,r0
	cmp/eq	#0xde,r0	! MAGIC # for "doDEs"
	bf	1f
	mov.l	0f,r5
	mov.l	0f,r6
	mov.l	0f,r7
	bra	1f
	 nop
	.align	2
0:	.long 0xbabeface
1:
	rts
	 nop

	.align 2


! ATOM debug
FRQCR_A:
	.long	0xFFC00000	/* FRQCR Address */
FRQCR_D:
	.long	0x00000E13	/* 4:1:1 */
BCR1_A:
	.long	0xFF800000	/* BCR1 Address */
BCR1_D:
	.long	0x0000c009		/* Area 3 SDRAM */
BCR2_A:
	.long	0xFF800004	/* BCR2 Address */
BCR2_D:
	.long	0x29e8		/* Area 2:32bit Area 4:16bit 
		                   Area 3:32bit	Area 5:32bit Area 6:16bit */
BCR3_A:
	.long	0xFF800050	/* BCR3 Address */
BCR3_D:
	.long	0x0001		/* Same as initial value */
BCR4_A:
	.long	0xFE0A00F0	/* BCR4 Address */
BCR4_D:
	.long	0x00000000	/* Same as initial value */
WCR1_A:
	.long	0xFF800008	/* WCR1 Address */
WCR1_D:
	.long	0x77777777	/* Idle state cycle:
				   WAITSEL=0  A6:1 A5:3 A4:3 A3:1 A2:3 A0:1 */
WCR2_A:
	.long	0xFF80000C	/* WCR2 Address */
WCR2_D:
	.long	0xDF7E66DF		/* A6: 3 A5: 10 A4: 10 A3: 2 A2: 3 A0: 3  */
WCR3_A:
	.long	0xFF800010	/* WCR3 Address */
WCR3_D:
	.long	0x07777777
MCR_A:
	.long	0xFF800014	/* MCR Address */
MCR_D1:
	.long	0x100A21F6
MCR_D2:
	.long	0x500A21F6
DCR_A:
	.long	0xFFFFFF6A	/* DCR Address */
DCR_D:
	.long	0x0000
PCR_A:
	.long	0xFF800018	/* PCR Address */
PCR_D:
	.long	0x0912
RTCSR_A:
	.long	0xFF80001C	/* RTCSR Address */
RTCSR_D:
	.long	0xA508		/* RTCSR Write Code A5h Data 08h */

RTCNT_A:
	.long	0xFF800020	/* RTCOR Address */
RTCNT_D:
	.long	0xA500		/* RTCNT Write Code A5h Data 00h */

RTCOR_A:
	.long	0xFF800024	/* RTCOR Address */
RTCOR_D:
	.long	0xa5f8		/* RTCOR Write Code A5h Data 80h */

RFCR_A:
	.long	0xFF800028	/* RFCR Address */
RFCR_D:
	.long	0xA400		/* RFCR Write Code A4h Data 00h */
SDMR2_A:
	.long	0xFF900000	/* SDMR2 Address */
SDMR3_A:
	.long	0xFF940088	/* SDMR3 Address */
BOOT_CONFIG_WORD:
	.long	0xa8c00000

SCPCR_A:
	.long	0x04000116
SCPCR_D:
	.long	0x0000
ICR1_A:
	.long	0x04000010
ICR1_D:
	.long	0x0065
WTCSR_A:
	.long	0xFFFFFF84
WTCSR_D:
	.long	0xa500
WTCNT_A:
	.long	0xFFFFFF86
WTCNT_D:
	.long	0x5a00
LOOP_COUNT:
	.long	0x20000

