/* $Id: init-sesh4.S,v 1.17 2001/06/04 09:09:19 gniibe Exp $
 *
 *  gdb-sh-stub/init-sesh4.S
 *
 *  Data taken from Chapter 11 of "SH7750 SolutionEngine Manual"
 *  Modified for SH7751 based on manual and Hitachi FW defaults.
 */

#include "config.h"
#include "linkage.h"

#define BCR2_D_VALUE	0x29E8	   /* Area 1-6 width: 32/32/32/32/32/16 */
#define WCR1_D_VALUE    0x77777777 /* DMA:0 A6:2 A3:0 A0:1 Others:15 */
#define WCR2_D_VALUE    0xFFFE66DF /* A6:15 A6B:3 A5:15 A5B:7 A4:15
				      A3:2  A2:15 A1:15 A0:6  A0B:7  */
#define WCR3_D_VALUE	0x07777777 /* A6: 0-1 A5: 1-3 A4: 1-3 A3: 1-3
				      A2: 1-3 A1: 1-3 A0: 0-1 */
#define RTCOR_D_VALUE	0xA5F8	   /* Write code A5, data 0D (~15us?) */
! 2002.11.25 I-O DATA NSD NWG	mod.	SDRAM 4 burst to 8 burst.
!#define SDMR3_ADDRESS	0xFF9400C8 /* SDMR3 address on 32-bit bus */
#define SDMR3_ADDRESS	0xFF9400CC /* SDMR3 address on 32-bit bus */
#define MCR_D1_VALUE	0x100A21F4 /* SDRAM 32-bit, CAS/RAS Refresh, ... */
#define MCR_D2_VALUE	0x500A21F4 /* Same w/MRSET now 1 (mode reg cmd) */


ENTRY(init_bsc)
	mov.l	FRQCR_A,r1	/* FRQCR Address */
	mov.l	FRQCR_D,r0	/* FRQCR Data */
	mov.w	r0,@r1

	mov.l	MMUCCR_A,r1	/* MMUCCR Address */
	mov.l	MMUCCR_D,r0	/* MMUCCR Data */
	mov.w	r0,@r1

	mov.l	BCR1_A,r1	/* BCR1 Address */
	mov.l	BCR1_D,r0	/* BCR1 Data */
	mov.l	r0,@r1

!	mov.l	PCIBCR1_A,r1	/* PCIBCR1 Address */
!	mov.l	PCIBCR1_D,r0	/* PCIBCR1 Data */
!	mov.l	r0,@r1

	mov.l	BCR2_A,r1	/* BCR2 Address */
	mov.l	BCR2_D,r0	/* BCR2 Data */
	mov.w	r0,@r1

!	mov.l	PCIBCR2_A,r1	/* PCIBCR2 Address */
!	mov.l	PCIBCR2_D,r0	/* PCIBCR2 Data */
!	mov.w	r0,@r1

	mov.l	BCR3_A,r1	/* BCR3 Address */
	mov.l	BCR3_D,r0	/* BCR3 Data */
	mov.w	r0,@r1

!	mov.l	PCIBCR3_A,r1	/* PCIBCR3 Address */
!	mov.l	PCIBCR3_D,r0	/* PCIBCR3 Data */
!	mov.w	r0,@r1

	mov.l	BCR4_A,r1	/* BCR4 Address */
	mov.l	BCR4_D,r0	/* BCR4 Data */
	mov.l	r0,@r1

	mov.l	WCR1_A,r1	/* WCR1 Address */
	mov.l	WCR1_D,r0	/* WCR1 Data */
	mov.l	r0,@r1

!	mov.l	PCIWCR1_A,r1	/* PCIWCR1 Address */
!	mov.l	PCIWCR1_D,r0	/* PCIWCR1 Data */
!	mov.l	r0,@r1

	mov.l	WCR2_A,r1	/* WCR2 Address */
	mov.l	WCR2_D,r0	/* WCR2 Data */
	mov.l	r0,@r1

!	mov.l	PCIWCR2_A,r1	/* PCIWCR2 Address */
!	mov.l	PCIWCR2_D,r0	/* PCIWCR2 Data */
!	mov.l	r0,@r1

	mov.l	WCR3_A,r1	/* WCR3 Address */
	mov.l	WCR3_D,r0	/* WCR3 Data */
	mov.l	r0,@r1

!	mov.l	PCIWCR3_A,r1	/* PCIWCR3 Address */
!	mov.l	PCIWCR3_D,r0	/* PCIWCR3 Data */
!	mov.l	r0,@r1

	mov.l	PCR_A,r1	/* PCR Adress */
	mov.l	PCR_D,r0	/* PCR Data */
	mov.w	r0,@r1

	mov.l	MCR_A,r1	/* MCR Address */
	mov.l	MCR_D1,r0	/* MCR Data1 */
	mov.l	r0,@r1

!	mov.l	PCIMCR_A,r1	/* PCIMCR Address */
!	mov.l	PCIMCR_D1,r0	/* PCIMCR Data1 */
!	mov.l	r0,@r1

	mov.l	SDMR3_A,r1	/* Set SDRAM mode */
	mov	#0,r0
	mov.b	r0,@r1

	! Do you need PCMCIA setting?	
	! If so, please add the lines here...

	mov.l	RTCNT_A,r1	/* RTCNT Address */
	mov.l	RTCNT_D,r0	/* RTCNT Data */
	mov.w	r0,@r1

	mov.l	RTCOR_A,r1	/* RTCOR Address */
	mov.l	RTCOR_D,r0	/* RTCOR Data */
	mov.w	r0,@r1

	mov.l	RTCSR_A,r1	/* RTCSR Address */
	mov.l	RTCSR_D,r0	/* RTCSR Data */
	mov.w	r0,@r1

	mov.l	RFCR_A,r1	/* RFCR Address */
	mov.l	RFCR_D,r0	/* RFCR Data */
	mov.w	r0,@r1		/* Clear reflesh counter */
	/* Wait DRAM refresh 30 times */
	mov	#30,r3
1:
	mov.w	@r1,r0
	extu.w	r0,r2
	cmp/hi	r3,r2
	bf	1b

	mov.l	MCR_A,r1	/* MCR Address */
	mov.l	MCR_D2,r0	/* MCR Data2 */
	mov.l	r0,@r1

	mov.l	PCIMCR_A,r1	/* PCIMCR Address */
	mov.l	PCIMCR_D2,r0	/* PCIMCR Data2 */
	mov.l	r0,@r1

	mov.l	SDMR3_A,r1	/* Set SDRAM mode */
	mov	#0,r0
	mov.b	r0,@r1

	mov.l	PTEA_A,r1	/* PTEA Adress */
	mov.l	PTEA_D,r0	/* PTEA Data */
	mov.l	r0,@r1

	mov.l	CPLD_A,r1	/* IDE control port Address */
	mov.l	CPLD_D,r0	/* IDE reset */
	mov.b	r0,@r1

	mov.l	INTR_A,r1	/* INTERRUPT MASK Address */
	mov.l	INTR_D,r0	/* INTERRUPT MASK Data */
	mov.b	r0,@r1

	mov.l	LED_A,r1	/* LED Address */
	mov.l	LED_D,r0	/* LED Data */
	mov.b	r0,@r1

	mov.l	BOOT_CONFIG_WORD,r1
	mov.w	@r1,r0
	exts.b	r0,r0
	cmp/eq	#0xde,r0	! MAGIC # for "doDEs"
	bf	1f
	mov.l	0f,r5
	mov.l	0f,r6
	mov.l	0f,r7
	bra	1f
	 nop
	.align	2
0:	.long 0xbabeface
1:
	rts
	 nop

	.align	2

FRQCR_A:
	.long	0xFFC00000	/* FRQCR Address */
FRQCR_D:
	.long	0x00000E13	/* 166.74:55.58:27.79 or 240.00:80.00:40.00 */
!	.long	0x00000E0c	/* 166.81:83.40:20.86 */
BCR1_A:
	.long	0xFF800000	/* BCR1 Address */
BCR1_D:
	.long	0x0000C009	/* Area 3 SDRAM */
BCR2_A:
	.long	0xFF800004	/* BCR2 Address */
BCR2_D:
	.long	BCR2_D_VALUE	/* Bus width settings */
BCR3_A:
	.long	0xFF800050	/* BCR3 Address */
BCR3_D:
! 2002.11.25 I-O DATA NSD NWG	mod.	SDRAM 4 burst to 8 burst.
!	.long	0x0001
	.long	0x0000
BCR4_A:
	.long	0xFE0A00F0	/* BCR4 Address */
BCR4_D:
	.long	0x00000000
WCR1_A:
	.long	0xFF800008	/* WCR1 Address */
WCR1_D:
	.long	WCR1_D_VALUE	/* Inter-area or turnaround wait states */
WCR2_A:
	.long	0xFF80000C	/* WCR2 Address */
WCR2_D:
	.long	WCR2_D_VALUE	/* Per-area access and burst wait states */
WCR3_A:
	.long	0xFF800010	/* WCR3 Address */
WCR3_D:
	.long	WCR3_D_VALUE	/* Address setup and data hold cycles */
RTCNT_A:
	.long	0xFF800020	/* RTCNT Address */
RTCNT_D:
	.long	0xA500		/* RTCNT Write Code A5h Data 00h */
RTCOR_A:
	.long	0xFF800024	/* RTCOR Address */
RTCOR_D:
	.long	RTCOR_D_VALUE	/* Set refresh time (about 15us) */
RTCSR_A:
	.long	0xFF80001C	/* RTCSR Address */
RTCSR_D:
	.long	0xA508		/* RTCSR Write Code A5h Data 18h */

SDMR3_A:
	.long	SDMR3_ADDRESS
MCR_A:
	.long	0xFF800014	/* MCR Address */
MCR_D1:
	.long	MCR_D1_VALUE
MCR_D2:
	.long	MCR_D2_VALUE
PCR_A:
	.long	0xFF800018
PCR_D:
!	.long	0x0912
	.long	0x0b5b
RFCR_A:
	.long	0xFF800028	/* RFCR Address */
RFCR_D:
	.long	0xA400		/* RFCR Write Code A4h Data 00h */
PTEA_A:
	.long	0xFF000034
PTEA_D:
	.long	0x0003
CPLD_A:
	.long	0xB0000000
CPLD_D:
	.long	0x0003
INTR_A:
	.long	0xB0000005
INTR_D:
	.long	0x00
LED_A:
	.long	0xB0000001
LED_D:
! 2002.12.04 I-O DATA NSD NWG	mod.	set LED boot default.
!	.long	0x00
	.long	0xFC
PCIBCR1_A:
	.long	0xFE2001E0
PCIBCR1_D:
	.long	0x4000C009
PCIBCR2_A:
	.long	0xFE2001E4
PCIBCR2_D:
	.long	0x29E8
PCIBCR3_A:
	.long	0xFE2001F8
PCIBCR3_D:
! 2002.11.25 I-O DATA NSD NWG	mod.	SDRAM 4 burst to 8 burst.
!	.long	0x0001
	.long	0x0000
PCIWCR1_A:
	.long	0xFE2001E8
PCIWCR1_D:
	.long	0x77777777
PCIWCR2_A:
	.long	0xFE2001EC
PCIWCR2_D:
	.long	0xFFFE66DF
PCIWCR3_A:
	.long	0xFE2001F0
PCIWCR3_D:
	.long	0x07777777
PCIMCR_A:
	.long	0xFE2001F4
PCIMCR_D1:
	.long	0x500A21F4
PCIMCR_D2:
	.long	0x100A21F4
MMUCCR_A:
	.long	0xFF000010
MMUCCR_D:
	.long	0x00000000
BOOT_CONFIG_WORD:
	.long	0xA8C00000
